//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "MChatlnk.h"
//---------------------------------------------------------------------------
#pragma link "NBLib32"
#pragma resource "*.dfm"
TForm1 *Form1;

#define MaxData MaxSessionData

typedef char* PBuffer;
PLanaList LanaList;
PBuffer CharBuffer;
WORD CountChar;
int CountInBytes;
int CountOutBytes;
int CountInPackets;
int CountOutPackets;
int CountInPings;
int CountOutPings;
AnsiString SavedCallName;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MemoClear()
{
  RecMemo->Clear();
  SendMemo->Clear();
  SendMemo->Enabled = False;
  CountChar = 0;
  CountInBytes = 0;
  CountOutBytes = 0;
  CountInPackets = 0;
  CountOutPackets = 0;
  CountInPings = 0;
  CountOutPings = 0;
  Label4->Caption = IntToStr(CountInBytes);
  Label5->Caption = IntToStr(CountOutBytes);
  Label7->Caption = IntToStr(CountInPackets);
  Label10->Caption = IntToStr(CountOutPackets);
  Label12->Caption = IntToStr(CountInPings);
  Label14->Caption = IntToStr(CountOutPings);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MemoEnabled()
{
  RecMemo->Color = clWindow;
  SendMemo->Color = clWindow;
  SendMemo->Enabled = True;
  SendMemo->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MemoDisabled()
{
  RecMemo->Color = clBtnFace;
  SendMemo->Color = clBtnFace;
  RecMemo->Enabled = False;
  SendMemo->Enabled = False;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::StartBlink(AnsiString S)
{
  TimerBlink->Enabled = True;
  LabelStatus->Caption = S;
  LabelStatus->Visible = True;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::StopBlink()
{
  TimerBlink->Enabled = False;
  LabelStatus->Visible = True;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  CharBuffer = new char[MaxData];
  CheckBox1->Enabled = NBLink1->SupportedTransportsLAN.Contains(nbNetBEUI);
  CheckBox1->Checked = CheckBox1->Enabled;
  CheckBox2->Enabled = NBLink1->SupportedTransportsLAN.Contains(nbOverIPX);
  CheckBox2->Checked = CheckBox2->Enabled;
  CheckBox3->Enabled = NBLink1->SupportedTransportsLAN.Contains(nbOverTCP);
  CheckBox3->Checked = CheckBox3->Enabled;
  CheckBox4->Enabled = NBLink1->SupportedTransportsWAN.Contains(nbNetBEUI);
  CheckBox4->Checked = CheckBox4->Enabled;
  CheckBox5->Enabled = NBLink1->SupportedTransportsWAN.Contains(nbOverIPX);
  CheckBox5->Checked = CheckBox5->Enabled;
  CheckBox6->Enabled = NBLink1->SupportedTransportsWAN.Contains(nbOverTCP);
  CheckBox6->Checked = CheckBox6->Enabled;
  MemoClear();
  MemoDisabled();
  BoxCallName->ItemIndex = 2;
  BoxOurName->ItemIndex = 3;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TimerBlinkTimer(TObject *Sender)
{
  LabelStatus->Visible = ! LabelStatus->Visible;	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonStartClick(TObject *Sender)
{
  TTransports TransportsLAN;
  TTransports TransportsWAN;
  TransportsLAN.Clear();
  TransportsWAN.Clear();
  if (CheckBox1->Checked) { TransportsLAN << nbNetBEUI; }
  if (CheckBox2->Checked) { TransportsLAN << nbOverIPX; }
  if (CheckBox3->Checked) { TransportsLAN << nbOverTCP; }
  if (CheckBox4->Checked) { TransportsWAN << nbNetBEUI; }
  if (CheckBox5->Checked) { TransportsWAN << nbOverIPX; }
  if (CheckBox6->Checked) { TransportsWAN << nbOverTCP; }
  NBLink1->TransportsLAN = TransportsLAN;
  NBLink1->TransportsWAN = TransportsWAN;
  SavedCallName = BoxCallName->Text;
  NBLink1->OurName = BoxOurName->Text;
  NBLink1->Open(anForce);
  if (NBLink1->NBComponentState.Contains(csOpening)) {
    StartBlink("Open...");
    LANGroupBox->Enabled = False;
    WANGroupBox->Enabled = False;
    BoxCallName->Enabled = False;
    BoxOurName->Enabled = False;
    HowToConnect->Enabled = False;
    ButtonStart->Enabled = False;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonStopClick(TObject *Sender)
{
  ButtonStop->Enabled = False;
  StartBlink("HangUp...");
  NBLink1->HangUp();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonExitClick(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Open(TObject *Sender, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    ButtonStop->Enabled = Enabled;
    ((TNBLink*)Sender)->CallName = SavedCallName;
    ((TNBLink*)Sender)->Connect(THowConnect(HowToConnect->ItemIndex));
    if (HowToConnect->ItemIndex == 0) {
      StartBlink("Call...");
    } else {
      StartBlink("Listen...");
    }  
  } else {
    MessageBeep(0);
    StopBlink();
    LabelStatus->Caption = "Not Connection";
    BoxCallName->Enabled = True;
    BoxOurName->Enabled = True;
    HowToConnect->Enabled = True;
    ButtonStart->Enabled = True;
    ButtonStop->Enabled = False;
    LANGroupBox->Enabled = True;
    WANGroupBox->Enabled = True;
    Application->MessageBox("Error Open!", "Error", MB_ICONSTOP);
  };
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Connect(TObject *Sender, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    MessageBeep(0);
    StopBlink();
    MemoClear();
    MemoEnabled();
    LabelStatus->Caption = "Connected (" +
      ((TNBLink*)Sender)->NameProtocolConnected + ")";
    BoxCallName->Text = ((TNBLink*)Sender)->CallName;
    ((TNBLink*)Sender)->Receive(MaxData);
  } else {
    ((TNBLink*)Sender)->CallName = SavedCallName;
    ((TNBLink*)Sender)->Connect(THowConnect(HowToConnect->ItemIndex));
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Break(TObject *Sender, BYTE RetCode)
{
  MessageBeep(0);
  MemoDisabled();
  BoxCallName->Text = SavedCallName;
  ((TNBLink*)Sender)->CallName = SavedCallName;
  ((TNBLink*)Sender)->Connect(THowConnect(HowToConnect->ItemIndex));
  if (HowToConnect->ItemIndex == 0) {
    StartBlink("Call...");
  } else {
    StartBlink("Listen...");
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1HangUp(TObject *Sender, BYTE RetCode)
{
  StartBlink("Close...");
  ((TNBLink*)Sender)->Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Close(TObject *Sender, BYTE RetCode)
{
  StopBlink();
  LabelStatus->Caption = "Not Connection";
  MemoDisabled();
  BoxCallName->Enabled = True;
  BoxOurName->Enabled = True;
  HowToConnect->Enabled = True;
  ButtonStart->Enabled = True;
  LANGroupBox->Enabled = True;
  WANGroupBox->Enabled = True;
  BoxCallName->Text = SavedCallName;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1SendData(TObject *Sender, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    CountOutBytes += ((TNBLink*)Sender)->SendSize;
    CountOutBytes += ((TNBLink*)Sender)->SecondSendSize;
    Label5->Caption = IntToStr(CountOutBytes);
    ++CountOutPackets;
    Label10->Caption = IntToStr(CountOutPackets);
    if (CountChar > 0) {
      ((TNBLink*)Sender)->Send(CountChar, CharBuffer);
      CountChar = 0;
    }
  } else {
    if (RetCode == NRC_CMDTMO) {
      ((TNBLink*)Sender)->Send(((TNBLink*)Sender)->SendSize, NULL);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1SendPing(TObject *Sender, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    ++CountOutPings;
    Label14->Caption = IntToStr(CountOutPings);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1ReceiveData(TObject *Sender, WORD Size,
        Pointer Data, BYTE RetCode)
{
  if ((RetCode == NRC_GOODRET) || (RetCode == NRC_INCOMP)) {
    CountInBytes += Size;
    Label4->Caption = IntToStr(CountInBytes);
    ++CountInPackets;
    Label7->Caption = IntToStr(CountInPackets);
    RecMemo->Lines->BeginUpdate();
    for (int i = 0; i < Size; i++)
      RecMemo->Perform(WM_CHAR, ((char*) Data)[i], 0);
    RecMemo->Lines->EndUpdate();
    ((TNBLink*)Sender)->Receive(MaxData);
  } else {
    if (RetCode == NRC_CMDTMO) {
      ((TNBLink*)Sender)->Receive(((TNBLink*)Sender)->ReceiveSize);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1ReceivePing(TObject *Sender, WORD Size,
	Pointer Data, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    ++CountInPings;
    Label12->Caption = IntToStr(CountInPings);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Error(TObject *Sender, TNBOperation Operation,
	BYTE Lana, BYTE ErrorCode)
{
  // Here can write in ErrorLog file
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SendMemoKeyPress(TObject *Sender, char &Key)
{
  if (CountChar < MaxData) {
    CharBuffer[CountChar++] = Key;
  }
  if ((NBLink1->NBComponentState.Contains(csConnected)) &&
     ( ! NBLink1->NBComponentState.Contains(csSending))) {
    NBLink1->Send(CountChar, CharBuffer);
    CountChar = 0;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::HowToConnectClick(TObject *Sender)
{
  if (HowToConnect->ItemIndex == 0) {
    BoxCallName->ItemIndex = 2;
    BoxOurName->ItemIndex = 3;
  } else {
    BoxCallName->ItemIndex = 4;
    BoxOurName->ItemIndex = 2;
  };
}
//---------------------------------------------------------------------------

