unit MTrans;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Gauges, ComCtrls, Spin, NBLib32;

type
  TForm1 = class(TForm)
    LabelStatus: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    ButtonStart: TButton;
    ButtonStop: TButton;
    ButtonExit: TButton;
    SelectButton: TButton;
    SendButton: TButton;
    HowToConnect: TRadioGroup;
    BoxCallName: TComboBox;
    BoxOurName: TComboBox;
    TimerBlink: TTimer;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    CheckBox1: TCheckBox;
    SpinEdit1: TSpinEdit;
    OpenDialog1: TOpenDialog;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    NBLink1: TNBLink;
    procedure ButtonExitClick(Sender: TObject);
    procedure SelectButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HowToConnectClick(Sender: TObject);
    procedure ButtonStartClick(Sender: TObject);
    procedure StartBlink(S: String);
    procedure StopBlink;
    procedure NBLink1Open(Sender: TObject; RetCode: Byte);
    procedure NBLink1Connect(Sender: TObject; RetCode: Byte);
    procedure NBLink1Break(Sender: TObject; RetCode: Byte);
    procedure NBLink1HangUp(Sender: TObject; RetCode: Byte);
    procedure NBLink1Close(Sender: TObject; RetCode: Byte);
    procedure ButtonStopClick(Sender: TObject);
    procedure TimerBlinkTimer(Sender: TObject);
    procedure NBLink1ReceiveData(Sender: TObject; Size: Word; Data: Pointer;
      RetCode: Byte);
    procedure NBLink1SendData(Sender: TObject; RetCode: Byte);
    procedure SendButtonClick(Sender: TObject);
    procedure SendFromStream;
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  MaxData = MaxSessionData;
  FrameSize: Integer =  MaxData;

type
  THeaderFile = record
    FileName: ShortString;
    FileSize: Integer;
  end;

var
  Form1: TForm1;
  Src,
  Dst,
  TempPath,
  TempFileName,
  SavedCallName: String;
  SendStream,
  ReceiveStream: TStream;
  SendCounter: Integer;
  ReceiveCounter: Integer;
  FileWait: Boolean;
  HeaderFile: THeaderFile;
  SendFileSize: Integer;
  ReceiveFileSize: Integer;
  SendDivider: Integer;
  ReceiveDivider: Integer;

implementation

{$R *.DFM}

procedure TForm1.StartBlink(S: String);
begin
  TimerBlink.Enabled := True;
  LabelStatus.Caption := S;
  LabelStatus.Visible := True;
end;

procedure TForm1.StopBlink;
begin
  TimerBlink.Enabled := False;
  LabelStatus.Visible := True;
end;

procedure TForm1.TimerBlinkTimer(Sender: TObject);
begin
  with LabelStatus do Visible := not Visible;
end;

procedure FreeSendStream;
begin
  if SendStream <> nil then
  begin
    SendStream.Free;
    SendStream := nil;
  end;
end;

procedure FreeReceiveStream;
begin
  if ReceiveStream <> nil then
  begin
    ReceiveStream.Free;
    ReceiveStream := nil;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Label2.Caption := '0';
  Label5.Caption := '0';
  Label9.Caption := '0';
  Label12.Caption := '0';
  Label7.Caption := '';
  Label14.Caption := '';
  BoxCallName.ItemIndex := 2;
  BoxOurName.ItemIndex := 3;
  TempPath := ExtractFilePath(Application.ExeName);
  SpinEdit1.Value := FrameSize;
end;

procedure TForm1.HowToConnectClick(Sender: TObject);
begin
  if HowToConnect.ItemIndex = 0 then
  begin
    BoxCallName.ItemIndex := 2;
    BoxOurName.ItemIndex := 3;
  end else
  begin
    BoxCallName.ItemIndex := 4;
    BoxOurName.ItemIndex := 2;
  end;
end;

procedure TForm1.ButtonStartClick(Sender: TObject);
begin
  NBLink1.TransportsLAN := NBLink1.SupportedTransportsLAN;
  SavedCallName := BoxCallName.Text;
  NBLink1.OurName := BoxOurName.Text;
  NBLink1.Open(anForce);
  if csOpening in NBLink1.NBComponentState then
  begin
    StartBlink('Open...');
    BoxCallName.Enabled := False;
    BoxOurName.Enabled := False;
    HowToConnect.Enabled := False;
    ButtonStart.Enabled := False;
  end;
end;

procedure TForm1.ButtonStopClick(Sender: TObject);
begin
  SendButton.Enabled := False;
  CheckBox1.Enabled := False;
  SpinEdit1.Enabled := False;
  ButtonStop.Enabled := False;
  StartBlink('HangUp...');
  NBLink1.HangUp;
end;

procedure CalcProgessParams(FileSize: Integer; ProgressBar: TProgressBar;
  var Divider: Integer);
begin
  if FileSize > MaxWord then
  begin
    Divider := (FileSize div MaxWord);
    if (FileSize mod MaxWord) > 0 then
      Inc(Divider);
    if Divider = 0 then Divider := 1;
    ProgressBar.Max := FileSize div Divider;
  end else
  begin
    ProgressBar.Max := MaxWord;
    Divider := 1;
  end;
  ProgressBar.Min := 0;
  ProgressBar.Position := 0;
end;

procedure TForm1.SelectButtonClick(Sender: TObject);
var
  SearchRec: TSearchRec;
begin
  if OpenDialog1.Execute then
  begin
    Src := OpenDialog1.FileName;
    Label7.Caption := Src;
    FindFirst(Src, faAnyFile, SearchRec);
    SendFileSize := SearchRec.Size;
    CalcProgessParams(SendFileSize, ProgressBar1, SendDivider);
    FindClose(SearchRec);
    Label2.Caption := IntToStr(SendFileSize);
    SendCounter := 0;
    Label5.Caption := IntToStr(SendCounter);
  end;
end;

procedure TForm1.SendButtonClick(Sender: TObject);
begin
  if Src <> '' then
  begin
    SendButton.Enabled := False;
    CheckBox1.Enabled := False;
    SpinEdit1.Enabled := False;
    SendCounter := 0;
    Label5.Caption := IntToStr(SendCounter);
    SendStream := TFileStream.Create(Src, fmOpenRead);
    ProgressBar1.Position := 0;
    HeaderFile.FileName := Src;
    HeaderFile.FileSize := SendFileSize;
    FrameSize := SpinEdit1.Value;
    if CheckBox1.Checked and
      (FrameSize > MaxWord div 2) then FrameSize := FrameSize div 2;
    NBLink1.Send(SizeOf(THeaderFile), @HeaderFile);
  end
    else Beep;
end;

procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.NBLink1Open(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    ButtonStop.Enabled := Enabled;
    TNBLink(Sender).CallName := SavedCallName;
    TNBLink(Sender).Connect(THowConnect(HowToConnect.ItemIndex));
    if HowToConnect.ItemIndex = 0
      then StartBlink('Call...')
      else StartBlink('Listen...')
  end else
  begin
    Beep;
    StopBlink;
    LabelStatus.Caption := 'Not Connection';
    BoxCallName.Enabled := True;
    BoxOurName.Enabled := True;
    HowToConnect.Enabled := True;
    ButtonStart.Enabled := True;
    ButtonStop.Enabled := False;
    Application.MessageBox('Error Open!', 'Error', MB_ICONSTOP);
  end;
end;

procedure TForm1.NBLink1Connect(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    StopBlink;
    Beep;
    SendButton.Enabled := True;
    CheckBox1.Enabled := True;
    SpinEdit1.Enabled := True;
    LabelStatus.Caption := 'Connected (' + TNBLink(Sender).NameProtocolConnected + ')';
    BoxCallName.Text := TNBLink(Sender).CallName;
    TNBLink(Sender).Receive(MaxData);
    FileWait := True;
  end else
  begin
    TNBLink(Sender).CallName := SavedCallName;
    TNBLink(Sender).Connect(THowConnect(HowToConnect.ItemIndex));
  end;
end;

procedure TForm1.NBLink1Break(Sender: TObject; RetCode: Byte);
begin
  Beep;
  SendButton.Enabled := False;
  CheckBox1.Enabled := False;
  SpinEdit1.Enabled := False;
  ProgressBar1.Position := 0;
  ProgressBar2.Position := 0;
  FreeSendStream;
  FreeReceiveStream;
  BoxCallName.Text := SavedCallName;
  TNBLink(Sender).CallName := SavedCallName;
  TNBLink(Sender).Connect(THowConnect(HowToConnect.ItemIndex));
  if HowToConnect.ItemIndex = 0
    then StartBlink('Call...')
    else StartBlink('Listen...')
end;

procedure TForm1.NBLink1HangUp(Sender: TObject; RetCode: Byte);
begin
  ProgressBar1.Position := 0;
  ProgressBar2.Position := 0;
  FreeSendStream;
  FreeReceiveStream;
  StartBlink('Close...');
  TNBLink(Sender).Close;
end;

procedure TForm1.NBLink1Close(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  LabelStatus.Caption := 'Not Connection';
  BoxCallName.Enabled := True;
  BoxOurName.Enabled := True;
  HowToConnect.Enabled := True;
  ButtonStart.Enabled := True;
  BoxCallName.Text := SavedCallName;
end;

procedure TForm1.NBLink1ReceiveData(Sender: TObject; Size: Word; Data: Pointer;
  RetCode: Byte);
begin
  with TNBLink(Sender) do
  case RetCode of
    NRC_GOODRET,
    NRC_INCOMP:
    begin
      if FileWait then
      begin
        FileWait := False;
        Dst := TempPath + ExtractFileName(THeaderFile(Data^).FileName);
        Label14.Caption := Dst;
        ReceiveFileSize := THeaderFile(Data^).FileSize;
        Label9.Caption := IntToStr(ReceiveFileSize);
        ReceiveCounter := 0;
        Label12.Caption := IntToStr(ReceiveCounter);
        CalcProgessParams(ReceiveFileSize, ProgressBar2, ReceiveDivider);
        ReceiveStream := TFileStream.Create(Dst, fmCreate);
      end else
      begin
        if ReceiveStream <> nil then ReceiveStream.WriteBuffer(Data^, Size);
        Inc(ReceiveCounter, Size);
        Label12.Caption := IntToStr(ReceiveCounter);
        ProgressBar2.Position := ReceiveCounter div ReceiveDivider;
        if ReceiveCounter >= ReceiveFileSize then
        begin
          FreeReceiveStream;
          ProgressBar2.Position := ProgressBar2.Max;
          FileWait := True;
          Beep;
        end;
      end;
      Receive(MaxData);
    end;
    NRC_CMDTMO:
    begin
      Receive(ReceiveSize);
    end;
  end;
end;

procedure TForm1.NBLink1SendData(Sender: TObject; RetCode: Byte);
begin
  with TNBLink(Sender) do
  case RetCode of
    NRC_GOODRET:
    begin
      ProgressBar1.Position := SendCounter div SendDivider;
      Label5.Caption := IntToStr(SendCounter);
      if SendCounter >= SendStream.Size then
      begin
        FreeSendStream;
        SizeIntSendBuffer := 0;
        SizeIntSecondSendBuffer := 0;
        SendButton.Enabled := True;
        CheckBox1.Enabled := True;
        SpinEdit1.Enabled := True;
        ProgressBar1.Position := ProgressBar1.Max;
        Beep;
      end else
        if SendStream <> nil then SendFromStream;
    end;
    NRC_CMDTMO:
    begin
      if CheckBox1.Checked
        then ChainSend(SendSize, nil, SecondSendSize, nil)
        else Send(SendSize, nil);
    end;
  end;
end;

procedure TForm1.SendFromStream;
var
  FirstSize,
  SecondSize: Integer;
begin
  FirstSize := 0;
  if SendStream.Size > SendCounter then
  begin
    if SendStream.Size - SendCounter >= FrameSize
      then FirstSize := FrameSize
      else FirstSize := SendStream.Size - SendCounter;
    NBLink1.SizeIntSendBuffer:= FirstSize;
    SendStream.ReadBuffer(NBLink1.IntSendBuffer^, FirstSize);
    Inc(SendCounter, FirstSize);
  end;
  if CheckBox1.Checked then
  begin
    SecondSize := 0;
    if SendStream.Size > SendCounter then
    begin
      if SendStream.Size - SendCounter >= FrameSize
        then SecondSize := FrameSize
        else SecondSize := SendStream.Size - SendCounter;
      NBLink1.SizeIntSecondSendBuffer := SecondSize;
      SendStream.ReadBuffer(NBLink1.IntSecondSendBuffer^, SecondSize);
      Inc(SendCounter, SecondSize);
    end;
    NBLink1.ChainSend(FirstSize, nil, SecondSize, nil);
  end else
    NBLink1.Send(FirstSize, nil);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FreeSendStream;
  FreeReceiveStream;
end;

end.

