//----------------------------------------------------------------------------
// NBLib32.hpp - bcbdcc32 generated hdr (DO NOT EDIT) rev: 0
// From: NBLib32.pas
//----------------------------------------------------------------------------
#ifndef NBLib32HPP
#define NBLib32HPP
//----------------------------------------------------------------------------
#include <Controls.hpp>
#include <Forms.hpp>
#include <StdCtrls.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Windows.hpp>
#include <System.hpp>
namespace Nblib32
{
//-- type declarations -------------------------------------------------------
typedef Byte TMACAddress[6];

typedef TMACAddress *PMACAddress;

typedef char TNCBName[16];

typedef Byte TNCBReserved[10];

enum TNCBThreadPriority { tpIdle, tpLowest, tpLower, tpNormal, tpHigher, tpHighest, tpTimeCritical }
	;

enum TNBUseName { unUnique, unGroup };

enum TNBOperation { opOpen, opClose, opConnect, opSend, opReceive };

enum TNBThreadSynch { tsAbsent, tsSendMessage, tsPostMessage };

enum TNBLanaResources { lrAlloc, lrFree };

enum TAddName { anAuto, anForce };

enum THowConnect { hcCall, hcListen };

typedef void __fastcall (__closure *TNCBNotifyEvent)(System::TObject* Sender);

typedef void __fastcall (__closure *TNBNotifyEvent)(System::TObject* Sender, Byte RetCode);

typedef void __fastcall (__closure *TNBReceiveNotifyEvent)(System::TObject* Sender, Word Size, void * 
	Data, Byte RetCode);

typedef void __fastcall (__closure *TNBErrorNotifyEvent)(System::TObject* Sender, TNBOperation Operation
	, Byte Lana, Byte ErrorCode);

enum TNBProtocol { nbOverTCP, nbOverIPX, nbNetBEUI, nbNotDefined };

enum TAdapter { taLAN, taWAN };

struct TLanaList;
typedef TLanaList *PLanaList;

#pragma pack(push, 1)
struct NBLib32_1
{
	Byte lana_num;
	TNBProtocol NBProtocol;
	TAdapter Adapter;
	Byte MACAddress[6];
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct TLanaList
{
	Byte length;
	NBLib32_1 lana[255];
} ;
#pragma pack(pop)

typedef Set<TNBProtocol, nbOverTCP, nbNotDefined>  TTransports;

enum NBLib32_2 { csOpening, csOpened, csAddedName, csConnecting, csConnected, csSending, csReceiving, 
	csHangUping, csClosing };

typedef Set<NBLib32_2, csOpening, csClosing>  TNBComponentState;

class __declspec(delphiclass) TNBAboutInfo;
class __declspec(pascalimplementation) TNBAboutInfo : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	System::AnsiString FCopyrightDate;
	System::AnsiString FMailto;
	System::AnsiString FHome;
	System::AnsiString FDescription;
	
public:
	__property System::AnsiString CopyrightDate = {read=FCopyrightDate, write=FCopyrightDate, nodefault
		};
	__property System::AnsiString Mailto = {read=FMailto, write=FMailto, nodefault};
	__property System::AnsiString Home = {read=FHome, write=FHome, nodefault};
	__property System::AnsiString Description = {read=FDescription, write=FDescription, nodefault};
public:
		
	/* TObject.Create */ __fastcall TNBAboutInfo(void) : Classes::TPersistent() { }
	/* TObject.Destroy */ __fastcall virtual ~TNBAboutInfo(void) { }
	
};

class __declspec(delphiclass) TNBAboutEditDlg;
class __declspec(pascalimplementation) TNBAboutEditDlg : public Forms::TForm
{
	typedef Forms::TForm inherited;
	
__published:
	Stdctrls::TButton* BtnOk;
	Extctrls::TPanel* Panel1;
	Stdctrls::TLabel* LabelCopyright;
	Buttons::TSpeedButton* BtnPaletteBmp;
	Stdctrls::TLabel* LabelComponentName;
	Stdctrls::TLabel* LabelMailto;
	Stdctrls::TLabel* LabelHome;
	Stdctrls::TLabel* LabelDescription;
	Extctrls::TBevel* Bevel1;
	void __fastcall LabelMailtoClick(System::TObject* Sender);
	void __fastcall LabelHomeClick(System::TObject* Sender);
	void __fastcall LabelMouseDown(System::TObject* Sender, Controls::TMouseButton Button, Classes::TShiftState 
		Shift, int X, int Y);
	
private:
	TNBAboutInfo* FAboutInfo;
	void __fastcall SetAboutInfo(TNBAboutInfo* Value);
	
public:
	System::AnsiString ComponentName;
	__property TNBAboutInfo* AboutInfo = {read=FAboutInfo, write=SetAboutInfo, nodefault};
public:
	/* TForm.Create */ __fastcall virtual TNBAboutEditDlg(Classes::TComponent* AOwner) : Forms::TForm(AOwner
		) { }
	/* TForm.CreateNew */ __fastcall TNBAboutEditDlg(Classes::TComponent* AOwner, int Dummy) : Forms::TForm(
		AOwner, Dummy) { }
	/* TForm.Destroy */ __fastcall virtual ~TNBAboutEditDlg(void) { }
	
public:
	/* TWinControl.CreateParented */ __fastcall TNBAboutEditDlg(HWND ParentWindow) : Forms::TForm(ParentWindow
		) { }
	
};

class __declspec(delphiclass) TVladNCB;
class __declspec(pascalimplementation) TVladNCB : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	TNBAboutInfo* FNBAboutInfo;
	Byte FCmd;
	Byte FRCode;
	Byte FSessionNumber;
	Byte FNameNumber;
	void *FData;
	Word FSize;
	char FCallName[16];
	char FOurName[16];
	Byte FRto;
	Byte FSto;
	void *FPostRoutine;
	Byte FLanaNumber;
	Byte FFinalRCode;
	Byte FReserved[10];
	int FEvent;
	int FNCBEventHandle;
	int FNCBEventStart;
	int FNCBThreadHandle;
	int FNCBThreadID;
	TNCBThreadPriority FNCBThreadPriority;
	bool FNCBThreadEnabled;
	TNCBNotifyEvent FOnNCBEvent;
	
protected:
	void __fastcall SetCallName( System::AnsiString Value);
	void __fastcall SetOurName( System::AnsiString Value);
	System::AnsiString __fastcall GetCallName(void);
	System::AnsiString __fastcall GetOurName(void);
	void __fastcall SetNCBThreadEnabled(bool Value);
	void __fastcall SetNCBThreadPriority(TNCBThreadPriority Value);
	TNCBThreadPriority __fastcall GetNCBThreadPriority(void);
	bool __fastcall GetBusy(void);
	
public:
	__fastcall virtual TVladNCB(Classes::TComponent* AOwner);
	__fastcall virtual ~TVladNCB(void);
	Byte __fastcall Execute(Byte CommandCode);
	Byte __fastcall Cancel(TVladNCB* CanceledNCB);
	__property bool Busy = {read=GetBusy, nodefault};
	__property Byte Cmd = {read=FCmd, write=FCmd, nodefault};
	__property Byte RCode = {read=FRCode, write=FRCode, nodefault};
	__property Byte SessionNumber = {read=FSessionNumber, write=FSessionNumber, nodefault};
	__property Byte NameNumber = {read=FNameNumber, write=FNameNumber, nodefault};
	__property void * Data = {read=FData, write=FData, nodefault};
	__property Word Size = {read=FSize, write=FSize, nodefault};
	__property Byte LanaNumber = {read=FLanaNumber, write=FLanaNumber, nodefault};
	__property Byte FinalRCode = {read=FFinalRCode, write=FFinalRCode, nodefault};
	__property int Event = {read=FEvent, write=FEvent, nodefault};
	
__published:
	__property TNBAboutInfo* About = {read=FNBAboutInfo, nodefault};
	__property System::AnsiString CallName = {read=GetCallName, write=SetCallName, nodefault};
	__property System::AnsiString OurName = {read=GetOurName, write=SetOurName, nodefault};
	__property Byte Rto = {read=FRto, write=FRto, nodefault};
	__property Byte Sto = {read=FSto, write=FSto, nodefault};
	__property bool ThreadEnabled = {read=FNCBThreadEnabled, write=SetNCBThreadEnabled, nodefault};
	__property TNCBThreadPriority ThreadPriority = {read=GetNCBThreadPriority, write=SetNCBThreadPriority
		, default=3};
	__property TNCBNotifyEvent OnNCBEvent = {read=FOnNCBEvent, write=FOnNCBEvent};
};

class __declspec(delphiclass) TNBDatagram;
class __declspec(pascalimplementation) TNBDatagram : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	TNBAboutInfo* FNBAboutInfo;
	TVladNCB* FOpenCloseNCB;
	TVladNCB* FSendNCB;
	TVladNCB* FReceiveNCB;
	TVladNCB* FCancelNCB;
	void *FIntSendBuffer;
	void *FIntReceiveBuffer;
	Word FSizeIntSendBuffer;
	Word FSizeIntReceiveBuffer;
	void *FExtSendBuffer;
	void *FExtReceiveBuffer;
	Word FSendSize;
	Word FReceiveSize;
	Byte FOpenFinalRCode;
	Byte FCloseFinalRCode;
	Byte FSendFinalRCode;
	Byte FReceiveFinalRCode;
	TNCBThreadPriority FThreadPriority;
	TNBThreadSynch FThreadSynch;
	_RTL_CRITICAL_SECTION FOwnedCriticalSection;
	TNBComponentState FNBComponentState;
	TNBUseName FUseName;
	TNBNotifyEvent FOnOpen;
	TNBNotifyEvent FOnClose;
	TNBNotifyEvent FOnSendData;
	TNBReceiveNotifyEvent FOnReceiveData;
	TNBErrorNotifyEvent FOnError;
	System::TObject* FUsedObject;
	
protected:
	void __fastcall StartExchange(Byte NameNumber);
	void __fastcall StopExchange(void);
	void __fastcall DoEvent(System::TObject* Sender);
	void __fastcall SetPriority(TNCBThreadPriority Value);
	void __fastcall SetLanaNumber(Byte Value);
	Byte __fastcall GetLanaNumber(void);
	void __fastcall SetCallName( System::AnsiString Value);
	System::AnsiString __fastcall GetCallName(void);
	void __fastcall SetOurName( System::AnsiString Value);
	System::AnsiString __fastcall GetOurName(void);
	void __fastcall SetSendSize(Word Value);
	void __fastcall SetReceiveSize(Word Value);
	void __fastcall SetExtSendBuffer(void * Value);
	void __fastcall SetExtReceiveBuffer(void * Value);
	void __fastcall SetSizeIntSendBuffer(Word Value);
	void __fastcall SetSizeIntReceiveBuffer(Word Value);
	void __fastcall MoveDataSend(Word Size, void * Data);
	System::AnsiString __fastcall GetFromWhom(void);
	
public:
	__fastcall virtual TNBDatagram(Classes::TComponent* AOwner);
	__fastcall virtual ~TNBDatagram(void);
	Byte __fastcall Open(TAddName AddName);
	Byte __fastcall Close(void);
	Byte __fastcall Send(Word Size, void * Data);
	Byte __fastcall SendBroadcast(Word Size, void * Data);
	Byte __fastcall Receive(Word Size);
	Byte __fastcall ReceiveBroadcast(Word Size);
	__property System::AnsiString FromWhom = {read=GetFromWhom, nodefault};
	__property TNBComponentState NBComponentState = {read=FNBComponentState, nodefault};
	__property Byte OpenFinalRCode = {read=FOpenFinalRCode, nodefault};
	__property Byte CloseFinalRCode = {read=FCloseFinalRCode, nodefault};
	__property Byte SendFinalRCode = {read=FSendFinalRCode, nodefault};
	__property Byte ReceiveFinalRCode = {read=FReceiveFinalRCode, nodefault};
	__property void * IntSendBuffer = {read=FIntSendBuffer, nodefault};
	__property void * IntReceiveBuffer = {read=FIntReceiveBuffer, nodefault};
	__property Word SizeIntSendBuffer = {read=FSizeIntSendBuffer, write=SetSizeIntSendBuffer, nodefault
		};
	__property Word SizeIntReceiveBuffer = {read=FSizeIntReceiveBuffer, write=SetSizeIntReceiveBuffer, 
		nodefault};
	__property void * ExtSendBuffer = {read=FExtSendBuffer, write=SetExtSendBuffer, nodefault};
	__property void * ExtReceiveBuffer = {read=FExtReceiveBuffer, write=SetExtReceiveBuffer, nodefault}
		;
	__property Word SendSize = {read=FSendSize, nodefault};
	__property Word ReceiveSize = {read=FReceiveSize, nodefault};
	__property System::TObject* UsedObject = {read=FUsedObject, write=FUsedObject, nodefault};
	
__published:
	__property TNBAboutInfo* About = {read=FNBAboutInfo, nodefault};
	__property TNCBThreadPriority ThreadPriority = {read=FThreadPriority, write=SetPriority, default=3}
		;
	__property TNBThreadSynch ThreadSynch = {read=FThreadSynch, write=FThreadSynch, default=2};
	__property TNBUseName UseName = {read=FUseName, write=FUseName, default=0};
	__property Byte LanaNumber = {read=GetLanaNumber, write=SetLanaNumber, nodefault};
	__property System::AnsiString CallName = {read=GetCallName, write=SetCallName, nodefault};
	__property System::AnsiString OurName = {read=GetOurName, write=SetOurName, nodefault};
	__property TNBNotifyEvent OnOpen = {read=FOnOpen, write=FOnOpen};
	__property TNBNotifyEvent OnClose = {read=FOnClose, write=FOnClose};
	__property TNBNotifyEvent OnSendData = {read=FOnSendData, write=FOnSendData};
	__property TNBReceiveNotifyEvent OnReceiveData = {read=FOnReceiveData, write=FOnReceiveData};
	__property TNBErrorNotifyEvent OnError = {read=FOnError, write=FOnError};
};

class __declspec(delphiclass) TNBSession;
class __declspec(pascalimplementation) TNBSession : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	TNBAboutInfo* FNBAboutInfo;
	TVladNCB* FOpenCloseNCB;
	TVladNCB* FConnectNCB;
	TVladNCB* FSendNCB;
	TVladNCB* FPingNCB;
	TVladNCB* FReceiveNCB;
	TVladNCB* FCancelNCB;
	void *FIntSendBuffer;
	void *FIntSecondSendBuffer;
	void *FIntReceiveBuffer;
	Word FSizeIntSendBuffer;
	Word FSizeIntSecondSendBuffer;
	Word FSizeIntReceiveBuffer;
	void *FExtSendBuffer;
	void *FExtSecondSendBuffer;
	void *FExtReceiveBuffer;
	Word FSendSize;
	Word FSecondSendSize;
	Word FReceiveSize;
	Byte FOpenFinalRCode;
	Byte FCloseFinalRCode;
	Byte FConnectFinalRCode;
	Byte FHangUpFinalRCode;
	Byte FSendFinalRCode;
	Byte FReceiveFinalRCode;
	TNCBThreadPriority FThreadPriority;
	TNBThreadSynch FThreadSynch;
	_RTL_CRITICAL_SECTION FOwnedCriticalSection;
	TNBComponentState FNBComponentState;
	TNBUseName FUseName;
	Byte FReceiveTimeout;
	Byte FSendTimeout;
	Byte FPingInterval;
	int FPingWaitEventHandle;
	int FPingStartEventHandle;
	int FPingThreadHandle;
	int FPingThreadID;
	bool FPingStarted;
	bool FPingSend;
	int FCancelEventHandle;
	TNBNotifyEvent FOnOpen;
	TNBNotifyEvent FOnClose;
	TNBNotifyEvent FOnConnect;
	TNBNotifyEvent FOnHangUp;
	TNBNotifyEvent FOnBreak;
	TNBNotifyEvent FOnSendData;
	TNBNotifyEvent FOnSendPing;
	TNBReceiveNotifyEvent FOnReceiveData;
	TNBReceiveNotifyEvent FOnReceivePing;
	TNBErrorNotifyEvent FOnError;
	System::TObject* FUsedObject;
	Byte __fastcall GetSessionNumber(void);
	void __fastcall CancelEvent(System::TObject* Sender);
	
protected:
	void __fastcall StartExchange(Byte SessionNumber);
	void __fastcall StopExchange(void);
	void __fastcall DoEvent(System::TObject* Sender);
	void __fastcall SetPriority(TNCBThreadPriority Value);
	void __fastcall SetLanaNumber(Byte Value);
	Byte __fastcall GetLanaNumber(void);
	void __fastcall SetCallName( System::AnsiString Value);
	System::AnsiString __fastcall GetCallName(void);
	void __fastcall SetOurName( System::AnsiString Value);
	System::AnsiString __fastcall GetOurName(void);
	void __fastcall SetPingInterval(Byte Value);
	void __fastcall SetExtSendBuffer(void * Value);
	void __fastcall SetExtSecondSendBuffer(void * Value);
	void __fastcall SetExtReceiveBuffer(void * Value);
	void __fastcall SetSizeIntSendBuffer(Word Value);
	void __fastcall SetSizeIntSecondSendBuffer(Word Value);
	void __fastcall SetSizeIntReceiveBuffer(Word Value);
	void __fastcall MoveDataSend(Word Size, void * Data, Word SecondSize, void * SecondData);
	
public:
	__fastcall virtual TNBSession(Classes::TComponent* AOwner);
	__fastcall virtual ~TNBSession(void);
	Byte __fastcall Open(TAddName AddName);
	Byte __fastcall Close(void);
	Byte __fastcall Connect(THowConnect HowConnect);
	Byte __fastcall HangUp(void);
	Byte __fastcall Send(Word Size, void * Data);
	Byte __fastcall ChainSend(Word Size, void * Data, Word SecondSize, void * SecondData);
	Byte __fastcall Receive(Word Size);
	__property TNBComponentState NBComponentState = {read=FNBComponentState, nodefault};
	__property Byte OpenFinalRCode = {read=FOpenFinalRCode, nodefault};
	__property Byte CloseFinalRCode = {read=FCloseFinalRCode, nodefault};
	__property Byte ConnectFinalRCode = {read=FConnectFinalRCode, nodefault};
	__property Byte HangUpFinalRCode = {read=FHangUpFinalRCode, nodefault};
	__property Byte SendFinalRCode = {read=FSendFinalRCode, nodefault};
	__property Byte ReceiveFinalRCode = {read=FReceiveFinalRCode, nodefault};
	__property void * IntSendBuffer = {read=FIntSendBuffer, nodefault};
	__property void * IntSecondSendBuffer = {read=FIntSecondSendBuffer, nodefault};
	__property void * IntReceiveBuffer = {read=FIntReceiveBuffer, nodefault};
	__property Word SizeIntSendBuffer = {read=FSizeIntSendBuffer, write=SetSizeIntSendBuffer, nodefault
		};
	__property Word SizeIntSecondSendBuffer = {read=FSizeIntSecondSendBuffer, write=SetSizeIntSecondSendBuffer
		, nodefault};
	__property Word SizeIntReceiveBuffer = {read=FSizeIntReceiveBuffer, write=SetSizeIntReceiveBuffer, 
		nodefault};
	__property void * ExtSendBuffer = {read=FExtSendBuffer, write=SetExtSendBuffer, nodefault};
	__property void * ExtSecondSendBuffer = {read=FExtSecondSendBuffer, write=SetExtSecondSendBuffer, nodefault
		};
	__property void * ExtReceiveBuffer = {read=FExtReceiveBuffer, write=SetExtReceiveBuffer, nodefault}
		;
	__property Word SendSize = {read=FSendSize, nodefault};
	__property Word SecondSendSize = {read=FSecondSendSize, nodefault};
	__property Word ReceiveSize = {read=FReceiveSize, nodefault};
	__property System::TObject* UsedObject = {read=FUsedObject, write=FUsedObject, nodefault};
	
__published:
	__property TNBAboutInfo* About = {read=FNBAboutInfo, nodefault};
	__property TNCBThreadPriority ThreadPriority = {read=FThreadPriority, write=SetPriority, default=3}
		;
	__property TNBThreadSynch ThreadSynch = {read=FThreadSynch, write=FThreadSynch, default=2};
	__property TNBUseName UseName = {read=FUseName, write=FUseName, default=0};
	__property Byte PingInterval = {read=FPingInterval, write=SetPingInterval, nodefault};
	__property Byte ReceiveTimeout = {read=FReceiveTimeout, write=FReceiveTimeout, nodefault};
	__property Byte SendTimeout = {read=FSendTimeout, write=FSendTimeout, nodefault};
	__property Byte LanaNumber = {read=GetLanaNumber, write=SetLanaNumber, nodefault};
	__property System::AnsiString CallName = {read=GetCallName, write=SetCallName, nodefault};
	__property System::AnsiString OurName = {read=GetOurName, write=SetOurName, nodefault};
	__property TNBNotifyEvent OnOpen = {read=FOnOpen, write=FOnOpen};
	__property TNBNotifyEvent OnClose = {read=FOnClose, write=FOnClose};
	__property TNBNotifyEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property TNBNotifyEvent OnBreak = {read=FOnBreak, write=FOnBreak};
	__property TNBNotifyEvent OnHangUp = {read=FOnHangUp, write=FOnHangUp};
	__property TNBNotifyEvent OnSendData = {read=FOnSendData, write=FOnSendData};
	__property TNBNotifyEvent OnSendPing = {read=FOnSendPing, write=FOnSendPing};
	__property TNBReceiveNotifyEvent OnReceiveData = {read=FOnReceiveData, write=FOnReceiveData};
	__property TNBReceiveNotifyEvent OnReceivePing = {read=FOnReceivePing, write=FOnReceivePing};
	__property TNBErrorNotifyEvent OnError = {read=FOnError, write=FOnError};
};

class __declspec(delphiclass) TNBSessionList;
class __declspec(pascalimplementation) TNBSessionList : public Classes::TList
{
	typedef Classes::TList inherited;
	
protected:
	TNBSession* __fastcall NBGet(int Index);
	void __fastcall NBPut(int Index, TNBSession* Item);
	TNBSession* __fastcall NBFirst(void);
	TNBSession* __fastcall NBLast(void);
	
public:
	__property TNBSession* Items[int Index] = {read=NBGet, write=NBPut/*, default*/};
public:
	/* TList.Destroy */ __fastcall virtual ~TNBSessionList(void) { }
	
public:
	/* TObject.Create */ __fastcall TNBSessionList(void) : Classes::TList() { }
	
};

class __declspec(delphiclass) EMoveToSendBuffer;
class __declspec(pascalimplementation) EMoveToSendBuffer : public Sysutils::Exception
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EMoveToSendBuffer(const System::AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	/* Exception.CreateFmt */ __fastcall EMoveToSendBuffer(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EMoveToSendBuffer(int Ident) : Sysutils::Exception(Ident) { }
	/* Exception.CreateResFmt */ __fastcall EMoveToSendBuffer(int Ident, const System::TVarRec * Args, 
		const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EMoveToSendBuffer(const System::AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EMoveToSendBuffer(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall EMoveToSendBuffer(int Ident, int AHelpContext) : Sysutils::
		Exception(Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EMoveToSendBuffer(int Ident, const System::TVarRec * Args
		, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EMoveToSendBuffer(void) { }
	
};

class __declspec(delphiclass) ETranportNotFound;
class __declspec(pascalimplementation) ETranportNotFound : public Sysutils::Exception
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall ETranportNotFound(const System::AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	/* Exception.CreateFmt */ __fastcall ETranportNotFound(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall ETranportNotFound(int Ident) : Sysutils::Exception(Ident) { }
	/* Exception.CreateResFmt */ __fastcall ETranportNotFound(int Ident, const System::TVarRec * Args, 
		const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall ETranportNotFound(const System::AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall ETranportNotFound(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall ETranportNotFound(int Ident, int AHelpContext) : Sysutils::
		Exception(Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall ETranportNotFound(int Ident, const System::TVarRec * Args
		, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~ETranportNotFound(void) { }
	
};

class __declspec(delphiclass) TNBLink;
class __declspec(pascalimplementation) TNBLink : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	TNBAboutInfo* FNBAboutInfo;
	TNBSession* FNBMain;
	TNBSessionList* FNBSessionList;
	TNBSession* FNBConnected;
	THowConnect FHowConnect;
	int FCounterOpen;
	int FCounterClose;
	TAddName FAddName;
	TNBUseName FUseName;
	Byte FReceiveTimeout;
	Byte FSendTimeout;
	Byte FPingInterval;
	TTransports FTransportsLAN;
	TTransports FTransportsWAN;
	TNBComponentState FNBComponentState;
	TNBNotifyEvent FOnOpen;
	TNBNotifyEvent FOnClose;
	TNBNotifyEvent FOnConnect;
	TNBNotifyEvent FOnHangUp;
	TNBNotifyEvent FOnBreak;
	TNBNotifyEvent FOnSendData;
	TNBNotifyEvent FOnSendPing;
	TNBReceiveNotifyEvent FOnReceiveData;
	TNBReceiveNotifyEvent FOnReceivePing;
	TNBErrorNotifyEvent FOnError;
	System::TObject* FUsedObject;
	int __fastcall GetOpenedIndex(int CurrentIndex);
	
protected:
	TTransports __fastcall GetSupportedTransportsLAN(void);
	TTransports __fastcall GetSupportedTransportsWAN(void);
	void __fastcall SetPriority(TNCBThreadPriority Value);
	TNCBThreadPriority __fastcall GetPriority(void);
	void __fastcall SetThreadSynch(TNBThreadSynch Value);
	TNBThreadSynch __fastcall GetThreadSynch(void);
	void __fastcall SetCallName( System::AnsiString Value);
	System::AnsiString __fastcall GetCallName(void);
	void __fastcall SetOurName( System::AnsiString Value);
	System::AnsiString __fastcall GetOurName(void);
	TNBUseName __fastcall GetUseName(void);
	void __fastcall SetUseName(TNBUseName Value);
	void * __fastcall GetIntSendBuffer(void);
	void * __fastcall GetIntSecondSendBuffer(void);
	void * __fastcall GetIntReceiveBuffer(void);
	Word __fastcall GetSizeIntSendBuffer(void);
	void __fastcall SetSizeIntSendBuffer(Word Value);
	Word __fastcall GetSizeIntSecondSendBuffer(void);
	void __fastcall SetSizeIntSecondSendBuffer(Word Value);
	Word __fastcall GetSizeIntReceiveBuffer(void);
	void __fastcall SetSizeIntReceiveBuffer(Word Value);
	void * __fastcall GetExtSendBuffer(void);
	void __fastcall SetExtSendBuffer(void * Value);
	void * __fastcall GetExtSecondSendBuffer(void);
	void __fastcall SetExtSecondSendBuffer(void * Value);
	void * __fastcall GetExtReceiveBuffer(void);
	void __fastcall SetExtReceiveBuffer(void * Value);
	Word __fastcall GetSendSize(void);
	Word __fastcall GetSecondSendSize(void);
	Word __fastcall GetReceiveSize(void);
	TNBProtocol __fastcall GetProtocolConnected(void);
	System::AnsiString __fastcall GetNameProtocolConnected(void);
	void __fastcall DoOpen(System::TObject* Sender, Byte RetCode);
	void __fastcall DoClose(System::TObject* Sender, Byte RetCode);
	void __fastcall DoConnect(System::TObject* Sender, Byte RetCode);
	void __fastcall DoBreak(System::TObject* Sender, Byte RetCode);
	void __fastcall DoHangUp(System::TObject* Sender, Byte RetCode);
	void __fastcall DoSend(System::TObject* Sender, Byte RetCode);
	void __fastcall DoSendPing(System::TObject* Sender, Byte RetCode);
	void __fastcall DoReceive(System::TObject* Sender, Word Size, void * Data, Byte RetCode);
	void __fastcall DoReceivePing(System::TObject* Sender, Word Size, void * Data, Byte RetCode);
	void __fastcall DoError(System::TObject* Sender, TNBOperation Operation, Byte Lana, Byte ErrorCode)
		;
	
public:
	__fastcall virtual TNBLink(Classes::TComponent* AOwner);
	__fastcall virtual ~TNBLink(void);
	Byte __fastcall Open(TAddName AddName);
	Byte __fastcall Close(void);
	Byte __fastcall Connect(THowConnect HowConnect);
	Byte __fastcall HangUp(void);
	Byte __fastcall Send(Word Size, void * Data);
	Byte __fastcall ChainSend(Word Size, void * Data, Word SecondSize, void * SecondData);
	Byte __fastcall Receive(Word Size);
	__property TNBComponentState NBComponentState = {read=FNBComponentState, nodefault};
	__property TTransports SupportedTransportsLAN = {read=GetSupportedTransportsLAN, nodefault};
	__property TTransports SupportedTransportsWAN = {read=GetSupportedTransportsWAN, nodefault};
	__property void * IntSendBuffer = {read=GetIntSendBuffer, nodefault};
	__property void * IntSecondSendBuffer = {read=GetIntSecondSendBuffer, nodefault};
	__property void * IntReceiveBuffer = {read=GetIntReceiveBuffer, nodefault};
	__property Word SizeIntSendBuffer = {read=GetSizeIntSendBuffer, write=SetSizeIntSendBuffer, nodefault
		};
	__property Word SizeIntSecondSendBuffer = {read=GetSizeIntSecondSendBuffer, write=SetSizeIntSecondSendBuffer
		, nodefault};
	__property Word SizeIntReceiveBuffer = {read=GetSizeIntReceiveBuffer, write=SetSizeIntReceiveBuffer
		, nodefault};
	__property void * ExtSendBuffer = {read=GetExtSendBuffer, write=SetExtSendBuffer, nodefault};
	__property void * ExtSecondSendBuffer = {read=GetExtSecondSendBuffer, write=SetExtSecondSendBuffer, 
		nodefault};
	__property void * ExtReceiveBuffer = {read=GetExtReceiveBuffer, write=SetExtReceiveBuffer, nodefault
		};
	__property Word SendSize = {read=GetSendSize, nodefault};
	__property Word SecondSendSize = {read=GetSecondSendSize, nodefault};
	__property Word ReceiveSize = {read=GetReceiveSize, nodefault};
	__property TNBProtocol ProtocolConnected = {read=GetProtocolConnected, nodefault};
	__property System::AnsiString NameProtocolConnected = {read=GetNameProtocolConnected, nodefault};
	__property System::TObject* UsedObject = {read=FUsedObject, write=FUsedObject, nodefault};
	
__published:
	__property TNBAboutInfo* About = {read=FNBAboutInfo, nodefault};
	__property TTransports TransportsLAN = {read=FTransportsLAN, write=FTransportsLAN, default=6};
	__property TTransports TransportsWAN = {read=FTransportsWAN, write=FTransportsWAN, default=0};
	__property TNCBThreadPriority ThreadPriority = {read=GetPriority, write=SetPriority, default=3};
	__property TNBThreadSynch ThreadSynch = {read=GetThreadSynch, write=SetThreadSynch, default=2};
	__property TNBUseName UseName = {read=GetUseName, write=SetUseName, default=0};
	__property Byte PingInterval = {read=FPingInterval, write=FPingInterval, nodefault};
	__property Byte ReceiveTimeout = {read=FReceiveTimeout, write=FReceiveTimeout, nodefault};
	__property Byte SendTimeout = {read=FSendTimeout, write=FSendTimeout, nodefault};
	__property System::AnsiString CallName = {read=GetCallName, write=SetCallName, nodefault};
	__property System::AnsiString OurName = {read=GetOurName, write=SetOurName, nodefault};
	__property TNBNotifyEvent OnOpen = {read=FOnOpen, write=FOnOpen};
	__property TNBNotifyEvent OnClose = {read=FOnClose, write=FOnClose};
	__property TNBNotifyEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property TNBNotifyEvent OnBreak = {read=FOnBreak, write=FOnBreak};
	__property TNBNotifyEvent OnHangUp = {read=FOnHangUp, write=FOnHangUp};
	__property TNBNotifyEvent OnSendData = {read=FOnSendData, write=FOnSendData};
	__property TNBNotifyEvent OnSendPing = {read=FOnSendPing, write=FOnSendPing};
	__property TNBReceiveNotifyEvent OnReceiveData = {read=FOnReceiveData, write=FOnReceiveData};
	__property TNBReceiveNotifyEvent OnReceivePing = {read=FOnReceivePing, write=FOnReceivePing};
	__property TNBErrorNotifyEvent OnError = {read=FOnError, write=FOnError};
};

//-- var, const, procedure ---------------------------------------------------
#define NCBCALL (Byte)(16)
#define NCBLISTEN (Byte)(17)
#define NCBHANGUP (Byte)(18)
#define NCBSEND (Byte)(20)
#define NCBRECV (Byte)(21)
#define NCBRECVANY (Byte)(22)
#define NCBCHAINSEND (Byte)(23)
#define NCBDGSEND (Byte)(32)
#define NCBDGRECV (Byte)(33)
#define NCBDGSENDBC (Byte)(34)
#define NCBDGRECVBC (Byte)(35)
#define NCBADDNAME (Byte)(48)
#define NCBDELNAME (Byte)(49)
#define NCBRESET (Byte)(50)
#define NCBASTAT (Byte)(51)
#define NCBSSTAT (Byte)(52)
#define NCBCANCEL (Byte)(53)
#define NCBADDGRNAME (Byte)(54)
#define NCBENUM (Byte)(55)
#define NCBUNLINK (Byte)(112)
#define NCBSENDNA (Byte)(113)
#define NCBCHAINSENDNA (Byte)(114)
#define NCBLANSTALERT (Byte)(115)
#define NCBACTION (Byte)(119)
#define NCBFINDNAME (Byte)(120)
#define NCBTRACE (Byte)(121)
#define ASYNCH (Byte)(128)
#define NRC_GOODRET (Byte)(0)
#define NRC_BUFLEN (Byte)(1)
#define NRC_ILLCMD (Byte)(3)
#define NRC_CMDTMO (Byte)(5)
#define NRC_INCOMP (Byte)(6)
#define NRC_BADDR (Byte)(7)
#define NRC_SNUMOUT (Byte)(8)
#define NRC_NORES (Byte)(9)
#define NRC_SCLOSED (Byte)(10)
#define NRC_CMDCAN (Byte)(11)
#define NRC_DUPNAME (Byte)(13)
#define NRC_NAMTFUL (Byte)(14)
#define NRC_ACTSES (Byte)(15)
#define NRC_LOCTFUL (Byte)(17)
#define NRC_REMTFUL (Byte)(18)
#define NRC_ILLNN (Byte)(19)
#define NRC_NOCALL (Byte)(20)
#define NRC_NOWILD (Byte)(21)
#define NRC_INUSE (Byte)(22)
#define NRC_NAMERR (Byte)(23)
#define NRC_SABORT (Byte)(24)
#define NRC_NAMCONF (Byte)(25)
#define NRC_IFBUSY (Byte)(33)
#define NRC_TOOMANY (Byte)(34)
#define NRC_BRIDGE (Byte)(35)
#define NRC_CANOCCR (Byte)(36)
#define NRC_CANCEL (Byte)(38)
#define NRC_DUPENV (Byte)(48)
#define NRC_ENVNOTDEF (Byte)(52)
#define NRC_OSRESNOTAV (Byte)(53)
#define NRC_MAXAPPS (Byte)(54)
#define NRC_NOSAPS (Byte)(55)
#define NRC_NORESOURCES (Byte)(56)
#define NRC_INVADDRESS (Byte)(57)
#define NRC_INVDDID (Byte)(59)
#define NRC_LOCKFAIL (Byte)(60)
#define NRC_OPENERR (Byte)(63)
#define NRC_SYSTEM (Byte)(64)
#define NRC_PENDING (Byte)(255)
#define NRC_NCBBUSY (Byte)(241)
#define NRC_NOTOPEN (Byte)(242)
#define NRC_NOTCONNECT (Byte)(243)
#define NCBNAMSZ (Byte)(16)
#define MAX_LANA (Byte)(254)
#define MaxDatagramData (Word)(512)
#define MaxSessionData (int)(65535)
extern int ThreadPriorities[7];
extern Byte __fastcall GetLanaList(PLanaList LanaList);
extern Byte __fastcall ResetLana(Byte LanaNum, Byte ReqSessions, Byte ReqNames, TNBLanaResources LanaRes
	);
extern Byte __fastcall GetLocalNames(Byte LanaNum, Classes::TStrings* LocalNames);
extern Byte __fastcall GetMACAddress(Byte LanaNum, PMACAddress MACAddress);
extern System::AnsiString __fastcall GetErrorString(Byte ErrorCode);
extern void __fastcall Register(void);
extern void __fastcall finalization(void);
//-- template instantiations -------------------------------------------------
template class TNBComponentState ;
template class TTransports ;

}	/* namespace Nblib32 */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Nblib32;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// NBLib32
