#include "anir32.h"


//forward declaration
class CAnirRemoteCtrl;

class COCXRemote : public CAnirRemoteControl
{
public: 
//constructors / Destructors
  COCXRemote() { m_pControl = NULL; };

//methods
  void SetControl(CAnirRemoteCtrl* pControl) { m_pControl = pControl; };

protected:
  virtual void ProcessReceivedData(BYTE data, BOOL bRepeat);
  CAnirRemoteCtrl* m_pControl;
};



class CAnirRemoteCtrl : public COleControl
{
	DECLARE_DYNCREATE(CAnirRemoteCtrl)

  friend class COCXRemote;

// Constructor
public:
	CAnirRemoteCtrl();

// Overrides
	virtual void OnDraw(CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);
	virtual void DoPropExchange(CPropExchange* pPX);
	virtual void OnResetState();
  virtual BOOL OnSetExtent(LPSIZEL lpSizeL);
  virtual BOOL OnProperties(LPMSG lpMsg, HWND hWndParent, LPCRECT lpRect);


// Implementation
protected:
	~CAnirRemoteCtrl();

	DECLARE_OLECREATE_EX(CAnirRemoteCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CAnirRemoteCtrl)      // GetTypeInfo
	DECLARE_OLECTLTYPE(CAnirRemoteCtrl)		// Type name and misc status

//member variables
  COCXRemote m_Remote;
  HICON m_hLogo;

// Message maps
	//{{AFX_MSG(CAnirRemoteCtrl)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CAnirRemoteCtrl)
	afx_msg BOOL Start(short nPort);
	afx_msg BOOL Stop();
	afx_msg short GetPort();
	afx_msg BOOL GetIsStarted();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

	afx_msg void AboutBox();

// Event maps
	//{{AFX_EVENT(CAnirRemoteCtrl)
	void FireProcessReceivedData(short nData, BOOL bRepeat)
		{FireEvent(eventidProcessReceivedData,EVENT_PARAM(VTS_I2  VTS_BOOL), nData, bRepeat);}
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CAnirRemoteCtrl)
	dispidStart = 1L,
	dispidStop = 2L,
	dispidGetPort = 3L,
	dispidGetIsStarted = 4L,
	eventidProcessReceivedData = 1L,
	//}}AFX_DISP_ID
	};
};
