/*
Module : ANIRREMOTECTL.CPP
Purpose: Implementation for the OCX wrapper 
Created: PJN / 28-01-1998
History: PJN / 24-03-1998 1) Now using PostMessage instead of SendMessage
                             to transition from background thread to foreground
                          2) Removed some incorrect comments
                          3) Code now compiles cleanly when built for UNICODE

Copyright (c) 1998 by PJ Naughter.  
All rights reserved.

*/

/////////////////////////////////  Includes  //////////////////////////////////
#include "stdafx.h"
#include "AnirRemote.h"
#include "AnirRemoteCtl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void COCXRemote::ProcessReceivedData(BYTE data, BOOL bRepeat) 
{ 
  m_pControl->FireProcessReceivedData(data, bRepeat); 
}

IMPLEMENT_DYNCREATE(CAnirRemoteCtrl, COleControl)

BEGIN_MESSAGE_MAP(CAnirRemoteCtrl, COleControl)
	//{{AFX_MSG_MAP(CAnirRemoteCtrl)
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CAnirRemoteCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CAnirRemoteCtrl)
	DISP_FUNCTION(CAnirRemoteCtrl, "Start", Start, VT_BOOL, VTS_I2)
	DISP_FUNCTION(CAnirRemoteCtrl, "Stop", Stop, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAnirRemoteCtrl, "GetPort", GetPort, VT_I2, VTS_NONE)
	DISP_FUNCTION(CAnirRemoteCtrl, "GetIsStarted", GetIsStarted, VT_BOOL, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CAnirRemoteCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()

BEGIN_EVENT_MAP(CAnirRemoteCtrl, COleControl)
	//{{AFX_EVENT_MAP(CAnirRemoteCtrl)
	EVENT_CUSTOM("ProcessReceivedData", FireProcessReceivedData, VTS_I2  VTS_BOOL)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()

IMPLEMENT_OLECREATE_EX(CAnirRemoteCtrl, "ANIR.AnirRemoteCtrl.1",
	0x9c325914, 0xbf0f, 0x11d1, 0x81, 0xf0, 0x72, 0x60, 0xbc, 0, 0, 0)

IMPLEMENT_OLETYPELIB(CAnirRemoteCtrl, _tlid, _wVerMajor, _wVerMinor)

const IID BASED_CODE IID_DAnirRemote =
		{ 0x9c325912, 0xbf0f, 0x11d1, { 0x81, 0xf0, 0x72, 0x60, 0xbc, 0, 0, 0 } };
const IID BASED_CODE IID_DAnirRemoteEvents =
		{ 0x9c325913, 0xbf0f, 0x11d1, { 0x81, 0xf0, 0x72, 0x60, 0xbc, 0, 0, 0 } };

static const DWORD BASED_CODE _dwAnirRemoteOleMisc =
  OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CAnirRemoteCtrl, IDS_ANIRREMOTE, _dwAnirRemoteOleMisc)

BOOL CAnirRemoteCtrl::CAnirRemoteCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_ANIRREMOTE,
			IDB_ANIRREMOTE,
			afxRegApartmentThreading,
			_dwAnirRemoteOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}

CAnirRemoteCtrl::CAnirRemoteCtrl()
{
	InitializeIIDs(&IID_DAnirRemote, &IID_DAnirRemoteEvents);
  m_Remote.SetControl(this);
  m_hLogo = AfxGetApp()->LoadIcon(IDI_ABOUTDLL);
  SetInitialSize(32, 32);  //set the initial size to the size of the icon
}

CAnirRemoteCtrl::~CAnirRemoteCtrl()
{
}

void CAnirRemoteCtrl::OnDraw(CDC* pdc, const CRect& rcBounds, const CRect& /*rcInvalid*/)
{
  //just draw our icon at the position indicated with a standard background color
  CBrush brush(GetSysColor(COLOR_3DFACE));
  CBrush* pOldBrush = pdc->SelectObject(&brush);
  pdc->Rectangle(rcBounds);
  pdc->DrawIcon(rcBounds.left, rcBounds.top, m_hLogo);
  pdc->SelectObject(pOldBrush);
}

void CAnirRemoteCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);
}

void CAnirRemoteCtrl::OnResetState()
{
	COleControl::OnResetState();
}

void CAnirRemoteCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_ANIRREMOTE);
	dlgAbout.DoModal();
}

BOOL CAnirRemoteCtrl::Start(short nPort) 
{
	return m_Remote.StartMonitoring(nPort);
}

BOOL CAnirRemoteCtrl::Stop() 
{
	return m_Remote.StopMonitoring();
}

short CAnirRemoteCtrl::GetPort() 
{
	return (short) m_Remote.GetPort();
}

BOOL CAnirRemoteCtrl::GetIsStarted() 
{
	return m_Remote.IsStarted();
}

BOOL CAnirRemoteCtrl::OnSetExtent(LPSIZEL /*lpSizeL*/)
{
  return FALSE; //disallow resizing
}

BOOL CAnirRemoteCtrl::OnProperties(LPMSG /*lpMsg*/, HWND /*hWndParent*/, LPCRECT /*lpRect*/)
{
  //we don't support a properties dialog
  return TRUE; 
}
  
