#include "executer.h"
#include "error.h"
#include "systemcatalog.h"
#include "server.h"
#include "general.h"
#include "shalloc.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


void MentorSQLVersion()
{
printf( "Mentor SQL - a freeware product by Systementor AB\n");
printf( "Version ALPHA 0.03\n");
printf( "--------------------------------------------------\n");
}

void MentorSQLStartup()
{
//Initializes the server and system catalog
GetServer()->GetSystemCatalog();
}



void ExecSQL( const char *szSQL )
{
CParseTree Tree;
printf("\n\n\nParsing %s\n", szSQL );	
if ( Tree.ParseSQL( szSQL ) )
	{
	printf("Parse error");
	return;
	}

printf("Executing \n" );	
CExecuter Executer( &Tree );
int nRet = Executer.Execute();
if ( nRet )
	printf( "Retur %s\n", ErrorGetDescription( (ERROR_NUM) nRet ) );
else
	printf("\nOK\n");
};

void main()
{
MentorSQLVersion();
MentorSQLStartup();
//SHAllocInitialize();	 
SHALLOC_BEGIN_GUARD()
 			   
//Create tables for test 
ExecSQL( "drop table supplier " );
ExecSQL( "create table supplier ( s char(5), sname char(20), status integer, city char(15) )" );
ExecSQL( "insert into supplier values ( 'S1', 'Smith', 20, 'London')" );
ExecSQL( "insert into supplier values ( 'S2', 'Jones', 10, 'Paris')" );
ExecSQL( "insert into supplier values ( 'S3', 'Blake', 30, 'Paris')" );
ExecSQL( "insert into supplier values ( 'S4', 'Clark', 20, 'London')" );
ExecSQL( "insert into supplier values ( 'S5', 'Adams', 30, 'Athens')" );

ExecSQL( "drop table part " );
ExecSQL( "create table part ( p char(5), pname char(20), color char(6), weight integer, city char(15) )" );
ExecSQL( "insert into part values ( 'P1', 'Nut', 'Red', 12,  'London')" );
ExecSQL( "insert into part values ( 'P2', 'Bolt', 'Green', 17,  'Paris')" );
ExecSQL( "insert into part values ( 'P3', 'Screw', 'Blue', 17,  'Rome')" );
ExecSQL( "insert into part values ( 'P4', 'Screw', 'Red', 14,  'London')" );
ExecSQL( "insert into part values ( 'P5', 'Cam', 'Blue', 12,  'Paris')" );
ExecSQL( "insert into part values ( 'P6', 'Coq', 'Red', 19,  'London')" );


ExecSQL( "drop table projects " );
ExecSQL( "create table projects ( j char(4), jname char(10), city char(15) )" );

ExecSQL( "insert into projects values ( 'J1', 'Sorter', 'Paris' )" );
ExecSQL( "insert into projects values ( 'J2', 'Punch', 'Rome' )" );
ExecSQL( "insert into projects values ( 'J3', 'Reader', 'Athens') " );
ExecSQL( "insert into projects values ( 'J4', 'Console', 'Athens') " );
ExecSQL( "insert into projects values ( 'J5', 'Collator', 'London') " );
ExecSQL( "insert into projects values ( 'J6', 'Terminal', 'Oslo' )" );
ExecSQL( "insert into projects values ( 'J7', 'Tape', 'London' )" );
ExecSQL( "create index projects_ix1 on projects ( j )" );

ExecSQL( "update projects set jname = 'NEW', city = 'NEWCITY' where j = 'J5'" );
ExecSQL( "select * from projects where j = 'J5'" );


ExecSQL( "drop table spj " );
ExecSQL( "create table spj ( s char(5), p char(5), j char(4), qty integer )" );
ExecSQL( "insert into spj values ( 'S1', 'P1', 'J1', 200 )" );
ExecSQL( "insert into spj values ( 'S1', 'P1', 'J4', 700 )" );
ExecSQL( "insert into spj values ( 'S2', 'P3', 'J1', 400 )" );
ExecSQL( "insert into spj values ( 'S1', 'P3', 'J2', 200 )" );
ExecSQL( "insert into spj values ( 'S2', 'P3', 'J3', 200 )" );
ExecSQL( "insert into spj values ( 'S2', 'P3', 'J4', 500 )" );
ExecSQL( "insert into spj values ( 'S2', 'P3', 'J5', 600 )" );
ExecSQL( "insert into spj values ( 'S2', 'P3', 'J6', 400 )" );
ExecSQL( "insert into spj values ( 'S2', 'P3', 'J7', 800 )" );
ExecSQL( "insert into spj values ( 'S2', 'P5', 'J2', 100 )" );
ExecSQL( "insert into spj values ( 'S3', 'P3', 'J1', 200 )" );
ExecSQL( "insert into spj values ( 'S3', 'P4', 'J2', 500 )" );
ExecSQL( "insert into spj values ( 'S4', 'P6', 'J3', 300 )" );
ExecSQL( "insert into spj values ( 'S4', 'P6', 'J7', 300 )" );
ExecSQL( "insert into spj values ( 'S5', 'P2', 'J2', 200 )" );
ExecSQL( "insert into spj values ( 'S5', 'P2', 'J4', 100 )" );
ExecSQL( "insert into spj values ( 'S5', 'P5', 'J5', 500 )" );
ExecSQL( "insert into spj values ( 'S5', 'P5', 'J7', 100 )" );
ExecSQL( "insert into spj values ( 'S5', 'P6', 'J2', 200 )" );
ExecSQL( "insert into spj values ( 'S5', 'P1', 'J4', 100 )" );
ExecSQL( "insert into spj values ( 'S5', 'P3', 'J4', 200 )" );
ExecSQL( "insert into spj values ( 'S5', 'P4', 'J4', 800 )" );
ExecSQL( "insert into spj values ( 'S5', 'P5', 'J4', 400 )" );
ExecSQL( "insert into spj values ( 'S5', 'P6', 'J4', 500 )" );
ExecSQL( "select * from sysindexes" );

ExecSQL( "select * from spj where s = 'S2'" );
ExecSQL( "update spj set p = '99' where s = 'S2'" );
ExecSQL( "select * from spj where s = 'S2'" );


ExecSQL( "select * from sysindexes" );
//ExecSQL( "delete from projects" );

/*ExecSQL( "select supplier.s, supplier.city from supplier where s = 'S1'" );

ExecSQL( "select projects.j, projects.city from projects where j = 'J7'" );*/


//ExecSQL( "select supplier.s, supplier.city, projects.j, projects.city, part.p, part.city from supplier, part, projects where supplier.city = part.city and part.city = projects.city and j = 'J7'" );
ExecSQL( "select supplier.city, supplier.s from supplier, part, projects where supplier.city = part.city and part.city = projects.city and j = 'J7'" );
ShutDownServer();
SHALLOC_END_GUARD()

//Now get input and execute...
while ( true )
	{
	char szBuf[512];
	printf( "\nMentorSQL>");
	gets( szBuf );
	if ( !stricmp( szBuf, "exit" ) )
		return;
	ExecSQL( szBuf );
	}
}

