/*  xbase.h

    Xbase project source code

    This file contains a header file for the XBASE class, which is the
    base class for using the Xbase DBMS library.

    Copyright (C) 1997  StarTech, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.5   1/2/98     - Added memo field support
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Numeric index keys

///////////////////////////////////////////////////////////////////////////////
	   25/9/98 - Changes made by Stefan Holmberg for MentorSQL
	   THIS IS NOT OFFICIAL XBASE CHANGES!
	   - Added import/export for DLL

	   I know I might have subclasses and changed in those classes instead but
	   since I'm gonna change a lot more - like memory allocation schema and 
	   file I/O it wouldn't have helped me there...
///////////////////////////////////////////////////////////////////////////////

*/

#ifndef XBASE_FLAG
#define XBASE_FLAG

//#ifdef XBASELIB_EXPORTS
//#define XBASELIB_API __declspec(dllexport)
//#else
//#define XBASELIB_API __declspec(dllimport)
//#endif
// But since I statically link all the files when doing this first betabetabeta release
// I just  undefines XBASELIB_API
// You see I have created dll-s but not decided how to split functionality
// amongst general library and client library

#define XBASELIB_API



#include <string.h>
#include "xtypes.h"
#include "options.h"
#include "retcodes.h"
#include "xdate.h"


#if defined(UNIX) && defined(DOS)
error In file options.h, only of UNIX, VMS or DOS can be specified
#endif

#if defined(VMS) && defined(DOS)
error In file options.h, only of UNIX, VMS or DOS can be specified
#endif

#if defined(UNIX) && defined(VMS)
error In file options.h, only of UNIX, VMS or DOS can be specified
#endif

#if defined(INDEX_NDX) && !defined(EXPRESSIONS)   /* expressions required for indexes */
#define EXPRESSIONS
#endif

#if defined(INDEX_NDX) || defined(EXPRESSIONS)
#include "exp.h"
#endif

class DBF;

struct XBASELIB_API DbList{
   DbList * NextDbf;
   CHAR * DbfName;
   DBF  * dbf;
};

#if defined(INDEX_NDX) || defined(EXPRESSIONS)
//class XBASE : public XDATE, public EXP { 

class XBASELIB_API XBASE : public EXPN { 
#else
class XBASELIB_API XBASE : public XDATE {
#endif
  
   DbList * DbfList;
   DbList * FreeDbfList;
   SHORT EndianType;                     /* B = Big Endian, L = Little Endian */

public:
   XBASE::XBASE( VOID );
   SHORT  AddDbfToDbfList( DBF *, CHAR * );
   DBF *  GetDbfPtr( CHAR * );
   SHORT  DirectoryExistsInName( CHAR * );
   SHORT  GetEndianType( VOID ) { return EndianType; }
   DOUBLE GetDouble( CHAR * );
   LONG   GetLong  ( CHAR * );
   SHORT  GetShort ( CHAR * );
   VOID   PutLong  ( CHAR *, LONG );
   VOID   PutShort ( CHAR *, SHORT );
   VOID   PutDouble( CHAR *, DOUBLE );
   SHORT  RemoveDbfFromDbfList( DBF * );
};

#include "dbf.h"

#ifdef INDEX_NDX
#include "ndx.h"
#endif

#ifdef LOCKING_ON
#include <fcntl.h>
#else
enum { F_SETLKW = 0, F_WRLCK = 0 };
#endif

#ifdef UI_HTML_ON
#include "html.h"
#endif


#ifdef EXPRESSIONS
#include "exp.h"
#endif

#endif		// XBASE_FLAG
