/*  retcodes.h

    Xbase project source code

    This file contains a listing of all the Xbase return codes.

    Copyright (C) 1997  StarTech, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.5   1/2/98     - Added memo field support
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Numeric index keys

///////////////////////////////////////////////////////////////////////////////
	   25/9/98 - Changes made by Stefan Holmberg for MentorSQL
	   THIS IS NOT OFFICIAL XBASE CHANGES!
	   - Added import/export for DLL

	   I know I might have subclasses and changed in those classes instead but
	   since I'm gonna change a lot more - like memory allocation schema and 
	   file I/O it wouldn't have helped me there...
///////////////////////////////////////////////////////////////////////////////

*/

#ifndef RETCODES_FLAG
#define RETCODES_FLAG

/***********************************************/
/* Return Codes and Error Messages             */

#define NO_ERROR                 0
#define XBASE_EOF              100
#define XBASE_BOF              101
#define NO_MEMORY              102
#define FILE_EXISTS            103
#define OPEN_ERROR             104
#define WRITE_ERROR            105
#define UNKNOWN_FIELD_TYPE     106
#define ALREADY_OPEN           107
#define NOT_XBASE              108
#define INVALID_RECORD         109
#define INVALID_OPTION         110
#define NOT_OPEN               111
#define SEEK_ERROR             112
#define READ_ERROR             113
#define NOT_FOUND              114
#define FOUND                  115
#define INVALID_KEY            116
#define INVALID_NODELINK       117
#define KEY_NOT_UNIQUE         118
#define INVALID_KEY_EXPRESSION 119
#define DBF_FILE_NOT_OPEN      120
#define INVALID_KEY_TYPE       121
#define INVALID_NODE_NO        122
#define NODE_FULL              123
#define INVALID_FIELDNO        124
#define INVALID_DATA           125
#define NOT_LEAFNODE           126
#define LOCK_FAILED            127
#define CLOSE_ERROR            128
#define INVALID_SCHEMA         129
#define INVALID_NAME           130
#define INVALID_BLOCK_SIZE     131
#define INVALID_BLOCK_NO       132
#define NOT_MEMO_FIELD         133
#define NO_MEMO_DATA           134
#define EXP_SYNTAX_ERROR       135
#define PARSE_ERROR            136
#define NO_DATA                137
#define UNKNOWN_TOKEN_TYPE     138
#define INVALID_FIELD          140
#define INSUFFICIENT_PARMS     141
#define INVALID_FUNCTION       142

#endif
