/*  html.h

    Xbase project source code
 
    This file contains a header file for the HTML object which is used
    for HTML generation.

    Copyright (C) 1997  StarTech, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.5   1/2/98     - Added memo field support
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Numeric index keys


///////////////////////////////////////////////////////////////////////////////
	   25/9/98 - Changes made by Stefan Holmberg for MentorSQL
	   THIS IS NOT OFFICIAL XBASE CHANGES!
	   - Added import/export for DLL

	   I know I might have subclasses and changed in those classes instead but
	   since I'm gonna change a lot more - like memory allocation schema and 
	   file I/O it wouldn't have helped me there...
///////////////////////////////////////////////////////////////////////////////
*/

#ifndef FLAG_HTML
#define FLAG_HTML

//#ifdef XBASELIB_EXPORTS
//#define XBASELIB_API __declspec(dllexport)
//#else
//#define XBASELIB_API __declspec(dllimport)
//#endif

#define XBASELIB_API

#include "options.h"
#include "stdlib.h"
#include "string.h"
#include "xtypes.h"

struct XBASELIB_API FieldList{
   CHAR * Label;                     /* field label on form */
   CHAR * FieldName;                 /* form field name     */ 
   SHORT FieldLen;                   /* form display length */
   SHORT FieldNo;                    /* database field no   */
   SHORT Option;                     /* field option        */
};

typedef CHAR **ArrayPtr;

class XBASELIB_API HTML {
   ArrayPtr FieldNameArray;
   ArrayPtr DataValueArray;
   SHORT    NoOfDataFields;

   CHAR * HtmlWorkBuf;
   SHORT  HtmlBufLen;

   VOID   LoadArray( VOID );
   VOID   DeleteEscChars( CHAR * );
   VOID   InitVals( VOID );

public:
   HTML   ( VOID );
   VOID   BoldOff( VOID ) { cout << "</b>\n"; };
   VOID   BoldOn( VOID ) { cout << "<b>"; };
   VOID   Bullet( VOID ) { cout << "<li>"; };
   VOID   DumpArray( VOID );
   VOID   EmphasizeOff( VOID ) { cout << "</em>\n"; };
   VOID   EmphasizeOn( VOID ) { cout << "<em>"; };
   VOID   EndHtmlPage( VOID ) { cout << "</BODY>\n</HTML>\n"; }
   SHORT  GenFormFields( DBF *, SHORT, CHAR *, FieldList * );
   SHORT  GetArrayNo( CHAR * );
   CHAR * GetData( SHORT );
   CHAR * GetDataForField( CHAR * );
   CHAR * GetEnv( CHAR * s ){ return getenv( s ); }
   SHORT  GetMethod( VOID );
   VOID   HeaderOff( SHORT i ){ cout << "</h" << i << ">\n"; };
   VOID   HeaderOn( SHORT i ){ cout << "<h" << i << ">\n"; };
   VOID   ItalicOff( VOID ) { cout << "</i>\n"; };
   VOID   ItalicOn( VOID ) { cout << "<i>"; };
   VOID   NewLine( VOID ) { cout << "<br>"; }
   SHORT  PostMethod( VOID );
   VOID   PrintEncodedChar( CHAR );
   VOID   PrintEncodedString( CHAR * );
   VOID   PrintHtml( CHAR * s ) { cout << s; };
   VOID   PrintHtml( LONG l ) { cout << l; };
   VOID   PrintHtml( SHORT i ) { cout << i; };
   VOID   PrintHtml( int i ) { cout << i; };
   VOID   StartHtmlPage( CHAR * );
   VOID   StartTextPage( VOID ) { cout << "Content-type: text/plain\n\n"; }
   VOID   TextOut( CHAR * );
   LONG   Tally( CHAR * );
   SHORT  SetCookie(CHAR *,CHAR *,CHAR *,CHAR *,CHAR *,CHAR *,CHAR *,SHORT);
   CHAR * GetCookie( CHAR * );
   VOID   SpaceToPlus( CHAR * );
   VOID   PlusToSpace( CHAR * );
};

#endif		// FLAG_HTML
