#include "stdafx.h"
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include "tcp.h"

#include "shalloc.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

int TCP_Send( SOCKET hSocket, char *szData, long lSize )
{
//First send a size - that's always 10 bytes
char szSize[10];
sprintf( szSize, "%10d", lSize );
int nSent = send( hSocket, ( const char * )szSize, 10, 0 );
if ( nSent != 10 )
	return nSent;
nSent = send( hSocket, szData, lSize, 0 );
return nSent;
};

int TCP_Read( SOCKET hSocket, char **szData, long &lSize )
{
//First read a size - that's always 10 bytes
char szSize[10];
memset( szSize, 0, 10 );
int nRecv = recv( hSocket, ( char * )szSize, 10,0 );
if ( nRecv != 10 )
	return nRecv;
lSize = atol( szSize );
*szData = new char[ lSize + 1 ];
memset(*szData,  0, lSize + 1 );

int nTotalRead = 0;
while ( 1 )
	{
	nRecv = recv( hSocket, &*szData[nTotalRead], lSize, 0 );
	if ( nRecv == 0 || nRecv == SOCKET_ERROR )
		{
		delete []*szData;
		return nRecv;
		}
	nTotalRead += nRecv;
	if ( nTotalRead == lSize )
		break;
	}
return nRecv;
};


class SockInitializer
{
public:
	SockInitializer();
	~SockInitializer();
};

SockInitializer Initializer;

SockInitializer::SockInitializer()
{
WSADATA wsaData;
WSAStartup( MAKEWORD(1,1), &wsaData );
}

SockInitializer::~SockInitializer()
{
WSACleanup();
}





