#include <windows.h>
#include "xbase.h"
#include "systemcatalog.h"
#include "tables.h"
#include "error.h"

#include "shalloc.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//Global function used to convert file handler errors ( that is XBase errors )
//to local error numbers. Used to ease plugging other file handlers in
/*
ERROR_NUM ErrorConvertFileHandlerError( short sErrNum )
{
switch( sErrNum )
	{
	case NO_ERROR:
		return ERROR_NUM_OK:
	case 
#define XBASE_EOF              100
#define XBASE_BOF              101
#define NO_MEMORY              102
#define FILE_EXISTS            103
#define OPEN_ERROR             104
#define WRITE_ERROR            105
#define UNKNOWN_FIELD_TYPE     106
#define ALREADY_OPEN           107
#define NOT_XBASE              108
#define INVALID_RECORD         109
#define INVALID_OPTION         110
#define NOT_OPEN               111
#define SEEK_ERROR             112
#define READ_ERROR             113
#define NOT_FOUND              114
#define FOUND                  115
#define INVALID_KEY            116
#define INVALID_NODELINK       117
#define KEY_NOT_UNIQUE         118
#define INVALID_KEY_EXPRESSION 119
#define DBF_FILE_NOT_OPEN      120
#define INVALID_KEY_TYPE       121
#define INVALID_NODE_NO        122
#define NODE_FULL              123
#define INVALID_FIELDNO        124
#define INVALID_DATA           125
#define NOT_LEAFNODE           126
#define LOCK_FAILED            127
#define CLOSE_ERROR            128
#define INVALID_SCHEMA         129
#define INVALID_NAME           130
#define INVALID_BLOCK_SIZE     131
#define INVALID_BLOCK_NO       132
#define NOT_MEMO_FIELD         133
#define NO_MEMO_DATA           134
#define EXP_SYNTAX_ERROR       135
#define PARSE_ERROR            136
#define NO_DATA                137
#define UNKNOWN_TOKEN_TYPE     138
#define INVALID_FIELD          140
#define INSUFFICIENT_PARMS     141
#define INVALID_FUNCTION       142
	}
}
*/

CTempIndex::CTempIndex( CTable *pTable )
	:CIndex( pTable )
{
}

CTempIndex::~CTempIndex()
{
Drop();
}


CIndex::CIndex( CBaseTable *pTable )
{
m_pTable = pTable;
m_pNDX = new NDX( pTable->m_pDBF );
}

CIndex::~CIndex()
{
CloseIndex();
delete m_pNDX;
//m_pNDX getting cleaned up by the table?
}

std::string CIndex::GetName()
{
return m_strName;
}


std::string CBaseTable::GetColNameFromPhysName( const char *szPhysColName )
{
std::string strTemp = szPhysColName;
strTemp = strTemp.substr( 3 );
int nColNo = atoi( strTemp.c_str() );
return GetFieldName( nColNo );
}

std::string CIndex::GetDirectory()
{
return m_strDataDirectory;
}

short CIndex::OpenIndex ( char *szName, const char *szDirectory )
{
m_strName = szName;
m_strDataDirectory = szDirectory;
std::string strPath = m_strDataDirectory + "\\" + szName + ".ndx";
SHORT rc;
rc = m_pNDX->OpenIndex( (char *)strPath.c_str() );
if ( rc != NO_ERROR )
	return rc;
m_strPhysColName = m_pNDX->GetExpression();
m_strColName = m_pTable->GetColNameFromPhysName( m_strPhysColName.c_str() );
return rc;
}

short  CIndex::CloseIndex( void )
{
if ( m_pNDX )
	return m_pNDX->CloseIndex();
return 0;
}

char *CIndex::GetExpression()
{
return (char *)m_strColName.c_str();
}

short CIndex::FindKey( const char *szKey )
{
short rc = m_pNDX->FindKey( (char *)szKey );
if ( rc == FOUND )
	return ERROR_NUM_OK;
return rc;
}
		    
short CIndex::FindKey( long lKey )
{
short rc =  m_pNDX->FindKey( lKey );
if ( rc == FOUND )
	return ERROR_NUM_OK;
return rc;
}

short CIndex::FindKey( double dKey )
{
short rc =  m_pNDX->FindKey( dKey );
if ( rc == FOUND )
	return ERROR_NUM_OK;
return rc;
}

short CIndex::NextKey()
{
return m_pNDX->GetNextKey();
}

short CIndex::PrevKey()
{
return m_pNDX->GetPrevKey();
}


short  CIndex::CreateIndex( char *szIndexName, const char *szDirectory, char *szPhysColName, char *szLogicalColName, bool fUnique )
{
m_strColName = szLogicalColName;
m_strPhysColName = szPhysColName;
std::string strPath = szDirectory;
strPath = strPath + "\\" + szIndexName;
short rc = m_pNDX->CreateIndex( (char *)strPath.c_str(), szPhysColName, fUnique ? 1 : 0 , OVERLAY);
if ( rc != 0 )
	return rc;
return m_pNDX->ReIndex();
}

short  CTempIndex::CreateIndex( char *szExp, bool fUnique )
{
return 0;
}


CBaseTable::CBaseTable( XBASE *pXBase )
{
m_pDBF = new DBF( pXBase );
m_pColumnDesc = NULL;
}

int CBaseTable::CreateIndex( const char *szIndexName, const char *szExp, bool fUnique )
{
CIndex *pIndex = new CIndex( this );
//Check if valid expression - that is a valid column

int nFieldNo = GetFieldNo(szExp);
if ( nFieldNo == -1 )
	return 1;

char szPhysColName[10];
sprintf( szPhysColName, "COL%d", nFieldNo );

short rc = pIndex->CreateIndex( (char *)szIndexName, m_strDataDirectory.c_str(), szPhysColName, (char *)szExp , fUnique );
if ( rc )
	delete pIndex;
else
	m_IndexArray.push_back( pIndex );
return rc;
}

int CBaseTable::OpenIndex( const char *szIndexName )
{
CIndex *pIndex = new CIndex( this );
short rc = pIndex->OpenIndex( (char *)szIndexName, m_strDataDirectory.c_str() );
if ( rc )
	delete pIndex;
else
	m_IndexArray.push_back( pIndex );
return rc;
}

CIndex *CBaseTable::GetIndex( const char *szColName )
{
for ( CIndexArray::iterator iter = m_IndexArray.begin();
	iter != m_IndexArray.end(); iter++ )
	{
	CIndex *pIndex = *iter;
	if ( !stricmp(pIndex->GetName().c_str(),szColName ) )
		return *iter;
	}
return NULL;

}

int CBaseTable::DeleteIndexFromArray( const char *szIndexName )
{
for ( CIndexArray::iterator iter = m_IndexArray.begin();
	iter != m_IndexArray.end(); iter++ )
	{
	CIndex *pIndex = *iter;
	m_IndexArray.erase( iter, iter );
	delete pIndex;
	return 0;
	}
return 1;

}

CBaseTable::~CBaseTable()
{
for ( int i = 0; i < m_IndexArray.size(); i++ )
	{
	delete m_IndexArray.at(i);
	}
m_IndexArray.erase( m_IndexArray.begin(), m_IndexArray.end() );
if ( m_pDBF )
	{
	m_pDBF->CloseDatabase();
	delete m_pDBF;
	}
if ( m_pColumnDesc )
	delete []m_pColumnDesc;
}

std::string CBaseTable::GetName()
{
return m_strName;
}

std::string CBaseTable::GetDirectory()
{
return m_strDataDirectory;
}

std::string CBaseTable::GetFullPath()
{
return m_strDataDirectory + "\\" + m_strName + ".dbf";
}


bool CheckAndColumn( CColumnDesc *pColumnDescIn, int nDataType, short sLen )
{
if ( sLen != pColumnDescIn->m_FieldLen )
	return false;
switch( pColumnDescIn->m_DataType )
	{
	case MENTORSQL_DATATYPE_CHAR:
		if ( nDataType != CHAR_FLD )
			return false;
		break;
	case MENTORSQL_DATATYPE_INT:
		if ( nDataType != NUMERIC_FLD )
			return false;
		break;
	case MENTORSQL_DATATYPE_FLOAT:
		if ( nDataType != FLOAT_FLD )
			return false;
		break;
	}
return true;
}

int CBaseTable::Open( CColumnDesc *pColumnDesc, int nCount, const char *szTableName, const char *szDirectory )
{
m_strDataDirectory = szDirectory;
m_strName = szTableName;

std::string strPath = GetFullPath();
SHORT rc;
rc = m_pDBF->OpenDatabase( (char *)strPath.c_str() );
if ( rc != NO_ERROR )
	return rc;
//Now check to see if pColumnDesc matches what we got in file...
if ( nCount !=  m_pDBF->GetFieldCount() )
	return ERROR_NUM_INTERNAL_CORRUPTFILE;

for ( int i = 0; i < nCount; i++ )
	{
	if ( !CheckAndColumn( &pColumnDesc[i], m_pDBF->GetFieldType(i), m_pDBF->GetFieldLen(i) ))
		return ERROR_NUM_INTERNAL_CORRUPTFILE;		
	}
m_pColumnDesc = new CColumnDesc[nCount];
memcpy( m_pColumnDesc, pColumnDesc, sizeof(CColumnDesc) * nCount );
return rc;
}

int CIndex::Drop()
{
m_pNDX->CloseIndex();
delete m_pNDX;
m_pNDX = NULL;
std::string strPath = m_strDataDirectory + "\\" + m_strName + ".ndx";
DeleteFile( strPath.c_str() );
return 0;
}


int CBaseTable::DropIndex( const char *szIndex )
{
for ( int i = 0; i < m_IndexArray.size(); i++ )
	{
	CIndex *pIndex = m_IndexArray.at(i);
	if ( !stricmp(pIndex->GetExpression(),szIndex ) )
		{
		pIndex->CloseIndex();
		pIndex->Drop();
		delete pIndex;
		m_IndexArray.erase( m_IndexArray.begin() + i );
		return 0;
		}
	}
return ERROR_NUM_INVALIDINDEX;
}


int CBaseTable::Drop()
{
//First of all drop all indexes...
for ( int i = 0; i < m_IndexArray.size(); i++ )
	{
	CIndex *pIndex = m_IndexArray.at(i);
	pIndex->Drop();
	delete pIndex;
	}
m_IndexArray.erase( m_IndexArray.begin(), m_IndexArray.end() );
m_pDBF->CloseDatabase();
delete m_pDBF;
m_pDBF = NULL;
std::string strPath = m_strDataDirectory + "\\" + m_strName + ".dbf";
DeleteFile( strPath.c_str() );
return 0;
}


short CBaseTable::GetLastRecord()
{
SHORT rc = m_pDBF->GetLastRecord();
if ( rc == NO_ERROR && m_pDBF->RecordDeleted() )
	return GetPrevRecord();
return rc;
}


short CBaseTable::GetFirstRecord()
{
SHORT rc = m_pDBF->GetFirstRecord();
if ( rc == NO_ERROR && m_pDBF->RecordDeleted() )
	return GetNextRecord();
return rc;
}
short CBaseTable::GetNextRecord()
{
SHORT rc = m_pDBF->GetNextRecord();
while ( 1 )
	{
	if ( rc != NO_ERROR )
		return rc;

	if ( m_pDBF->RecordDeleted() )
		{
		rc = m_pDBF->GetNextRecord();
		continue;
		}
	if ( rc == NO_ERROR )
		return rc;
	}
}


short CBaseTable::GetPrevRecord()
{
SHORT rc = m_pDBF->GetPrevRecord();
while ( 1 )
	{
	if ( rc != NO_ERROR )
		return rc;

	if ( m_pDBF->RecordDeleted() )
		{
		rc = m_pDBF->GetPrevRecord();
		continue;
		}
	if ( rc == NO_ERROR )
		return rc;
	}
}



CColumnDesc *CBaseTable::GetColumnInfo( const char *szColName )
{
int nColumnCount = GetFieldCount();
for ( int i = 0; i < nColumnCount; i++ )
	{
	char szName[20];
	CColumnDesc *pColumnDesc = GetColumnInfo( i );
	strcpy( szName, pColumnDesc->m_szName );
	SpaceTruncate( szName );
	if ( !stricmp( szName, szColName ) )
		return pColumnDesc;
	}
return NULL;
}

char *CBaseTable::GetFieldName( int nColIndex )
{
return m_pColumnDesc[nColIndex].m_szName ;
}


short CBaseTable::GetFieldType(int nColIndex )
{
short DataType;
switch(m_pDBF->GetFieldType(nColIndex))
	{
	case CHAR_FLD:
		DataType = MENTORSQL_DATATYPE_CHAR;
		break;
	case NUMERIC_FLD:			
		DataType = MENTORSQL_DATATYPE_INT;
		break;
	case FLOAT_FLD:
		DataType = MENTORSQL_DATATYPE_FLOAT;
		break;
	}
return DataType;
}

int CBaseTable::GetFieldNo(const char *szColName)
{
return _GetFieldIndex( szColName );
}

LONG    CBaseTable::GetLongField( SHORT s1 )
{
return m_pDBF->GetLongField( s1 );
}

LONG    CBaseTable::GetLongField( const char *szColName )
{
return m_pDBF->GetLongField( GetFieldNo(szColName) );
}

DOUBLE     CBaseTable::GetDoubleField( const char *szColName )
{
return m_pDBF->GetDoubleField( GetFieldNo(szColName));
}


DOUBLE     CBaseTable::GetDoubleField( SHORT s1 )
{
return m_pDBF->GetDoubleField( s1 );
}


short CBaseTable::GetFieldAsBuf( short nIndex, char *szBuf)
{
short rc;
switch ( m_pColumnDesc[nIndex].m_DataType )
	{
	case MENTORSQL_DATATYPE_CHAR:
		{
		char buf[512];
		memset( szBuf, 0, sizeof(szBuf) );
		rc = GetField( nIndex, szBuf );
		SpaceTruncate( szBuf );
		return 0;
		break;
		}
	case MENTORSQL_DATATYPE_INT:			
		{
		long lData = GetLongField( nIndex );
		sprintf( szBuf, "%ld", lData );
		return 0;
		break;
		}
	case MENTORSQL_DATATYPE_FLOAT:
		{
		double dData = GetDoubleField( nIndex );
		sprintf( szBuf, "%lf", dData );
		return 0;
		break;
		}
	}
return 0;
}


SHORT   CBaseTable::GetField( SHORT s1, CHAR *s2 )
{
return m_pDBF->GetField(s1, s2 );
}


int CBaseTable::GetFieldCount()
{
return m_pDBF->GetFieldCount();
}


// Optimizer support routines
long CBaseTable::GetApproxRowCount()
{
return m_pDBF->NoOfRecords();
}
//


CColumnDesc *CBaseTable::GetColumnInfo( int nIndex )
{
return &m_pColumnDesc[nIndex];
}

int CBaseTable::Create( CColumnDesc *pColumnDesc, int nCount )
{
std::string strPath = m_strDataDirectory + "\\" + m_strName + ".dbf";
SHORT rc;
Schema *pSchema = new Schema[ nCount + 1 ];
for ( int i = 0; i < nCount; i++ )
	{
	pSchema[i].FieldLen = pColumnDesc[i].m_FieldLen;

	//The XBase field names are just numbers
	//Real names are stored in SYSCOLUMNS
	//A way to easily support longer names, aliasing etc
	sprintf( pSchema[i].FieldName, "COL%d", i );
	//strcpy( pSchema[i].FieldName, pColumnDesc[i].m_szName );
	char DataType;
	switch ( pColumnDesc[i].m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			DataType = CHAR_FLD;
			pSchema[i].NoOfDecs = 0;
			break;
		case MENTORSQL_DATATYPE_INT:			
			DataType = NUMERIC_FLD;
			pSchema[i].NoOfDecs = 0;
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			DataType = FLOAT_FLD;
			pSchema[i].NoOfDecs = 5;
			break;
		}
	pSchema[i].Type = DataType;
	}
pSchema[nCount].FieldLen = 0;
pSchema[nCount].FieldName[0] = 0;
pSchema[nCount].NoOfDecs = 0;
pSchema[nCount].Type = 0;

rc =  m_pDBF->CreateDatabase( (char *)strPath.c_str(), pSchema, OVERLAY );
delete pSchema;
m_pColumnDesc = new CColumnDesc[ nCount ];
memcpy( m_pColumnDesc, pColumnDesc, sizeof(CColumnDesc) * nCount );
return rc;
}


SHORT   CBaseTable::PutDoubleField( SHORT sColIndex, DOUBLE dValue)
{
return m_pDBF->PutDoubleField( sColIndex, dValue );
}

SHORT   CBaseTable::PutLongField( SHORT sColIndex, LONG lValue )
{
return m_pDBF->PutLongField( sColIndex, lValue );
}

SHORT   CBaseTable::PutField( SHORT sColIndex, const char *szValue )
{
return m_pDBF->PutField( sColIndex, (char *)szValue );
}

SHORT   CBaseTable::PutRecord( ULONG ulRecNo )
{
return m_pDBF->PutRecord( ulRecNo );
}

LONG    CBaseTable::GetCurRecNo() 
{ 
return m_pDBF->GetCurRecNo(); 
}

SHORT   CBaseTable::DeleteAllRecords( VOID ) 
{ 
return m_pDBF->DeleteAllRecords(); 
}

SHORT   CBaseTable::DeleteRecord( )
{
return m_pDBF->DeleteRecord();
}

SHORT   CBaseTable::AppendRecord( VOID )
{
return m_pDBF->AppendRecord();
}

SHORT   CBaseTable::BlankRecord( VOID )
{
return m_pDBF->BlankRecord();
}

short CBaseTable::GetRecord( unsigned long ulRecNo )
{
return m_pDBF->GetRecord( ulRecNo );
}

CTable::CTable( CSystemCatalog *pCatalog, const char *szTableName, const char *szDirectory )
	: CBaseTable( pCatalog->m_pXBase )
{
m_pCatalog = pCatalog;
m_strDataDirectory = szDirectory;
m_strName = szTableName;
m_lTableId = -1;
}



long CBaseTable::_GetFieldIndex( const char *szName )
{
if ( !m_pColumnDesc )
	return -1;
for ( int i = 0; i < m_pDBF->GetFieldCount(); i++ )
	{
	if ( !stricmp(m_pColumnDesc[i].m_szName, szName ) )
		return i;
	}
return -1;
}



int CTable::Open( CColumnDesc *pColumnDesc, int nCount )
{
return CBaseTable::Open( pColumnDesc, nCount, m_strName.c_str(), m_strDataDirectory.c_str());
//return CBaseTable::Open( (const char *)m_strName.c_str(), (const char *)m_strDataDirectory.c_str() );
}


XBASE m_TempXBase;
CTempTable::CTempTable()
	: CBaseTable( &m_TempXBase )
{
}

CTempTable::~CTempTable()
{
}
	

int CTempTable::Create( CColumnDesc *pColumnDesc, int nCount )
{
SHORT rc;
char szTempPath[ MAX_PATH ];
GetTempPath( MAX_PATH, szTempPath );
char szTempName[ MAX_PATH ];
GetTempFileName( szTempPath, "XBR", 0, szTempName );
m_strName = szTempName;
Schema *pSchema = new Schema[ nCount + 1 ];
for ( int i = 0; i < nCount; i++ )
	{
	pSchema[i].FieldLen = pColumnDesc[i].m_FieldLen;
	sprintf( pSchema[i].FieldName, "COL%d", i );
//	strcpy( pSchema[i].FieldName, pColumnDesc[i].m_szName );
	char DataType;
	switch ( pColumnDesc[i].m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			DataType = CHAR_FLD;
			pSchema[i].NoOfDecs = 0;
			break;
		case MENTORSQL_DATATYPE_INT:			
			DataType = NUMERIC_FLD;
			pSchema[i].NoOfDecs = 0;
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			DataType = FLOAT_FLD;
			pSchema[i].NoOfDecs = 5;
			break;
		}
	pSchema[i].Type = DataType;
	}
pSchema[nCount].FieldLen = 0;
pSchema[nCount].FieldName[0] = 0;
pSchema[nCount].NoOfDecs = 0;
pSchema[nCount].Type = 0;

rc =  m_pDBF->CreateDatabase( (char *)m_strName.c_str(), pSchema, OVERLAY );
m_pColumnDesc = new CColumnDesc[ nCount ];
memcpy( m_pColumnDesc, pColumnDesc, sizeof(CColumnDesc) * nCount );
return rc;
return rc;
}

//	DBF *GetDBF() { return m_pDBF; };
long CTempTable::CloseAndGetFileSize()
{
m_pDBF->CloseDatabase();
std::string strRealName;
strRealName = m_strName + ".dbf";
HANDLE hFile = CreateFile( strRealName.c_str(), GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 );
long lSize = GetFileSize( hFile, NULL );
CloseHandle( hFile );
return lSize;
}

void CTempTable::CopyToBuf( char *szBuf, long lSize )
{
DWORD dwWritten;
std::string strRealName;
strRealName = m_strName + ".dbf";
HANDLE hFile = CreateFile( strRealName.c_str(), GENERIC_READ , 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 );
DWORD dwRead;
ReadFile( hFile, szBuf, lSize, &dwRead, 0 );
CloseHandle( hFile );
}


long CTempTable::_GetFieldIndex( const char *szName )
{
return CBaseTable::_GetFieldIndex( szName );
if ( !m_pColumnDesc )
	return -1;
for ( int i = 0; i < m_pDBF->GetFieldCount(); i++ )
	{
	if ( !stricmp(m_ColStrings[i].c_str(), szName ) )
		return i;
	}
return -1;
}
													 
