/*  Product: Mentor SQL

    Copyright (C) 1998  Systementor AB, Stefan Holmberg
    Email - stefan.holmberg@systementor.se
    Web:   - http://www.systementor.se

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
*/
%{

#pragma warning ( disable:4786)
#include <stdio.h>
#include "flexlexer.h"
#include "ParseTree.h"
#include <malloc.h>

//#define YYLEX pLexer->yylex()
//You need to change yyparse to look like this - and remove unistd.h
//int yyparse(CParseTree *pState, yyFlexLexer *pLexer)
//#ifdef YYPURE
//  int yychar;
//  YYSTYPE yylval = 0; !!!! Set this also!
//  int yynerrs;
//#ifdef YYLSP_NEEDED
//  YYLTYPE yylloc;
//#endif
//#endif


#define YYSTYPE CSQLNode *

extern "C++" void yyerror(char *s);
extern "C++" int  yylex(void);

//#define YYPARSE_PARAM pState
#define YYLEX (( CFlexLexer* )->yylex())


%}
%pure_parser

%token IDENTIFIER
%token DROP TABLE CREATE LEFTPAREN RIGHTPAREN COMMA 
%token STRING_VALUE FLOAT_VALUE NUMBER_VALUE 
%token INTEGER_DATATYPE FLOAT_DATATYPE CHAR_DATATYPE
%token INSERT INTO VALUES SQL_NULL
%token DELETE FROM
%token WHERE EQUALS DOT 
%token AND OR LESS MORE LESS_EQUALS MORE_EQUALS 
%token SELECT STAR
%token ORDER BY DESC ASC
%token UPDATE SET
%token INDEX ON

%%
Command:  DDL_Statement
	{
	$$ = $1
	}
	| SQL_Statement
	{
	$$ = $1
	}

DDL_Statement: DROP TABLE Identifier
		{
			pState->SetStmt("DROP TABLE" );
			pState->AddList( "NameIdent", $3 );
			$$ = pState->MakeNode( NodeType_DropTable, "drop table" );
			pState->SetFirst( $$ );
		}
		| CREATE TABLE Identifier  LEFTPAREN ColDataTypeList RIGHTPAREN
		{
			pState->SetStmt( "CREATE TABLE" );
			pState->AddList( "NameIdent", $3 );
			pState->AddList( "ColDataTypeList", $5);
			$$ = pState->MakeNode( NodeType_CreateTable, "create table" );
			pState->SetFirst( $$ );
		}
		| CREATE INDEX Identifier ON Identifier LEFTPAREN ColName RIGHTPAREN
		{
			pState->SetStmt( "CREATE INDEX" );
			pState->AddList( "IndexNameIdent", $3 );
			pState->AddList( "TableNameIdent", $5);
			pState->AddList( "ColNameIdent", $7);
			$$ = pState->MakeNode( NodeType_CreateIndex, "create index" );
			pState->SetFirst( $$ );
		}
		| DROP INDEX Identifier
		{
			pState->SetStmt( "DROP INDEX" );
			pState->AddList( "IndexNameIdent", $3 );
			$$ = pState->MakeNode( NodeType_DropIndex, "drop index" );
			pState->SetFirst( $$ );
		};

SQL_Statement:	INSERT INTO Identifier VALUES LEFTPAREN InsertValueList RIGHTPAREN
		{
			pState->SetStmt( "INSERT INTO" );
			pState->AddList( "NameIdent", $3 );
			pState->AddList( "InsertValueList", $6);
			$$ = pState->MakeNode( NodeType_Insert, "Insert" );
			pState->SetFirst( $$ );
		} 
		| DELETE FROM Identifier WhereClause
		{
			pState->SetStmt( "DELETE" );
			pState->AddList( "NameIdent", $3 );
			pState->AddList( "WhereClause", $4);
			$$ = pState->MakeNode( NodeType_Delete, "Delete" );
			pState->SetFirst( $$ );
		} 
		| SELECT ColNameList FROM IdentList WhereClause OrderClause
		{
			pState->SetStmt( "SELECT" );
			pState->AddList( "ColNameList", $2);
			pState->AddList( "NameIdent", $4 );
			pState->AddList( "WhereClause", $5);
			pState->AddList( "OrderColList", $6);
			$$ = pState->MakeNode( NodeType_Select, "Select" );
			pState->SetFirst( $$ );
		} 
		| UPDATE Identifier SET UpdateList WhereClause
		{
			pState->SetStmt( "UPDATE" );
			pState->AddList( "NameIdent", $2);
			pState->AddList( "UpdateList", $4 );
			pState->AddList( "WhereClause", $5);
			$$ = pState->MakeNode( NodeType_Update, "Update" );
			pState->SetFirst( $$ );
		}
		;


OrderColList:	ColName DESC
		{
		$$ = pState->MakeNode( NodeType_OrderDESC, "OrderDESC" );
		$$->m_pLeftChild = $1;
		}
		| ColName ASC
		{
		$$ = pState->MakeNode( NodeType_OrderASC, "OrderASC" );
		$$->m_pLeftChild = $1;
		}
		| ColName 
		{
		$$ = pState->MakeNode( NodeType_OrderASC, "OrderASC" );
		$$->m_pLeftChild = $1;
		};


IdentList: IDENTIFIER
	{
                $$ = pState->MakeNode(NodeType_Identifier, "id");
	}
	| IdentList COMMA Identifier
	{
				$1->AddLast( $3 );
				$$ = $1;
	}
	

Identifier:                IDENTIFIER
        { 
                $$ = pState->MakeNode(NodeType_Identifier, "id");
        }
                ;

ColDataTypeList: Identifier DataType
        {
                        $1->m_pLeftChild = $2;
                        $$=$1;
        }
                |   ColDataTypeList COMMA Identifier DataType
        {
                        $3->m_pLeftChild = $4;
						$1->AddLast( $3 );
						$$ = $1;
        }
                ;

ColNameList:	STAR
		{
						$$ = pState->MakeNode(NodeType_Star, "*");			
		}
			| SelectElementList
		{
						$$ = $1;
		}
		;

SelectElementList: SelectElement
		{
			$$ = $1;
		}
		| SelectElementList COMMA SelectElement
		{
						$1->AddLast( $3 );
						$$ = $1;
		}
		;	

SelectElement: ColName /* Today only colnames is supported - no functions like DATE()  */
	{
		$$ = $1;
	}

DataType: CHAR_DATATYPE LEFTPAREN Number RIGHTPAREN         
        {
                        $$ = pState->MakeNode(NodeType_CharDataType, "character_typ");
						$$->m_pLeftChild = $3;
        }
                | INTEGER_DATATYPE
        {
						$$ = pState->MakeNode(NodeType_IntegerDataType, "interger_typ");
        }
                | FLOAT_DATATYPE               
        {
						$$ = pState->MakeNode(NodeType_FloatDataType, "float_typ");
        }
                ;

OrderClause:
		{
			$$ = pState->MakeNode( NodeType_Empty, "Empty");
		}
		| ORDER BY OrderColList
		{
			$$ = $3;
		}

WhereClause:
		{
			$$ = pState->MakeNode(NodeType_Empty, "Empty");
		}
		| WHERE WhereCondition
		{
			$$ = pState->MakeNode( NodeType_WhereCondition, "Where" );
			$$->m_pLeftChild = $2;
		};


WhereCondition: ColName EQUALS Value
	{
		$$ = pState->MakeNode( NodeType_Equals, "Equals" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	} 
	| ColName EQUALS ColName
	{
		$$ = pState->MakeNode( NodeType_Equals, "Equals" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	}
	| WhereCondition AND WhereCondition
	{
		$$ = pState->MakeNode( NodeType_And, "And" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	}
	| WhereCondition OR WhereCondition
	{
		$$ = pState->MakeNode( NodeType_Or, "Or" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	}
	| ColName LESS Value
	{
		$$ = pState->MakeNode( NodeType_Less, "Less" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	}
	| ColName MORE Value
	{
		$$ = pState->MakeNode( NodeType_More, "More" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	}
	| ColName LESS_EQUALS Value
	{
		$$ = pState->MakeNode( NodeType_LessEquals, "LESS_EQUALS" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	}
	| ColName MORE_EQUALS Value
	{
		$$ = pState->MakeNode( NodeType_MoreEquals, "MORE_EQUALS" );
        $$->m_pLeftChild = $1;
        $$->m_pRightChild = $3;
	}
	| LEFTPAREN WhereCondition RIGHTPAREN
	{
		$$ = $2;
	}
	;


ColName:          Identifier DOT Identifier
        { 
                $$ = pState->MakeNode(NodeType_Dot, "dot");
				$$->m_pLeftChild = $1;
				$$->m_pRightChild = $3;
        }
                | Identifier                               
        { 
                $$ = pState->MakeNode(NodeType_Dot, "dot");
				$$->m_pLeftChild = NULL;
				$$->m_pRightChild = $1;
        }
                ;


UpdateList: UpdateValue
	{
		$$ = $1;		
	}
		| UpdateList COMMA UpdateValue
	{
				$1->AddLast( $3 );
                $$ = $1;

	}

UpdateValue: ColName EQUALS Value
	{
		$$ = pState->MakeNode(NodeType_UpdateValue, "UpdateValue");
		$$->m_pLeftChild = $1;
		$$->m_pRightChild = $3;
	}

InsertValueList:  Value
        { 
                $$=$1;
        }
                | InsertValueList COMMA Value
        {
				$1->AddLast( $3 );
                $$ = $1;
        }
                ;

Value:                  LiteralValue
        { 
                $$=$1;
        }
                | SQL_NULL
        { 
                $$ = pState->MakeNode(NodeType_Null, "NULL");
        }
                ;

LiteralValue:   Number        { $$ = $1; }
                | Float                { $$ = $1; }
                | String        { $$ = $1; }
                ;


Number:		NUMBER_VALUE
	{
						$$ = pState->MakeNode(NodeType_Integer_Value, "Number");
	}

Float:		FLOAT_VALUE
	{
						$$ = pState->MakeNode(NodeType_Float_Value, "Float");
	}

String:		STRING_VALUE
	{
						$$ = pState->MakeNode(NodeType_String_Value, "String");
	}

%%

void yyerror(char *s)
{
   
   //exit(0);
}

