/*  Product: Mentor SQL

    Copyright (C) 1998  Systementor AB, Stefan Holmberg
    Email - stefan.holmberg@systementor.se
    Web:   - http://www.systementor.se

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
*/
%{
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <iostream.h>
#include "yyacc.h"
#include "ParseTree.h"



int yyleng;


#define    YYBUFF_SIZE    4096
YY_BUFFER_STATE yybuff;

#define YY_SKIP_YYWRAP
#define yywrap() (1)


extern char *input_string;
#define YY_NO_UNPUT
#undef YY_INPUT
#define YY_INPUT(buf,result,maxsize) \
           result = strlen(input_string); \
           if (result > maxsize) result = maxsize; \
           strncpy(buf, input_string, maxsize); \
           input_string += result;

%}
__dot			[.]
_update          [uU][pP][dD][aA][tT][eE]
_set          [sS][eE][tT]
_insert          [iI][nN][sS][eE][rR][tT]
_select          [sS][eE][lL][eE][cC][tT]
_into			 [iI][nN][tT][oO]
_values			 [vV][aA][lL][uU][eE][sS]
__char            [cC][hH][aA][rR]
_drop            [dD][rR][oO][pP]
_table           [tT][aA][bB][lL][eE]
_create          [cC][rR][eE][aA][tT][eE]
_delete          [dD][eE][lL][eE][tT][eE]
_index          [iI][nN][dD][eE][xX]
_where           [wW][hH][eE][rR][eE]
_on          [oO][nN]
_from            [fF][rR][oO][mM]
__float			 [fF][lL][oO][aA][tT]
__integer		 [iI][nN][tT][eE][gG][eE][rR]
_order			[oO][rR][dD][eE][rR]
_by				[bB][yY]
_asc			[aA][sS][cC]
_desc			[dD][eE][sS][cC]
_and				[aA][nN][dD]
_or				[oO][rR]
_sql_null         [nN][uU][lL][lL]
__number_value			([0-9]+)
__float_value			([0-9]*\.[0-9]+)
__string_value			(\'(([^\'])|(\\.))*\')
__identifier      ([a-zA-Z_][a-zA-Z0-9_]*)
__leftparen      [(] 
__rightparen      [)] 

%%
{__char}        return CHAR_DATATYPE; 
{__float}		return FLOAT_DATATYPE; 
{__integer}		return INTEGER_DATATYPE;
{_index}          return INDEX;
{_on}         return ON;
{_update}        return UPDATE; 
{_set}         return SET ;
{_delete}        return DELETE ; 
{_from}         return FROM ; 
{_drop}        return DROP ; 
{_where}       return WHERE ; 
{_select}      return SELECT ;
{_table}       return TABLE ; 
{_create}		return CREATE; 
{_insert}       return INSERT ; 
{_into}         return INTO ; 
{_values}		return VALUES; 
{_and}			return AND; 
{_or}			return OR; 
{_order}		return ORDER; 
{_by}			return BY; 
{_desc}			return DESC; 
{_asc}			return ASC; 
{_sql_null}		return SQL_NULL; 
{__identifier}    { m_pTree->AddToken(IDENTIFIER, YYText());     return IDENTIFIER; }
{__leftparen}             return LEFTPAREN; 
{__rightparen}            return RIGHTPAREN; 
{__number_value}		{ m_pTree->AddToken( NUMBER_VALUE, YYText()); return NUMBER_VALUE; };
{__float_value}		{ m_pTree->AddToken( FLOAT_VALUE, YYText()); return FLOAT_VALUE; };
{__string_value}		{ m_pTree->AddToken( STRING_VALUE, YYText()); return STRING_VALUE; };
,               return COMMA; 
"="			return EQUALS;
">"			return MORE;
"<"			return LESS;
">="			return MORE_EQUALS;
"<="			return LESS_EQUALS;
"*"				return STAR;
[ ]             {  }
\t              {  }
\n              { }
{__dot}            return DOT; 

%%
