 #include "optimizer.h"
#include "general.h"
#include "shalloc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CProjectOperator *CSHOptimizer::CreateProjectOperator()
{
CProjectOperator *pOp = new CProjectOperator(this);
m_GlobalPlanOperatorList.push_back(pOp);
return pOp;
}

CJoinOperator *CSHOptimizer::CreateJoinOperator()
{
CJoinOperator *pOp = new CJoinOperator;
m_GlobalPlanOperatorList.push_back(pOp);
return pOp;
}

CTableScanAccessMethod *CSHOptimizer::CreateTableScanAccessMethod()
{
CTableScanAccessMethod *pOp = new CTableScanAccessMethod;
m_GlobalPlanOperatorList.push_back(pOp);
return pOp;
}

CIndexAccessMethod *CSHOptimizer::CreateIndexAccessMethod()
{
CIndexAccessMethod *pOp = new CIndexAccessMethod;
m_GlobalPlanOperatorList.push_back(pOp);
return pOp;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
// CLASS CTablePlanInfo
//		Contains information from systemcatalog about a table used in query	
//		Also contains a list of column information - for all columns that should be
//			used from that particular table
/////////////////////////////////////////////////////////////////////////////////////////////////////

CTablePlanInfo::~CTablePlanInfo()
{
for ( CColumnPlanInfoArray::iterator iter = m_ColumnPlanInfoArray.begin();
	iter!= m_ColumnPlanInfoArray.end(); iter++ )
	delete *iter;
m_ColumnPlanInfoArray.erase(m_ColumnPlanInfoArray.begin(), m_ColumnPlanInfoArray.end());

for ( CIndexPlanInfoArray::iterator iter2 = m_IndexPlanInfoArray.begin();
	iter2!= m_IndexPlanInfoArray.end(); iter2++ )
	delete *iter2;
m_IndexPlanInfoArray.erase(m_IndexPlanInfoArray.begin(), m_IndexPlanInfoArray.end());

}



CSolution::~CSolution()
{
}				  

#ifdef _DEBUG
void CSolution::Dump()
{
m_pPlanOperator->Dump();
}
#endif


CSolution *CPlanList::GetBestSolution()
{
long lLowestCost = -1;
long lTempCost;
CSolution *pRet;
for ( int i = 0; i < m_SolutionList.size(); i++ )
	{
	CSolution *pSol = m_SolutionList.at(i);
	lTempCost = pSol->m_pPlanOperator->GetCost();
	if ( lLowestCost == -1 || lTempCost < lLowestCost )
		{
		lLowestCost = lTempCost;
		pRet = pSol;
		}
	}
return pRet;
}

bool CPlanList::ContainsTable( const char *szTableName  )
{
if ( !m_strInner.compare( szTableName ) )
	return true;
if ( !m_pOuter )
	return false;
return m_pOuter->ContainsTable( szTableName );
}


#ifdef _DEBUG	
std::string CPlanList::GetName()
{
std::string strRet = "DIM: ";
char szBuf[20];
sprintf( szBuf, "%d", m_nDimension );
strRet += szBuf;
strRet += "   " + m_strInner;
if ( m_pOuter )
	strRet = strRet + m_pOuter->GetName();
return strRet;
}
#endif


CPlanList::~CPlanList()
{
for ( CSolutionList::iterator iter = m_SolutionList.begin(); iter != m_SolutionList.end();
	iter++ )
	{
	delete *iter;
	}
m_SolutionList.erase( m_SolutionList.begin(), m_SolutionList.end());
}

CAccessMethod *CSHOptimizer::GetBestRowAccessMethod()
{
CSolution *pSolution = GetBestSolution();

//This is low budget safe casting but since I need the Name() anyway - why not use it?

//The first operator is a project...
if ( stricmp( pSolution->m_pPlanOperator->Name(), "CProjectOperator" ) )
	return NULL;
CProjectOperator *pProjectOperator = (CProjectOperator *)pSolution->m_pPlanOperator;

//This one should point to an accessmethod - that is what is interesting here
char *szTemp = pProjectOperator->m_pLeftChild->Name();
return (CAccessMethod *)pProjectOperator->m_pLeftChild;
}


CSolution *CSHOptimizer::GetBestSolution()
{
CSolution *pSolutionTemp;
CSolution *pBestSolution;
CPlanList *PlanList;
long lLowestCost = -1;
long lTempCost;
int m_nDimension = m_PlanListList.at(m_PlanListList.size()-1)->m_nDimension;
for ( int i = m_PlanListList.size() -1; i >= 0;i-- )
	{
	PlanList = m_PlanListList.at(i);
	if ( PlanList->m_nDimension != m_nDimension )
		break;
	pSolutionTemp = PlanList->GetBestSolution();
	lTempCost = pSolutionTemp->m_pPlanOperator->GetCost();
	if ( lLowestCost == -1 || lTempCost < lLowestCost )
		{
		lLowestCost = lTempCost;
		pBestSolution = pSolutionTemp;
		}
	}
//First now we add a CProjectOperator -  there is no need to create it earlier for each solution
//We might get too many columns too many levels up but consider each operator takes memory and CPU
// and it also was a little easier to implement it like this...
//
return AddProjectOperator( pBestSolution );
}

CSolution *CSHOptimizer::AddProjectOperator( CSolution *pSolution )
{
//Always add it - the project order might be different even if we have just the right columns
CPlanList *pPlanList = new CPlanList;
pPlanList->m_nDimension = 1000; //Special planlist
pPlanList->m_strInner = "Projector";
pPlanList->m_pOuter = NULL;

//AddColumns from this result columns array to PlanList
for ( int i = 0; i < m_ResultColumns.size(); i++ )
	{
	pPlanList->m_AvailableColumns.push_back( m_ResultColumns.at(i) );
	}
m_PlanListList.push_back( pPlanList );

CSolution *pSol = new CSolution;
CProjectOperator *pOp = CreateProjectOperator();
pSol->m_pPlanOperator = pOp;
pSol->m_pPlanOperator->m_pPlanList = pPlanList;
pOp->m_pLeftChild = pSolution->m_pPlanOperator;
pPlanList->m_SolutionList.push_back( pSol );
return pSol;
}


void CSHOptimizer::PrintOne()
{
//Vi tar den frsta
CSolution *pSolution = GetBestSolution();
//

//Print solution tree
//pSolution->Dump();
pSolution->Execute();

//
int j;
j = 0;
}


CSHOptimizer::~CSHOptimizer()
{
Clear();
}

//Now we should extract all where-conditions that can be used on its own - that is
//as long as they are AND:ed
void CSHOptimizer::ExtractSeparateConditions( CSQLNode *pNode, bool fParentIsAnd )
{
if ( pNode == NULL )
	return;
switch( pNode->m_nType )
	{
	case NodeType_WhereCondition:
		ExtractSeparateConditions( pNode->m_pLeftChild, true );		
		break;
	case NodeType_And:
		ExtractSeparateConditions( pNode->m_pLeftChild, true );		
		ExtractSeparateConditions( pNode->m_pRightChild, true );		
		break;
	default:
		if ( fParentIsAnd )
			m_WhereCondArray.push_back( pNode );		
	}
}

void CSHOptimizer::Clear()
{

for ( CTablePlanInfoList::iterator iter = m_PlanInfoList.begin(); iter != m_PlanInfoList.end();
	iter++ )
	{
	delete *iter;
	}
m_PlanInfoList.erase( m_PlanInfoList.begin(), m_PlanInfoList.end());
for ( CPlanListList::iterator iter2 = m_PlanListList.begin(); iter2 != m_PlanListList.end();
	iter2++ )
	{
	delete *iter2;
	}
m_PlanListList.erase( m_PlanListList.begin(), m_PlanListList.end() );
for ( CPlanOperatorList::iterator iter3 = m_GlobalPlanOperatorList.begin();
	iter3 != m_GlobalPlanOperatorList.end();
	iter3++ )
	delete *iter3;
m_GlobalPlanOperatorList.erase(m_GlobalPlanOperatorList.begin(), m_GlobalPlanOperatorList.end());
m_ResultColumns.erase(m_ResultColumns.begin(), m_ResultColumns.end());
}


void CSHOptimizer::CreateJoinRelationPlans( CPlanList *pInnerPlanList, CTablePlanInfo *pPlanInfo, CParseTree *pTree, CPlanList *pPlanList  )
{
//Skapa plans fr denna...

// Combine two existing solutions into this
// Vi skall allts skapa lsningar fr att joina:
//			pPlanInfo	
//Get this tables 

//Ta alla lsningar fr aktuell planinfo och kombinera med alla i planlistens outer
 
for ( CSolutionList::iterator inneriter = pInnerPlanList->m_SolutionList.begin();
	inneriter != pInnerPlanList->m_SolutionList.end();
	inneriter++ )
	{
	for ( CSolutionList::iterator soliter = pPlanList->m_pOuter->m_SolutionList.begin();
		soliter != pPlanList->m_pOuter->m_SolutionList.end();
		soliter++ )
		{
		CJoinOperator *pJoinOp = CreateJoinOperator();
		CSolution *pSolution = new CSolution;
		pSolution->m_pPlanOperator = pJoinOp;

		//CTableScanAccessMethod *pScan = CreateTableScanAccessMethod();
//		pScan->m_pTablePlanInfo = pPlanInfo;
//		pScan->m_pPlanList = pPlanList;
		pJoinOp->m_pLeftChild = (*inneriter)->m_pPlanOperator; //Inner
		pJoinOp->m_pRightChild = (*soliter)->m_pPlanOperator; //Outer


		//Place all conditions we can on this one...
		pJoinOp->m_pPlanList = pPlanList;

		pJoinOp->PlaceWhereConditions( m_WhereCondArray );
	//	pSolution->m_lApproxIOCount = pPlanInfo->m_lNrOfRows;
		pPlanList->m_SolutionList.push_back( pSolution );
		}
	}

/*
//Combine all solutions with filescan...
for ( CSolutionList::iterator soliter = pPlanList->m_pOuter->m_SolutionList.begin();
	soliter != pPlanList->m_pOuter->m_SolutionList.end();
	soliter++ )
	{
	CJoinOperator *pJoinOp = CreateJoinOperator();
	CSolution *pSolution = new CSolution;
	pSolution->m_pPlanOperator = pJoinOp;

	CTableScanAccessMethod *pScan = CreateTableScanAccessMethod();
	pScan->m_pTablePlanInfo = pPlanInfo;
	pScan->m_pPlanList = pPlanList;
	pJoinOp->m_pLeftChild = pScan; //Inner
	pJoinOp->m_pRightChild = (*soliter)->m_pPlanOperator; //Outer


	//Place all conditions we can on this one...
	pJoinOp->PlaceWhereConditions( m_WhereCondArray );

	pJoinOp->m_pPlanList = pPlanList;

//	pSolution->m_lApproxIOCount = pPlanInfo->m_lNrOfRows;
	pPlanList->m_SolutionList.push_back( pSolution );
	}
*/
}


void CSHOptimizer::CreateOneRelationPlans( CTablePlanInfo *pPlanInfo, CParseTree *pTree, CPlanList *pPlanList  )
{
//Skapa plans fr denna...

// Frst en vanlig filescan
CSolution *pSolution = new CSolution;
CTableScanAccessMethod *pTableScan = CreateTableScanAccessMethod();
pSolution->m_pPlanOperator = pTableScan;
pTableScan->m_pTablePlanInfo = pPlanInfo;
pTableScan->m_pPlanList = pPlanList;
pTableScan->PlaceWhereConditions( m_WhereCondArray );
pPlanList->m_SolutionList.push_back( pSolution );



for ( int i = 0; i < pPlanInfo->m_IndexPlanInfoArray.size(); i++ )
	{
	CIndexPlanInfo *pIndexPlanInfo = pPlanInfo->m_IndexPlanInfoArray.at(i);
	
	//We do not care if indexes are good or not - that will cost approximation say later
	//Or it can give us a sorted view so always take it with us 

	CSolution *pSolution = new CSolution;
	CIndexAccessMethod *pIndexAccessMethod = CreateIndexAccessMethod();
	pSolution->m_pPlanOperator = pIndexAccessMethod;
	pIndexAccessMethod->m_pTablePlanInfo = pPlanInfo;
	pIndexAccessMethod->m_pIndexPlanInfo = pIndexPlanInfo;
	pIndexAccessMethod->m_pPlanList = pPlanList;
	//Set approx count...for a table scan it is always all of them?
	pIndexAccessMethod->PlaceWhereConditions( m_WhereCondArray );
	pIndexAccessMethod->SetIndexExpression();

	//pSolution->m_lApproxIOCount = pPlanInfo->m_lNrOfRows;

	pPlanList->m_SolutionList.push_back( pSolution );
	}
//Create index accessors on this table

}

CPlanList *CSHOptimizer::GetOneRelationList( CTablePlanInfo *pInfo )
{
for ( int i = 0; i < m_PlanListList.size(); i++ )
	{
	CPlanList *pList = m_PlanListList.at(i);
	if ( !pList->m_strInner .compare( pInfo->m_strTableName ) )
		return pList;
	}
return NULL;
}


//1. CreateOneRelationPlans
//2. CreateNRelationPlans - skapar med n-1

CSHOptimizer::CSHOptimizer( )
{
}

void CSHOptimizer::OptimizeQuery( CParseTree *pTree )
{
int nTableCount;

Clear();
ExtractSeparateConditions( pTree->GetList( "WhereClause" ), true );
//1. Hmta systeminformation ang alla inblandade tabeller - lgg i global area
CSQLNode *pWhereClause = pTree->GetList( "WhereClause" );
CSQLNode *pSelectClause = pTree->GetList( "ColNameList" );
CSQLNode *pFromClause = pTree->GetList( "NameIdent" );

nTableCount = ReadSystemInfo( pSelectClause, pWhereClause, pFromClause );

CPlanListList PlanListEarlierDimension;
//2.   Create OneRelationPlans
for ( CTablePlanInfoList::iterator iter = m_PlanInfoList.begin(); iter != m_PlanInfoList.end();
	iter++ )
	{
	CPlanList *pPlanList = new CPlanList;
	pPlanList->m_nDimension = 1;
	pPlanList->m_strInner = (*iter)->m_strTableName;
	pPlanList->m_pOuter = NULL;

	//AddColumns from this table to PlanList
	pPlanList->AddToAvailableColumns( *iter );


	m_PlanListList.push_back( pPlanList );
	PlanListEarlierDimension.push_back( pPlanList );
	
	std::string strName = pPlanList->GetName();

	CreateOneRelationPlans( *iter, pTree, pPlanList );
	}


//Find best way to join with another 
int nCurrentDim = 2;
while ( nCurrentDim <= nTableCount )
	{
	//Now loop and join with nCurrentDim - 1
	for ( iter = m_PlanInfoList.begin(); iter != m_PlanInfoList.end();
		iter++ )
		{
		int nSize = PlanListEarlierDimension.size();
		for ( int nTemp = 0; nTemp < nSize; nTemp++ )
			{
			CPlanList *pList = PlanListEarlierDimension[nTemp];
			if ( nCurrentDim == 3 )
				{
				int j;
				j = 0;
				}

			if ( ( pList->m_nDimension == nCurrentDim -1 )  && ( !pList->ContainsTable( (*iter)->m_strTableName.c_str())) )
				{
				CPlanList *pPlanList = new CPlanList;
				pPlanList->m_nDimension = nCurrentDim;
				pPlanList->m_strInner = (*iter)->m_strTableName;
				pPlanList->m_pOuter = pList;
				
				//AddColumns from this table to PlanList
				pPlanList->AddToAvailableColumns( *iter );
				std::string strName = pPlanList->GetName();

				m_PlanListList.push_back( pPlanList );
				PlanListEarlierDimension.push_back( pPlanList );
				CreateJoinRelationPlans( GetOneRelationList(*iter), *iter, pTree, pPlanList );
				}
			}
		}
	nCurrentDim++;
	}

}

//Function for createing solutions for just accessing a table - used by update and delete
void CSHOptimizer::OptimizeRowAccess( CParseTree *pTree )
{
int nTableCount;

Clear();
ExtractSeparateConditions( pTree->GetList( "WhereClause" ), true );
//1. Hmta systeminformation ang alla inblandade tabeller - lgg i global area
CSQLNode *pWhereClause = pTree->GetList( "WhereClause" );

CSQLNode *pFromClause = pTree->GetList( "NameIdent" );

//There are no selectclause for updates and deletes so lets create a 'fake' one with just one 
nTableCount = ReadSystemInfo( NULL, pWhereClause, pFromClause );

CPlanListList PlanListEarlierDimension;
//2.   Create OneRelationPlans
for ( CTablePlanInfoList::iterator iter = m_PlanInfoList.begin(); iter != m_PlanInfoList.end();
	iter++ )
	{
	CPlanList *pPlanList = new CPlanList;
	pPlanList->m_nDimension = 1;
	pPlanList->m_strInner = (*iter)->m_strTableName;
	pPlanList->m_pOuter = NULL;

	//AddColumns from this table to PlanList
	pPlanList->AddToAvailableColumns( *iter );


	m_PlanListList.push_back( pPlanList );
	PlanListEarlierDimension.push_back( pPlanList );
	
	std::string strName = pPlanList->GetName();

	CreateOneRelationPlans( *iter, pTree, pPlanList );
	}
}


int CSHOptimizer::ReadSystemInfo( CSQLNode *pSelectList, CSQLNode *pWhereClause, CSQLNode *pFromClause )
{
int nCount = 0;
CSQLNode *pTableNode = pFromClause;
while ( pTableNode )
	{
	CTable *pTable = GetServer()->GetSystemCatalog()->GetTable( pTableNode->m_pSQLToken->m_strText.c_str() );
	if ( !pTable )
		return nCount;
	
	CTablePlanInfo *pInfo = new CTablePlanInfo;
	pInfo->m_lNrOfRows = pTable->GetApproxRowCount();
	pInfo->m_strTableName = pTable->GetName();

	//Now fill it up with column info regarding this query...
	BuildColumnsInfo( pInfo, pSelectList, pWhereClause, pFromClause, pTable );

	//And get the index information regarding this table
	BuildIndexInfo( pInfo, pTable ); 

	m_PlanInfoList.push_back( pInfo );
	nCount++;

	pTableNode = pTableNode->m_pNext;	

	//pInfo->Dump();
	}
return nCount;
}


//

//

bool CSHOptimizer::ExistsInSchema( CTablePlanInfo *pInfo, const char *szNewColName )
{
//Easy check - just loop and see if it already exists
for ( CColumnPlanInfoArray::iterator iter = pInfo->m_ColumnPlanInfoArray.begin();
	iter != pInfo->m_ColumnPlanInfoArray.end();	iter++)
	if ( !(*iter)->m_strColumnName.compare( szNewColName ))
		return true;
return false;
}


void CSHOptimizer::RecursiveAddColDesc( CTablePlanInfo *pInfo, CSQLNode *pNode, CTable *pTable )
{
if ( pNode == NULL )
	return;
switch( pNode->m_nType )
	{
	case NodeType_Equals:
	case NodeType_More:
	case NodeType_Less:
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
	case NodeType_And:
	case NodeType_Or: //We should perform check on all childs
		{
		RecursiveAddColDesc( pInfo, pNode->m_pLeftChild, pTable); 
		RecursiveAddColDesc( pInfo, pNode->m_pRightChild, pTable );
		break;
		}
	case NodeType_Dot:
		{
		if ( pNode->m_pLeftChild->m_pSQLToken->m_strText.c_str()  == pInfo->m_strTableName )
			{
			CColumnDesc *pColumnDesc = pTable->GetColumnInfo( pNode->m_pRightChild->m_pSQLToken->m_strText.c_str() );

			if ( ExistsInSchema( pInfo, pColumnDesc->m_szName  ) )
				break;
				

			CColumnPlanInfo *pColumnPlanInfo = new CColumnPlanInfo( pInfo->m_strTableName.c_str(), pColumnDesc->m_szName, pColumnDesc->m_DataType, pColumnDesc->m_FieldLen );
			pInfo->m_ColumnPlanInfoArray.push_back( pColumnPlanInfo );
			}
		break;
		}
	}
}


void CSHOptimizer::BuildIndexInfo( CTablePlanInfo *pInfo, CTable *pTable )
{
for ( int i = 0; i < pTable->m_IndexArray.size(); i++ )
	{
	CIndex *pIndex = pTable->m_IndexArray.at(i);
	CIndexPlanInfo *pIndexPlanInfo = new CIndexPlanInfo;

	pIndexPlanInfo->m_strColumn = pIndex->GetExpression();
	pIndexPlanInfo->m_strIndexName = pIndex->GetName();
	pInfo->m_IndexPlanInfoArray.push_back( pIndexPlanInfo );
	}
}

void CSHOptimizer::BuildColumnsInfo( CTablePlanInfo *pInfo, CSQLNode *pSelectList, CSQLNode *pWhereClause, CSQLNode *pFromClause, CTable *pTable )
{
//1. Count all columns that should be involved
int nColCount = 0;
CSQLNode *pNode = pSelectList;
while ( pNode )
	{
	if ( ! pNode->m_pLeftChild->m_pSQLToken->m_strText.compare(pInfo->m_strTableName))
		{
		CColumnDesc *pColumnDesc = pTable->GetColumnInfo( pNode->m_pRightChild->m_pSQLToken->m_strText.c_str() );
		CColumnPlanInfo *pColumnPlanInfo = new CColumnPlanInfo( pInfo->m_strTableName.c_str(), pColumnDesc->m_szName, pColumnDesc->m_DataType, pColumnDesc->m_FieldLen );
		pInfo->m_ColumnPlanInfoArray.push_back( pColumnPlanInfo );
		m_ResultColumns.push_back( pColumnPlanInfo );
		}
	pNode = pNode->m_pNext;
	}


//That was the easy part, now we need to create for all joins and wheres etc
if ( pFromClause->m_pNext ) //As I said only if we are joining...
	RecursiveAddColDesc( pInfo, pWhereClause->m_pLeftChild, pTable  );

if ( pInfo->m_ColumnPlanInfoArray.size() == 0 )
	{
	//This means no columns at all were specified, so we'd better
	//add one manually
	//This is a fix for update and delete queries that doesn't have a
	//select clause
	CColumnDesc *pColumnDesc = pTable->GetColumnInfo( 0 );
	CColumnPlanInfo *pColumnPlanInfo = new CColumnPlanInfo( pInfo->m_strTableName.c_str(), pColumnDesc->m_szName, pColumnDesc->m_DataType, pColumnDesc->m_FieldLen );
	pInfo->m_ColumnPlanInfoArray.push_back( pColumnPlanInfo );
	m_ResultColumns.push_back( pColumnPlanInfo );
	}
}


//Check so all iterms in this is available
bool CIndexAccessMethod::CanApplyCondition( CSQLNode *pNode )
{
if ( pNode == NULL || pNode->m_nType == NodeType_Empty )
	return false;
switch( pNode->m_nType )
	{
	case NodeType_Equals:
	case NodeType_More:
	case NodeType_Less:
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
		m_pIndexExpression = pNode;
	case NodeType_And:
		return	CanApplyCondition( pNode->m_pLeftChild ) && 
				CanApplyCondition( pNode->m_pRightChild );

	case NodeType_Or: //Cant use any ors in our indexed search - must be an value
					  //that can be solved by one single index access
		{
		return false;
		}
	case NodeType_Dot:
		{
		//Here is the actual check...
		if ( !pNode->m_pRightChild->m_pSQLToken->m_strText.compare( m_pIndexPlanInfo->m_strColumn ) )
			return true;			
		return false;
		}
	}
return true;
}


void CIndexAccessMethod::SetIndexExpression()
{
//Lets go through the conditions and check if an index is applicable
long lLastCost = -1;
for ( int i = 0; i < m_WhereCondArray.size(); i++ )
	{
	//Can we use the indexed column on this one?
	if ( CanApplyCondition( m_WhereCondArray.at(i) ) )
		{
		if ( lLastCost == -1 || GetCost() < lLastCost )
			return;
		}
	}

m_pIndexExpression = NULL;
}

bool CIndexAccessMethod::SortOrder( std::string &strCol )
{
if ( m_pIndexExpression )
	{
	strCol = m_pIndexPlanInfo->m_strColumn;
	}
return true;
}


long CIndexAccessMethod::GetCost()
{
CTable *pTable = GetServer()->GetSystemCatalog()->GetTable( m_pTablePlanInfo->m_strTableName.c_str() );

if ( !m_pIndexExpression )
	{
	if ( m_fIndexOnlyScan )
		return pTable->GetApproxRowCount();
	return pTable->GetApproxRowCount() * 2; 
	}

//So we now the column - what kinda selectivity can we expect?
//Really simple stuff until a selectivity routines are implemented
double d1 = (double)pTable->GetApproxRowCount();
switch( m_pIndexExpression->m_nType )
	{
	case NodeType_Equals:
		//If unique then 1, here we simplify and say 2 %
		d1  = d1 * 0.02;
		break;
	case NodeType_More:
	case NodeType_Less:
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
		d1 = d1 * 0.10;
		break;
	}
long lRet = ( long ) d1;
if ( lRet == 0 )
	lRet = 1;
return lRet;
}


short CIndexAccessMethod::GetFirstRecord()
{
short rc;
std::string strValue;
//Get feed value
//We know it is a simple expression and the value is the right child...
strValue = m_pIndexExpression->m_pRightChild->m_pSQLToken->m_strText;

switch( m_pIndexExpression->m_pRightChild->m_nType )
	{
	case NodeType_String_Value:
		{
		strValue = strValue.substr( 1, strValue.length()-2);
		rc = m_pIndex->FindKey( strValue.c_str() );
		break;
		}
	case NodeType_Integer_Value:
		{
		long lVal = atol( strValue.c_str() );
		rc = m_pIndex->FindKey( lVal );
		}
	case NodeType_Float_Value:
		{
		double dVal = atof( strValue.c_str() );
		rc = m_pIndex->FindKey( dVal );
		}
	}

switch( m_pIndexExpression->m_nType )
	{
	case NodeType_Equals:
		break;
	case NodeType_More:
		if ( rc == ERROR_NUM_OK )
			rc = m_pIndex->NextKey();
		break;
	case NodeType_Less:
		if ( rc == ERROR_NUM_OK )
			rc = m_pIndex->PrevKey();
		break;
	case NodeType_MoreEquals:
		break;
	case NodeType_LessEquals:
		break;
	}
return rc;
}

short CIndexAccessMethod::GetNextRecord()
{
short rc;
switch( m_pIndexExpression->m_nType )
	{
	case NodeType_Equals:
	case NodeType_MoreEquals:
	case NodeType_More:
		rc = m_pIndex->NextKey();
		break;
	case NodeType_Less:
	case NodeType_LessEquals:
		rc = m_pIndex->PrevKey();
	}
return rc;
}

int CIndexAccessMethod::GetRow()
{
CTreeTracer Tracer;
short sRet;
if ( !m_pTuple )
	{
	m_pTuple = new CTuple( &m_pPlanList->m_AvailableColumns );
#ifdef _DEBUG
	char szDump[256];
	sprintf( szDump, "Using index based lookup on %s", m_pTablePlanInfo->m_strTableName.c_str() );
	Tracer.Dump( szDump );
//	printf("Using index based lookup on %s\n", m_pTablePlanInfo->m_strTableName.c_str() );
#endif
	}
if ( !m_pTableRef )
	{
	m_pTableRef = GetServer()->GetSystemCatalog()->GetTable( m_pTablePlanInfo->m_strTableName.c_str() );
	m_pIndex = m_pTableRef->GetIndex( m_pIndexPlanInfo->m_strIndexName.c_str() );
	sRet = GetFirstRecord();
	}
else if ( !m_fReset )
	sRet = GetNextRecord();
else
	{
	sRet = GetFirstRecord();
	m_fReset = false;
	}
//This is a simple table scan...
while ( true )
	{
	if ( sRet != ERROR_NUM_OK )
		return GETROW_EOF;

	//Copy data to tuple
	//then try and apply
	CopyDataToTuple();
	if ( ApplyConditions() == true )
		return GETROW_OK;
	sRet = GetNextRecord();
	}
}

#ifdef _DEBUG
void CIndexAccessMethod::Dump()
{
}
#endif


int CTableScanAccessMethod::GetRow()
{
CTreeTracer Tracer;
short sRet;
if ( !m_pTuple )
	{
	m_pTuple = new CTuple( &m_pPlanList->m_AvailableColumns  );
#ifdef _DEBUG
	char szDump[256];
	sprintf( szDump, "Using table scan on %s", m_pTablePlanInfo->m_strTableName.c_str() );
	Tracer.Dump( szDump );
#endif
	}
if ( !m_pTableRef )
	{
	m_pTableRef = GetServer()->GetSystemCatalog()->GetTable( m_pTablePlanInfo->m_strTableName.c_str() );
	sRet = m_pTableRef->GetFirstRecord();
	}
else if (!m_fReset)
	sRet = m_pTableRef->GetNextRecord();
else
	{
	sRet = m_pTableRef->GetFirstRecord();
	m_fReset = false;
	}
//This is a simple table scan...
while ( true )
	{
	if ( sRet != ERROR_NUM_OK )
		return GETROW_EOF;

	//Copy data to tuple
	//then try and apply
	CopyDataToTuple();
	if ( ApplyConditions() == true )
		return GETROW_OK;
	sRet = m_pTableRef->GetNextRecord();
	}
}

int CAccessMethod::GetRow()
{
return GETROW_EOF;
}

int CProjectOperator::GetRow()
{
CTreeTracer Tracer;
bool fFirst = false;
int nRet;
if ( !m_pTuple )
	{
	m_pTuple = new CTuple( &m_pOptimizer->m_ResultColumns  );
	fFirst = true;
#ifdef _DEBUG
	char szDump[256];
	Tracer.Dump( "Projecting columns" );
#endif
	}
nRet = m_pLeftChild->GetRow();
if ( nRet == GETROW_EOF )
	return nRet;
CopyDataToTuple();
return GETROW_OK;
}

void CProjectOperator::CopyDataToTuple()
{
CTuple *pTuple;
for ( int i = 0; i < m_pPlanList->m_AvailableColumns.size(); i++ )
	{
	CColumnPlanInfo *pInfo = (m_pPlanList->m_AvailableColumns)[i];

	pTuple = m_pLeftChild->m_pTuple;
	switch( pInfo->m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			{
			std::string strRet;
			pTuple->GetStringValue( strRet, pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			m_pTuple->SetValue( (void *)strRet.c_str(), pInfo->m_nFieldLen,  pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			break;
			}
		case MENTORSQL_DATATYPE_INT:
			{
			long lRet;
			pTuple->GetLongValue( lRet, pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			m_pTuple->SetValue( &lRet, sizeof(long),  pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			}
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			{
			double dRet;
			pTuple->GetDoubleValue( dRet, pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			m_pTuple->SetValue( &dRet, sizeof(double),  pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			}
			break;
		}
	}
}


int CJoinOperator::GetRow()
{
CTreeTracer Tracer;
bool fFirst = false;
int nRet;
if ( !m_pTuple )
	{
	m_pTuple = new CTuple( &m_pPlanList->m_AvailableColumns  );
	fFirst = true;
#ifdef _DEBUG
	char szDump[256];
	sprintf( szDump, "Joining" );
	Tracer.Dump( szDump );
#endif
	}

if ( fFirst )
	{
/*	CPlanOperator *p1 = m_pRightChild;
	m_pRightChild = m_pLeftChild;
	m_pLeftChild = p1;*/

	//Runs right one once - that involoves many accesses so...
	nRet = m_pRightChild->GetRow();
	if ( nRet == GETROW_EOF )
		return nRet;
	}
if ( m_fReset )
	{
	m_pLeftChild->Reset();
	m_pRightChild->Reset();
	nRet = m_pRightChild->GetRow();
	if ( nRet == GETROW_EOF )
		return nRet;
	m_fReset = false;
	}

while ( true )
	{
	nRet = m_pLeftChild->GetRow(); 
	if ( nRet == GETROW_EOF )
		{
		nRet = m_pRightChild->GetRow();
		if ( nRet == GETROW_EOF )
			return GETROW_EOF;

		m_pLeftChild->Reset();
		nRet = m_pLeftChild->GetRow(); 
		if ( nRet == GETROW_EOF )
			return GETROW_EOF;
		}
	CopyDataToTuple();
	if ( ApplyConditions() )
		return GETROW_OK;
	}
}


void CSolution::Execute()
{
for ( int i = 0; i < m_pPlanOperator->m_pPlanList->m_AvailableColumns.size(); i++ )
	{
	CColumnPlanInfo *pInfo = m_pPlanOperator->m_pPlanList->m_AvailableColumns.at(i);

	cout << pInfo->m_strTableName.c_str() << "." << pInfo->m_strColumnName.c_str() << "\t";
	}
cout << endl;
fflush( stdout);
while ( m_pPlanOperator->GetRow() )
	{
	std::string strRet;

	for ( int i = 0; i < m_pPlanOperator->m_pPlanList->m_AvailableColumns.size(); i++ )
		{
		m_pPlanOperator->m_pTuple->GetFieldAsBuf( strRet, i );
		cout << strRet.c_str() << "\t";
		}
	cout << endl;
	}
}

#ifdef _DEBUG
void CJoinOperator::Dump()
{
cout << "JOIN ";
//cout << "     " << "Inner: " << m_pLeftChild->
//cout << "     " << "Outer: " << m_pRightChild->
}

void CPlanOperator::Dump()
{
}
void CTableScanAccessMethod::Dump()
{
}
void CAccessMethod::Dump()
{
}
#endif

bool CPlanOperator::ColumnExists( CSQLNode *pNode )
{
for ( CColumnPlanInfoArray::iterator iter = m_pPlanList->m_AvailableColumns.begin();
			iter != m_pPlanList->m_AvailableColumns.end();
			iter++ )
	if ( !(*iter)->m_strTableName.compare( pNode->m_pLeftChild->m_pSQLToken->m_strText ) && 
		 !(*iter)->m_strColumnName.compare( pNode->m_pRightChild->m_pSQLToken->m_strText ) )
		 {
		 return true;
		 }
return false;
}


bool CPlanOperator::CondExistsInChild( CSQLNode *pNode )
{
bool bRet = false;
if ( m_pLeftChild )
	bRet = m_pLeftChild->CondExistsInChild( pNode );
if ( bRet )
	return bRet;
if ( m_pRightChild )
	bRet = m_pRightChild->CondExistsInChild( pNode);
return bRet;
}


//Apply conditions onto this tuple
bool CPlanOperator::ApplyConditions()
{
for ( int i = 0; i < m_WhereCondArray.size(); i++ )
	{
	CSQLNode *pNode = m_WhereCondArray.at(i);
	if ( !ApplyOneCondition( pNode  ) )
		return false;
	}
return true;
}

bool CPlanOperator::GetValueInTuple( CSQLNode *pNode, std::string &strRet, MENTORSQL_DATATYPES &dt1 )
{
if ( pNode->m_nType == NodeType_Dot ) 
	{
	std::string strColName = pNode->m_pRightChild->m_pSQLToken->m_strText.c_str();
	std::string strTableName = pNode->m_pLeftChild->m_pSQLToken->m_strText.c_str();
	std::string strQualifiedName;

	dt1 = (MENTORSQL_DATATYPES)m_pTuple->GetDataType( strColName.c_str(), strTableName.c_str() );

	m_pTuple->GetFieldAsBuf( strRet, strColName.c_str(), strTableName.c_str() );
	return true;
	}
//Just a value from user
switch(pNode->m_nType )
	{
	case NodeType_String_Value:
		{
		std::string strTemp = pNode->m_pSQLToken->m_strText;
		strTemp = strTemp.substr( 1, strTemp.length()-2);
		strRet = strTemp;
		dt1 = MENTORSQL_DATATYPE_CHAR;
		return true;
		break;
		}
	case NodeType_Integer_Value:
		dt1 = MENTORSQL_DATATYPE_INT;
		break;
	case NodeType_Float_Value:
		dt1 = MENTORSQL_DATATYPE_FLOAT;
		break;
	} 
strRet = pNode->m_pSQLToken->m_strText;
return true;
}


bool CPlanOperator::ApplyOneCondition( CSQLNode *pNode )
{
if ( pNode == NULL )
	return 0;
switch( pNode->m_nType )
	{
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
	case NodeType_More:
	case NodeType_Less:
	case NodeType_Equals:
		{
//		if ( pNode->m_pLeftChild->m_pSQLToken->m_strText.compare( pTable->GetName() ) )
//			return true;
		std::string str1, str2;
		MENTORSQL_DATATYPES dt1, dt2;
		GetValueInTuple( pNode->m_pLeftChild, str1, dt1 );
		GetValueInTuple( pNode->m_pRightChild, str2, dt2 );
		int nEq;
		nEq = GeneralCompare( str1.c_str(), dt1, str2.c_str(), dt2 );
		if ( pNode->m_nType == NodeType_MoreEquals )
			return nEq >= 0;
		if ( pNode->m_nType == NodeType_LessEquals )
			return nEq <= 0;
		if ( pNode->m_nType == NodeType_More )
			return nEq > 0;
		if ( pNode->m_nType == NodeType_Less )
			return nEq > 0;
		if ( pNode->m_nType == NodeType_Equals )
			return nEq == 0;

		}
	case NodeType_And:
		{
		//Both should be applied...
		return ApplyOneCondition( pNode->m_pLeftChild ) && 
			ApplyOneCondition( pNode->m_pRightChild );
		}
	case NodeType_Or:
		{
		//Both should be applied...
		return ApplyOneCondition( pNode->m_pLeftChild ) || 
			ApplyOneCondition( pNode->m_pRightChild );
		}
	}
return false;
}


//Check so all iterms in this is available
bool CPlanOperator::CanApplyCondition( CSQLNode *pNode )
{
if ( pNode == NULL || pNode->m_nType == NodeType_Empty )
	return false;
switch( pNode->m_nType )
	{
	case NodeType_Equals:
	case NodeType_More:
	case NodeType_Less:
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
	case NodeType_And:
	case NodeType_Or: //We should perform check on all childs
		{
		return	CanApplyCondition( pNode->m_pLeftChild ) && 
				CanApplyCondition( pNode->m_pRightChild );
		break;
		}
	case NodeType_Dot:
		{
		//Here is the actual check...
		return ColumnExists( pNode );
		}
	}
return true;
}


void CPlanOperator::PlaceWhereConditions(  CSQLNodeArray &WhereCondArray )
{
for ( CSQLNodeArray::iterator iter = WhereCondArray.begin(); 
	iter != WhereCondArray.end();
	iter++ )
	{
	CSQLNode *pNode = *iter;
	//Om den r applicerbar och den inte redan r applicerad i en lgre nod s...
	if ( (!CondExistsInChild(pNode )) && CanApplyCondition( pNode ) )
		m_WhereCondArray.push_back( pNode );	
	}	
}

void CPlanList::AddToAvailableColumns( CTablePlanInfo *pTablePlanInfo )
{
//So for this one - create available columns
for ( CColumnPlanInfoArray::iterator iter = pTablePlanInfo->m_ColumnPlanInfoArray.begin(); iter != pTablePlanInfo->m_ColumnPlanInfoArray.end(); iter++ )
	{
	CColumnPlanInfo *pInfo = *iter;
	if ( !pInfo->m_strTableName.compare( m_strInner ) )
		{
		//This is right...
		m_AvailableColumns.push_back( *iter );	
		}
	}
if ( m_pOuter )
	{
	for ( iter = m_pOuter->m_AvailableColumns.begin(); iter != m_pOuter->m_AvailableColumns.end(); iter++ )
		{
		CColumnPlanInfo *pInfo = *iter;
		//This is right...
		m_AvailableColumns.push_back( *iter );	
		}
	}
}





#if(0)
//typedef std::vector<string> CStringArray; 
typedef std::vector<CStringArray> CStringArrayArray; 

//Sg att vi har tre tabeller
//Vi skall d f 6 stycken strngarrayer
//123, 132, 213, 231, 321, 312

typedef struct
{
	char *szTable;
	TABLE *pNext;
}TABLE;

void test()
{
//Sg att vi har tre stycken
TABLE *pTable;
CreateSolutions( pTable );
}

void CreateSolutions( TABLE *pTable )
{
if ( !pTable )
	return;

//Vi skall skapa en array fr varje mjlig 

CStringArray Array; //First, create a solution for this, next and the last
//Then a solution for this, last and next etc

//pSolution = CreateSolution( pTable )
while ( pTable->pNext )
	{
	CreateSolutions( pTable->pNext );

	}
}

#endif





#ifdef _DEBUG
void CTablePlanInfo::Dump()
{
cout << "TABLEPLAN DUMP: " << m_strTableName.c_str() << endl;
cout << "Columns to extract:" << endl;
for ( CColumnPlanInfoArray::iterator iter =  m_ColumnPlanInfoArray.begin();
	iter !=  m_ColumnPlanInfoArray.end();	
	iter++ )
	{
	CColumnPlanInfo *pInfo = *iter;
	cout << "\t" << pInfo->m_strColumnName.c_str() << endl;
	}
fflush( stdout );
}
#endif



void CJoinOperator::CopyDataToTuple()
{
CTuple *pTuple;
for ( int i = 0; i < m_pPlanList->m_AvailableColumns.size(); i++ )
	{
	CColumnPlanInfo *pInfo = (m_pPlanList->m_AvailableColumns)[i];

	//Vilken finns den i 
	if ( m_pLeftChild->m_pTuple->ColumnExists( pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() ) )
		pTuple = m_pLeftChild->m_pTuple;
	if ( m_pRightChild->m_pTuple->ColumnExists( pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() ) )
		pTuple = m_pRightChild->m_pTuple;


	switch( pInfo->m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			{
			std::string strRet;
			pTuple->GetStringValue( strRet, pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			m_pTuple->SetValue( (void *)strRet.c_str(), pInfo->m_nFieldLen,  pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			break;
			}
		case MENTORSQL_DATATYPE_INT:
			{
			long lRet;
			pTuple->GetLongValue( lRet, pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			m_pTuple->SetValue( &lRet, sizeof(long),  pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			}
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			{
			double dRet;
			pTuple->GetDoubleValue( dRet, pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			m_pTuple->SetValue( &dRet, sizeof(double),  pInfo->m_strColumnName.c_str(), pInfo->m_strTableName.c_str() );
			}
			break;
		}
	}
}


void CIndexAccessMethod::CopyDataToTuple()
{
int nFieldNo;
for ( int i = 0; i < m_pPlanList->m_AvailableColumns.size(); i++ )
	{
	CColumnPlanInfo *pInfo = (m_pPlanList->m_AvailableColumns)[i];
	nFieldNo = m_pTableRef->GetFieldNo( pInfo->m_strColumnName.c_str() );
	switch( pInfo->m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			{
			char szBuf[512];
			m_pTableRef->GetField( nFieldNo, szBuf );
			SpaceTruncate( szBuf );
			m_pTuple->SetValue( szBuf, pInfo->m_nFieldLen,  pInfo->m_strColumnName.c_str() );
			break;
			}
		case MENTORSQL_DATATYPE_INT:
			{
			long lTemp = m_pTableRef->GetLongField( nFieldNo );
			m_pTuple->SetValue( &lTemp, sizeof(long),  pInfo->m_strColumnName.c_str() );
			}
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			double dTemp = m_pTableRef->GetDoubleField( nFieldNo );
			m_pTuple->SetValue( &dTemp, sizeof(double),  pInfo->m_strColumnName.c_str() );
			break;
		}
	}
}



void CTableScanAccessMethod::CopyDataToTuple()
{
int nFieldNo;
for ( int i = 0; i < m_pPlanList->m_AvailableColumns.size(); i++ )
	{
	CColumnPlanInfo *pInfo = (m_pPlanList->m_AvailableColumns)[i];
	nFieldNo = m_pTableRef->GetFieldNo( pInfo->m_strColumnName.c_str() );
	switch( pInfo->m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			{
			char szBuf[512];
			m_pTableRef->GetField( nFieldNo, szBuf );
			SpaceTruncate( szBuf );
			m_pTuple->SetValue( szBuf, pInfo->m_nFieldLen,  pInfo->m_strColumnName.c_str() );
			break;
			}
		case MENTORSQL_DATATYPE_INT:
			{
			long lTemp = m_pTableRef->GetLongField( nFieldNo );
			m_pTuple->SetValue( &lTemp, sizeof(long),  pInfo->m_strColumnName.c_str() );
			}
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			double dTemp = m_pTableRef->GetDoubleField( nFieldNo );
			m_pTuple->SetValue( &dTemp, sizeof(double),  pInfo->m_strColumnName.c_str() );
			break;
		}
	}
}


CTuple::CTuple( CColumnPlanInfoArray *pPlanInfoArray )
{
m_szBuf = NULL;
m_pColumnPlanInfoArray = pPlanInfoArray;
int nSize = 0;
for ( int i = 0; i < m_pColumnPlanInfoArray->size(); i++ )
	{
	CColumnPlanInfo *pInfo = (*m_pColumnPlanInfoArray)[i];
	switch( pInfo->m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			nSize += pInfo->m_nFieldLen;
			break;
		case MENTORSQL_DATATYPE_INT:
			nSize += sizeof( long );
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			nSize += sizeof( double );
			break;

		}
	}
m_szBuf = new char[ nSize ];
memset( m_szBuf, 0, nSize );
}

void CTuple::SetValue( void *pvData, int nSize, const char *szColName, const char *szTableName )
{
int nFieldSize;
int nColNo = GetColNo( szColName, szTableName );
char *szBuf = GetBuffer( nColNo, nFieldSize );
memcpy( szBuf, (char *) pvData, nSize );
}

char *CTuple::GetBuffer( int nColNo, int &nFieldSize )
{
int nSize = 0;
for ( int i = 0; i <= nColNo; i++ )
	{
	CColumnPlanInfo *pInfo = (*m_pColumnPlanInfoArray)[i];
	switch( pInfo->m_DataType )
		{
		case MENTORSQL_DATATYPE_CHAR:
			nFieldSize = pInfo->m_nFieldLen;
			break;
		case MENTORSQL_DATATYPE_INT:
			nFieldSize = sizeof( long );
			break;
		case MENTORSQL_DATATYPE_FLOAT:
			nFieldSize = sizeof( double );
			break;
		}
	nSize += nFieldSize;
	}
return &m_szBuf[nSize-nFieldSize];
}

int CTuple::GetColNo( const char *szColName, const char *szTableName )
{
for ( int i = 0; i < m_pColumnPlanInfoArray->size(); i++ )
	{
	CColumnPlanInfo *pInfo = m_pColumnPlanInfoArray->at(i);
	if ( !stricmp(pInfo->m_strColumnName.c_str(), szColName) )
		{
		if ( szTableName )
			{
			if (  !stricmp(pInfo->m_strTableName.c_str(), szTableName) )
				return i;
			}
		else
			return i;
		}
	}
return -1;
}


CTuple::~CTuple()
{
if ( m_szBuf )
	delete []m_szBuf;
}

bool CTuple::GetStringValue( std::string &strRet, const char *szColName, const char *szTableName )
{
int nColNo = GetColNo( szColName, szTableName );
if ( nColNo == -1 )
	return false;
return GetStringValue( strRet, nColNo );
}

bool CTuple::GetStringValue( std::string &strRet, int nColNo )
{
int nSize;
char *szBuf = GetBuffer( nColNo, nSize );
char *szTempBuf = new char[ nSize + 1 ];
memset( szTempBuf, 0, nSize + 1 );
strncpy( szTempBuf, szBuf, nSize );
strRet = szTempBuf;
delete []szTempBuf;
return true;
}

bool CTuple::GetLongValue( long &lRet, const char *szColName, const char *szTableName)
{
int nColNo = GetColNo( szColName, szTableName );
if ( nColNo == -1 )
	return false;
return GetLongValue( lRet, nColNo );
}

bool CTuple::GetLongValue( long &lRet, int nColNo )
{
int nSize;
char *szBuf = GetBuffer( nColNo, nSize );
long *lPek = (long *)szBuf;
lRet = *lPek;
return true;
}

bool CTuple::GetDoubleValue( double &dRet, const char *szColName, const char *szTableName )
{
int nColNo = GetColNo( szColName, szTableName );
if ( nColNo == -1 )
	return false;
return GetDoubleValue( dRet, nColNo );
}

bool CTuple::GetDoubleValue( double &dRet, int nColNo )
{
int nSize;
char *szBuf = GetBuffer( nColNo, nSize );
double *dPek = (double *)szBuf;
dRet = *dPek;
return true;
}

MENTORSQL_DATATYPES CTuple::GetDataType( const char *szColName, const char *szTableName )
{
int nColNo = GetColNo( szColName, szTableName );
return GetDataType( nColNo );
}

MENTORSQL_DATATYPES CTuple::GetDataType( int nColNo )
{
return m_pColumnPlanInfoArray->at(nColNo)->m_DataType;
}

bool CTuple::ColumnExists( const char *szColName, const char *szTableName )
{
for ( int i = 0; i < m_pColumnPlanInfoArray->size(); i++ )
	{
	CColumnPlanInfo *pInfo = m_pColumnPlanInfoArray->at(i);
	if ( !pInfo->m_strColumnName.compare( szColName ) )
		{
		if ( !szTableName )
			return true;
		if ( !pInfo->m_strTableName.compare( szTableName ) )
			return true;
		}
	}
return false;
}



bool CTuple::GetFieldAsBuf( std::string &strRet, int nColNo )
{
MENTORSQL_DATATYPES dt = GetDataType( nColNo );
switch( this->m_pColumnPlanInfoArray->at(nColNo)->m_DataType )
	{
	case MENTORSQL_DATATYPE_CHAR:
		{
		GetStringValue( strRet, nColNo );
		break;
		}
	case MENTORSQL_DATATYPE_INT:
		{
		long lTemp;
		GetLongValue( lTemp, nColNo );
		char szTemp[20];
		sprintf( szTemp, "%ld", lTemp );
		strRet = szTemp;
		break;
		}
	case MENTORSQL_DATATYPE_FLOAT:
		{
		double dTemp;
		GetDoubleValue( dTemp, nColNo );
		char szTemp[20];
		sprintf( szTemp, "%.2lf", dTemp );
		strRet = szTemp;
		break;
		}
	}
return true;
}

bool CTuple::GetFieldAsBuf( std::string &strRet, const char *szColName, const char *szTableName )
{
int nColNo = GetColNo( szColName, szTableName );
return GetFieldAsBuf( strRet, nColNo);
}
