#ifndef __SYSTEMCATALOG_H
#define __SYSTEMCATALOG_H
/*  Product: Mentor SQL

    Copyright (C) 1998  Systementor AB, Stefan Holmberg
    Email - stefan.holmberg@systementor.se
    Web:   - http://www.systementor.se

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
*/

#include <string>
#include <vector>

//#include "xbase.h"
#include "tables.h"

class XBASE;

class CSystemCatalog;
class CTable;

void SpaceTruncate( char *szName );

class CSystemCatalog
{
public:
	CSystemCatalog();
	~CSystemCatalog();	
	bool Initialize();

	void ReadSystemTables();

	XBASE *m_pXBase;

	CTableArray m_TableArray;

	CTable *m_pSystemTables;
	CTable *m_pSystemColumns;
	CTable *m_pSystemIndexes;
	std::string m_strDataDirectory;
	int CreateTable( const char *szName, CColumnDesc *pSchema, int nCount );
	CTable *GetTable( const char *szName );
	int DropTable( const char *szName );

	int CreateIndex( const char *szTable, const char *szIndex, const char *szExp );
	int DropIndex( const char *szIndex );

	CColumnDesc *GetColumnDesc( long lTabellID, int &nCount );
protected:
	bool InitSystemTables();
	bool AddToSystemTables( const char *szName, long &lID );
	bool AddToSystemColumns( long lTabellID, CColumnDesc *pSchema, int nCount );
	bool DeleteFromSystemTables( const char *szTableName, long &lTabellId );
	bool DeleteFromSystemColumns( long lTabellID );
	bool AddToSystemIndexes( long lTableID, const char *szIndexName, char *szExp, long &lID );
	bool DeleteFromSystemIndexes( long lTableId, const char *szIndexName = NULL );
	int OpenTable( CTable *pTable );

	char *GetDataType( char chDescInFile );
	int ConvertDataType( char *szBuf );
	CColumnDesc *AllocateSystemArray( const char *szTableName, int &nCount );
};


#endif