#ifndef __EXECUTER_H
#define __EXECUTER_H

/*  Product: Mentor SQL

    Copyright (C) 1998  Systementor AB, Stefan Holmberg
    Email - stefan.holmberg@systementor.se
    Web:   - http://www.systementor.se

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
*/


#include "parsetree.h"
#include "tables.h"
#include "error.h"

class CSQLNode;
class CParseTree;

//Class for executing a ParseTree
class CExecuter
{
public:
	CExecuter( CParseTree *pTree );
	~CExecuter();
	int Execute();
	long ResultSize();
	void CopyToBuf( char *szBuf );



protected:
	//Functions for executing different queries 
	int ExecuteInsert();
	int ExecuteDelete();
	int ExecuteUpdate();
	int ExecuteUtility();
	int ExecuteQuery();



	bool _CheckTableNames( CSQLNode *pFromClause );
	int _CheckAndQualifyColumnNames( CSQLNode *pSelectClause, CSQLNode *pFromClause, int &nColCount );
	int _CheckAndQualifyWhereNames( CSQLNode *pFromClause, CSQLNode *pWhereClause );
	int _QualifyColName( CSQLNode *pNode, CSQLNode *pFromClause );
	int _CheckAndQualifyUpdateList( CSQLNode *pTableIdent, CSQLNode *pUpdateList );
	int _CheckAndValidateOrderNames( CSQLNode *pTableIdent, CSQLNode *pUpdateList );
	

	int _RecursiveCheck( CSQLNode *pNode, CSQLNode *pFromClause );
	int _RecordUpdate( CTable *pTable, CSQLNode *pDotColNode, CSQLNode *pDataNode, int nColCount = -1 );
//	void DumpTable();

	CParseTree *m_pTree;
	long m_lResultSize;
	char *m_szResult;
	CTempTable *m_pResultSet;
};

#endif