#include <stdlib.h>
#include <string.h>
#include "general.h"
#include "error.h"
#include <windows.h>

#include "shalloc.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


CTreeTracer::CTreeTracer()
{
m_nRefCount++;
}

CTreeTracer::~CTreeTracer()
{
m_nRefCount--;
}
	
void CTreeTracer::Dump( const char *szString )
{
for ( int i = 1; i < CTreeTracer::m_nRefCount; i++ )
	printf( "\t");
printf( szString );
printf( "\n");
}

int CTreeTracer::m_nRefCount = 0;



void SpaceTruncate( char *szName )
{
int n = strlen(szName) -1;
while ( szName[n] == ' ' )
	{
	szName[n] = 0;
	n--;
	}
}

int GeneralCompare( const char *sz1, MENTORSQL_DATATYPES dt1, const char *sz2, MENTORSQL_DATATYPES dt2 )
{
switch( dt1 )
	{
	case MENTORSQL_DATATYPE_CHAR:
		{
		if ( dt2 != MENTORSQL_DATATYPE_CHAR )
			return ERROR_NUM_WRONG_DATATYPE;
		int nRet = stricmp( (const char *)sz1, (const char *)sz2 );
		if ( nRet > 0 )
			return 1;
		if ( nRet == 0 )
			return 0;
		if ( nRet < 0 )
			return -1;
		}
	case MENTORSQL_DATATYPE_INT:
		{
		if ( dt2 != MENTORSQL_DATATYPE_INT )
			return ERROR_NUM_WRONG_DATATYPE;
		long lData = atol(sz1);
		lData = lData - atol( sz2 );
		if ( lData > 0 )
			return 1;
		if ( lData < 0 )
			return -1;
		return 0;
		}
	case MENTORSQL_DATATYPE_FLOAT:
		{
		if ( dt2 != MENTORSQL_DATATYPE_FLOAT )
			return ERROR_NUM_WRONG_DATATYPE;
		double dData = atof(sz1);
		dData = dData - atof( sz2 );
		if ( dData > 0.0001 )
			return 1;
		if ( dData < -0.0001 )
			return -1;
		return 0;
		}

	}
return ERROR_NUM_WRONG_DATATYPE;
}


int Compare( CColumnDesc *pSchema, CBaseTable *pTable, CSQLNode *pNode )
{
CSQLToken *pSQLToken = pNode->m_pSQLToken;
switch( pSchema->m_DataType )
	{
	case MENTORSQL_DATATYPE_CHAR:
		{
		if ( pNode->m_nType != NodeType_String_Value )
			return ERROR_NUM_WRONG_DATATYPE;
		char szBuf[ 512 ];
		memset( szBuf, 0, sizeof(szBuf) );
		int nIndex = pTable->GetFieldNo( pSchema->m_szName );
		pTable->GetField( nIndex, szBuf );
		SpaceTruncate( szBuf );
		std::string strTemp = pSQLToken->m_strText;
		strTemp = strTemp.substr( 1, strTemp.length()-2);
		int nRet = stricmp( (const char *)szBuf, (const char *)strTemp.c_str() );
		if ( nRet > 0 )
			return 1;
		if ( nRet == 0 )
			return 0;
		if ( nRet < 0 )
			return -1;
		}
	case MENTORSQL_DATATYPE_INT:
		{
		if ( pNode->m_nType != NodeType_Integer_Value )
			return ERROR_NUM_WRONG_DATATYPE;
		long lData = pTable->GetLongField( pSchema->m_szName );
		lData = lData - atol( (const char *)pSQLToken->m_strText.c_str() );
		if ( lData > 0 )
			return 1;
		if ( lData < 0 )
			return -1;
		return 0;
		}
	case MENTORSQL_DATATYPE_FLOAT:
		{
		if ( pNode->m_nType != NodeType_Float_Value )
			return ERROR_NUM_WRONG_DATATYPE;
		double dData = pTable->GetDoubleField( pSchema->m_szName );
		dData = dData - atof( (const char *)pSQLToken->m_strText.c_str() );
		if ( dData > 0.0001 )
			return 1;
		if ( dData < -0.0001 )
			return -1;
		return 0;
		}
	}
return ERROR_NUM_WRONG_DATATYPE;
}

