//#include <windows.h>
#include <winsock.h>
//#include "FlexLexer.h"
#include "Executer.h"
#include "CommClient.h"
#include "tcp.h"
#include "error.h"

#include "shalloc.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


typedef struct
{
char szError[50];
char szText;
} TRANSACTION_RESULT;


long Comm_Execute( const char *szSQL, char **szRetBuf )
{
static HANDLE hMutex = INVALID_HANDLE_VALUE;
TRANSACTION_RESULT *pResult = (TRANSACTION_RESULT *)szRetBuf;

if ( hMutex == INVALID_HANDLE_VALUE )
	hMutex = CreateMutex(NULL, 0, NULL );

//Only one at a time...

WaitForSingleObject( hMutex, INFINITE );
printf( "Executing %s\n", szSQL );
CParseTree Parse;
int nRetCode = Parse.ParseSQL( szSQL );
if ( nRetCode != 0 )
	{
	*szRetBuf = new char[ 50 ];
	sprintf( *szRetBuf, "%02d;%s", nRetCode, "Parse error" );
	ReleaseMutex( hMutex );
	return 50;
	}

CExecuter Executer( &Parse );
nRetCode = Executer.Execute();
ReleaseMutex( hMutex );

*szRetBuf = new char[ Executer.ResultSize() + 55 ];
char *szTemp = *szRetBuf;
szTemp = &szTemp[50];
if ( Executer.ResultSize() )
	{
	Executer.CopyToBuf(szTemp);
	}
sprintf( *szRetBuf, "%02d;%s", nRetCode, ErrorGetDescription( (ERROR_NUM)nRetCode ) );
return 50 + Executer.ResultSize();
}


void Comm_StartClient()
{
//Create a new thread for listening...
DWORD dwThreadId;
CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE) Comm_Listen, 0, 0, &dwThreadId );
}

void Comm_ClientThread( void *cs )
{
char *szBuf = NULL;
int nNumRcv;
char *szRetBuf = NULL;
SOCKET hSock = (SOCKET) cs;

while ( 1 )
	{
	long lSize;
	nNumRcv = TCP_Read( hSock, &szBuf, lSize );
	if ( nNumRcv == 0 || nNumRcv == SOCKET_ERROR )
		break;
	long lLen = Comm_Execute( szBuf, &szRetBuf );
	nNumRcv = TCP_Send( hSock, szRetBuf, lLen );
	if ( nNumRcv == 0 || nNumRcv == SOCKET_ERROR )
		break;
	delete []szBuf;
	delete []szRetBuf;
	szBuf = NULL;
	szRetBuf = NULL;
	}
if ( szBuf )
	delete []szBuf;
if ( szRetBuf )
	delete []szRetBuf;
closesocket( hSock );
}

void Comm_Listen()
{
WSADATA wsadata;
SOCKADDR_IN serverSockAddr;
SOCKADDR_IN clientSockAddr;
SOCKET hServerSock, hClientSock;
int nStatus;

nStatus = WSAStartup(MAKEWORD(1,1), &wsadata);
if ( nStatus != 0 )
	return;
memset( &serverSockAddr, 0, sizeof(SOCKADDR_IN) );
serverSockAddr.sin_port = htons( 8701 );
serverSockAddr.sin_family = AF_INET;
serverSockAddr.sin_addr.s_addr = htonl( INADDR_ANY );

hServerSock = socket( AF_INET, SOCK_STREAM, 0 );
nStatus = bind( hServerSock, (LPSOCKADDR) &serverSockAddr, sizeof(SOCKADDR_IN) );
nStatus = listen( hServerSock, 5 );

while( 1 )
	{
	DWORD dwThreadId;
	int nAddrLen = sizeof( SOCKADDR_IN );

	hClientSock = accept( hServerSock, (LPSOCKADDR) &clientSockAddr, &nAddrLen );
	CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE) Comm_ClientThread, (void *)hClientSock, 0, &dwThreadId );
	}
}