/*  xdate.h

    Xbase project source code

    This file contains a header file for the XDATE object, which is 
    used for handling dates.

    Copyright (C) 1997  StarTech, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.5   1/2/98     - Added memo field support
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Numeric index keys
    V 1.7.1 5/25/98    - Enhancements/bug fixes from eljorgo@fontun.com


///////////////////////////////////////////////////////////////////////////////
	   25/9/98 - Changes made by Stefan Holmberg for MentorSQL
	   THIS IS NOT OFFICIAL XBASE CHANGES!
	   - Added import/export for DLL

	   I know I might have subclasses and changed in those classes instead but
	   since I'm gonna change a lot more - like memory allocation schema and 
	   file I/O it wouldn't have helped me there...
///////////////////////////////////////////////////////////////////////////////
*/

#include "options.h"

#ifndef XDATE_FLAG
#define XDATE_FLAG

//#ifdef XBASELIB_EXPORTS
//#define XBASELIB_API __declspec(dllexport)
//#else
//#define XBASELIB_API __declspec(dllimport)
//#endif
#define XBASELIB_API


#define FMT_WEEK   1
#define FMT_MONTH  2
#define FMT_YEAR   3

class XBASELIB_API XDATE
{
    int LeapTable[12];
    int NonLeapTable[12];
    char *Days[7];
    char *Months[12];
  public:
    XDATE( void );
    long JulianDays    ( char * );
    int  YearOf        ( char * );
    int  MonthOf       ( char * );
    int  IsLeapYear    ( char * );
    int  DayOf         ( int, char * );
    char * Sysdate     ( void );
    int  DateIsValid   ( char * );
    char * JulToDate8  ( long );
    char * CharDayOf   ( char * );
    char * CharMonthOf ( char * );
    char * FormatDate  ( char *, char * );
    long LastDayOfMonth( char * );
};

#endif    // XDATE_FLAG
