/*  stack.cpp 

    Xbase project source code

    This fiel contains logic for handling basic stack functions.

    Copyright (C) 1997  Crypton Technologies, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.5   1/2/97     - Added memo field support
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Added expression support
*/

#include "stdafx.h"
#include "options.h"
#include <string.h>
#include <iostream.h>
#include "xstack.h"


#ifdef _DEBUG
#include "shalloc.h"
#define malloc(a) DebugMalloc(a, __FILE__, __LINE__ )
#endif

/*************************************************************************/
STACK::STACK( VOID )
{
   First      = NULL;
   Last       = NULL;
   Free       = NULL;
   StackDepth = 0;;
}
/*************************************************************************/
VOID STACK::InitStack( VOID )
{
   if( !First || !Last ) return;
   if( Free )
   {
      Last->Next     = Free;
      Free->Previous = Last;
   }
   Free  = First;
   First = NULL;
   Last  = NULL;
   StackDepth = 0;
   return;
}
/*************************************************************************/
StackElement * STACK::GetStackElement( VOID )
{
   StackElement * Temp;

   /* check the free chain for an empty Stack element, if not found,
      allocate one from memory */

   if( Free )
   {
      Temp = Free;
      Free = Free->Next;
   }
   else 

    if((( Temp = (StackElement *) malloc( sizeof( StackElement )))==NULL))
      return NULL;

   memset( Temp, 0x00, sizeof( StackElement ));
   return Temp;
}
/*************************************************************************/
VOID STACK::FreeStackElement( StackElement * e )
{
   e->Previous = NULL;
   e->Next = Free;
   if( Free ) Free->Previous = e;
   Free = e;
}
/*************************************************************************/
SHORT STACK::Push( VOID * p )
{
   StackElement * Temp;
   if(( Temp = GetStackElement()) == NULL )
      return 102;

   Temp->UserPtr = p;
   if( !First )
   {
      First = Temp;
      Last  = Temp;
      StackDepth = 1;
   }
   else
   {
      Last->Next = Temp;
      Temp->Previous = Last;
      Last = Temp;
      StackDepth++;
   }
   return 0;
}
/*************************************************************************/
VOID * STACK::Pop( VOID )
{
   VOID * p;
   StackElement * Save;

   if( StackDepth == 0 ) 
      return NULL;
   else
   {
      p = Last->UserPtr;
      if( StackDepth == 1 )
      {
         FreeStackElement( First );
         First = NULL;
         Last  = NULL;
      }
      else  /* number of items in Stack must be > 1 */
      {
         Last->Previous->Next = NULL;
         Save = Last;
         Last = Last->Previous;
         FreeStackElement( Save );
      }
      StackDepth--;
      return p;
   }
}
/*************************************************************************/
#ifdef XBASE_DEBUG
VOID STACK::DumpStack( VOID )
{
   StackElement * e;
   if( StackDepth == 0 )
   {
      cout << "\nStack is empty...";
      return;
   }

   cout << "\nThere are " << StackDepth << " entries.";
   cout << "\nFirst = " << First << "  Last = " << Last;

   e = First;
   while( e )
   {
      cout << "\n*****************************";
      cout << "\nThis      = " << e;
      cout << "\nNext      = " << e->Next;
      cout << "\nPrevious  = " << e->Previous;
      cout << "\nUser Pointer = " << e->UserPtr;
      e = e->Next;
   }
   cout << "\nFree list follows...";
   e = Free;
   while( e )
   {
      cout << "\n*****************************";
      cout << "\nThis      = " << e;
      cout << "\nNext      = " << e->Next;
      cout << "\nPrevious  = " << e->Previous;
      cout << "\nUser Pointer = " << e->UserPtr;
      e = e->Next;
   }
   return;
}
#endif
/*************************************************************************/
