/*  ndx.h

    Xbase project source code

    This file contains a header file for the NDX object, which is used
    for handling NDX type indices.

    Copyright (C) 1997  StarTech, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.02  10/25/97   - Index performance enhancements
    V 1.3   11/30/97   - Moved GetLong and GetShort to DBF class for memos
    V 1.5   1/2/98     - Added Dbase IV memo field support
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Numeric index support


///////////////////////////////////////////////////////////////////////////////
	   25/9/98 - Changes made by Stefan Holmberg for MentorSQL
	   THIS IS NOT OFFICIAL XBASE CHANGES!
	   - Added import/export for DLL

	   I know I might have subclasses and changed in those classes instead but
	   since I'm gonna change a lot more - like memory allocation schema and 
	   file I/O it wouldn't have helped me there...
///////////////////////////////////////////////////////////////////////////////
*/

#ifndef NDX_FLAG
#define NDX_FLAG

#include "xbase.h"
#include <string.h>

#define NDX_NODE_SIZE 512

struct XBASELIB_API NdxHeadNode {			/* ndx header on disk */
   LONG   StartNode;                    /* header node is node 0 */
   LONG   TotalNodes;                   /* includes header node */
   LONG   NoOfKeys;                     /* actual count + 1 */
   USHORT KeyLen;                       /* length of key data */
   USHORT KeysPerNode;
   USHORT KeyType;                      /* 00 = Char, 01 = Numeric */
   LONG   KeySize;                      /* key len + 8 bytes */
   CHAR   Unknown2;
   CHAR   Unique;
   CHAR   KeyExpression[488];
};

struct XBASELIB_API NdxLeafNode {			/* ndx node on disk */
   LONG   NoOfKeysThisNode;
   CHAR   KeyRecs[NDX_NODE_SIZE-4];
};

struct XBASELIB_API NodeLink {			/* ndx node memory */
   NodeLink * PrevNode;
   NodeLink * NextNode;
   LONG       CurKeyNo;                 /* 0 - KeysPerNode-1 */
   LONG       NodeNo;
   struct NdxLeafNode Leaf;
};

class XBASELIB_API NDX {
   NDX * ndx;
   DBF * dbf;
   ExpNode * ExpressionTree;    /* Expression tree for index */
   NdxHeadNode HeadNode;
   NdxLeafNode LeafNode;
   LONG NodeLinkCtr;
   LONG ReusedNodeLinks;

   CHAR  *IndexName;
   CHAR  Node[NDX_NODE_SIZE];
   FILE  *ndxfp;
   int   NdxStatus;                /* 0 = closed, 1 = open */

   NodeLink * NodeChain;        /* pointer to node chain of index nodes */
   NodeLink * FreeNodeChain;    /* pointer to chain of free index nodes */
   NodeLink * CurNode;          /* pointer to current node              */
   NodeLink * DeleteChain;      /* pointer to chain to delete           */
   NodeLink * CloneChain;       /* pointer to node chain copy (add dup) */
   LONG  CurDbfRec;		/* current Dbf record number */
   CHAR  *KeyBuf;               /* work area key buffer */
   CHAR  *KeyBuf2;              /* work area key buffer */

/* private functions */
   LONG     GetLeftNodeNo( SHORT, NodeLink * );
   SHORT    CompareKey( CHAR *, CHAR *, SHORT );
   LONG     GetDbfNo( SHORT, NodeLink * );
   CHAR *   GetKeyData( SHORT, NodeLink * );
   USHORT   GetKeysPerNode( VOID );
   SHORT    GetHeadNode( VOID );    
   SHORT    GetLeafNode( LONG, SHORT );
   NodeLink * GetNodeMemory( VOID );
   VOID     ReleaseNodeMemory( NodeLink * );
   LONG     GetLeafFromInteriorNode( CHAR *, SHORT );
   SHORT    CalcKeyLen( VOID );
   SHORT    PutKeyData( SHORT, NodeLink * );
   SHORT    PutLeftNodeNo( SHORT, NodeLink *, LONG );
   SHORT    PutLeafNode( LONG, NodeLink * );
   SHORT    PutHeadNode( NdxHeadNode *, FILE *, SHORT );
   SHORT    PutDbfNo( SHORT, NodeLink *, LONG );
   SHORT    PutKeyInNode( NodeLink *, SHORT, LONG, LONG, SHORT );
   SHORT    SplitLeafNode( NodeLink *, NodeLink *, SHORT, LONG ); 
   SHORT    SplitINode( NodeLink *, NodeLink *, LONG );
   SHORT    AddToIxList( VOID );
   SHORT    RemoveFromIxList( VOID );
   SHORT    RemoveKeyFromNode( SHORT, NodeLink * );
   SHORT    FindKey( CHAR *, SHORT, SHORT );      
   SHORT    UpdateParentKey( NodeLink * );
   SHORT    GetFirstKey( SHORT );
   SHORT    GetNextKey( SHORT );
   SHORT    GetLastKey( LONG, SHORT );
   SHORT    GetPrevKey( SHORT ); 
   VOID     UpdateDeleteList( NodeLink * );
   VOID     ProcessDeleteList( VOID );
   NodeLink * LeftSiblingHasSpace( NodeLink * );
   NodeLink * RightSiblingHasSpace( NodeLink * );
   SHORT    DeleteSibling( NodeLink * );
   SHORT    MoveToLeftNode( NodeLink *, NodeLink * );
   SHORT    MoveToRightNode( NodeLink *, NodeLink * );
   SHORT    FindKey( CHAR *, LONG );         /* for a specific dbf no */

   SHORT    CloneNodeChain( VOID );          /* test */
   SHORT    UncloneNodeChain( VOID );        /* test */
   
public:
   NDX      ( DBF * );

/* note to gak - don't uncomment next line - it causes seg faults */
   ~NDX() { if( NdxStatus ) CloseIndex(); }  

   char *GetExpression() { return HeadNode.KeyExpression; };


   SHORT  OpenIndex ( CHAR * );
   SHORT  CloseIndex( VOID );
   VOID   DumpHdrNode  ( VOID );
   VOID   DumpNodeRec  ( LONG ); 
   SHORT  CreateIndex( CHAR *, CHAR *, SHORT, SHORT );
   LONG   GetTotalNodes( VOID );
   LONG   GetCurDbfRec( VOID ) { return CurDbfRec; }
   VOID   DumpNodeChain( VOID );
   SHORT  CreateKey( SHORT, SHORT );
   SHORT  AddKey( LONG );
   SHORT  UniqueIndex( VOID ) { return HeadNode.Unique; }
   SHORT  DeleteKey( LONG );
   SHORT  KeyWasChanged( VOID );
   SHORT  FindKey( CHAR * );
   SHORT  FindKey( VOID );
   SHORT  FindKey( DOUBLE );
   SHORT  CheckNdxIntegrity( SHORT );
   SHORT  GetNextKey( VOID )  { return GetNextKey( 1 ); }
   SHORT  GetLastKey( VOID )  { return GetLastKey( 0, 1 ); }
   SHORT  GetFirstKey( VOID ) { return GetFirstKey( 1 ); }
   SHORT  GetPrevKey( VOID )  { return GetPrevKey( 1 ); }
   SHORT  ReIndex( VOID );
   SHORT  KeyExists( CHAR * Key ) { return FindKey( Key, strlen( Key ), 0 ); }
   SHORT  KeyExists( DOUBLE );

#ifdef LOCKING_ON
   SHORT  LockIndex( SHORT, SHORT );
#else
   SHORT  LockIndex( SHORT, SHORT ) { return NO_ERROR; }
#endif
};
#endif		/* NDX_FLAG */
