/*  exp.h

    Xbase project source code 

    This file contains a header file for the EXP object, which is
    used for expression processing.

    Copyright (C) 1997  Startech, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.5   1/2/97     - Added memo field support
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Numeric index keys
    V 1.7.1 5/25/98    - Expression support enhancements

///////////////////////////////////////////////////////////////////////////////
	   25/9/98 - Changes made by Stefan Holmberg for MentorSQL
	   THIS IS NOT OFFICIAL XBASE CHANGES!
	   - Added import/export for DLL

	   I know I might have subclasses and changed in those classes instead but
	   since I'm gonna change a lot more - like memory allocation schema and 
	   file I/O it wouldn't have helped me there...
///////////////////////////////////////////////////////////////////////////////

*/

#ifndef FLAG_EXP
#define FLAG_EXP



#include "xbase.h"

#include "options.h"


#ifdef EXPRESSIONS             /* compile if expression logic on */

#define EXPRESSION ExpNode

#include "stdlib.h"
#include "xtypes.h"
#include "xstack.h"

class DBF;

struct XBASELIB_API FuncDtl{
   CHAR * FuncName;                 /* function name               */
   SHORT  ParmCnt;                  /* no of parms it needs        */
   CHAR   ReturnType;               /* return type of function     */
   VOID   (*ExpFuncPtr)();          /* pointer to function routine */
};

struct XBASELIB_API ExpNode{
   CHAR * NodeText;           /* expression text                 */
   CHAR Type;                 /* same as TokenType below         */ 
   SHORT Len;                 /* length of expression text       */
   SHORT InTree;              /* this node in the tree? 1=yes    */
   ExpNode * Node;            /* pointer to parent               */ 
   ExpNode * Sibling1;        /* pointer to sibling 1            */
   ExpNode * Sibling2;        /* pointer to sibling 2            */
   ExpNode * Sibling3;        /* pointer to sibling 3            */

   SHORT  DataLen;            /* length of data in result buffer */
   SHORT  ResultLen;          /* length of result buffer         */
   CHAR * Result;             /* result buffer - ptr to result   */
   DOUBLE DoubResult;         /* Numeric Result                  */
   SHORT  IntResult;          /* logical result                  */

   DBF *  dbf;                /* pointer to datafile             */
   SHORT  FieldNo;            /* field no if DBF field           */
   CHAR   ExpressionType;     /* used in head node C,N,L or D    */
};

/* Expression handler */

class XBASELIB_API EXPN : public STACK , public XDATE {

   FuncDtl *XbaseFuncList;    /* pointer to list of Xbase functions    */
   ExpNode *NextFreeExpNode;  /* pointer to chain of free nodes        */ 
   ExpNode *Tree;
   SHORT LogicalType;         /* set to 1 for logical type nodes       */
//   CHAR TreeResultType;       /* C,N,L or D                            */

   CHAR TokenType;            /* E - Expression, not in simplist form  */
                              /* C - Constant                          */
                              /* N - Numeric Constant                  */
                              /* O - Operator                          */
                              /* F - Function                          */
                              /* D - Database Field                    */
                              /* s - character string result           */
                              /* l - logical or short int result       */
                              /* d - double result                     */
                              

   CHAR  PreviousType;        /* used to see if "-" follows operator     */
   CHAR  * Op1;               /* pointer to operand 1                    */
   CHAR  * Op2;               /* pointer to operand 2                    */
   DOUBLE Opd1;               /* double result 1                         */
   DOUBLE Opd2;               /* double result 2                         */
   SHORT OpLen1;              /* length of memory allocated to operand 1 */
   SHORT OpLen2;              /* length of memory allocated to operand 2 */
   SHORT OpDataLen1;          /* length of data in op1                   */
   SHORT OpDataLen2;          /* length of data in op2                   */

   CHAR  OpType1;             /* type of operand 1                       */
   CHAR  OpType2;             /* type of operand 2                       */
   SHORT TokenLen;            /* length of token                         */

   enum { WorkBufMaxLen = 200 };
   CHAR  WorkBuf[WorkBufMaxLen+1];

   SHORT IsWhiteSpace( CHAR );
   CHAR  IsSeperator( CHAR );
   ExpNode * LoadExpNode( CHAR *, CHAR, SHORT, SHORT );
   SHORT OperatorWeight( CHAR *, SHORT );
   SHORT ReduceComplexExpression( CHAR *, SHORT, ExpNode *, DBF * );   
   SHORT GetFunctionTokenLen( CHAR * );
   SHORT ReduceFunction( CHAR *, ExpNode *, DBF * );
   ExpNode * GetNextTreeNode( ExpNode * );
   SHORT ProcessOperator( SHORT );
   SHORT ProcessFunction( CHAR * );
   SHORT ValidOperation( CHAR *, CHAR, CHAR );
   CHAR  GetOperandType( ExpNode * );
   SHORT AlphaOperation( CHAR * );
   SHORT NumericOperation( CHAR * );
   ExpNode * GetExpNode( SHORT );
   SHORT GetFuncInfo( CHAR *, SHORT );
   DOUBLE GetDoub( ExpNode * );
   LONG   GetInt( ExpNode * );

public:
   VOID  FreeExpNode( ExpNode * );
   SHORT ProcessExpression( ExpNode *, SHORT );
   ExpNode * GetTree( VOID ) { return Tree; }
   VOID SetTreeToNull( VOID ) { Tree = NULL; }
   ExpNode * GetFirstTreeNode( ExpNode * );

   EXPN( VOID );
   TOKEN( VOID );
   SHORT  GetNextToken( CHAR *, SHORT );

   /* expression methods */ 
   DOUBLE ABS( DOUBLE );
   LONG   ASC( CHAR * );
   LONG   AT( CHAR *, CHAR * );
   CHAR * CDOW( CHAR * );
   CHAR * CHR( LONG );
   CHAR * CMONTH( CHAR * ); 
   LONG   DAY( CHAR * );
   LONG   DOW( CHAR * );
   CHAR * DTOC( CHAR * );
   DOUBLE EXP( DOUBLE );   
   LONG   INT( DOUBLE );
   LONG   ISALPHA( CHAR * );
   LONG   ISLOWER( CHAR * );
   LONG   ISUPPER( CHAR * );
   CHAR * LEFT( CHAR *, SHORT );
   LONG   LEN( CHAR * );
   DOUBLE LOG( DOUBLE );
   CHAR * LOWER( CHAR * );
   CHAR * LTRIM( CHAR * );
   DOUBLE MAX( DOUBLE, DOUBLE );
   LONG   MONTH( CHAR * );         /* MONTH() */
   DOUBLE MIN( DOUBLE, DOUBLE );
   CHAR * REPLICATE( CHAR *, SHORT );
   CHAR * RIGHT( CHAR *, SHORT );
   CHAR * RTRIM( CHAR * );
   CHAR * STR( CHAR * );
   CHAR * STR( DOUBLE );
   CHAR * SPACE( SHORT );   
   DOUBLE SQRT( DOUBLE );
   CHAR * TRIM( CHAR * );
   CHAR * UPPER( CHAR * );
   CHAR * SUBSTR( CHAR *, SHORT, SHORT );
   CHAR * DATE( VOID );
   LONG   VAL( CHAR * );
   LONG   YEAR( CHAR * );  

   /* next routines should ultimately be private */
   SHORT BuildExpressionTree( CHAR *, SHORT, DBF * );

   SHORT ProcessExpression( CHAR *, DBF * );
   SHORT ParseExpression( CHAR *, DBF * );
   EXPRESSION * GetExpressionHandle( VOID );
   CHAR   GetExpressionResultType( EXPRESSION * );
   CHAR * GetCharResult( VOID );
   DOUBLE GetDoubleResult( VOID );
   LONG  GetIntResult( VOID );
   SHORT ProcessExpression( ExpNode * );

#ifdef XBASE_DEBUG
   VOID DumpExpressionTree( ExpNode * );
   VOID DumpExpFreeChain( VOID );
   VOID DumpExpNode( ExpNode * );
#endif
};
#endif               // EXPRESSIONS
#endif               // FLAG_EXP
