/*  dbf.h

    Xbase project source code

    This file contains the Class definition for a DBF object.

    Copyright (C) 1997  StarTech, Gary A. Kunkel   
    email - xbase@startech.keller.tx.us
    www   - http://www.startech.keller.tx.us/xbase.html

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    V 1.0   10/10/97   - Initial release of software
    V 1.3   11/30/97   - Added memo field processing
    V 1.6a  4/1/98     - Added expression support
    V 1.6b  4/8/98     - Numeric index keys


///////////////////////////////////////////////////////////////////////////////
	   25/9/98 - Changes made by Stefan Holmberg for MentorSQL
	   THIS IS NOT OFFICIAL XBASE CHANGES!
	   - Added import/export for DLL
	   - Added GetFieldCount()
	   - Added GetSchemaPtr()

	   I know I might have subclasses and changed in those classes instead but
	   since I'm gonna change a lot more - like memory allocation schema and 
	   file I/O it wouldn't have helped me there...
///////////////////////////////////////////////////////////////////////////////
*/



//#ifdef XBASELIB_EXPORTS
//#define XBASELIB_API __declspec(dllexport)
//#else
//#define XBASELIB_API __declspec(dllimport)
//#endif

// But since I statically link all the files when doing this first betabetabeta release
// I just  undefines XBASELIB_EXPORTS
// You see I have created dll-s but not decided how to split functionality
// amongst general library and client library

#define XBASELIB_API 

#ifndef DBF_FLAG
#define DBF_FLAG

#include <iostream.h>
#include <stdio.h>
#include "xtypes.h"
#include "xdate.h"


#ifdef INDEX_NDX
   class NDX;
#endif

/*****************************/
/* Field Types               */

#define CHAR_FLD      'C'
#define LOGICAL_FLD   'L'
#define NUMERIC_FLD   'N'
#define DATE_FLD      'D'
#define MEMO_FLD      'M'
#define FLOAT_FLD     'F'

/*****************************/
/* File Status Codes         */

#define CLOSED  0
#define OPEN    1
#define UPDATED 2

/*****************************/
/* Other defines             */

#define OVERLAY     1    
#define DONTOVERLAY 0

/* This structure is used for defining a database */
struct XBASELIB_API Schema{
   CHAR  FieldName[11];
   CHAR  Type;
   CHAR  FieldLen;
   CHAR  NoOfDecs;
};

/* This structure defines field data as defined in an Xbase file header */
struct XBASELIB_API SchemaRec {
   CHAR  FieldName[11];
   CHAR  Type;
   CHAR  *Address;
   CHAR  FieldLen;
   CHAR  NoOfDecs;
   CHAR  *Address2;
};

struct IxList {
   IxList * NextIx;
   CHAR   * IxName; 
#ifdef INDEX_NDX
   NDX    * ndx;
   SHORT  Unique;
   SHORT  KeyUpdated;
#endif
};

#ifdef MEMO_FIELDS
struct MH{                      /* memo header                    */
   LONG  NextBlock;             /* pointer to next block to write */
   CHAR  FileName[8];           /* name of dbt file               */
   CHAR  Version;              /* not sure                       */
   SHORT BlockSize;             /* memo file block size           */
};
#endif

class XBASELIB_API DBF {
   CHAR   *DatabaseName;
   SHORT  XFV;                  /* xBASE file version          */  
   SHORT  NoOfFields;
   CHAR   DbfStatus;            /* 0 = closed
                                   1 = open
                                   2 = updates pending         */
   FILE   *fp;                  /* file pointer                */
   SchemaRec *SchemaPtr;        /* Pointer to field data       */
   CHAR   *RecBuf;              /* Pointer to record buffer    */
   CHAR   *RecBuf2;             /* Pointer to original rec buf */

#ifdef MEMO_FIELDS
   FILE   *mfp;                 /* memo file pointer             */
   VOID   *mbb;                 /* memo block buffer             */
   MH     MemoHeader;           /* memo header structure         */

   SHORT  mfield1;              /* memo block field one FF       */
   SHORT  MStartPos;            /* memo start pos of data        */
   LONG   MFieldLen;            /* memo length of data           */
   LONG   NextFreeBlock;        /* next free block in free chain */
   LONG   FreeBlockCnt;         /* count of free blocks this set */

   LONG   MNextBlockNo;         /* free block chain              */
   LONG   MNoOfFreeBlocks;      /* free block chain              */

   LONG   CurMemoBlockNo;       /* Current block no loaded       */
#endif

/* Next seven variables are read directly off the database header */
/* Don't change the order of the following seven items            */
   CHAR   Version;
   CHAR   UpdateYY;
   CHAR   UpdateMM;
   CHAR   UpdateDD;
//   LONG   NoOfRecs;
//   SHORT  HeaderLen;
//   SHORT  RecordLen;

   ULONG  NoOfRecs;
   USHORT HeaderLen;
   USHORT RecordLen;

   IxList * MdxList;
   IxList * NdxList;
   IxList * FreeIxList;
   ULONG  CurRec;               /* Current record or zero   */
   SHORT  AutoLock;             /* Auto update option 0 = off  */

   SHORT   DeleteAll( SHORT );
   VOID    InitVars( VOID );
   SHORT   PackDatafiles( VOID );
   SHORT   ReadHeader( SHORT );
   SHORT   WriteHeader( SHORT );

#ifdef MEMO_FIELDS
   SHORT   AddMemoData( SHORT, LONG, CHAR * );
   SHORT   CreateMemoFile( VOID );
   SHORT   DeleteMemoField( SHORT );
   SHORT   GetDbtHeader( SHORT );
   SHORT   GetMemoBlockSize( VOID ) { return MemoHeader.BlockSize; }
   SHORT   OpenMemoFile( VOID );
   SHORT   PutMemoData( LONG, LONG, LONG, CHAR * );
   SHORT   ReadMemoBlock( LONG, SHORT );
   SHORT   SetMemoBlockSize( SHORT );
   SHORT   UpdateHeadNextNode( VOID );
   SHORT   WriteMemoBlock( LONG, SHORT );
#endif

public:
   DBF( XBASE * );
   XBASE  *xbase;               /* linkage to main base class */


   int GetFieldCount() { return NoOfFields; };
   SchemaRec *GetSchemaPtr() { return SchemaPtr; };


/* datafile methods */
#ifdef INDEX_NDX
   SHORT   AddNdxToIxList( NDX *, CHAR * );
   SHORT   RemoveNdxFromIxList( NDX * );
#endif
   SHORT   AppendRecord( VOID );
   SHORT   BlankRecord( VOID );
   LONG    CalcCheckSum( VOID );
   SHORT   CloseDatabase( VOID );
   SHORT   CopyDbfStructure( CHAR *, SHORT );
   SHORT   CreateDatabase( CHAR *, Schema *, SHORT );
   SHORT   DeleteAllRecords( VOID ) { return DeleteAll(0); }
   SHORT   DeleteRecord( VOID );
   SHORT   DumpHeader( SHORT );
   SHORT   DumpRecord( ULONG );
   LONG    FieldCount( VOID ) { return NoOfFields; }
   SHORT   GetDbfStatus( VOID ) { return DbfStatus; }
   SHORT   GetFirstRecord( VOID );
   SHORT   GetLastRecord( VOID );
   SHORT   GetNextRecord( VOID );
   SHORT   GetPrevRecord( VOID );
   LONG    GetCurRecNo( VOID ) { return CurRec; }
   SHORT   GetRecord( ULONG );
   CHAR *  GetRecordBuf( VOID ) { return RecBuf; }
   SHORT   GetRecordLen( VOID ) { return RecordLen; }
   SHORT   NameSuffixMissing( SHORT, CHAR * );
   LONG    NoOfRecords( VOID ) { return NoOfRecs; }
   SHORT   OpenDatabase( CHAR * );
   SHORT   PackDatabase( SHORT );
   SHORT   PutRecord( ULONG );
   SHORT   RebuildAllIndices( VOID );
   SHORT   RecordDeleted( VOID );
   VOID    ResetNoOfRecs( VOID ) { NoOfRecs = 0L; }
   SHORT   SetVersion( SHORT );
   SHORT   UndeleteAllRecords( VOID ) { return DeleteAll(1); }
   SHORT   UndeleteRecord( VOID );   
   SHORT   Zap( SHORT );

/* field methods */
   SHORT   GetField( SHORT, CHAR * );
   SHORT   GetField( SHORT, CHAR *, SHORT );
   SHORT   GetFieldDecimal( SHORT );
   SHORT   GetFieldLen( SHORT );
   CHAR *  GetFieldName( SHORT );
   SHORT   GetFieldNo( CHAR * );
   CHAR    GetFieldType( SHORT );
   SHORT   PutField( SHORT, CHAR * );
   SHORT   ValidLogicalData( CHAR * );
   SHORT   ValidNumericData( CHAR * );

   LONG    GetLongField( CHAR * );
   LONG    GetLongField( SHORT );
   SHORT   PutLongField( SHORT, LONG );
   SHORT   PutLongField( CHAR *, LONG );

   FLOAT  GetFloatField( CHAR * );
   FLOAT  GetFloatField( SHORT );
   SHORT   PutFloatField( CHAR *, FLOAT );
   SHORT   PutFloatField( SHORT, FLOAT );

   DOUBLE  GetDoubleField( CHAR * );
   DOUBLE  GetDoubleField( SHORT );
   SHORT   PutDoubleField( CHAR *, DOUBLE );
   SHORT   PutDoubleField( SHORT, DOUBLE );

#if defined (LOCKING_ON)
   SHORT   LockDatabase( SHORT, SHORT, ULONG );
   SHORT   ExclusiveLock( SHORT );
   SHORT   ExclusiveUnlock( VOID );
#else
   SHORT   LockDatabase( SHORT, SHORT, LONG ) { return NO_ERROR; }
   SHORT   ExclusiveLock( SHORT ) { return NO_ERROR; };
   SHORT   ExclusiveUnlock( VOID ) { return NO_ERROR; };
#endif 
 
   VOID    AutoLockOn( VOID )  { AutoLock = 1; }
   VOID    AutoLockOff( VOID ) { AutoLock = 0; }

#ifdef MEMO_FIELDS
   SHORT   GetMemoField( SHORT, LONG, CHAR *, SHORT );
   LONG    GetMemoFieldLen( SHORT );
   SHORT   UpdateMemoData( SHORT, LONG, CHAR *, SHORT );
   SHORT   MemoFieldExists( SHORT );
   SHORT   LockMemoFile( SHORT, SHORT );
   SHORT   MemoFieldsPresent( VOID );

#ifdef XBASE_DEBUG
   SHORT   DumpMemoFreeChain( VOID );
   VOID    DumpMemoHeader( VOID );
   VOID    DumpMemoBlock( VOID );
   LONG    DbfTell( VOID ) { return ftell( fp ); }
#endif
#endif


};
#endif		// DBF_FLAG

