#include <windows.h>
#include <io.h>
#include "systemcatalog.h"
#include "error.h"
#include "general.h"
#include "xbase.h"

#include "shalloc.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


CSystemCatalog::CSystemCatalog()
{
m_pSystemTables = NULL;
m_pSystemColumns = NULL;
m_pSystemIndexes = NULL;
m_pXBase = NULL;
}

CSystemCatalog::~CSystemCatalog()
{
if( m_pSystemTables )
	delete m_pSystemTables;
if ( m_pSystemColumns )
	delete m_pSystemColumns;
if ( m_pSystemIndexes )
	delete m_pSystemIndexes;
for ( CTableArray::iterator iter = m_TableArray.begin();
	iter != m_TableArray.end(); iter++ )
	{
	delete *iter;
	}
m_TableArray.empty();
delete m_pXBase;
}
					   
 

bool CSystemCatalog::Initialize()
{
m_strDataDirectory = "DataDirectory";

m_pXBase = new XBASE;

printf("Initializing system catalog...\n");
InitSystemTables(); //ppna och skapa eventuellt systemtabellerna
printf("done\n");

return true;
}

CColumnDesc *CSystemCatalog::AllocateSystemArray( const char *szTable, int &nCount )
{
CColumnDesc *pRet = NULL;
if ( !stricmp( szTable, "SYSTABLES" ) )
	{
	pRet = new CColumnDesc[2];
	pRet[0].m_DataType = MENTORSQL_DATATYPE_INT;
	pRet[0].m_FieldLen = 9;
	strcpy( pRet[0].m_szName ,"ST_ID" );
	pRet[1].m_DataType = MENTORSQL_DATATYPE_CHAR;
	pRet[1].m_FieldLen = 20;
	strcpy( pRet[1].m_szName , "ST_NAME");
	nCount = 2;
	}
if ( !stricmp( szTable, "SYSCOLUMNS" ) )
	{
	pRet = new CColumnDesc[5];
	pRet[0].m_DataType = MENTORSQL_DATATYPE_INT;
	pRet[0].m_FieldLen = 9;
	strcpy( pRet[0].m_szName , "SC_ID");
	pRet[1].m_DataType = MENTORSQL_DATATYPE_CHAR;
	pRet[1].m_FieldLen = 20;
	strcpy( pRet[1].m_szName , "SC_NAME");
	pRet[2].m_DataType = MENTORSQL_DATATYPE_INT;
	pRet[2].m_FieldLen = 9;
	strcpy( pRet[2].m_szName , "SC_ST_ID");
	pRet[3].m_DataType = MENTORSQL_DATATYPE_CHAR;
	pRet[3].m_FieldLen = 20;
	strcpy( pRet[3].m_szName , "SC_TYPE");
	pRet[4].m_DataType = MENTORSQL_DATATYPE_INT;
	pRet[4].m_FieldLen = 9;
	strcpy( pRet[4].m_szName , "SC_LEN");
	nCount = 5;
	}
if ( !stricmp( szTable, "SYSINDEXES" ) )
	{
	pRet = new CColumnDesc[4];
	pRet[0].m_DataType = MENTORSQL_DATATYPE_INT;
	pRet[0].m_FieldLen = 9;
	strcpy( pRet[0].m_szName , "SI_ID");
	pRet[1].m_DataType = MENTORSQL_DATATYPE_CHAR;
	pRet[1].m_FieldLen = 20;
	strcpy( pRet[1].m_szName , "SI_NAME");
	pRet[2].m_DataType = MENTORSQL_DATATYPE_INT;
	pRet[2].m_FieldLen = 9;
	strcpy( pRet[2].m_szName , "SI_ST_ID");
	pRet[3].m_DataType = MENTORSQL_DATATYPE_CHAR;
	pRet[3].m_FieldLen = 50;
	strcpy( pRet[3].m_szName, "SI_EXP");
	nCount = 4;
	}
return pRet;
}

bool CSystemCatalog::AddToSystemTables( const char *szName, long &lID )
{
long lLastID;

SHORT rc = m_pSystemTables->GetLastRecord();
if ( rc == NO_ERROR )
	lLastID = m_pSystemTables->GetLongField( (short)0 );
else
	lLastID = 0;

lLastID++;
m_pSystemTables->BlankRecord();
m_pSystemTables->PutLongField((short)0, lLastID );
m_pSystemTables->PutField( 1, (char *)szName );
rc = m_pSystemTables->AppendRecord();
m_pSystemTables->GetFirstRecord(); //Force a flush
lID = lLastID;
return true;
}

int CSystemCatalog::ConvertDataType( char *szBuf )
{
if ( !stricmp( szBuf, "CHAR" ) )
	return MENTORSQL_DATATYPE_CHAR;
if ( !stricmp( szBuf, "INTEGER" ) )
	return MENTORSQL_DATATYPE_INT;
if ( !stricmp( szBuf, "DOUBLE" ) )
	return MENTORSQL_DATATYPE_FLOAT;
return 0;
}

char *CSystemCatalog::GetDataType( char chDescInFile )
{
switch( chDescInFile )
	{
	case MENTORSQL_DATATYPE_CHAR:
		return "CHAR";
		break;
	case MENTORSQL_DATATYPE_INT:
		return "INTEGER";
		break;
	case MENTORSQL_DATATYPE_FLOAT:
		return "DOUBLE";
		break;
	}
return NULL;
}


bool CSystemCatalog::AddToSystemIndexes( long lTableID, const char *szIndexName, char *szExp, long &lID  )
{
int i = 0;
long lLastID;

m_pSystemIndexes->GetLastRecord();
lLastID = m_pSystemIndexes->GetLongField((short) 0 );

lLastID++;
m_pSystemIndexes->BlankRecord();
m_pSystemIndexes->PutLongField((short)0, lLastID );
m_pSystemIndexes->PutField( 1, ( char *)szIndexName );
m_pSystemIndexes->PutLongField(2, lTableID );
m_pSystemIndexes->PutField( 3, ( char *)szExp );

m_pSystemIndexes->AppendRecord();
m_pSystemIndexes->GetFirstRecord(); //Force a flush
lID = lLastID;
return true;
}


CColumnDesc *CSystemCatalog::GetColumnDesc( long lTabellID, int &nCount )
{
//Returns column descriptor accordning to syscolumns

CColumnDesc *pRet = NULL;
CColumnDesc *pCurr = NULL;
nCount = 0;
short rc = m_pSystemColumns->GetFirstRecord();
while ( rc == NO_ERROR )
	{
	if ( lTabellID == m_pSystemColumns->GetLongField( 2 ) )
		nCount++;
	rc = m_pSystemColumns->GetNextRecord();
	}
if ( !nCount )
	return NULL;

pRet = new CColumnDesc[ nCount ];
pCurr = pRet;
rc = m_pSystemColumns->GetFirstRecord();
while ( rc == NO_ERROR )
	{
	//
	char buf[51];
	memset( buf, 0, sizeof(buf));
	if ( m_pSystemColumns->GetLongField( 2 ) == lTabellID )
		{
		m_pSystemColumns->GetField( 1, buf );
		SpaceTruncate( buf );
		strcpy( pCurr->m_szName, buf );
		pCurr->m_FieldLen = m_pSystemColumns->GetLongField( 4 );

		memset( buf, 0, sizeof(buf));
		m_pSystemColumns->GetField( 3, buf );
		SpaceTruncate( buf );
		pCurr->m_DataType = (MENTORSQL_DATATYPES)ConvertDataType( buf );
		pCurr++;
		}
	rc = m_pSystemColumns->GetNextRecord();
	}
return pRet;
}


bool CSystemCatalog::AddToSystemColumns( long lTabellID, CColumnDesc *pSchema, int nCount )
{
for ( int i = 0; i < nCount; i++ )
	{
	long lLastID;

	m_pSystemColumns->GetLastRecord();
	lLastID = m_pSystemColumns->GetLongField((short) 0 );

	lLastID++;
	m_pSystemColumns->BlankRecord();
	m_pSystemColumns->PutLongField((short)0, lLastID );
	m_pSystemColumns->PutField( 1, pSchema->m_szName );
	m_pSystemColumns->PutLongField(2, lTabellID );
	m_pSystemColumns->PutField( 3, GetDataType(pSchema->m_DataType) );
	m_pSystemColumns->PutLongField( 4, pSchema->m_FieldLen );

	m_pSystemColumns->AppendRecord();
	pSchema++;
	}
m_pSystemColumns->GetFirstRecord(); //Force a flush
return true;
}

bool CSystemCatalog::DeleteFromSystemIndexes( long lTableId, const char *szIndexName )
{
SHORT rc = m_pSystemIndexes->GetFirstRecord();
while( rc == NO_ERROR )
	{
	char buf[51];
	memset( buf, 0, sizeof(buf));
	if ( lTableId == m_pSystemIndexes->GetLongField(2) )
		{
		bool fDelete = true;
		if ( szIndexName )
			{
			m_pSystemIndexes->GetField( 1, buf );
			SpaceTruncate( buf );
			if ( stricmp( buf, szIndexName ) )
				fDelete = false;
			}
		
		if ( fDelete )
			m_pSystemIndexes->DeleteRecord();
		}
	rc = m_pSystemIndexes->GetNextRecord();
	}
return true;
}


bool CSystemCatalog::DeleteFromSystemColumns( long lTabellID )
{
SHORT rc = m_pSystemColumns->GetFirstRecord();
while( rc == NO_ERROR )
	{
	if ( lTabellID == m_pSystemColumns->GetLongField(2) )
		m_pSystemColumns->DeleteRecord();
	rc = m_pSystemColumns->GetNextRecord();
	}
return true;
}

bool CSystemCatalog::DeleteFromSystemTables( const char *szTableName, long &lTabellId )
{
SHORT rc = m_pSystemTables->GetFirstRecord();
while( rc == NO_ERROR )
	{
	char buf[21];
	memset( buf, 0, sizeof(buf) );
    m_pSystemTables->GetField( 1, buf );
	SpaceTruncate( buf );

	if ( !stricmp( buf, szTableName ) )
		{
		lTabellId = m_pSystemTables->GetLongField((short)0);
		m_pSystemTables->DeleteRecord();
		return true;
		}
	rc = m_pSystemTables->GetNextRecord();
	}
return false;
}


bool CSystemCatalog::InitSystemTables()
{
SHORT rc;
CColumnDesc *pColumnDescSysTables = NULL;
int nSysTablesCount;
CColumnDesc *pColumnDescSysColumns = NULL;
int nSysColumnsCount;
CColumnDesc *pColumnDescSysIndexes = NULL;
int nSysIndexesCount;
long lSystemTableId;
bool fCreated;

fCreated = false;
if ( !m_pSystemTables )
	{
	m_pSystemTables = new CTable(this, "SYSTABLES" , m_strDataDirectory.c_str());
	m_pSystemTables->m_lTableId = 1;
	pColumnDescSysTables = AllocateSystemArray( "SYSTABLES", nSysTablesCount );
	rc = m_pSystemTables->Open( pColumnDescSysTables, nSysTablesCount  );
	if ( rc != NO_ERROR )
		{
		printf("No system catalog present. Running bootstrap code...\n");
		rc = m_pSystemTables->Create( pColumnDescSysTables, nSysTablesCount );
		if ( rc != NO_ERROR )
			return false;
		fCreated = true;
		}
	}

if ( !m_pSystemColumns )
	{
	m_pSystemColumns = new CTable(this, "SYSCOLUMNS" , m_strDataDirectory.c_str());
	m_pSystemColumns->m_lTableId = 2;
	pColumnDescSysColumns = AllocateSystemArray( "SYSCOLUMNS", nSysColumnsCount );
	rc = m_pSystemColumns->Open( pColumnDescSysColumns, nSysColumnsCount );
	if ( rc != NO_ERROR )
		{
		rc = m_pSystemColumns->Create( pColumnDescSysColumns, nSysColumnsCount );
		if ( rc != NO_ERROR )
			return false;
		}
	}
if ( !m_pSystemIndexes )
	{
	m_pSystemIndexes = new CTable(this, "SYSINDEXES" , m_strDataDirectory.c_str());
	m_pSystemIndexes->m_lTableId = 3;
	pColumnDescSysIndexes = AllocateSystemArray( "SYSINDEXES", nSysIndexesCount );
	rc = m_pSystemIndexes->Open( pColumnDescSysIndexes ,nSysIndexesCount );
	if ( rc != NO_ERROR )
		{
		rc = m_pSystemIndexes->Create( pColumnDescSysIndexes, nSysIndexesCount );
		}
	}

if ( fCreated )
	{
	AddToSystemTables( "SYSTABLES", lSystemTableId );
	m_pSystemTables->m_lTableId = lSystemTableId;
	AddToSystemColumns( lSystemTableId, pColumnDescSysTables, nSysTablesCount );
	AddToSystemTables( "SYSCOLUMNS", lSystemTableId );
	m_pSystemColumns->m_lTableId = lSystemTableId;
	AddToSystemColumns( lSystemTableId, pColumnDescSysColumns, nSysColumnsCount );
	AddToSystemTables( "SYSINDEXES", lSystemTableId );
	m_pSystemIndexes->m_lTableId = lSystemTableId;
	AddToSystemColumns( lSystemTableId, pColumnDescSysIndexes, nSysIndexesCount );
	printf("done\n");
	}

if ( pColumnDescSysTables )
	delete []pColumnDescSysTables;
if ( pColumnDescSysColumns )
	delete []pColumnDescSysColumns;
if ( pColumnDescSysIndexes )
	delete []pColumnDescSysIndexes;
ReadSystemTables();

return true;
};

int CSystemCatalog::OpenTable( CTable *pTable )
{
int nCount;
CColumnDesc *pColDesc = GetColumnDesc( pTable->m_lTableId, nCount );
if ( !pColDesc )
	return ERROR_NUM_SELECTNOTABLE;
int nRet = pTable->Open( pColDesc, nCount );
if ( nRet )
	{
	delete []pColDesc;
	return nRet;
	}
//Fix all indexes too...
SHORT rc = m_pSystemIndexes->GetFirstRecord();
while( rc == NO_ERROR )
	{
	char buf[51];
	memset( buf, 0, sizeof(buf));
	if ( pTable->m_lTableId == m_pSystemIndexes->GetLongField(2) )
		{
		m_pSystemIndexes->GetField( 1, buf );
		SpaceTruncate( buf );
		pTable->OpenIndex( buf );
		}
	rc = m_pSystemIndexes->GetNextRecord();
	}
delete []pColDesc;
return true;
}

void CSystemCatalog::ReadSystemTables()
{
for ( CTableArray::iterator iter = m_TableArray.begin();
	iter != m_TableArray.end(); iter++ )
	{
	delete *iter;
	}
m_TableArray.clear();

SHORT rc = m_pSystemTables->GetFirstRecord();
while( rc == NO_ERROR )
	{
	char buf[20];
    m_pSystemTables->GetField( 1, buf );
	SpaceTruncate( buf );

	if ( !stricmp( "SYSTABLES", buf ) )
		{
		rc = m_pSystemTables->GetNextRecord();
		continue;
		}
	if ( !stricmp( "SYSCOLUMNS", buf ) )
		{
		rc = m_pSystemTables->GetNextRecord();
		continue;
		}
	if ( !stricmp( "SYSINDEXES", buf ) )
		{
		rc = m_pSystemTables->GetNextRecord();
		continue;
		}

	long lID = m_pSystemTables->GetLongField( (short)0 );
	std::string strTable = buf;
	CTable *pTable = new CTable( 
						this, 
						(const char *)strTable.c_str(), 
						m_strDataDirectory.c_str());
	pTable->m_lTableId = lID;
	OpenTable( pTable );
	m_TableArray.push_back( pTable );
	rc = m_pSystemTables->GetNextRecord();
	}
}


CTable *CSystemCatalog::GetTable( const char *szName )
{
if ( !stricmp( szName, "SYSCOLUMNS" ) )
	return m_pSystemColumns;
if ( !stricmp( szName, "SYSTABLES" ) )
	return m_pSystemTables;
if ( !stricmp( szName, "SYSINDEXES" ) )
	return m_pSystemIndexes;


for ( CTableArray::iterator iter = m_TableArray.begin();
	iter != m_TableArray.end(); iter++ )
	{
	CTable *pTable = *iter;
	if ( !stricmp(pTable->GetName().c_str(),szName ) )
		return *iter;
	}
return NULL;
}

int CSystemCatalog::DropTable( const char *szName )
{
if ( !stricmp( szName, "SYSCOLUMNS" ) )
	return ERROR_NUM_INVALIDTABLE;
if ( !stricmp( szName, "SYSTABLES" ) )
	return ERROR_NUM_INVALIDTABLE;
if ( !stricmp( szName, "SYSINDEXES" ) )
	return ERROR_NUM_INVALIDTABLE;

CTable *pTable = GetTable( szName );
if ( !pTable )
	return ERROR_NUM_INVALIDTABLE;
//
long lTabellID;
DeleteFromSystemTables( szName, lTabellID );
DeleteFromSystemColumns( lTabellID );
DeleteFromSystemIndexes( lTabellID );
pTable->Drop();

//Delete the table from the array
for ( int i = 0; i < m_TableArray.size(); i++ )
	{
	CTable *pTableTemp = m_TableArray.at(i);
	if ( pTableTemp->m_lTableId == pTable->m_lTableId )
		{
		m_TableArray.erase(m_TableArray.begin() + i );
		delete pTable;
		break;			  
		}
	}
//this->ReadSystemTables();
return 0;
}

int CSystemCatalog::CreateIndex( const char *szTable, const char *szIndex, const char *szExp )
{
if ( !stricmp( szTable, "SYSCOLUMNS" ) )
	return ERROR_NUM_INVALIDTABLE;
if ( !stricmp( szTable, "SYSTABLES" ) )
	return ERROR_NUM_INVALIDTABLE;

//1. Check if table exists
//1. Check if table exists
CTable *pTable = GetTable( szTable );
if ( !pTable )
	return ERROR_NUM_INVALIDTABLE;

//2. Check if index already exists
if ( pTable->GetIndex( szIndex ) )
	return ERROR_NUM_INDEXALREADYEXISTS;
	
//3. If not - create it!
long lIndexID;
if ( pTable->CreateIndex( szIndex, szExp, false ) == ERROR_NUM_OK )
	AddToSystemIndexes( pTable->m_lTableId, ( char *)szIndex, ( char *)szExp, lIndexID );
return 0;
}

int CSystemCatalog::DropIndex( const char *szIndex )
{
//Get table name for this index
//
CTable *pTable;
CIndex *pIndex = NULL;
for ( int i = 0; i < m_TableArray.size(); i++ )
	{
	pTable = m_TableArray.at(i);
	pIndex = pTable->GetIndex( szIndex );
	if ( pIndex )
		break;
	}
if ( !pIndex )
	return ERROR_NUM_INVALIDINDEX;

//Drop it!
long lTabellID;
DeleteFromSystemTables( szIndex, lTabellID );
DeleteFromSystemColumns( lTabellID );
DeleteFromSystemIndexes( lTabellID, szIndex );
pTable->DropIndex( (char *)szIndex );
//pIndex->Drop();
//this->ReadSystemTables();
return 0;
}


int CSystemCatalog::CreateTable( const char *szName, CColumnDesc *pSchema, int nCount )
{
CTable *pTable = new CTable( this, szName , m_strDataDirectory.c_str());
//Finns den redan?
int nRet = pTable->Open( pSchema, nCount );
if ( nRet == NO_ERROR ) 
	return ERROR_NUM_TABLE_EXISTS;

	
SHORT rc = pTable->Create( pSchema, nCount );
if ( rc != NO_ERROR )
	{
	delete pTable;
	return rc;
	}
long lSystemTableId;
AddToSystemTables( szName, lSystemTableId );
pTable->m_lTableId = lSystemTableId;
AddToSystemColumns( lSystemTableId, pSchema, nCount );

delete pTable; //Causes an OK flush..
pTable = new CTable( this, szName , m_strDataDirectory.c_str());
pTable->m_lTableId = lSystemTableId;
//Finns den redan?
pTable->Open( pSchema, nCount );

m_TableArray.push_back( pTable );
return 0;
}




