#include "FlexLexer.h"
#include "executer.h"
#include "error.h"
#include "systemcatalog.h"
#include "server.h"
#include "general.h"

bool ExistsInSchema( CColumnDesc *pSchema, int nTemp,  const char *szNewColName )
{
//Easy check - just loop and see if it already exists
for ( int nCount = 0; nCount < nTemp; nCount++ )
	{
	if ( !stricmp(pSchema[nCount].m_szName, szNewColName ) )
		return true;
	}
return false;
}

void RecursiveAddColDesc( CTable *pTable, CSQLNode *pNode, CTempTable *pSet, int &nTemp, CColumnDesc *pSchema  )
{
if ( pNode == NULL )
	return;
switch( pNode->m_nType )
	{
	case NodeType_Equals:
	case NodeType_More:
	case NodeType_Less:
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
	case NodeType_And:
	case NodeType_Or: //We should perform check on all childs
		{
		RecursiveAddColDesc( pTable, pNode->m_pLeftChild, pSet, nTemp, pSchema ); 
		RecursiveAddColDesc( pTable, pNode->m_pRightChild, pSet, nTemp, pSchema  );
		break;
		}
	case NodeType_Dot:
		{
		if ( pNode->m_pLeftChild->m_pSQLToken->m_strText.c_str()  == pTable->GetName() )
			{
			CColumnDesc *pColumnDesc = pTable->GetColumnInfo( pNode->m_pRightChild->m_pSQLToken->m_strText.c_str() );
			std::string strQualifiedName = pTable->GetName() + "." + pColumnDesc->m_szName;

			if ( ExistsInSchema( pSchema, nTemp,  strQualifiedName.c_str()  ) )
				break;
				

			pSet->m_ColStrings.push_back( pNode->m_pRightChild->m_pSQLToken->m_strText );
			pSchema[nTemp].m_FieldLen = pColumnDesc->m_FieldLen;
			strcpy(pSchema[nTemp].m_szName ,strQualifiedName.c_str() );
			pSchema[nTemp].m_DataType = pColumnDesc->m_DataType;
			nTemp++;
			}
		break;
		}
	}
}


int _RecursiveCount( CSQLNode *pNode, CTable *pTable )
{
int nRet = 0;
if ( pNode == NULL )
	return 0;
switch( pNode->m_nType )
	{
	case NodeType_Equals:
	case NodeType_More:
	case NodeType_Less:
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
	case NodeType_And:
	case NodeType_Or: //We should perform check on all childs
		{
		nRet += _RecursiveCount( pNode->m_pLeftChild, pTable ); 
		nRet += _RecursiveCount( pNode->m_pRightChild, pTable );
		return nRet;
		}
	case NodeType_Dot:
		{
		if ( pNode->m_pLeftChild->m_pSQLToken->m_strText.c_str() == pTable->GetName() )
			nRet++;
		}
	}
return nRet;
}


//Build a new column definition after joins is done
bool BuildFinalColumns( CTempTable *pTempSetTo, CTempTable *pTempSetFrom, CSQLNode *pSelectClause, CSQLNode *pFromClause, CSQLNode *pWhereClause )
{
//1. Count all columns that should be involved
int nColCount = 0;
CSQLNode *pNode = pSelectClause;
while ( pNode )
	{
	nColCount++;
	pNode = pNode->m_pNext;
	}

//Create an structure for it
CColumnDesc *pSchema = new CColumnDesc[ nColCount ];
int nTemp = 0;

CSQLNode *pColNode = pSelectClause;
//For columnnames leftchild is table and rightchild is column
while ( pColNode )
	{
	std::string strQualifiedName = pColNode->m_pLeftChild->m_pSQLToken->m_strText +  "." + pColNode->m_pRightChild->m_pSQLToken->m_strText;
	CColumnDesc *pColumnDesc = pTempSetFrom->GetColumnInfo( strQualifiedName.c_str() );

	memcpy( &pSchema[nTemp], pColumnDesc, sizeof(CColumnDesc) );
	nTemp++;
	pColNode = pColNode->m_pNext;
	}

pTempSetTo->Create( pSchema, nTemp );
delete []pSchema;
return true;
}
  

//Builds up column definition for a search in pTable 
// IMPORTANT: All columns nedd to be already fully qualified!!!

bool BuildColumns( CTempTable *pSet, CTable *pTable, CSQLNode *pSelectClause, CSQLNode *pFromClause, CSQLNode *pWhereClause, bool fJoin )
{
//1. Count all columns that should be involved
int nColCount = 0;
CSQLNode *pNode = pSelectClause;
while ( pNode )
	{
	if ( pNode->m_pLeftChild->m_pSQLToken->m_strText.c_str() == pTable->GetName() )
		nColCount++;
	pNode = pNode->m_pNext;
	}

//Fix for joins: If we are joining then we need to select all the tables columns in the pWhereClause as well
//so we can make the join later...
if ( fJoin && pFromClause->m_pNext ) //As I said only if we are joining...
	nColCount += _RecursiveCount( pWhereClause->m_pLeftChild, pTable );
//Maybe we get to many here, but that doesn't matter, as we check for real count later



//Create an structure for it
CColumnDesc *pSchema = new CColumnDesc[ nColCount ];
int nTemp = 0;

CSQLNode *pColNode = pSelectClause;
//For columnnames leftchild is table and rightchild is column
while ( pColNode )
	{
	CTable *pTempTable = GetServer()->GetSystemCatalog()->GetTable( pColNode->m_pLeftChild->m_pSQLToken->m_strText.c_str() );

	if ( !pTempTable->GetName().compare(pTable->GetName()) )
		{

		CColumnDesc *pColumnDesc = pTempTable->GetColumnInfo( pColNode->m_pRightChild->m_pSQLToken->m_strText.c_str() );

		std::string strQualifiedName = pTempTable->GetName() + "." + pColumnDesc->m_szName;
		pSchema[nTemp].m_FieldLen = pColumnDesc->m_FieldLen;
		strcpy(pSchema[nTemp].m_szName ,strQualifiedName.c_str() );
		pSchema[nTemp].m_DataType = pColumnDesc->m_DataType;
//		pTempTable->m_pRightChild->m_pSQLToken->m_strText.c_str()
		nTemp++;
		}
	pColNode = pColNode->m_pNext;
	}

//That was the easy part, now we need to create for all joins and wheres etc
if ( fJoin && pFromClause->m_pNext ) //As I said only if we are joining...
	RecursiveAddColDesc( pTable, pWhereClause->m_pLeftChild, pSet, nTemp, pSchema  );

pSet->Create( pSchema, nTemp );
delete []pSchema;
return true;
}


bool GetValueInJoin( CSQLNode *pNode, CBaseTable *pTable, std::string &strRet, MENTORSQL_DATATYPES &dt1 )
{
if ( pNode->m_nType == NodeType_Dot ) 
	{
	std::string strColName = pNode->m_pRightChild->m_pSQLToken->m_strText.c_str();
	std::string strTableName = pNode->m_pLeftChild->m_pSQLToken->m_strText.c_str();
	std::string strQualifiedName;

	
	if ( pTable->FullyQualifiedNames() )
		strQualifiedName = strTableName + "." + strColName;
	else
		{
		if ( strTableName.compare( pTable->GetName() )	)
			return false;
		strQualifiedName = strColName;
		}


	//Check if it is there
	char szBuf[512];
	memset( szBuf, 0, sizeof(szBuf) );

	int nIndex = pTable->GetFieldNo(strQualifiedName.c_str());
	if ( nIndex == -1 )
		return false;
	dt1 = (MENTORSQL_DATATYPES)pTable->GetFieldType( nIndex );
	if ( pTable->GetFieldAsBuf( nIndex, szBuf ) == ERROR_NUM_OK )
		{
		strRet = szBuf;
		return true;
		}
	return false; //Not available
	}
//Just a value from user
switch(pNode->m_nType )
	{
	case NodeType_String_Value:
		dt1 = MENTORSQL_DATATYPE_CHAR;
		break;
	case NodeType_Integer_Value:
		dt1 = MENTORSQL_DATATYPE_INT;
		break;
	case NodeType_Float_Value:
		dt1 = MENTORSQL_DATATYPE_FLOAT;
		break;
	} 
strRet = pNode->m_pSQLToken->m_strText;
return true;
}

//For each condition
//: Get the value : is is either direct or from a table

bool _RecursiveApply2( CSQLNode *pNode, CBaseTable *pTable )
{
if ( pNode == NULL )
	return 0;
switch( pNode->m_nType )
	{
	case NodeType_MoreEquals:
	case NodeType_LessEquals:
	case NodeType_More:
	case NodeType_Less:
	case NodeType_Equals:
		{
//		if ( pNode->m_pLeftChild->m_pSQLToken->m_strText.compare( pTable->GetName() ) )
//			return true;
		std::string str1, str2;
		MENTORSQL_DATATYPES dt1, dt2;
		if ( !GetValueInJoin( pNode->m_pLeftChild, pTable, str1, dt1 ))
			return true;
		if ( !GetValueInJoin( pNode->m_pRightChild, pTable, str2, dt2 ))
			return true;

		int nEq;
		nEq = GeneralCompare( str1.c_str(), dt1, str2.c_str(), dt2 );
		if ( pNode->m_nType == NodeType_MoreEquals )
			return nEq >= 0;
		if ( pNode->m_nType == NodeType_LessEquals )
			return nEq <= 0;
		if ( pNode->m_nType == NodeType_More )
			return nEq > 0;
		if ( pNode->m_nType == NodeType_Less )
			return nEq > 0;
		if ( pNode->m_nType == NodeType_Equals )
			return nEq == 0;

		}
	case NodeType_And:
		{
		//Both should be applied...
		return _RecursiveApply2( pNode->m_pLeftChild, pTable ) && 
			_RecursiveApply2( pNode->m_pRightChild, pTable );
		}
	case NodeType_Or:
		{
		//Both should be applied...
		return _RecursiveApply2( pNode->m_pLeftChild, pTable ) || 
			_RecursiveApply2( pNode->m_pRightChild, pTable );
		}
	}
return false;
}




bool _ApplyWhereClause( CSQLNode *pWhereClause, CBaseTable *pTable )
{
bool bRet = true;
if ( !pWhereClause || pWhereClause->m_nType == NodeType_Empty )
	return true;

pWhereClause = pWhereClause->m_pLeftChild;
//Apply where clause for this SINGLE table. Another routines handles many table clauses
return _RecursiveApply2( pWhereClause, pTable);
}

//Class for iterating a table
class CScanIterator2 : public CTableIterator
{
public:
	CScanIterator2( CBaseTable *pTable, CSQLNode *pWhereClause, CExecuter *pExecuter )
		: CTableIterator( pTable, pWhereClause, pExecuter )
		{
		}

	bool ApplyWhereClause()
		{
		if ( _ApplyWhereClause( m_pWhereClause, m_pTable ) )
			{
			m_nApplyCount++;
			return true;
			}
		return false;
		}
	short GetNextRecord()	
		{
		short rc;
		if ( !m_nCurRecInTable )
			{
			m_nCurRecInTable = 1;
			rc = m_pTable->GetFirstRecord();
			if ( rc != ERROR_NUM_OK )
				return rc;
			if ( ApplyWhereClause() == true )
				return ERROR_NUM_OK;
			}
		rc = m_pTable->GetNextRecord();
		if ( rc != ERROR_NUM_OK )
			return rc;

		while ( ApplyWhereClause() == false )
			{
			m_nCurRecInTable++;
			rc = m_pTable->GetNextRecord();
			if ( rc != ERROR_NUM_OK )
				return rc;
			}
		return ERROR_NUM_OK;
		}
};

bool _DoSearch(CBaseTable *pTable, CSQLNode *pSelectClause, CSQLNode *pFromClause, CSQLNode *pWhereClause, CTempTable &Set, CExecuter *pExecuter, const char *szSortCol, bool fQualified);


CTempTable *_DoJoinSearchInTable(CTempTable &t2, CTable *pTable, CSQLNode *pSelectClause, CSQLNode *pFromClause, CSQLNode *pWhereClause, CTempTable &Set, CExecuter *pExecuter, const char *szSortCol)
{

_DoSearch( pTable, pSelectClause, pFromClause, pWhereClause, t2, pExecuter, szSortCol, false );

//Now we got two sets...
//Lets join them together
int nColCount = t2.GetFieldCount() + Set.GetFieldCount();
CColumnDesc *pSchema = new CColumnDesc[ nColCount ];
memcpy( pSchema, Set.GetColumnDesc(), Set.GetFieldCount() * sizeof( CColumnDesc ) );
memcpy( &pSchema[Set.GetFieldCount()], t2.GetColumnDesc(), t2.GetFieldCount() * sizeof( CColumnDesc ) );

//Lets create a new one...
CTempTable *pNew = new CTempTable;
pNew->Create( pSchema, nColCount );

//We now all records are pretty good so we can just iterate right away

//char *szBuf = new char[ pNew->Get ];

short rc = Set.GetFirstRecord();
int nSum = 0;

pNew->BlankRecord();
pNew->AppendRecord();//Always an empty record at the end...We deletes this after were done...
pNew->GetLastRecord();
while ( rc == ERROR_NUM_OK )
	{
	//Seems like a good idea to use XBase:s fieldhandling routines...Therefore we 'fake' a new record
	pNew->BlankRecord();

	rc = t2.GetFirstRecord();
	while ( rc == ERROR_NUM_OK )
		{
		//Throw it into the new table buffer
		//First from Set-table
		for ( int nIndex = 0; nIndex < Set.GetFieldCount(); nIndex++ )
			{
			CColumnDesc *pSchemaRec = Set.GetColumnInfo( nIndex );

			switch( pSchemaRec->m_DataType )
				{
				case MENTORSQL_DATATYPE_CHAR:
					{
					char buf[512];
					memset( buf, 0, sizeof(buf));
					Set.GetField(nIndex, buf );
					SpaceTruncate( buf );
					if ( !stricmp(buf, "S4" ) )
						{
						int j;
						j = 0;
						}

					pNew->PutField( nIndex, buf );
					}
					break;
				case MENTORSQL_DATATYPE_INT:
					long lTemp;
					lTemp = Set.GetLongField( nIndex );
					pNew->PutLongField( nIndex, lTemp );
					break;
				case MENTORSQL_DATATYPE_FLOAT:
					double dTemp;
					dTemp = Set.GetDoubleField( nIndex );
					pNew->PutDoubleField( nIndex, dTemp );
					break;
				}
			}
		//Then from second table...
		for ( nIndex = 0; nIndex < t2.GetFieldCount(); nIndex++ )
			{
			CColumnDesc *pSchemaRec = t2.GetColumnInfo( nIndex );

			switch( pSchemaRec->m_DataType )
				{
				case MENTORSQL_DATATYPE_CHAR:
					{
					char buf[512];
					memset( buf, 0, sizeof(buf));
					t2.GetField(nIndex, buf );
					SpaceTruncate( buf );
					pNew->PutField( nIndex + Set.GetFieldCount(), buf );
					}
					break;
				case MENTORSQL_DATATYPE_INT:
					long lTemp;
					lTemp = t2.GetLongField( nIndex );
					pNew->PutLongField( nIndex + Set.GetFieldCount(), lTemp );
					break;
				case MENTORSQL_DATATYPE_FLOAT:
					double dTemp;
					dTemp = t2.GetDoubleField( nIndex );
					pNew->PutDoubleField( nIndex + Set.GetFieldCount(), dTemp );
					break;
				}
			}
		//Now all fields are in the buffer - so lets try and see if join condition are OK?

		//We join all - then deletes not wanted records?
		if ( _RecursiveApply2(pWhereClause->m_pLeftChild, pNew ) == true )
			{
			char szBuf[512];
			pNew->GetField( 0, szBuf );			
			pNew->GetField( 1, szBuf );			
			pNew->GetField( 2, szBuf );			
			pNew->GetField( 3, szBuf );			
			if ( pNew->GetFieldCount() == 6 )
				{
				pNew->GetField( 4, szBuf );			
				pNew->GetField( 5, szBuf );			
				}
			pNew->PutRecord(pNew->GetCurRecNo());
			pNew->GetLastRecord();
			pNew->AppendRecord();
			pNew->BlankRecord();
//			pNew->PutRecord( pNew->GetCurRecNo() );

			//pNew->UpdateRecord();
			//pNew->GetFirstRecord();
			nSum++;
			}
		else
			{
			pNew->BlankRecord();
			}
		rc = t2.GetNextRecord();
		}
	rc = Set.GetNextRecord();
	}
//pNew->GetFirstRecord();
printf("Joined : now its %d rows\n", nSum );
pNew->GetLastRecord();
pNew->DeleteRecord();

return pNew;

}

bool _DoSearch(CBaseTable *pTable, CSQLNode *pSelectClause, CSQLNode *pFromClause, CSQLNode *pWhereClause, CTempTable &Set, CExecuter *pExecuter, const char *szSortCol, bool fQualified )
{
int nColCount = Set.GetFieldCount();
CScanIterator2 ScanIterator( pTable, pWhereClause, pExecuter );
while ( ScanIterator.GetNextRecord() == ERROR_NUM_OK )
	{
	bool fAdd = true;
	
	Set.GetFirstRecord();
	Set.BlankRecord();
	for ( int n = 0; n < nColCount; n++ )
		{
		//Whats the name of the column
		char *szName = Set.GetFieldName(n);
		const char *szHej = strchr( szName, '.' );
		szHej++;
		if ( fQualified )
			szHej = szName;
		//And in the actual table thats

		int nIndex = pTable->GetFieldNo( szHej  );
		szName = pTable->GetFieldName( nIndex) ;
		switch( pTable->GetFieldType(nIndex) )
			{
			case MENTORSQL_DATATYPE_CHAR:
				{
				char buf[512];
				memset( buf, 0, sizeof(buf));
				pTable->GetField(nIndex, buf );
				SpaceTruncate( buf );
				Set.PutField( n, buf );
				}
				break;
			case MENTORSQL_DATATYPE_INT:
				{
				long lTemp;
				lTemp = pTable->GetLongField( nIndex );
				Set.PutLongField( n, lTemp );
				}
				break;
			case MENTORSQL_DATATYPE_FLOAT:
				double dTemp;
				dTemp = pTable->GetDoubleField( nIndex );
				Set.PutDoubleField( n, dTemp );
				break;
			}
		if ( !fAdd )
			break;
		}
	if ( fAdd )
		Set.AppendRecord();
	}
pTable->GetFirstRecord(); //Flush the table...
printf( "Selected count %d", ScanIterator.GetApplyCount() );

cout << endl;
return true;
}









