/*  Product: Mentor SQL

    Copyright (C) 1998  Systementor AB, Stefan Holmberg
    Email - stefan.holmberg@systementor.se
    Web:   - http://www.systementor.se

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
*/
#include <windows.h>
#include <crtdbg.h>
#include "FlexLexer.h"
#include "executer.h"
#include "ParseTree.h"
#include "server.h"
#include "CommClient.h"
#include "general.h"
#include "shalloc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


void CParseTree::AddList( const char *szName, CSQLNode *pPtr )
{
CPointerName *pName = new CPointerName;
pName->m_pNode = pPtr;
pName->m_strName = szName;
m_PointerArray.push_back( pName );
}


void CParseTree::ClearAll()
{
ClearTokenArray();
m_pFirst = NULL;
}

void CParseTree::ClearTokenArray()
{
for ( CSQLTokenArray::iterator iter = m_TokenArray.begin();
			iter != m_TokenArray.end(); iter++ )
			delete *iter;
for ( CSQLNodeArray::iterator iter2 = m_NodeArray.begin();
			iter2 != m_NodeArray.end(); iter2++ )
			delete *iter2;
for ( CPointerNameArray::iterator iter3 = m_PointerArray.begin(); iter3 != m_PointerArray.end(); iter3++ )
	delete *iter3;

m_TokenArray.clear();
m_PointerArray.clear();
m_NodeArray.clear();
}

CSQLNode *CParseTree::ManuallyAddIdentifier( const char *szTokenText, const char *szNodeText )
{
m_pCurrentToken = new CSQLToken( 0, (char*)szTokenText ) ;
m_TokenArray.push_back( m_pCurrentToken );
return MakeNode( NodeType_Identifier, (char *)szNodeText );
}


CSQLNode *CParseTree::ManuallyAddDot( const char *szTableName, const char *szColName )
{
CSQLNode *pNode = MakeNode( NodeType_Dot, ( char *)szColName );
pNode->m_pLeftChild = ManuallyAddIdentifier( szTableName, "Id" );
pNode->m_pRightChild = ManuallyAddIdentifier( szColName, "Id" );
return pNode;
}


void CParseTree::AddToken( int nType, const char *strText )
{
m_pCurrentToken = new CSQLToken( nType, (char*)strText ) ;
m_TokenArray.push_back( m_pCurrentToken );
}


CParseTree::~CParseTree()
{
ClearAll();
}


int yyparse(CParseTree *pState, yyFlexLexer *pLexer);

int CParseTree::ParseSQL( const char *szSQL )
{
ClearAll();
Lexer.SetInputString( this, (char *)szSQL );
return yyparse( this, &Lexer );
}

CSQLNode *CParseTree::MakeNode( int nType, char *szName )
{
CSQLNode *pNode = new CSQLNode(nType, szName);
m_NodeArray.push_back( pNode );
switch( nType )
    {
    case NodeType_String_Value :
		//m_pCurrentToken->m_strText = 		
    case NodeType_Integer_Value :
    case NodeType_Float_Value :
    case NodeType_Identifier :
		//
        pNode->m_pSQLToken =  m_pCurrentToken;
    default : 
        break;
    }
return pNode;
}


