#ifndef __TABLES_H
#define __TABLES_H

#include <string>
#include <vector>
#include <crtdbg.h>

class CSystemCatalog;
class XBASE;
//struct Schema;
//struct SchemaRec;
class DBF;
class NDX;
class CTable;
class CBaseTable;

typedef enum
{
	MENTORSQL_DATATYPE_CHAR,
	MENTORSQL_DATATYPE_INT,
	MENTORSQL_DATATYPE_FLOAT	
} MENTORSQL_DATATYPES;


class CColumnDesc
{
friend class CBaseTable;

public:
   char m_szName[21];
   MENTORSQL_DATATYPES m_DataType;
   unsigned char  m_FieldLen; //Maximum 255 tecken
};


class CIndex
{
public:
	CIndex( CBaseTable *pTable );
	virtual ~CIndex();
	int Drop();
   char *GetExpression() ;
	short OpenIndex ( char *szName, const char *szDirectory );
   short  CloseIndex( void );
	short  CreateIndex( char *szIndexName, const char *szDirectory, char *szPhysColName, char *szLogicalColName, bool fUnique );

	short FindKey( const char *szKey );
	short FindKey( long lKey );
	short FindKey( double dKey );
	short NextKey();
	short PrevKey();

										  
   std::string GetName();
   std::string GetDirectory();
protected:
	NDX *m_pNDX;
	CBaseTable *m_pTable;
	std::string m_strName;
	std::string m_strDataDirectory;
	std::string m_strColName;
	std::string m_strPhysColName;
};

class CTempIndex : public CIndex
{
public:
	CTempIndex( CTable *pTable );
	~CTempIndex();
	short  CreateIndex( char *szExp, bool fUnique );

};


typedef std::vector<CIndex*> CIndexArray;


class CBaseTable
{
public:
friend class CIndex;
	CBaseTable( XBASE *pXBase );
	virtual ~CBaseTable();

	virtual bool FullyQualifiedNames()
		{
		return false;
		}

	int OpenIndex( const char *szIndexName );
	int Open( CColumnDesc *pColumnDesc, int nCount, const char *szTableName, const char *szDirectory );
	int Drop();
	int Create( CColumnDesc *pColumnDesc, int nCount );
	std::string GetName();
	std::string GetDirectory();
	std::string GetFullPath();

	// Optimizer support routines
	long GetApproxRowCount();
	//


	short GetLastRecord();
	short GetFirstRecord();
	short GetNextRecord();
	short GetPrevRecord();

	int GetFieldNo(const char *szColName);
	int GetFieldCount();
	char *GetFieldName( int nColIndex );
	short GetFieldType(int nColIndex );
	CColumnDesc *GetColumnInfo( const char *szColName );
	CColumnDesc *GetColumnInfo( int nIndex );
	short GetFieldAsBuf( short, char *);
   short   GetField( short, char * );
	long    GetLongField( short );
	long    GetLongField( const char *szColName );
	double     GetDoubleField( short s1 );
	double     GetDoubleField( const char *szColName );
   short   PutDoubleField( short, double );
   short   PutLongField( short, long );
   short   PutField( short sColIndex, const char *szFieldData);
   short   PutRecord( unsigned long  ulRecNo );
	long  GetCurRecNo() ;
	short   DeleteAllRecords( ) ;
	short   DeleteRecord( );
   short   AppendRecord( );
   short   BlankRecord();
   short GetRecord( unsigned long ulRecNo );

	CIndex *GetIndex( const char *szColName );
	int CreateIndex(const char * szIndexName, const char *szExp, bool sUnique);
	int DropIndex( const char *szIndex );
	CIndexArray m_IndexArray;

	std::string GetColNameFromPhysName( const char *szPhysColName );
protected:
	virtual long _GetFieldIndex( const char *szName );//Names in XBase-file are just enumerators...

	int DeleteIndexFromArray( const char *szIndexName );
	DBF *m_pDBF;
	std::string m_strName;
	std::string m_strDataDirectory;
	CColumnDesc *m_pColumnDesc;
};


class CTable : public CBaseTable
{
public:
	CTable( CSystemCatalog *pCatalog, const char *szTableName, const char *szDirectory );
	int Open( CColumnDesc *pColumnDesc, int nCount );
	virtual bool FullyQualifiedNames()
		{
		return false;
		}
	CSystemCatalog *m_pCatalog;
	long m_lTableId;
};



typedef std::vector<CTable *> CTableArray;
typedef std::vector< std::string > CStringArray;


class CTempTable : public CBaseTable
{
public:
	CTempTable();
	~CTempTable();	

													
	virtual bool FullyQualifiedNames()
		{
		return true;
		}
	CStringArray m_ColStrings;
	CColumnDesc *GetColumnDesc()
		{
		return m_pColumnDesc;
		}

	int Create( CColumnDesc *pColumnDesc, int nCount ); // Used to create the set - no name is needed...
	long CloseAndGetFileSize();
	void CopyToBuf( char *szBuf, long lSize );
protected:
	virtual long _GetFieldIndex( const char *szName );//Names in XBase-file are just enumerators...
													  // Here we map it to the stringarray	
};

#endif

