#ifndef __PARSETREE_H
#define __PARSETREE_H

/*  Product: Mentor SQL

    Copyright (C) 1998  Systementor AB, Stefan Holmberg
    Email - stefan.holmberg@systementor.se
    Web:   - http://www.systementor.se

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
*/


#include <string>
#include <vector>

//Types of nodes. When parsing nodes are used to build up a 
//tree, representing the SQL-query
typedef enum
{
	NodeType_Integer_Value = 1,
	NodeType_Float_Value,
	NodeType_String_Value,
	NodeType_Identifier,
	NodeType_CreateIndex,
	NodeType_DropIndex,
	NodeType_CreateTable,
	NodeType_DropTable,
	NodeType_Dot,
	NodeType_Insert,
	NodeType_Null,
	NodeType_Delete,
	NodeType_Empty,
	NodeType_WhereCondition,


	NodeType_Equals,
	NodeType_And,
	NodeType_Or,
	NodeType_MoreEquals,
	NodeType_LessEquals,
	NodeType_More,
	NodeType_Less,

	NodeType_Star,
	NodeType_Select,

	NodeType_Update,
	NodeType_UpdateValue,

	NodeType_OrderDESC,
	NodeType_OrderASC,
	
	NodeType_CharDataType,
	NodeType_IntegerDataType,
	NodeType_FloatDataType

} NodeType;


#include "flexlexer.h"


class CSQLToken
{
public:
    CSQLToken( int nType, char *strText )
        {
        m_nType = nType;
		m_strText = strText;
        }
	~CSQLToken()
		{
		}
    int m_nType;
    std::string m_strText;
};

typedef std::vector< CSQLToken *> CSQLTokenArray;


class CSQLNode
{
public:
    CSQLNode( int nType, char *szText = "" )
        {
        m_pSQLToken = NULL;
        m_nType = nType;
        m_pNext = NULL;
        m_pLeftChild = NULL;
		m_pRightChild = NULL;
		m_strText = szText;
        };

	void AddLast( CSQLNode *pNewNode )
		{
		if ( m_pNext )
			m_pNext->AddLast( pNewNode );
		else
			m_pNext = pNewNode;
		}
    CSQLToken *m_pSQLToken; //Corresponding SQL-token, valid only if identifier or value
    CSQLNode *m_pNext;
    CSQLNode *m_pLeftChild;
	CSQLNode *m_pRightChild;
    int m_nType;
	std::string m_strText;						 
};

typedef std::vector< CSQLNode *> CSQLNodeArray;


//The CPointerNameArray is used to give lists a friendly name
class CPointerName
{
public:
	std::string m_strName;
	CSQLNode *m_pNode;
};

typedef std::vector< CPointerName *> CPointerNameArray;

class CParseTree
{
public:
	virtual ~CParseTree();
	void ClearAll();
	void ClearTokenArray();
    void AddToken( int nType, const char *strText );
	int ParseSQL( const char *szSQL );
	CSQLTokenArray m_TokenArray;	
	CSQLToken *m_pCurrentToken;
	CSQLNodeArray m_NodeArray;
	CPointerNameArray m_PointerArray;


	CSQLNode *ManuallyAddIdentifier( const char *szTokenText, const char *szNodeText );
	CSQLNode *ManuallyAddDot( const char *szTableName, const char *szColName );

	CSQLNode *GetList( const char *szName )
		{
		std::string strComp = szName;
		for ( CPointerNameArray::iterator iter = m_PointerArray.begin(); iter != m_PointerArray.end(); iter++ )
			{
			if ( (*iter)->m_strName.compare( strComp ) == 0 )
				{
				return (*iter)->m_pNode;
				}
			}
		return NULL;
		}


	void SetList( const char *szName, CSQLNode *pPtr )
		{
		std::string strComp = szName;
		for ( CPointerNameArray::iterator iter = m_PointerArray.begin(); iter != m_PointerArray.end(); iter++ )
			{
			if ( (*iter)->m_strName.compare( strComp ) == 0 )
				{
				(*iter)->m_pNode = pPtr;
				return;
				}
			}
		};


	void AddList( const char *szName, CSQLNode *pPtr );

	void SetStmt( const char *szText )
		{
		};

    CSQLNode *MakeNode( int nType, char *szName );
    CSQLNode *m_pFirst;
	std::string m_strStmt, m_strType;
    void SetFirst( CSQLNode *pFirst  )
        {
        m_pFirst = pFirst;
        }
	yyFlexLexer Lexer;
};

//#define NODPTR CSQLNode *

#endif