///////////////////////////////////////////////////////////////////
//  FileName: Disable.h
//  Description: CDisable Class Header File
//  Programmed By: Jordan Terrell
//  Home Page: www.infinet.com/~adkins/CGuile/CHome.htm
//  E-Mail: cppguile@juno.com
//  Version: 1.11
///////////////////////////////////////////////////////////////////

#include <windows.h>

#define ITEM_ENABLE 1
#define ITEM_DISABLE 2
#define ITEM_SHOW 4
#define ITEM_HIDE 8

#define ITEM_DESKTOP 1
#define ITEM_DESKTOPICONS 2
#define ITEM_MOUSE 4
#define ITEM_SCREENSAVER 8
#define ITEM_STARTBUTTON 16
#define ITEM_TASKBAR 32
#define ITEM_APPBUTTONS 64
#define ITEM_TASKSWITCH 128
#define ITEM_TRAYCLOCK 256
#define ITEM_TRAYICONS 512
#define ITEM_IEBAR 1024

#define ITEM_DISABLEALL (ITEM_DESKTOP | ITEM_DESKTOPICONS | ITEM_MOUSE | ITEM_SCREENSAVER | ITEM_STARTBUTTON \
| ITEM_TASKBAR | ITEM_APPBUTTONS | ITEM_TASKSWITCH | ITEM_TRAYCLOCK | ITEM_TRAYICONS | ITEM_IEBAR)

class CDisable
{
public:

	CDisable();
	~CDisable();

	void Disable(long dItems, long dFlags);

	void DisableDesktop(long dFlags);
	void DisableDesktopIcons(long dFlags);
	void DisableStartButton(long dFlags);
	void DisableTaskSwitching(long dFlags);
	void DisableTaskBar(long dFlags);
	void DisableAppButtons(long dFlags);
	void DisableTrayIcons(long dFlags);
	void DisableTrayClock(long dFlags);
	void DisableMouse(long dFlags);
	void DisableScreenSaver(long dFlags);
	void DisableIEBar(long dFlags);

	long GetStatus(long dItems);

	void SetSafety(BOOL bEnabled){m_Safety = bEnabled;}
	BOOL GetSafety(){return m_Safety;}
	void DoSafety();

private:
	void DisableWindow(HWND m_DisWnd,long dFlags);

	HWND m_Desktop;
	HWND m_DesktopIcons;
	HWND m_StartButton;
	HWND m_TaskBar;
	HWND m_AppButtons;
	HWND m_TrayIcons;
	HWND  m_TrayClock;
	HWND m_IEBar;

	BOOL m_Safety;
};

 
