////////////////////////////////////////////////////////////////////////////////
// TCimaRegister                                                              //
//                                                                            //
//                                                                            //
// Purpose:      Allows your users to type in a Registration Code to end a    //
//           shareware evaluation period.                                     //
//                                                                            //
//                                                                            //
// Usage:  Place CimaRegister1->Execute(UserName) in your main form's         //
//         constructer, this may or may not trigger the OnNotRegisteredYet    //
//         event.  Execute() creates a Serial Number based on the UserName.   //
//         Use the GetSerialNumber() method to show your user this serial     //
//         number.  Use TryToRegister(RegistrationNumber) to attempt a        //
//         registration. This will either trigger the OnRegistered Event or   //
//         the OnUnSuccessfullRegistration Event.  The OnRegistered Event     //
//         will record the Registration Number in the registry.               //
//                                                                            //
//         You can change the default settings of the RegistryKey and the     //
//         RegistryValueName below.                                           //
//             InstallShield saves the Name entered during the registration   //
//         in the registry at:                                                //
//           Key = HKEY_LOCAL_MACHINE\SOFTWARE\<Company>\<AppName>\<Version>  //
//           ValueName = Name                                                 //
//         This is an ideal place to get the UserName for the Execute method. //
//                                                                            //
//                                                                            //
// Special Notes:                                                             //
//         The SeedNumber property is used to vary the formula for the        //
//         registration number in different programs.  Make sure you change   //
//         this from the default and that each of your programs use a different
//         seed number.  If for some reason you wish to vary the seed number  //
//         from installation to installation you can use the GetSeedNumber()  //
//         method, then encode it, and display it with the serial number.     //
//         The Seed Number must be known when using the Decoder to get the    //
//         Registration Number.                                               //
//                                                                            //
//                                                                            //
//  Events:                                                                   //
//     OnRegistered;                                                          //
//     OnUnSuccessfulRegistration;                                           //
//     OnNotRegisteredYet;                                                    //
//                                                                            //
//                                                                            //
//  Methods:                                      Return Type                 //
//     Execute(String UserName)                       bool                    //
//     TryToRegister(String RegistrationNumber)       void                    //                                                                            //
//     GetSerialNumber()                             String                   //
//     GetRegistrationNumber()                       String                   //
//     GetSeedNumber()                               String                   //
//         (Use GetSeedNumber carefully!!)                                    //
//         (User should not see GetSeedNumber() directly)                     //
//                                                                            //
//  Demo:                                                                     //
//     If your copy of this component did not come with a demo project you    //
//     can get one by sending e-mail to cimasoftware@usa.net                  //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// by: Jarrid Cima                                                            //
//     cimasoftware@usa.net                                                   //
//     http://www.intrnet.net/~jacima/cbuilder                                //
//                                                                            //
//  Copyright 1997                                                           //
////////////////////////////////////////////////////////////////////////////////
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef TCimaRegH
#define TCimaRegH
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//Constants  --   Edit these constants to change their default values
const String DefaultCimaRegRegistryKey = "\\Software\\Cima Software\\";
const String DefaultCimaRegRegistryValueName = "RegistrationNumber";
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <vcl\registry.hpp>
#include <vcl\dsgnintf.hpp>
#include "CimaAboutReg.h"
#include "CimaShareRegBox.h"

#pragma link "CimaAboutReg.obj"
#pragma link "CimaShareRegBox.obj"
//---------------------------------------------------------------------------
#ifndef _TRegRoot
#define _TRegRoot
enum TRegRoot {rrHKEY_CLASSES_ROOT, rrHKEY_CURRENT_USER, rrHKEY_LOCAL_MACHINE, rrHKEY_USERS};
#endif
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
class TAboutMeReg : public Dsgnintf::TPropertyEditor
{
	typedef Dsgnintf::TPropertyEditor inherited;
	
public:
	virtual void __fastcall Edit(void);
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual System::AnsiString __fastcall GetValue(void);
public:
	/* TPropertyEditor.Destroy */ __fastcall virtual ~TAboutMeReg(void) { }
	
public:
	/* TObject.Create */ __fastcall TAboutMeReg(void) : Dsgnintf::TPropertyEditor() { }
	
};
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
class TCimaRegister : public TComponent
{
private:
   int       DoNothingCheck;
   int	     SerialNo;
   String    Serial;
   String    RegNumber;

     //  __published
   int          FSeedNumber;
   TRegRoot     FRegistryRoot;
   String       FRegistryKey;
   String       FRegistryValueName;
   int          FSerialNumber;

   // Events
   Classes::TNotifyEvent  FOnRegistered;
   Classes::TNotifyEvent  FOnUnSuccessfullRegistration;
   Classes::TNotifyEvent  FOnNotRegisteredYet;
   Classes::TNotifyEvent  FOnAlreadyRegistered;
//---------------------------------------------------------------------------
protected:
  bool __fastcall CheckRegistration();
  void __fastcall MakeSerialNumber (String UserName);

   // Setters
  void __fastcall SetSeedNumber (int ASeedNumber);
  void __fastcall SetSerialNumber (int ASerialNumber);

   // Virtual functions which trigger Events
  virtual void __fastcall Registered(String RegistrationNumber);
  virtual void __fastcall UnSuccessfulRegistration();
  virtual void __fastcall NotRegisteredYet();
  virtual void __fastcall AlreadyRegistered();
//---------------------------------------------------------------------------
public:
    __fastcall TCimaRegister(TComponent* Owner);
  bool __fastcall Execute(String UserName);        // Main Method
  void __fastcall TryToRegister(String RegistrationNumber);

    // Getters
  String __fastcall GetSeedNumber ();              // Use this carefully!!
  String __fastcall GetSerialNumber ();
  String __fastcall GetRegistrationNumber();

//---------------------------------------------------------------------------
__published:
     TAboutMeReg*  FAbout;
     __property TAboutMeReg* About = {read=FAbout, write=FAbout};
  __property int SerialNumber = {read=FSerialNumber};               // Read Only
  __property int SeedNumber = {read=FSeedNumber, write=SetSeedNumber};
  __property TRegRoot RegistryRoot = {read=FRegistryRoot, write=FRegistryRoot, default = HKEY_CURRENT_USER};
  __property String RegistryKey= {read=FRegistryKey, write = FRegistryKey};
  __property String RegistryValueName = {read=FRegistryValueName, write = FRegistryValueName};

  __property Classes::TNotifyEvent OnUnSuccessfulRegistration = {read = FOnUnSuccessfullRegistration, write=FOnUnSuccessfullRegistration};
  __property Classes::TNotifyEvent OnNotRegisteredYet = {read = FOnNotRegisteredYet, write=FOnNotRegisteredYet};
  __property Classes::TNotifyEvent OnAlreadyRegistered = {read = FOnAlreadyRegistered, write=FOnAlreadyRegistered};
  __property Classes::TNotifyEvent OnRegistered = {read = FOnRegistered, write=FOnRegistered};

};
//---------------------------------------------------------------------------
#endif
