// CDigitST_demoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CDigitST_demo.h"
#include "CDigitST_demoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCDigitST_demoDlg dialog

CCDigitST_demoDlg::CCDigitST_demoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCDigitST_demoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCDigitST_demoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_bRunning = FALSE;
}


void CCDigitST_demoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCDigitST_demoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCDigitST_demoDlg, CDialog)
	//{{AFX_MSG_MAP(CCDigitST_demoDlg)
	ON_BN_CLICKED(IDC_ZEROPAD, OnZeroPad)
	ON_BN_CLICKED(IDB_ABOUT, OnAbout)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_RESETPARTIAL, OnResetPartial)
	ON_BN_CLICKED(IDC_GO, OnGo)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCDigitST_demoDlg message handlers

BOOL CCDigitST_demoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// Create IDC_DIGIT_SPEED control
	m_dgtSpeed.SubclassDlgItem(IDC_DIGIT_SPEED, this);
	m_dgtSpeed.SetStyle(IDB_BIG1, 5);
	m_dgtSpeed.SetValue(0);

	// Create IDC_DIGIT_TOTALKM control
	m_dgtTotal.SubclassDlgItem(IDC_DIGIT_TOTALKM, this);
	m_dgtTotal.SetStyle(IDB_SMALL1, 6);
	m_dgtTotal.SetValue(1055);

	// Create IDC_DIGIT_PARTIALKM control
	m_dgtPartial.SubclassDlgItem(IDC_DIGIT_PARTIALKM, this);
	m_dgtPartial.SetStyle(IDB_SMALL2, 5);
	m_dgtPartial.SetValue(0);
	// Show zeroes
	m_dgtPartial.SetZeroPadding(TRUE);

	// Write class version
	CString sVersion;
	sVersion.Format("CDigitST v%s", CDigitST::GetVersionC());
	SetWindowText(sVersion);

	return TRUE;
} // End of OnInitDialog


void CCDigitST_demoDlg::OnZeroPad() 
{
	m_dgtTotal.SetZeroPadding(!m_dgtTotal.GetZeroPadding());	
} // End of OnZeroPad


void CCDigitST_demoDlg::OnAbout() 
{
	CAboutDlg about;

	about.DoModal();	
} // End of OnAbout


void CCDigitST_demoDlg::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == 1)
	{
		m_dgtTotal.Inc();
		m_dgtPartial.Inc();
	}
	else
	CDialog::OnTimer(nIDEvent);
} // End of OnTimer


void CCDigitST_demoDlg::OnResetPartial() 
{
	m_dgtPartial.SetValue(0);	
} // End of OnResetPartial


void CCDigitST_demoDlg::OnGo() 
{
	m_bRunning ^= TRUE;
	
	if (m_bRunning == TRUE)
	{
		SetTimer(1, 250, NULL);
		m_dgtSpeed.SetValue(90);
		SetDlgItemText(IDC_GO, "Stop moving!");
	}
	else
	{
		KillTimer(1);
		m_dgtSpeed.SetValue(0);
		SetDlgItemText(IDC_GO, "Go somewhere");
	}
} // End of OnGo


void CCDigitST_demoDlg::OnDestroy() 
{
	KillTimer(1);	

	CDialog::OnDestroy();
} // End of OnDestroy
