;JQ Mail Version 0.3.1 by JoeyQ
;For use on mIRC 5.3 or 5.31
;Checks and sends electronic mail using POP3 and SMTP protocols.
;Refer to readme.txt for installation procedures and help.

;==Function Keys==

;READ THIS! The following two aliases are function keys 5 and 6 (F5 and F6). If these 
;function keys are already being used by another script, please change the F5 and F6
;to any other available function key, or simply remove the two alias F5 and F6 lines if you
;have no available function keys.

alias F5 mailin
alias F6 mailout

;==Events==

on 1:load:{
  ;Unsuccessful Install
  if (($version != 5.3) && ($version != 5.31)) {
    window @MailLoad 200 200 400 100 Arial 12
    aline @MailLoad 4JQ Mail v0.3.1 Unsuccessfully Loaded
    aline @MailLoad Sorry, but you are using mIRC $version $+ . JQ Mail needs mIRC version 5.3
    aline @MailLoad or 5.31 in order to run correctly. To get the latest version of mIRC, go
    aline @MailLoad to 4http://www.mirc.co.uk/. JQ Mail is automanically being unloaded.
    unload -rs jqmail03.mrc
  }
  ;Successful Install
  else {
    unset %mailpass*
    set %mailusername Default
    set %mailusernamenum 1
    set %mailusername1 Default
    set %mailusername2 None
    set %mailusername3 None
    set %mailusername4 None
    set %mailusername5 None
    set %mailabook1 None
    set %mailabook2 None
    set %mailabook3 None
    set %mailabook4 None
    set %mailabook5 None
    set %mailabook6 None
    set %mailabook7 None
    set %mailabook8 None
    set %mailabook9 None
    set %mailabook10 None
    window -p +bt @MailLoad 200 65 391 380
    drawpic @MailLoad 0 0 $scriptdir $+ jqmail.bmp
    drawtext @MailLoad 4 Arial 20 120 329 Successfully loaded!
  }
}
;Socket Events
on 1:sockopen:jqmailac:{
  if ((%mailuser != $null) && (%mailpass != $null)) {
    set %mailaccheckok 1
    sockwrite -n jqmailac USER %mailuser
    sockwrite -n jqmailac PASS $maildecrypt(%mailpass)
    sockwrite -n jqmailac STAT
    .timer -o 1 10 if ($sock(jqmailac).status == active) { sockclose jqmailac }
  }
  else { sockclose jqmailac }
}
on 1:sockread:jqmailac:{
  if ($sockerr > 0) { return }
  :back
  sockread %i
  if (%i == $null) { goto skip }
  mailacsr %i
  :skip
  if ($sockbr > 0) { goto back }
}
on 1:sockopen:jqmail:{
  if (%mailsend == ready) {
    mailtbar SMTP: Connected
    set %mailsend off
    set %mailsend250 1
  }
  if (%mailcheck == ready) {
    .timerJQMailNoop -o 0 30 mailsw NOOP
    .timerJQMailTimeout off
    mailtbar POP3: Connected
    set %mailcheck off
    set %mailcheckok 1
  }
}
on 1:sockclose:jqmail:{ mailpop3quit | aline 2 @JQMail *** Disconnected by mail server }
on 1:sockread:jqmail:{
  if ($sockerr > 0) { aline 4 @JQMail *** Socket Error: Cannot read receive buffer, closing connection (Error $sockerr $+ ) | mailpop3quit | return }
  :back
  sockread %i
  mailsr %i
  if ($sockbr > 0) { goto back }
}
;Misc
on 1:dns:{
  if (%maildns == smtp) { unset %maildns | if ($raddress == $null) { aline @JQMailHostCheck 4Failed, %mailservsmtporg is not a valid host. | unset %mailservsmtporg | mailsetup | halt } | aline @JQMailHostCheck 3Passed, %mailservsmtporg is a valid host. | set %mailservsmtp $longip($iaddress) | set %mailservsmtp [ $+ [ %mailusernamenum ] ] %mailservsmtp | mailsetup }
  if (%maildns == pop3) { unset %maildns | if ($raddress == $null) { aline @JQMailHostCheck 4Failed, %mailservpop3org is not a valid host. | unset %mailservpop3org | mailsetup | halt } | aline @JQMailHostCheck 3Passed, %mailservpop3org is a valid host. | set %mailservpop3 $longip($iaddress) | set %mailservpop3 [ $+ [ %mailusernamenum ] ] %mailservpop3 | mailsetup }
}
on 1:connect:{ if (%mailac == on) { sockopen jqmailac %mailservpop3 110 } }
on 1:start:{ echo 2 -s *** JQ Mail 0.3.1 by JoeyQ is loaded | if (%mailac == on) { .timerJQMailAC -o 0 %mailacdel sockopen jqmailac %mailservpop3 110 } }
on 1:input:@JQMail:{ if (%mailnewmessage == yes) { mailsplit 1 $1- | halt } }
ctcp 1:jqmail:{ .ctcpreply $nick JQMAIL JQ Mail 0.3.1 by JoeyQ }
on 1:close:@:{
  if (($target == @JQMail) || ($target == @JQMailInbox)) { mailpop3quit }
  if ($target == @MailLoad) { unset %mailegg | mailsetup }
}

;==Aliases==

;Auto Check Read from Socket
alias -l mailacsr {
  if ($1 == +OK) {
    if (%mailaccheckok == 4) {
      unset %mailaccheckok
      if ($2 == 1) { echo 4 %mailacwin *** JQ Mail: User %mailusername has 1 message. }
      if ($2 > 1) { echo 4 %mailacwin *** JQ Mail: User %mailusername has $2 messages. }
      sockwrite -n jqmailac QUIT
      sockclose jqmailac
    }
    if (%mailaccheckok == 3) { inc %mailaccheckok }
    if (%mailaccheckok == 2) { inc %mailaccheckok }
    if (%mailaccheckok == 1) { inc %mailaccheckok }
  }
  if ($1 == -ERR) { unset %mailaccheckok | sockwrite -n jqmailac QUIT | sockclose jqmailac }
}
;Write to Socket
alias -l mailsw {
  sockwrite -n jqmail $1-
  ;Debug
  if (%maildebug == on) { write $scriptdir $+ maildbug.txt $1- }
}
;Read Events from Socket
alias -l mailsr {
  ;SMTP Events
  if ($1 == 220) { mailsw HELO %mailuser | mailtbar SMTP: Sending username }
  if ($1 == 250) { 
    if (%mailsend250 == 4) { unset %mailsend250 | mailsw QUIT | mailtbar SMTP: Message delivered }
    if (%mailsend250 == 3) { set %mailsend250 4 | mailsw DATA | mailtbar SMTP: Initializing message send }
    if (%mailsend250 == 2) { set %mailsend250 3 | mailsw RCPT TO: %mailrcpt | mailtbar SMTP: Sending recipient }
    if (%mailsend250 == 1) { set %mailsend250 2 | mailsw MAIL FROM: %mailaddy | mailtbar SMTP: Sending sender }
  }
  if ($1 == 354) {
    mailtbar SMTP: Sending message...
    mailsw X-Mailer: JQ Mail v0.3.1 by JoeyQ for mIRC 5.3-5.31
    mailsw From: $me < $+ %mailaddy $+ >
    mailsw Subject: %mailsubj
    set %mailsendnum 0
    :back
    inc %mailsendnum 1
    set %mailsendline $read -l [ $+ [ %mailsendnum ] ] $scriptdir $+ mailsend.jqt
    if (%mailsendline == $null) { goto next }
    mailsw %mailsendline
    goto back
    :next
    if (%mailsign == on) {
      set %mailsignnum 0
      :back2
      inc %mailsignnum 1
      set %mailsignline $read -l [ $+ [ %mailsignnum ] ] $scriptdir $+ mailsign.txt
      if (%mailsignline == $null) { goto next2 }
      mailsw %mailsignline
      goto back2
      :next2
    }
    mailsw .
  }
  if ($1 == 354) { mailpop3quit | aline 2 @JQMail *** Message sent successfully }
  ;POP3 Events
  if ($1 == +OK) { 
    if ($2 == $null) { halt }
    if (%mailcheckok == 4) {
      unset %mailcheckok
      if ($2 == 0) { aline 2 @JQMail *** You have no messages. | mailpop3quit | halt }
      if ($2 >= 1) { mailtbar POP3: Connected }
      aline 2 @JQMail *** Connected to mail server
      mailpop3bar
      set %mailtotal $2
      mailpop3list
    }
    if (%mailcheckok == 3) { inc %mailcheckok | mailsw STAT }
    if (%mailcheckok == 2) { inc %mailcheckok | mailsw PASS $maildecrypt(%mailpass) | mailtbar POP3: Sending password }
    if (%mailcheckok == 1) { inc %mailcheckok | mailsw USER %mailuser | mailtbar POP3: Sending username }
  }
  if ($1 == +ERR) { aline 4 @JQMail *** Server Error: $2- }
  else {
    if (%mailreadlist == ready) {
      if ($1 == From:) { set %mailreadlistfrom $2- }
      if ($1 == Subject:) { set %mailreadlistsubj $2- }
      if ($1 == .) {
        aline 3 @JQMailInbox %mailreadlistfrom 	 %mailreadlistsubj
        unset %mailreadlist*
        inc %maillistleft 1
        if (%maillistleft <= %mailtotal) {
          set %mailreadlist ready
          titlebar @JQMailInbox - Loading message %maillistleft of %mailtotal
          mailsw top %maillistleft 0
        }
        if (%maillistleft > %mailtotal) { titlebar @JQMailInbox - %mailtotal messages total. }
      }
    }
    if (%mailreadinfo == ready) {
      if (($1 == Subject:) || ($1 == Date:) || ($1 == Reply-To:) || ($1 == Cc:) || ($1 == To:)) {
        aline 4 @JQMail  $+ $1-
        write $scriptdir $+ mailget.jqt $1-
        if (%mailsave == on) { write mailsave.txt * $1- }
        halt
      }
      if ($1 == From:) {
        aline 4 @JQMail  $+ $1-
        write $scriptdir $+ mailget.jqt $1-
        set %i 0
        :back
        inc %i 1
        if ($ [ $+ [ %i ] ] == $null) { goto next }
        goto back
        :next
        dec %i
        set %mailreplyrcpt $remove($remove($ [ $+ [ %i ] ] ,<),>)
        if (%mailsave == on) { write mailsave.txt * $1- }
        halt
      }
      if ($1 == $null) { if (%mailreadinfonull == $null) { set %mailreadinfonull 0 } | inc %mailreadinfonull 1 | if (%mailreadinfonull == 2) { set %mailreadmsg ready | set %mailreadinfo off | unset %mailreadinfonull } }
    }
    if (%mailreadmsg == ready) {
      if ($1 == $null) { aline @JQMail  | halt }
      if ($1 == .) { write mailsave.txt * End of Message | set %mailreadmsg off | if (%mailad == on) { mailsw dele %mailadnum } | aline 2 @JQMail *** End of Message | halt }
      if (($7 == MIME) && ($8 == format.)) { write mailsave.txt * Message Halted | set %mailreadmsg off | aline 2 @JQMail *** Message Halted: Please read this message in your e-mail client. | mailpop3quit }
      mailsplit 2 $1-
      write $scriptdir $+ mailget.jqt $1-
      if (%mailsave == on) { write mailsave.txt $1- }
    }
  }
  ;Debug
  if (%maildebug == on) { write $scriptdir $+ maildbug.txt $1- }
}
;Misc
alias -l mailpop3list {
  if ($window(@JQMailInbox).state == $null) {
    window -l -t20 @JQMailInbox 20 320 744 141 @JQMailInbox
    titlebar @JQMailInbox - Loading message 1 of %mailtotal
    set %maillistleft 1
    set %mailreadlist ready
    mailsw top %maillistleft 0
  }
}
alias -l mailsend { aline @JQMail $1- | write $scriptdir $+ mailsend.jqt $1- }
alias -l maildone {
  unset %mailnewmessage
  clear -l @JQMail
  sockopen jqmail %mailservsmtp 25
  set %mailsend ready
  mailtbar SMTP: Connecting...
}
alias -l mailpop3quit {
  if ($sock(jqmail).status == active) {
    mailsw QUIT
    sockclose jqmail
  }
  if ($window(@JQMailInbox).state != $null) { window -c @JQMailInbox }
  if ($window(@JQMail).state != $null) {
    mailtbar Disconnected
    aline 2 @JQMail *** Disconnected
    maildisbar
  }
  .timerJQMailNoop off
}
alias -l mailpop3read {
  rline 1 @JQMailInbox $1 $line(@JQMailInbox,$1,0)
  write -c $scriptdir $+ mailget.jqt
  mailsw retr $1
  set %mailreadinfo ready
  clear @JQMail
  set %mailcurnum $1
  set %mailadnum %mailcurnum
}
alias -l mailtbar { titlebar @JQMail - %mailusername - $1- }
alias -l mailtimeout {
  mailpop3quit
  aline 2 @JQMail *** Connection attempt timed out
  unset %mailcheck
}
;Load User
alias -l mailloaduser {
  if ($1 == $null) { halt }
  else { set %mailusername %mailusername [ $+ [ $1 ] ] | set %mailusernamenum $1 | set %mailservpop3 %mailservpop3 [ $+ [ $1 ] ] | set %mailservsmtp %mailservsmtp [ $+ [ $1 ] ] | set %mailaddy %mailaddy [ $+ [ $1 ] ] | set %mailuser %mailuser [ $+ [ $1 ] ] | set %mailpass %mailpass [ $+ [ $1 ] ] | set %mailin %mailin [ $+ [ $1 ] ] | set %mailout %mailout [ $+ [ $1 ] ] | set %mailac %mailac [ $+ [ $1 ] ] | set %mailad %mailad [ $+ [ $1 ] ] | set %mailsign %mailsign [ $+ [ $1 ] ] | set %mailsave %mailsave [ $+ [ $1 ] ] | set %mailacdel %mailacdel [ $+ [ $1 ] ] | set %mailacwin set %mailacwin [ $+ [ $1 ] ] }
}
;Sidebar Loaders
alias -l maildisbar {
  clear -l @JQMail
  aline -l @JQMail Get Mail
  aline -l @JQMail Send Mail
  set %mailbar dis
}
alias -l mailpop3bar {
  clear -l @JQMail
  aline -l @JQMail Delete
  aline -l @JQMail Reply
  aline -l @JQMail Forward
  aline -l @JQMail Quit
  set %mailbar pop3
}
alias -l mailsmtpbar {
  clear -l @JQMail
  aline -l @JQMail Done
  aline -l @JQMail Quit
  set %mailbar smtp
}
;Returns Version of JQ Mail
alias jqmailver { return 0.3.1 }
;Encryption
alias -l mailencrypt {
  unset %i2
  set %i 0
  :back
  inc %i
  set %i2 %i2 $+ $chr($calc(($asc($mid($1,%i,1)) + $asc()) - $asc()))
  if (%i >= $len($1)) { return %i2 }
  goto back
}
alias -l maildecrypt {
  unset %i2
  set %i 0
  :back
  inc %i
  set %i2 %i2 $+ $chr($calc(($asc($mid($1,%i,1)) - $asc()) + $asc()))
  if (%i >= $len($1)) { return %i2 }
  goto back
}
;Word Wrap
alias -l mailsplit {
  set %i $2-
  :back
  if ($len(%i) > 80) {
    if ($1 == 1) { mailsend $left(%i,80) }
    if ($1 == 2) { aline @JQMail $left(%i,80) }
    set %i $remove(%i,$left(%i,80))
    goto back
  }
  if (%i != $null) {
    if ($1 == 1) { mailsend %i }
    if ($1 == 2) { aline @JQMail $replace(%i,$chr(32),$chr(160)) }
  }
}
;Uninstaller
alias mailuninst {
  if ($$?="Uninstall: Are you sure? (y/n)" == y) {
    echo 2 -s *** JQ Mail: Uninstalling...
    unset %mail*
    unload -rs $scriptdir $+ jqmail03.mrc
    if ($?="Uninstall: Remove JQ Mail files? (y/n)" == y {
      remove $scriptdir $+ mailget.jqt
      remove $scriptdir $+ mailsend.jqt
      remove $scriptdir $+ mailsign.txt
      remove $scriptdir $+ mailsave.txt
      remove $scriptdir $+ jqmail.bmp
      remove $scriptdir $+ jqmail03.mrc
    }
    echo 2 -s *** JQ Mail: Uninstall complete. Thank you for using JQ Mail v0.3.1.
  }
}
;Forward Mail
alias -l mailfor {
  sockclose jqmail
  set %mailrcpt $$?="Enter E-Mail Recipient Address:"
  set %mailsubj Fwd: $read -sSubject: $scriptdir $+ mailget.jqt
  write -c $scriptdir $+ mailsend.jqt
  set %mailfornum 0
  :back
  inc %mailfornum 1
  set %mailforline $read -l [ $+ [ %mailfornum ] ] $scriptdir $+ mailget.jqt
  write $scriptdir $+ mailsend.jqt > $+ %mailforline
  if (%mailfornum == $lines($scriptdir $+ mailget.jqt)) { goto next }
  goto back
  :next
  sockopen jqmail %mailservsmtp 25
  set %mailsend ready
  mailtbar SMTP: Connecting...
}
;Reply Mail
alias -l mailreply {
  mailpop3quit
  set %mailrcpt %mailreplyrcpt
  set %mailsubj Re: $read -sSubject: $scriptdir $+ mailget.jqt
  write -c $scriptdir $+ mailsend.jqt
  mailsmtpbar
  clear @JQMail
  aline 2 @JQMail *** SMTP Reply Started
  aline 2 @JQMail Enter message. Use as many lines as you like.
  aline 2 @JQMail When you're done, double-click on Done in the sidebar to your right.
  aline 2 @JQMail 
  aline 2 @JQMail 4To: %mailrcpt
  aline 2 @JQMail 4Subject: %mailsubj
  aline 2 @JQMail 4________________________________________________________________________________
  aline 2 @JQMail 
  set %mailreplynum 0
  set %mailnewmessage yes
  :back
  inc %mailreplynum 1
  set %mailreplyline $read -l [ $+ [ %mailreplynum ] ] $scriptdir $+ mailget.jqt
  if (%mailreplyline == $null) { goto next }
  mailsend  > $+ %mailreplyline
  goto back
  :next
}
;Starts JQ Mail
alias jqmail {
  if ($window(@JQMail).state == $null) {
    window -el7 +bfnt @JQMail 20 20 745 300 @JQMail Courier 10
    window -p +b @JQMailLoaded 200 65 391 335
    drawpic @JQMailLoaded 0 0 $scriptdir $+ jqmail.bmp
    .timer -mo 1 2500 window -c @JQMailLoaded
  }
  if ($sock(jqmail).status == active) { sockclose jqmail }
  clear @JQMail
  aline 2 @JQMail *** Welcome to JQ Mail Version 0.3.1 by JoeyQ
  maildisbar
  mailtbar Disconnected
}
;Starts POP3 Client
alias mailin {
  if ($1 != $null) { mailloaduser $1 }
  jqmail
  if (%mailservpop3 == $null) { aline 4 @JQMail *** JQ Mail Error: No POP3 server entered in setup. | halt }
  if (%mailuser == $null) { aline 4 @JQMail *** JQ Mail Error: No username entered in setup. | halt }
  if (%mailpass == $null) { aline 4 @JQMail *** JQ Mail Error: No password entered in setup. | halt }
  sockopen jqmail %mailservpop3 110
  set %mailcheck ready
  aline 2 @JQMail *** POP3 Started
  mailtbar POP3: Connecting...
  .timerJQMailTimeout -o 1 30 mailtimeout
}
;Starts SMTP Client
alias mailout {
  jqmail
  if (%mailservsmtp == $null) { aline 4 @JQMail *** JQ Mail Error: No SMTP server entered in setup. | halt }
  if (%mailuser == $null) { aline 4 @JQMail *** JQ Mail Error: No username entered in setup. | halt }
  if (%mailabook != $null) { set %mailrcpt %mailabook | unset %mailabook | goto skip }
  if ($1 != $null) { set %mailrcpt $1 | goto skip }
  set %mailrcpt $$?="Enter E-Mail Recipient Address:"
  :skip
  if ($2- != $null) { set %mailsubj $2- | goto skip2 }
  set %mailsubj $$?="Enter E-Mail Subject:"
  :skip2
  write -c $scriptdir $+ mailsend.jqt
  mailsmtpbar
  clear @JQMail
  set %mailnewmessage yes
  aline 2 @JQMail *** SMTP Started
  aline 2 @JQMail Enter message. Use as many lines as you like.
  aline 2 @JQMail When you're done, double-click on Done in the sidebar to your right.
  aline 2 @JQMail 
  aline 2 @JQMail 4To: %mailrcpt
  aline 2 @JQMail 4Subject: %mailsubj
  aline 2 @JQMail 4________________________________________________________________________________
  aline 2 @JQMail 
}
;Setup Screen
alias mailsetup {
  if ($window(@JQMailSetup).state == $null) { window -l8 @JQMailSetup 20 20 550 170 Arial 16 }
  clear @JQMailSetup
  clear -l @JQMailSetup
  titlebar @JQMailSetup - User: %mailusername
  aline @JQMailSetup 4JQ Mail Setup
  aline @JQMailSetup 
  aline @JQMailSetup 1. POP3 Server0l  $+ %mailservpop3org
  aline @JQMailSetup SMTP Server0l  $+ %mailservsmtporg
  aline @JQMailSetup 2. E-Mail Address $+ %mailaddy
  aline @JQMailSetup 3. Username $+ %mailuser
  aline @JQMailSetup 4. Password0l<Encrypted>
  aline -l @JQMailSetup 1. POP3
  aline -l @JQMailSetup SMTP
  aline -l @JQMailSetup 2. Address
  aline -l @JQMailSetup 3. Username
  aline -l @JQMailSetup 4. Password
}

;==Popup Menus==

;Value Filling Popup Identifier
alias -l mailpopup {
  if ($1 == acswitch) {
    if (%mailac == on) { return on }
    else { return off }
  }
  if ($1 == acdelay) {
    if (%mailacdel != $null) { return $calc(%mailacdel / 60) }
    else { return No }
  }
  if ($1 == acdisplay) {
    if (%mailacwin == -a) { return Active }
    if (%mailacwin == -s) { return Status }
    else { return No }
  }
  if ($1 == adswitch) {
    if (%mailad == on) { return on }
    else { return off }
  }
  if ($1 == signswitch) {
    if (%mailsign == on) { return on }
    else { return off }
  }
  if ($1 == saveswitch) {
    if (%mailsave == on) { return on }
    else { return off }
  }
  if ($1 == debugswitch) {
    if (%maildebug == on) { return on }
    else { return off }
  }
}
;Setup Double-Click
menu @JQMailSetup {
  dclick {
    if ($1 == 1) { set %mailservpop3org $$?="Enter POP3 Server Host:" | set %mailservpop3org [ $+ [ %mailusernamenum ] ] %mailservpop3org | window @JQMailHostCheck 0 0 400 100 | aline @JQMailHostCheck Checking if %mailservpop3org is a valid host... | set %maildns pop3 | dns %mailservpop3org }
    if ($1 == 2) { set %mailservsmtporg $$?="Enter SMTP Server Host:" | set %mailservsmtporg [ $+ [ %mailusernamenum ] ] %mailservsmtporg | window @JQMailHostCheck 0 0 400 100 | aline @JQMailHostCheck Checking if %mailservsmtporg is a valid host... | set %maildns smtp | dns %mailservsmtporg }
    if ($1 == 3) { set %mailaddy $$?="Enter E-Mail Address:" | set %mailaddy [ $+ [ %mailusernamenum ] ] %mailaddy | mailsetup }
    if ($1 == 4) { set %mailuser $$?="Enter E-Mail UserName:" | set %mailuser [ $+ [ %mailusernamenum ] ] %mailuser | mailsetup }
    if ($1 == 5) { if (%mailpass != $null) { set %i $$?="Enter Old Password" } | if ((%i == $maildecrypt(%mailpass)) || (%mailpass == $null)) { unset %i | set %mailpass $mailencrypt($$?="Enter E-Mail Password:") | set %mailpass [ $+ [ %mailusernamenum ] ] %mailpass | mailsetup } | else { titlebar @JQMailSetup - User: %mailusername - Wrong Password | timer -o 1 3 titlebar @JQMailSetup - User: %mailusername | halt } }
  }
}
;Inbox Popup Menu (Found by right clicking in the @JQ Mail Inbox window)
menu @JQMailInbox {
  dclick { window -a @JQMailInbox | mailpop3read $1 }
  Read:{ mailpop3read $sline(@JQMailInbox,1).ln }
  Delete:{ mailsw dele $sline(@JQMailInbox,1).ln | rline 1 @JQMailInbox $sline(@JQMailInbox,1).ln <Deleted> | if (%mailcurnum == $sline(@JQMailInbox,1).ln) { aline 2 @JQMail *** Message Deleted } }
  Mark Unread:{ rline 3 @JQMailInbox $sline(@JQMailInbox,1).ln $line(@JQMailInbox,$sline(@JQMailInbox,1).ln,0) }
  -
  Delete All and Quit:{
    set %i 0
    :back
    inc %i
    mailsw dele %i
    if (%i >= %mailtotal) { .timer -m 1 250 aline 2 @JQMail *** All messages deleted | .timer -m 1 250 mailpop3quit | halt }
    goto back
  }
}
;Misc
menu @MailLoad {
  mouse {
    if ((%maildold != $null) && ($mouse.key & 1) && (%mailegg == yes)) {
      drawline @MailLoad 1 1 %maildold $mouse.x $mouse.y
      set %maildold $mouse.x $mouse.y
    }
  }
  sclick {
    if (($mouse.x > 294) && ($mouse.x < 378) && ($mouse.y > 282) && ($mouse.y < 321) && (%mailegg == $null)) { set %mailegg yes | drawtext @MailLoad 4 Arial 30 120 72 Easter Egg! | halt }
    if (%mailegg == yes) {
      drawdot @MailLoad 1 1 $mouse.x $mouse.y
      set %maildold $mouse.x $mouse.y
    }
  }
  drop { if (%mailegg == yes) { unset %maildold } }
  dclick { clear @MailLoad }
}
;JQ Mail Shortcut Popup Menu (Found in the Commands menu above the toolbar or by right clicking in the status window)
menu menubar,status {
  JQ Mail:jqmail
}
;Main Popup Menu (Found by right clicking in the @JQ Mail window)
menu @JQMail {
  dclick {
    if (%mailbar == pop3) {
      if ($1 == 1) { mailsw dele %mailcurnum | rline 1 @JQMailInbox %mailcurnum <Deleted> | aline 2 @JQMail *** Message Deleted }
      if ($1 == 2) { mailreply }
      if ($1 == 3) { mailfor }
      if ($1 == 4) { mailpop3quit }
      return
    }
    if (%mailbar == smtp) {
      if ($1 == 1) { maildone }
      if ($1 == 2) { unset %mailnewmessage | maildisbar | aline 2 @JQMail *** SMTP mode has been quit, message has not been sent. }
      return
    }
    if (%mailbar == dis) {
      if ($1 == 1) { mailin }
      if ($1 == 2) { mailout }
    }
  }
  Setup
  .Setup Window:mailsetup
  .-
  .Uninstall:mailuninst
  -
  AutoCheck
  .Switch
  ..On:set %mailac on | set %mailac [ $+ [ %mailusernamenum ] ] on | set %i $$?="Check for mail every ? minutes" | set %mailacdel $calc(%i * 60) | set %mailacdel [ $+ [ %mailusernamenum ] ] $calc(%i * 60) | set %mailacwin -s | set %mailacwin [ $+ [ %mailusernamenum ] ] -s | sockopen jqmailac %mailservpop3 110
  ..Off:unset %mailac | set %mailac [ $+ [ %mailusernamenum ] ] off | .timerJQMailAC off
  .-
  .Delay:set %i $$?="Check for mail every ? minutes" | set %mailacdel $calc(%i * 60) | set %mailacdel [ $+ [ %mailusernamenum ] ] $calc(%i * 60)
  .Display
  ..Active Window:set %mailacwin -a | set %mailacwin [ $+ [ %mailusernamenum ] ] -a
  ..Server Window:set %mailacwin -s | set %mailacwin [ $+ [ %mailusernamenum ] ] -s
  .-
  .Current Switch - $mailpopup(acswitch):halt
  .Current Delay - $mailpopup(acdelay) min.:halt
  .Current Display - $mailpopup(acdisplay) window:halt
  AutoDelete
  .On:set %mailad on | set %mailad [ $+ [ %mailusernamenum ] ] on
  .Off:unset %mailad | set %mailad [ $+ [ %mailusernamenum ] ] off
  .-
  .Current Switch - $mailpopup(adswitch):halt
  Signature
  .On:set %mailsign on | set %mailsign [ $+ [ %mailusernamenum ] ] on
  .Off:unset %mailsign | set %mailsign [ $+ [ %mailusernamenum ] ] off
  .-
  .Current Switch - $mailpopup(signswitch):halt
  AutoSave
  .On:set %mailsave on | set %mailsave [ $+ [ %mailusernamenum ] ] on
  .Off:unset %mailsave | set %mailsave [ $+ [ %mailusernamenum ] ] off
  .-
  .Current Switch - $mailpopup(saveswitch):halt
  Debug
  .On:set %maildebug on
  .Off:unset %maildebug
  .-
  .Current Switch - $mailpopup(debugswitch):halt
  -
  Address Book
  .Slot 1 - %mailabook1
  ..Send Mail:set %mailabook %mailabook1 | mailout
  ..Set Address:set %mailabook1 $$?="Enter New E-Mail Address"
  .Slot 2 - %mailabook2
  ..Send Mail:set %mailabook %mailabook2 | mailout
  ..Set Address:set %mailabook2 $$?="Enter New E-Mail Address"
  .Slot 3 - %mailabook3
  ..Send Mail:set %mailabook %mailabook3 | mailout
  ..Set Address:set %mailabook3 $$?="Enter New E-Mail Address"
  .Slot 4 - %mailabook4
  ..Send Mail:set %mailabook %mailabook4 | mailout
  ..Set Address:set %mailabook4 $$?="Enter New E-Mail Address"
  .Slot 5 - %mailabook5
  ..Send Mail:set %mailabook %mailabook5 | mailout
  ..Set Address:set %mailabook5 $$?="Enter New E-Mail Address"
  .Slot 6 - %mailabook6
  ..Send Mail:set %mailabook %mailabook6 | mailout
  ..Set Address:set %mailabook6 $$?="Enter New E-Mail Address"
  .Slot 7 - %mailabook7
  ..Send Mail:set %mailabook %mailabook7 | mailout
  ..Set Address:set %mailabook7 $$?="Enter New E-Mail Address"
  .Slot 8 - %mailabook8
  ..Send Mail:set %mailabook %mailabook8 | mailout
  ..Set Address:set %mailabook8 $$?="Enter New E-Mail Address"
  .Slot 9 - %mailabook9
  ..Send Mail:set %mailabook %mailabook9 | mailout
  ..Set Address:set %mailabook9 $$?="Enter New E-Mail Address"
  .Slot 10 - %mailabook10
  ..Send Mail:set %mailabook %mailabook10 | mailout
  ..Set Address:set %mailabook10 $$?="Enter New E-Mail Address"
  User
  .Current User - %mailusername:halt
  .-
  .Rename User
  ..User 1 - %mailusername1:set %mailusername1 $$?="Enter User Name" | if (%mailusernamenum == 1) { set %mailusername %mailusername1 }
  ..User 2 - %mailusername2:set %mailusername2 $$?="Enter User Name" | if (%mailusernamenum == 2) { set %mailusername %mailusername2 }
  ..User 3 - %mailusername3:set %mailusername3 $$?="Enter User Name" | if (%mailusernamenum == 3) { set %mailusername %mailusername3 }
  ..User 4 - %mailusername4:set %mailusername4 $$?="Enter User Name" | if (%mailusernamenum == 4) { set %mailusername %mailusername4 }
  ..User 5 - %mailusername5:set %mailusername5 $$?="Enter User Name" | if (%mailusernamenum == 5) { set %mailusername %mailusername5 }
  .Load User
  ..User 1 - %mailusername1:mailloaduser 1
  ..User 2 - %mailusername2:mailloaduser 2
  ..User 3 - %mailusername3:mailloaduser 3
  ..User 4 - %mailusername4:mailloaduser 4
  ..User 5 - %mailusername5:mailloaduser 5
  -
  Check for E-Mail:mailin
  Send E-Mail:mailout
}
;EOF (End of File)
