#include <stdio.h>
     
#define TRUE -1
#define FALSE 0
/*
*       This routine does a string compare of s1 to s 
*       it differs from the standard library lookup
*       in that it supports wildcard characters (?, *) 
*       and it returns a boolean result, not a pointer. 
*       ? is a single character wildcard and will match 
*       any character in the same position.
*       * is a 0-n character wildcard 
*/
int gstrcmp(unsigned char *s, unsigned char *s1, int first) 
{
//    int first = TRUE;

    while (*s && *s1)
    {
	if (*s1 == '*')
	{
	    s1++;
	    if (*s1)
		return gstrcmp(s, s1, TRUE);
	    else
		return TRUE;
	}
	else
	    if (first)
	    {
		if (*s == *s1 || *s1 == '?')
		{
		    first = FALSE;
		    s1++;
		}
	    }
	    else
		if (*s != *s1 && *s1 != '?')
		    return FALSE;
		else
		    s1++;
	s++;
    }
    if (!*s && *s1 == '*')
        return TRUE;
    if (*s || *s1)
	return FALSE;
    return TRUE;
}
     
/*
*       This routine does a substring search of s1 in s 
*       it differs from the standard library lookup
*       in that it supports wildcard characters (?, *) 
*       and it returns a boolean result, not a pointer. 
*       ? is a single character wildcard and will match 
*       any character in the same position.
*       * is a 0-n character wildcard 
*/
int gstrscn(unsigned char *s, unsigned char *s1) 
{
    int first = TRUE;
     
    while (*s && *s1)
    {
	if (*s1 == '*')
	{
	    s1++;
	    if (*s1)
	        return gstrscn(s, s1);
	    else
		return TRUE;
	}
	else
	    if (first)
	    {
		if (*s == *s1 || *s1 == '?')
		{
		    first = FALSE;
		    s1++;
		}
	    }
	    else
		if (*s != *s1 && *s1 != '?')
		    return FALSE;
		else
		    s1++;
	s++;
    }
    if (!*s && *s1 == '*')
        return TRUE;
    if (!*s && *s1)
	return FALSE;
    return TRUE;
}

void main(int argc, char **argv)
{
    if (gstrscn(argv[1], argv[2]))
	printf("%s is contained in %s\n", argv[2], argv[1]);
    else
	printf("%s is not contained in %s\n", argv[2], argv[1]);
    if (gstrcmp(argv[1], argv[2], FALSE))
	printf("%s is equivalent to %s\n", argv[2], argv[1]);
    else
	printf("%s is not equivalent to %s\n", argv[2], argv[1]);
}
