/*
 * Project ReD Users Editor
 * iusers.java -- main (and only) users editor class
 * Copyright (C) 1998 Filip Pizlo
 */

import java.io.*;
import java.awt.*;
import java.util.*;

public class iusers extends Frame {
 //static
  public static void main(String[] v) {
   String name="users";
   if (v.length>0) name=v[0];
   iusers fr=new iusers(name);
   fr.show();
  }
 //dynamic
  pizlist allows;
  TextField name,dir;
  Button add,sub,ok,cancel,apply;
  String fname;
  public iusers(String _fname) {
   super("Users Editor");
   setLayout(new FlowLayout());
   setFont(new Font("Serif",Font.PLAIN,14));
   setBackground(Color.lightGray);
   setForeground(Color.black);
   fname=""+_fname;
   allows=new pizlist();
   load();
   name=new TextField("",20);
   dir=new TextField("",20);
   add=new Button("Add");
   sub=new Button("Remove");
   ok=new Button("OK");
   cancel=new Button("Cancel");
   apply=new Button("Apply");
   Panel txt=new Panel(new GridLayout(2,1));
   txt.add(new Label("This program allows you to edit"));
   txt.add(new Label("the user database."));
   Panel north=new Panel(new GridLayout(3,1));
   Panel field1=new Panel();
   field1.add(new Label("Username:"));
   field1.add(name);
   north.add(field1);
   Panel field2=new Panel();
   field2.add(new Label("Directory:"));
   field2.add(dir);
   north.add(field2);
   Panel adrem=new Panel();
   adrem.add(add);
   adrem.add(sub);
   north.add(adrem);
   Panel south=new Panel();
   south.add(ok);
   south.add(cancel);
   south.add(apply);
   add(txt);
   add(north);
   add(allows);
   add(south);
   resize(300,400);
  }
  public void load() {
   String buf;
   try {
    File tfl=new File(fname);
    BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
    while (true) {
     try {
      buf=fin.readLine();
      if (buf==null) break;
      if (buf.charAt(0)!='#') {
       StringTokenizer tox=new StringTokenizer(buf);
       allows.add(tox.nextToken()+" on "+tox.nextToken());
      }
     } catch (Exception e) {}
    }
   } catch (Exception e) {
    System.err.println("Error: "+e);
   }
  }
  public void save() {
   try {
    String[] items=allows.getItems();
    File tfl=new File(fname);
    PrintStream fout=new PrintStream(new FileOutputStream(tfl));
    fout.println("# Users File\n# Generated by iusers.class");
    for (int i=0;i<items.length;i++) {
     StringTokenizer tox=new StringTokenizer(items[i]);
     String line=tox.nextToken();
     tox.nextToken();
     line+=" "+tox.nextToken();
     fout.println(line);
    }
    fout.close();
   } catch (Throwable e) {
    System.err.println("Error: "+e);
   }
  }
  public boolean action(Event ev,Object arg) {
   if (ev.target==add) {
    allows.add(name.getText()+" on "+dir.getText());
    return true;
   }
   if (ev.target==sub) {
    try {
     allows.remove(allows.getSelectedItem());
    } catch (Throwable e) {}
    return true;
   }
   if (ev.target==ok) {
    save();
    dispose();
    return true;
   }
   if (ev.target==cancel) {
    dispose();
    return true;
   }
   if (ev.target==apply) {
    save();
    return true;
   }
   return false;
  }
}

