/*
 * Project ReD
 * centrale.java -- central control and database
 * Copyright (C) 1997-1998 Filip Pizlo
 * This code is under GPL 2.0
 * You must read the README before proceeding!
 */

import java.util.*;
import java.io.*;
import java.net.*;

public class centrale extends jdth implements centbase {
 final int MAXMIMES=50,MAXUSERS=20,MAXVHOST=20,MAXTHS=50,MAXPRALS=50;
 URL CTXURL;
 final String
  USRURL="users",VHSURL="vhosts",CFGURL="config",MIMURL="mimes",
  PRXURL="proxy",ALIURL="alias";
 public static final String 
  VERSION="Red/0.6.8",
  VSTRING="Two percent of zero is almost nothing.",
  CGIVER="CGI/1.1",MIMEVER="1.0",
  CSTRING="Copyright (C) 1997-1998 Filip Pizlo";
 public static String FULLVER=VERSION;
 public ServerSocket serv;
 Socket sock;
 int
  tcnt=0,cidc=0,port=80,cnn,rqn,ern,dcn,ppn,cgn,hdn,pcn,pdn,crn,rxn,pxn,
  psn,srn,timeo=0,adept=1;
 public int mimen=0,usern=0,vhostn=0,rfln=0,praln=0,thn=0;
 public logbase logs;
 public statbase st;
 public boolean
  cgiex=false,cgidr=true,llnode=false,isth=false,proxy=false,pinghack=false,
  remsrv=false,aset=false,srvex=false,srvdr=true,cgiusr=true,srvusr=true,
  dyndnson=false,perlext=false;
 public String
  er400="<h1>Error 400</h1>Bad request",
  er403="<h1>Error 403</h1>Forbidden",
  er404="<h1>Error 404</h1>File not found",
  er502="<h1>Error 502</h1>Could not connect",
  er500="<h1>Error 500</h1>Server error",mdir,
  er302="<h1>Error 302</h1>Location moved";
 public jdth[] ths;
 public String
  hostnm,mimes[],mexts[],usrs[],udirs[],vhsts[],vdirs[],hdir=".",rfl[],
  fcgidr="/cgi-bin/",rcgidr="./cgi-bin/",fsrvdr="/servlet/",
  rsrvdr="./servlets/",prals[],fltrs[],prext,srvdrex=".class",ddlogin="",
  ddpass="",ddhost="",perlcom="";
 public Runtime run;
 public Hashtable srvs,snms,aliases,alitp;
 public centrale() {
  super();
  System.setSecurityManager(new redsecurity());
 }
 public void init() {
  blow=this;
  tid=0;
  makever();
  System.out.println("\n"+FULLVER+" -- "+VSTRING);
  boolean lis=false;
  if (!distro.INFOSTR.equals("null")) {
   System.out.println(distro.INFOSTR);
   lis=true;
  }
  initlogs();
  try {
   CTXURL=new URL(distro.CONFIGURL);
  } catch (Exception e) {
   doh(e,true);
  }
  if (lis) logit(distro.INFOSTR);
  initvars();
  loadprops();
  loadmimes();
  loadusers();
  loadvirts();
  loadprals();
  loadaliases();
  logit("Red initialized!");
 }
 public void servit() {
  start();
 }
 public void run() {
  work();
 }
 protected void work() {		// non-thread work no longer supported
  try {
   try {			// attempt to tell Pizlo that its working!
    pinger ping=null;
    if (pinghack) {
     ping=new pinger(logs,true);
    } else {
     ping=new pinger(logs,false);
    }
    ping.start();
   } catch (Throwable e) {
    doh(e,false);
   }
   if (dyndnson) {
    try {
     dyndns dd=new dyndns(ddlogin,ddpass,ddhost,logs);
     dd.start();
    } catch (Throwable e) {
     doh(e,false);
    }
   }
   serv=new ServerSocket(port);
   queueth tmp,tmp2;
   tmp2=new error(itid(),this);
   aths(tmp2);
   for (int i=1;i<ern;i++) {
    tmp=new error(itid(),this);
    aths(tmp);
    tmp.append(tmp2);
    tmp2=tmp;
   }
   error er=(error)tmp2;
   document dc=null;
   if (dcn>0) {
    tmp2=new document(itid(),this);
    aths(tmp2);
    for (int i=1;i<dcn;i++) {
     tmp=new document(itid(),this);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    dc=(document)tmp2;
   }
   postproc pp=null;
   if (ppn>0) {
    tmp2=new postproc(itid(),this);
    aths(tmp2);
    for (int i=1;i<ppn;i++) {
     tmp=new postproc(itid(),this);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    pp=(postproc)tmp2;
   }
   cgi cg=null;
   if (cgn>0) {
    tmp2=new cgi(itid(),this,pp);
    aths(tmp2);
    for (int i=1;i<cgn;i++) {
     tmp=new cgi(itid(),this,pp);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    cg=(cgi)tmp2;
   }
   servlet sr=null;
   if (srn>0) {
    tmp2=new servlet(itid(),this,er);
    aths(tmp2);
    for (int i=1;i<srn;i++) {
     tmp=new servlet(itid(),this,er);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    sr=(servlet)tmp2;
   }
   proxy rx=null;
   if (rxn>0) {
    tmp2=new proxy(itid(),this,pp);
    aths(tmp2);
    for (int i=1;i<rxn;i++) {
     tmp=new proxy(itid(),this,pp);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    rx=(proxy)tmp2;
   }
   tmp2=new header(itid(),this,er,dc,cg,sr);
   aths(tmp2);
   for (int i=1;i<hdn;i++) {
    tmp=new header(itid(),this,er,dc,cg,sr);
    aths(tmp);
    tmp.append(tmp2);
    tmp2=tmp;
   }
   header hd=(header)tmp2;
   precgi pc=null;
   if (pcn>0) {
    tmp2=new precgi(itid(),this,hd);
    aths(tmp2);
    for (int i=1;i<pcn;i++) {
     tmp=new precgi(itid(),this,hd);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    pc=(precgi)tmp2;
   }
   presrv ps=null;
   if (psn>0) {
    tmp2=new presrv(itid(),this,hd);
    aths(tmp2);
    for (int i=1;i<psn;i++) {
     tmp=new presrv(itid(),this,hd);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    ps=(presrv)tmp2;
   }
   preprox px=null;
   if (pxn>0) {
    tmp2=new preprox(itid(),this,hd,rx);
    aths(tmp2);
    for (int i=1;i<pxn;i++) {
     tmp=new preprox(itid(),this,hd,rx);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    px=(preprox)tmp2;
   }
   predoc pd=null;
   if (pdn>0) {
    tmp2=new predoc(itid(),this,hd);
    aths(tmp2);
    for (int i=1;i<pdn;i++) {
     tmp=new predoc(itid(),this,hd);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    pd=(predoc)tmp2;
   }
   chreq cr=null;
   if (crn>0) {
    tmp2=new chreq(itid(),this,hd,pd,pc,ps);
    aths(tmp2);
    for (int i=1;i<crn;i++) {
     tmp=new chreq(itid(),this,hd,pd,pc,ps);
     aths(tmp);
     tmp.append(tmp2);
     tmp2=tmp;
    }
    cr=(chreq)tmp2;
   }
   tmp2=new request(itid(),this,cr,hd,px);
   aths(tmp2);
   for (int i=1;i<rqn;i++) {
    tmp=new request(itid(),this,cr,hd,px);
    aths(tmp);
    tmp.append(tmp2);
    tmp2=tmp;
   }
   request rq=(request)tmp2;
   for (int i=0;i<cnn;i++) {
    connecth cn=new connecth(itid(),this,rq);
    aths(cn);
    cn.start();
   }
   logit("Suspending central thread");
   suspend();
   goodstop();
  } catch (Exception e) {
   doh(e,true);
  }
 }
 public void goodstop() {
  for (int i=0;i<thn;i++) ths[i].goodstop();
  stop();
 }
 void makever() {
  run=Runtime.getRuntime();
  Properties props=System.getProperties();
//  FULLVER=VERSION+" ("+props.getProperty("os.name","?")+"/"+props.getProperty("os.version","?")+" "+props.getProperty("os.arch","?")+")";
  FULLVER=VERSION+" (";
  String tmp=null;
  try {
   if (File.separatorChar!='\\') throw new Exception("hehe");
   Process vpr=run.exec("c:\\windows\\command.com /c ver");
   DataInputStream fin=new DataInputStream(vpr.getInputStream());
   fin.readLine();
   tmp=fin.readLine().replace('\n',' ').replace('\r',' ');
   FULLVER=FULLVER+tmp+" ";
   fin.close();
   vpr.destroy();
  } catch (Throwable e) {
   tmp=props.getProperty("os.name","?");
   FULLVER=FULLVER+tmp;
   String tmp2=props.getProperty("os.version","?");
   if (tmp.indexOf(' ')<0) FULLVER=FULLVER+"/"+tmp2+" ";
   else FULLVER=FULLVER+" v."+tmp2+" ";
  }
  tmp=props.getProperty("os.arch","?");
  FULLVER=FULLVER+tmp+")";
 }
 void initvars() {
  mimes=new String[MAXMIMES];  
  mexts=new String[MAXMIMES];  
  usrs=new String[MAXUSERS];  
  udirs=new String[MAXUSERS];  
  vhsts=new String[MAXVHOST];  
  vdirs=new String[MAXVHOST];  
  prals=new String[MAXPRALS];
  fltrs=new String[MAXMIMES];
  aliases=new Hashtable();
  alitp=new Hashtable();
  for (int i=0;i<fltrs.length;i++) fltrs[i]=null;
  ths=new jdth[MAXTHS];
  rfl=new String[3];
 }
 void loadmimes() {
  String buf;
  try {
   logit("Loading MIMEs..");
   File tfl=new File("mimes");
   if (!tfl.exists()) {
    logit("MIME file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,MIMURL);
    logit("Download complete");
   } 
   BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
   mimes[0]="text/plain";
   mimes[1]="text/html";
   mimes[2]="text/html";
   mimes[3]="text/html";
   mexts[0]=".txt";
   mexts[1]=".html";
   mexts[2]=".cgi";
   mexts[3]=".srv";
   mimen=4;
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     StringTokenizer tox=new StringTokenizer(buf);
     if (tox.countTokens()>=3) {
      String cmd=tox.nextToken();
      if (cmd.equals("add")) {
       mimes[mimen]=""+tox.nextToken();
       mexts[mimen]=""+tox.nextToken();
       logit("Added: "+mimes[mimen]+" on "+mexts[mimen]);
       mimen++;
      } else if (cmd.equals("filter")) {
       mimes[mimen]=""+tox.nextToken();
       mexts[mimen]=""+tox.nextToken();
       fltrs[mimen]=""+tox.nextToken();
       logit("Added filtered: "+mimes[mimen]+" on "+mexts[mimen]);
       mimen++;
      } else if (cmd.equals("default")) {
       mimes[0]=""+tox.nextToken();
       mexts[0]=""+tox.nextToken();
       logit("Added default: "+mimes[0]+" on "+mexts[0]);
      } else if (cmd.equals("cgi")) {
       mimes[2]=""+tox.nextToken();
       mexts[2]=""+tox.nextToken();
       logit("Added CGI: "+mimes[2]+" on "+mexts[2]);
      } else if (cmd.equals("srv")) {
       mimes[3]=""+tox.nextToken();
       mexts[3]=""+tox.nextToken();
       logit("Added Servlet: "+mimes[3]+" on "+mexts[3]);
      } else if (cmd.equals("html")) {
       mimes[1]=""+tox.nextToken();
       mexts[1]=""+tox.nextToken();
       logit("Added default hypertext: "+mimes[1]+" on "+mexts[1]);
      }
     }
    } catch (Exception e) {}
   } 
   logit("MIMEs loaded.");
  } catch (Exception e) {
   doh(e,true);
  }
 }
 void loadusers() {
  String buf;
  usern=0;
  try {
   logit("Loading Users..");
   File tfl=new File("users");
   if (!tfl.exists()) {
    logit("Users file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,USRURL);
    logit("Download complete");
   } 
   BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     if (buf.charAt(0)!='#') {
      StringTokenizer tox=new StringTokenizer(buf);
      if (tox.countTokens()>=2) {
       usrs[usern]=""+tox.nextToken();
       udirs[usern]=""+tox.nextToken();
       logit("Added: "+usrs[usern]+" on "+udirs[usern]);
       usern++;
      }
     }
    } catch (Exception e) {}
   }
   logit("Users loaded");
  } catch (Exception e) {
   doh(e,false);
  }
 }
 void loadprals() {
  String buf;
  praln=0;
  try {
   logit("Loading Proxy Allows..");
   File tfl=new File("proxy");
   if (!tfl.exists()) {
    logit("Proxy file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,PRXURL);
    logit("Download complete");
   } 
   BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     if (buf.charAt(0)!='#') {
      prals[praln]=""+buf;
      logit("Added: "+prals[praln]);
      praln++;
     }
    } catch (Exception e) {}
   }
   logit("Proxy Allows loaded");
  } catch (Exception e) {
   doh(e,false);
  }
 }
 void loadvirts() {
  String buf;
  try {
   logit("Loading Vhosts..");
   File tfl=new File("vhosts");
   if (!tfl.exists()) {
    logit("Vhost file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,VHSURL);
    logit("Download complete");
   } 
   BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     if (buf.charAt(0)!='#') {
      StringTokenizer tox=new StringTokenizer(buf);
      if (tox.countTokens()>=2) {
       vhsts[vhostn]=""+tox.nextToken();
       vdirs[vhostn]=""+tox.nextToken();
       logit("Added: "+vhsts[vhostn]+" on "+vdirs[vhostn]);
       vhostn++;
      }
     }
    } catch (Exception e) {}
   }
   logit("Vhosts loaded");
  } catch (Exception e) {
   doh(e,false);
  }
 }
 void loadaliases() {
  String buf;
  try {
   logit("Loading Aliases..");
   File tfl=new File("alias");
   if (!tfl.exists()) {
    logit("Alias file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,ALIURL);
    logit("Download complete");
   } 
   BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     if (buf.charAt(0)!='#') {
      StringTokenizer tox=new StringTokenizer(buf);
      if (tox.countTokens()>=2) {
       String bef=tox.nextToken(),aft=tox.nextToken();
       boolean tp=false;
       try {
        if (tox.nextToken().equals("redirect")) tp=true;
       } catch (Throwable e) {}
       aliases.put(bef,aft);
       alitp.put(bef,new Boolean(tp));
       logit("Added: "+bef+" to "+aft);
      }
     }
    } catch (Exception e) {}
   }
   logit("Alias loaded");
  } catch (Exception e) {
   doh(e,false);
  }
 }
 void initlogs() {
  try {
   logs=new logger(this);
   logs.init();
   logit(VERSION+" -- "+VSTRING);
   logit(CSTRING);
   st=new stats();
  } catch (Exception e) {
   doh(e,true);
  }
 }
 void loadprops() {
  String buf,cmd,prm;
  StringTokenizer tox;
  try {
   logit("Loading properties..");
   hostnm=InetAddress.getLocalHost().getHostAddress();
   port=80;
   mdir=System.getProperty("user.dir")+File.separatorChar;
   rfl[0]="index.html";
   rfl[1]="index.cgi";
   rfl[2]="index.txt";
   rfln=3;
   cgidr=false;
   cgiex=true;
   srvdr=false;
   srvex=true;
   fcgidr="/cgi-bin/";
   rcgidr=mdir+fcgidr.replace('/',File.separatorChar);
   fsrvdr="/servlet/";
   rsrvdr=mdir+fsrvdr.replace('/',File.separatorChar);
   srvdrex=".class";
   ern=3;
   dcn=2;
   ppn=1;
   cgn=1;
   perlext=false;
   perlcom="";
   hdn=3;
   pcn=1;
   pdn=2;
   rqn=3;
   cnn=2;
   crn=3;
   rxn=1;
   pxn=1;
   psn=1;
   srn=1;
   prext=".props";
   pinghack=false;
   dyndnson=false;
   timeo=0;
   adept=2;
   File tfl=new File("config");
   if (!tfl.exists()) {
    logit("Config file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,CFGURL);
    logit("Download complete");
   }
   BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
   while (true) {
    buf=fin.readLine();
    if (buf==null) break;
    try {
     int fsp=buf.indexOf(' ');
     if (fsp<0) {
      cmd=buf;
      prm=null;
     } else {
      cmd=buf.substring(0,fsp);
      prm=buf.substring(fsp+1,buf.length());
     }
     if (cmd.equals("port")) {
      port=Integer.parseInt(prm);
      logit("Port set to "+port);
     } else if (cmd.equals("timeout")) {
      timeo=Integer.parseInt(prm);
      logit("Timeout set to "+timeo);
     } else if (cmd.equals("aldepth")) {
      adept=Integer.parseInt(prm);
      logit("Alias depth set to "+adept);
     } else if (cmd.equals("er400")) {
      er400=""+prm;
      logit("Error file 400 set to "+prm);
     } else if (cmd.equals("er403")) {
      er403=""+prm;
      logit("Error file 403 set to "+prm);
     } else if (cmd.equals("er302")) {
      er302=""+prm;
      logit("Error file 302 set to "+prm);
     } else if (cmd.equals("er404")) {
      er404=""+prm;
      logit("Error file 404 set to "+prm);
     } else if (cmd.equals("er500")) {
      er500=""+prm;
      logit("Error file 500 set to "+prm);
     } else if (cmd.equals("er502")) {
      er502=""+prm;
      logit("Error file 502 set to "+prm);
     } else if (cmd.equals("hostnm")) {
      hostnm=""+prm;
      aset=true;
      logit("My hostname set to "+prm);
     } else if (cmd.equals("propext")) {
      prext=""+prm;
      logit("Properties extension set to "+prm);
     } else if (cmd.equals("classext")) {
      srvdrex=""+prm;
      logit("Default class extension set to "+prm);
     } else if (cmd.equals("index")) {
      StringTokenizer tox2=new StringTokenizer(prm);
      rfln=0;
      while (tox2.hasMoreTokens()) {
       rfl[rfln]=""+tox2.nextToken();
       rfln++;
      }
      logit("Root indexes set to "+prm);
     } else if (cmd.equals("pipeline")) {
      llnode=false;
      StringTokenizer tox2=new StringTokenizer(prm);
      ern=Integer.parseInt(tox2.nextToken());
      dcn=Integer.parseInt(tox2.nextToken());
      ppn=Integer.parseInt(tox2.nextToken());
      cgn=Integer.parseInt(tox2.nextToken());
      srn=Integer.parseInt(tox2.nextToken());
      rxn=Integer.parseInt(tox2.nextToken());
      hdn=Integer.parseInt(tox2.nextToken());
      pcn=Integer.parseInt(tox2.nextToken());
      pdn=Integer.parseInt(tox2.nextToken());
      psn=Integer.parseInt(tox2.nextToken());
      pxn=Integer.parseInt(tox2.nextToken());
      rqn=Integer.parseInt(tox2.nextToken());
      crn=Integer.parseInt(tox2.nextToken());
      cnn=Integer.parseInt(tox2.nextToken());
      logit("Pipeline set to "+prm);
     } else if (cmd.equals("remsrv")) {
      remsrv=Boolean.valueOf(prm).booleanValue();
      if (remsrv) {
       srvs=new Hashtable();
       snms=new Hashtable();
      }
      logit("Servlet remembering set to "+remsrv);
     } else if (cmd.equals("dyndnsset")) {
      StringTokenizer tox2=new StringTokenizer(prm);
      ddlogin=tox2.nextToken();
      ddpass=tox2.nextToken();
      ddhost=tox2.nextToken();
      logit("DynDNS setup as "+prm);
     } else if (cmd.equals("perlext")) {
      perlext=Boolean.valueOf(prm).booleanValue();
      logit("PERL Extensions set to "+prm);
     } else if (cmd.equals("perlcom")) {
      perlcom=""+prm;
      logit("PERL command set to "+prm);
     } else if (cmd.equals("dyndns")) {
      dyndnson=Boolean.valueOf(prm).booleanValue();
      logit("DynDNS set to "+prm);
     } else if (cmd.equals("pinghack")) {
      pinghack=Boolean.valueOf(prm).booleanValue();
      logit("Ping Hack set to "+prm);
     } else if (cmd.equals("cgiusr")) {
      cgiusr=Boolean.valueOf(prm).booleanValue();
      logit("CGI for users set to "+prm);
     } else if (cmd.equals("srvusr")) {
      srvusr=Boolean.valueOf(prm).booleanValue();
      logit("CGI for users set to "+prm);
     } else if (cmd.equals("cgidir")) {
      cgidr=Boolean.valueOf(prm).booleanValue();
      logit("CGI by directory set to "+cgidr);
     } else if (cmd.equals("cgiext")) {
      cgiex=Boolean.valueOf(prm).booleanValue();
      logit("CGI by extension set to "+cgiex);
     } else if (cmd.equals("srvdir")) {
      srvdr=Boolean.valueOf(prm).booleanValue();
      logit("Servlet by directory set to "+srvdr);
     } else if (cmd.equals("srvext")) {
      srvex=Boolean.valueOf(prm).booleanValue();
      logit("Servlet by extension set to "+srvex);
     } else if (cmd.equals("mdir")) {
      mdir=""+prm;
      if (File.separatorChar=='\\') mdir=mdir.replace('/','\\');
      else if (File.separatorChar=='/') mdir=mdir.replace('\\','/');
      logit("Main directory set to "+prm);
     } else if (cmd.equals("setcgidir")) {
      StringTokenizer tox2=new StringTokenizer(prm);
      fcgidr=tox2.nextToken();
      rcgidr=tox2.nextToken();
      logit("CGI directory set to "+fcgidr+" on "+rcgidr);
     } else if (cmd.equals("setsrvdir")) {
      StringTokenizer tox2=new StringTokenizer(prm);
      fsrvdr=tox2.nextToken();
      rsrvdr=tox2.nextToken();
      logit("Servlet directory set to "+fsrvdr+" on "+rsrvdr);
     } else if (cmd.equals("proxy")) {
      proxy=Boolean.valueOf(prm).booleanValue();
      logit("Proxy "+(proxy?"Enabled":"Dissabled"));
     } else if (cmd.equals("stats")) {
      if (Boolean.valueOf(prm).booleanValue()) {
       logit("Enabling kewl Stats");
       st=new kewlstats(logs);
      } else logit("Stats still null");
     } else if (cmd.equals("logs")) {
      if (!Boolean.valueOf(prm).booleanValue()) {
       logit("Dissabling logs");
       logs=new badlog((logger)logs);
      } else logit("Logs still active");
     } 
    } catch (Exception e) {}
   }
   File mdirf=new File(mdir);
   if (!mdirf.exists()) mdirf.mkdir();
   logit("Properties loaded");
  } catch (Exception e) {
   doh(e,true);
  }
 }
 public int whatmime(String flnm) {
  int i;
  for (i=0;i<mimen;i++) if (flnm.endsWith(mexts[i])) return i;
  return 0;
 }
 public int whatvirt(String hst) {
  int i;
  for (i=0;i<vhostn;i++) if (hst.equals(vhsts[i])) return i;
  return -1;
 }
 public int whatuser(String usr) {
  int i;
  for (i=0;i<usern;i++) if (usr.equals(usrs[i])) return i;
  return -1;
 }
 public boolean prallowed(String prc) {
  int i;
  for (i=0;i<praln;i++) if (prc.equals(prals[i])) return true;
  return false;
 }
 public int itid() {
  tcnt++;
  return tcnt;
 }
 void aths(jdth th) {
  ths[thn]=th;
  thn++;
 }
}

