import java.awt.*;
import java.io.*;

public class advancedPipelineDlg extends Dialog {
	public java.awt.Label	   lbls[]=new java.awt.Label[14];
	public java.awt.TextField txts[]=new java.awt.TextField[14];
	
	java.awt.Choice cboPipe;
	java.awt.Button comOK;
	java.awt.Button comCancel;

	int SPACING=24;
	int CBOWIDTH=240;
	int TXTLEFT=CBOWIDTH/4;
	int TXTLONGWIDTH=60;
	int CHKLEFT=10;
	int CHKWIDTH=CBOWIDTH/4-15;
	int TOPLBL=CHKLEFT+SPACING+4;
	int BUTTONHEIGHT=21;
	int BUTTONWIDTH=63;
	int FORMSCALEWIDTH=insets().left+insets().right+CHKLEFT*2+CBOWIDTH;
	int FORMSCALEHEIGHT=insets().top+insets().bottom+CHKLEFT+TOPLBL+8*SPACING+BUTTONHEIGHT;
	int txtht=15;

	public final static int OKCLICKED=1;
	public final static int CANCELCLICKED=2;
	public int ButtonPushed;
	
	private String m_strPipe;
	String GetPipeStr() {
		return m_strPipe;
	}
	void SetPipeStr(String newPipeStr) {
		if (newPipeStr.length()!=27) {
			System.out.println(newPipeStr);
			System.out.println("String not correct length.");
			return;
		}
		m_strPipe=newPipeStr;
		cboPipe.select(visconfig.GetPipelineString(m_strPipe));
		if (m_strPipe!=null) {
			int Index;
			for(Index=0;Index<14;Index++) {
				txts[Index].setText(m_strPipe.substring((Index*2),(Index*2+1)));
			}
		}
	}

	void InitLblTxt(int Index, String cap, int col) {
		int chkTop=SPACING*(Index-((col-1)*7))+TOPLBL;

		lbls[Index]=new java.awt.Label(cap);
		txts[Index]=new java.awt.TextField();
		
		lbls[Index].reshape(insets().left + CHKLEFT+((col-1)*(CBOWIDTH/2)),insets().top + chkTop,CHKWIDTH,txtht);
		lbls[Index].setAlignment(Label.RIGHT);
		add(lbls[Index]);
		
//		String str=visconfig.parms[visconfig.PIPELINE].GetValue();
		txts[Index].setText(m_strPipe.substring((Index*2),(Index*2+1)));
		txts[Index].enable();
		txts[Index].reshape(insets().left + TXTLEFT+((col-1)*(CBOWIDTH/2)),insets().top + chkTop-2,TXTLONGWIDTH,txtht+5);
		add(txts[Index]);
	}

	advancedPipelineDlg(Frame parent, boolean modal, String pStr) {

		super(parent, modal);

		if (File.separatorChar=='/') {
			// unix visual settings
			SPACING=30;
			CBOWIDTH=290;
			TXTLEFT=CBOWIDTH/4;
			TXTLONGWIDTH=80;
			CHKLEFT=15;
			CHKWIDTH=CBOWIDTH/4-15;
			TOPLBL=CHKLEFT+SPACING+4;
			BUTTONHEIGHT=21;
			BUTTONWIDTH=63;
			txtht=25;
		}

		FORMSCALEWIDTH=insets().left+insets().right+CHKLEFT*2+CBOWIDTH;
		FORMSCALEHEIGHT=insets().top+insets().bottom+CHKLEFT+TOPLBL+8*SPACING+BUTTONHEIGHT;
		
		m_strPipe=pStr;

		setLayout(null);
		addNotify();
		resize(FORMSCALEWIDTH,FORMSCALEHEIGHT);

		setBackground(new Color(12632256));

		cboPipe=new java.awt.Choice();
		InitCboPipe();

//		 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13
// init er,dc,pp,cg,sr,rx,hd,pc,pd,ps,px,rq,cr,cn
		InitLblTxt(0,"er=",1);
		InitLblTxt(1,"dc=",1);
		InitLblTxt(2,"pp=",1);
		InitLblTxt(3,"cg=",1);
		InitLblTxt(4,"sr=",1);
		InitLblTxt(5,"rx=",1);
		InitLblTxt(6,"hd=",1);
		InitLblTxt(7,"pc=",2);
		InitLblTxt(8,"pd=",2);
		InitLblTxt(9,"ps=",2);
		InitLblTxt(10,"px=",2);
		InitLblTxt(11,"rq=",2);
		InitLblTxt(12,"cr=",2);
		InitLblTxt(13,"cn=",2);

		comOK=new java.awt.Button("OK");
		comCancel=new java.awt.Button("Cancel");
		comOK.reshape(FORMSCALEWIDTH - 2*(CHKLEFT+BUTTONWIDTH),FORMSCALEHEIGHT - (CHKLEFT+BUTTONHEIGHT),BUTTONWIDTH,BUTTONHEIGHT);
		add(comOK);
		comCancel.reshape(FORMSCALEWIDTH - 1*(CHKLEFT+BUTTONWIDTH),FORMSCALEHEIGHT - (CHKLEFT+BUTTONHEIGHT),BUTTONWIDTH,BUTTONHEIGHT);
		add(comCancel);

		cboPipe_Action();

		setTitle("Advanced Pipeline Setup");
		setResizable(false);
	}
	advancedPipelineDlg(Frame parent, boolean modal, String pStr,String title) {
		this(parent,modal,pStr);
		setTitle(title);
	}
	void InitCboPipe() {
		cboPipe.addItem("Default");
		cboPipe.addItem("Default, No Servlet support");
		cboPipe.addItem("Large Server, No CGI or proxy support");
		cboPipe.addItem("Server with CGI but no proxy support");
		cboPipe.addItem("Server with CGI and proxy support");
		cboPipe.addItem("Server with proxy support only");
		cboPipe.addItem("Other");
		cboPipe.select(visconfig.GetPipelineString(m_strPipe));
		cboPipe.enable();
		cboPipe.reshape(insets().left + CHKLEFT,insets().top + CHKLEFT,CBOWIDTH,20);
		add(cboPipe);
	}

	public synchronized void show() {
		Rectangle bounds = getParent().getBounds();
		Rectangle abounds = getBounds();

		setLocation(bounds.x + (bounds.width - abounds.width)/ 2, bounds.y + (bounds.height - abounds.height)/2);

		super.show();
	}
	
	public boolean handleEvent(Event event) {
		if(event.id == Event.WINDOW_DESTROY) {
			//do cancel action if clicked x
			return comCancel_Action(event);
		}
		if (event.target instanceof TextField) {
			int i;
			if (event.id==Event.LOST_FOCUS || (event.id==Event.KEY_RELEASE && event.key>='0' && event.key<='9') || event.id==Event.GOT_FOCUS) {
				for(i=0;i<14;i++)
					if (event.target==txts[i]) 
						return txts_Action(i,event);
			}
		}
		return super.handleEvent(event);
	}		

	public boolean action(Event event, Object arg) {
		if (event.target instanceof Button) {
			String label =(String)arg;
			if (label.equalsIgnoreCase("OK")) 
				return (comOK_Action(event));
			else if (label.equalsIgnoreCase("Cancel")) 
				return (comCancel_Action(event));
		}
		if (event.target instanceof Choice) {
			String label=(String)arg;
			cboPipe_Action(event);
			return true;
		}
				
		return super.action(event, arg);
	}
	
	boolean txts_Action(int Index, Event e) {
		if (e.id==Event.GOT_FOCUS) {
			txts[Index].selectAll();
			return true;
		}
		else {
			if (Integer.valueOf(txts[Index].getText()).intValue()>9)
				txts[Index].setText("9");
			if (Integer.valueOf(txts[Index].getText()).intValue()<0)
				txts[Index].setText("0");

			int selstart=txts[Index].getSelectionStart();
			if (Index==0)
				SetPipeStr(txts[0].getText()+m_strPipe.substring(1));
			else if (Index<13)
				SetPipeStr(m_strPipe.substring(0,(Index-1)*2+2)+txts[Index].getText()+m_strPipe.substring(Index*2+1));
			else
				SetPipeStr(m_strPipe.substring(0,(Index-1)*2+2)+txts[Index].getText());
			txts[Index].select(selstart,selstart);
			return true;
		}
	}

		
	boolean comOK_Action(Event e) {
		int i;
		int total=0;
		
		for(i=0;i<14;i++)
			total+=Integer.valueOf(txts[i].getText()).intValue();
		if (total<=50) {
			ButtonPushed=OKCLICKED;
			hide();
		}
		else {
			System.out.println("Total number of pipes must be less than or equal to 50");
		}
		return true;
	}

	boolean comCancel_Action(Event e) {
		ButtonPushed=CANCELCLICKED;
		hide();
		return true;
	}
	
	void cboPipe_Action(Event e) {
		cboPipe_Action();
	}
	void cboPipe_Action() {
//		System.out.println("Setting choPipeline");
//		System.out.println(choPipeline.getSelectedIndex());
//		System.out.println(GetPipelineNumbers(choPipeline.getSelectedItem()));
		if (!cboPipe.getSelectedItem().equalsIgnoreCase("other"))
		{
			SetPipeStr(visconfig.GetPipelineNumbers(cboPipe.getSelectedItem()));
		}
	}
}
