/*
 * Project ReD
 * centrale.java -- central control and database
 * Copyright (C) Filip Pizlo 1997
 * This code is under GPL 2.0
 * You must read the README before proceeding!
 */

import java.util.*;
import java.io.*;
import java.net.*;

class centrale extends jdth {
 int MAXMIMES=50,MAXUSERS=20,MAXVHOST=20;
 URL CTXURL;
 String USRURL="users",VHSURL="vhosts",CFGURL="config",MIMURL="mimes";
 public static String VERSION="Red/0.2.7",VSTRING="God is an atheist.",CGIVER="CGI/1.1";
 public ServerSocket serv;
 Socket sock;
 int tcnt=0,port=80;
 public int mimen=0,usern=0,vhostn=0,rfln=0;
 PrintStream log,errlog=System.err,reqlog,cntlog;
 PipedOutputStream badcntlog;
 public boolean cnton=true,cgiex=false,cgidr=true;
 public String er400="<h1>Error 400</h1>Bad request",er404="<h1>Error 404</h1>File not found",er500="<h1>Error 500</h1>Server error",mdir;
 public String hostnm,mimes[],mexts[],usrs[],udirs[],vhsts[],vdirs[],hdir=".",rfl[],fcgidr="/cgi-bin/",rcgidr="./cgi-bin/";
 public centrale() {
  super();
  blow=this;
  tid=0;
  System.out.println(VERSION+" -- "+VSTRING);
  boolean lis=false;
  if (!distro.INFOSTR.equals("null")) {
   System.out.println(distro.INFOSTR);
   lis=true;
  }
  try {
   CTXURL=new URL(distro.CONFIGURL);
  } catch (Exception e) {
   doh(e,true);
  }
  mimes=new String[MAXMIMES];  
  mexts=new String[MAXMIMES];  
  usrs=new String[MAXUSERS];  
  udirs=new String[MAXUSERS];  
  vhsts=new String[MAXVHOST];  
  vdirs=new String[MAXVHOST];  
  rfl=new String[3];
  initlogs();
  if (lis) logit(distro.INFOSTR);
  loadprops();
  loadmimes();
  loadusers();
  loadvirts();
  logit("Red initialized!");
 }
 public void run() {
  work();
 }
 public void work() {
  try {
   serv=new ServerSocket(port);
   while (true) {
    try {
     sock=serv.accept();
     tcnt++;
     new request(this,sock,tcnt);
     sock=null;
    } catch (Exception e) {
     doh(e,false);
    }
   }
  } catch (Exception e) {
   doh(e,true);
  }
 }
 public void goodstop() {
  System.exit(0);
 }
 void loadmimes() {
  String buf;
  try {
   logit("Loading MIMEs..");
   File tfl=new File("mimes");
   if (!tfl.exists()) {
    logit("MIME file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,MIMURL);
    logit("Download complete");
   } 
   DataInputStream fin=new DataInputStream(new FileInputStream(tfl));
   mimes[0]="text/plain";
   mimes[1]="text/html";
   mimes[2]="text/html";
   mexts[0]=".txt";
   mexts[1]=".html";
   mexts[2]=".cgi";
   mimen=3;
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     StringTokenizer tox=new StringTokenizer(buf);
     if (tox.countTokens()>=3) {
      String cmd=tox.nextToken();
      if (cmd.equals("add")) {
       mimes[mimen]=""+tox.nextToken();
       mexts[mimen]=""+tox.nextToken();
       logit("Added: "+mimes[mimen]+" on "+mexts[mimen]);
       mimen++;
      } else if (cmd.equals("default")) {
       mimes[0]=""+tox.nextToken();
       mexts[0]=""+tox.nextToken();
       logit("Added default: "+mimes[0]+" on "+mexts[0]);
      } else if (cmd.equals("cgi")) {
       mimes[2]=""+tox.nextToken();
       mexts[2]=""+tox.nextToken();
       logit("Added CGI: "+mimes[2]+" on "+mexts[2]);
      } else if (cmd.equals("html")) {
       mimes[1]=""+tox.nextToken();
       mexts[1]=""+tox.nextToken();
       logit("Added default hypertext: "+mimes[1]+" on "+mexts[1]);
      }
     }
    } catch (Exception e) {}
   } 
   logit("MIMEs loaded.");
  } catch (Exception e) {
   doh(e,true);
  }
 }
 void loadusers() {
  String buf;
  try {
   logit("Loading Users..");
   File tfl=new File("users");
   if (!tfl.exists()) {
    logit("Users file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,USRURL);
    logit("Download complete");
   } 
   DataInputStream fin=new DataInputStream(new FileInputStream(tfl));
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     if (buf.charAt(0)!='#') {
      StringTokenizer tox=new StringTokenizer(buf);
      if (tox.countTokens()>=2) {
       usrs[usern]=""+tox.nextToken();
       udirs[usern]=""+tox.nextToken();
       logit("Added: "+usrs[usern]+" on "+udirs[usern]);
       usern++;
      }
     }
    } catch (Exception e) {}
   }
   logit("Users loaded");
  } catch (Exception e) {
   doh(e,false);
  }
 }
 void loadvirts() {
  String buf;
  try {
   logit("Loading Vhosts..");
   File tfl=new File("vhosts");
   if (!tfl.exists()) {
    logit("Vhost file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,VHSURL);
    logit("Download complete");
   } 
   DataInputStream fin=new DataInputStream(new FileInputStream(tfl));
   while (true) {
    try {
     buf=fin.readLine();
     if (buf==null) break;
     if (buf.charAt(0)!='#') {
      StringTokenizer tox=new StringTokenizer(buf);
      if (tox.countTokens()>=2) {
       vhsts[vhostn]=""+tox.nextToken();
       vdirs[vhostn]=""+tox.nextToken();
       logit("Added: "+vhsts[vhostn]+" on "+vdirs[vhostn]);
       vhostn++;
      }
     }
    } catch (Exception e) {}
   }
   logit("Vhosts loaded");
  } catch (Exception e) {
   doh(e,false);
  }
 }
 void initlogs() {
  try {
   log=new PrintStream(new FileOutputStream("main.log"));
   logit(VERSION+" -- "+VSTRING);
   logit("Copyright (C) 1997 Filip Pizlo");
   logit("Openning Connection/Request log");
   reqlog=new PrintStream(new FileOutputStream("request.log"));
   logit("Openned successfully.");
  } catch (Exception e) {
   doh(e,true);
  }
 }
 void loadprops() {
  String buf,cmd,prm;
  StringTokenizer tox;
  try {
   logit("Loading properties..");
   hostnm=InetAddress.getLocalHost().getHostAddress();
   port=80;
   mdir=System.getProperty("user.dir")+File.separatorChar;
   rfl[0]="index.html";
   rfl[1]="index.cgi";
   rfl[2]="index.txt";
   rfln=3;
   cgidr=false;
   cgiex=true;
   fcgidr=""+File.separatorChar+"cgi-bin"+File.separatorChar;
   rcgidr=mdir+fcgidr;
   File tfl=new File("config");
   if (!tfl.exists()) {
    logit("Config file doesn't exist, downloading it");
    start.txtdownload(tfl,CTXURL,CFGURL);
    logit("Download complete");
   }
   DataInputStream fin=new DataInputStream(new FileInputStream(tfl));
   while (true) {
    buf=fin.readLine();
    if (buf==null) break;
    try {
     int fsp=buf.indexOf(' ');
     if (fsp<0) throw new Exception("Improperly formatted config!");
     cmd=buf.substring(0,fsp);
     prm=buf.substring(fsp+1,buf.length());
     if (cmd.equals("port")) {
      port=Integer.parseInt(prm);
      logit("Port set to "+port);
     } else if (cmd.equals("er400")) {
      er400=""+prm;
      logit("Error file 400 set to "+prm);
     } else if (cmd.equals("er404")) {
      er404=""+prm;
      logit("Error file 404 set to "+prm);
     } else if (cmd.equals("er500")) {
      er500=""+prm;
      logit("Error file 500 set to "+prm);
     } else if (cmd.equals("hostnm")) {
      hostnm=""+prm;
      logit("My hostname set to "+prm);
     } else if (cmd.equals("index")) {
      StringTokenizer tox2=new StringTokenizer(prm);
      rfln=0;
      while (tox2.hasMoreTokens()) {
       rfl[rfln]=""+tox2.nextToken();
       rfln++;
      }
      logit("Root indexes set to "+prm);
     } else if (cmd.equals("cgimode")) {
      if (prm.indexOf('e')<0) cgiex=false;
      else cgiex=true;
      if (prm.indexOf('d')<0) cgidr=false;
      else cgidr=true;
      logit("CGI modes set to "+(cgiex?"e":"")+(cgidr?"d":""));
     } else if (cmd.equals("mdir")) {
      mdir=""+prm;
      logit("Main directory set to "+prm);
     } else if (cmd.equals("cgidir")) {
      StringTokenizer tox2=new StringTokenizer(prm);
      fcgidr=tox2.nextToken();
      rcgidr=tox2.nextToken();
      logit("CGI directory set to "+fcgidr+" on "+rcgidr);
     } else if (cmd.equals("nocnt")) {
      cnton=false;
      logit("Counter dissabled");
     } else if (cmd.equals("nolog")) {
      logit("Dissabling logs");
      log.close();
      log=new PrintStream(new FileOutputStream(File.separatorChar=='/'?"/dev/null":"NULL"));
     } 
    } catch (Exception e) {}
   }
   logit("Properties loaded");
  } catch (Exception e) {
   doh(e,true);
  }
 }
 public int whatmime(String flnm) {
  int i;
  for (i=0;i<mimen;i++) if (flnm.endsWith(mexts[i])) return i;
  return 0;
 }
 public int whatvirt(String hst) {
  int i;
  for (i=0;i<vhostn;i++) if (hst.equals(vhsts[i])) return i;
  return -1;
 }
 public int whatuser(String usr) {
  int i;
  for (i=0;i<usern;i++) if (usr.equals(usrs[i])) return i;
  return -1;
 }
}

