/*
 * Visual Configuration
 * visconfig.java -- visual configuration class
 * Copyright (C) 1998 Filip Pizlo
 */

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class visconfig extends Frame implements ActionListener, ItemListener, Runnable {
 //static
  public static void main(String[] v) {
   visconfig blow=new visconfig();
   blow.show();
  }
 //dynamic
  public Panel main;
  public CardLayout mainc;
  List stuff;
  Button ok,cancel,apply,mimes,vhosts,proxy,users,alias;
  Panel rsrvp,srvp,cgip,srvdp,cgidp,ddp,ptf;
  TextField port,hostnm,index[],cgifdir,cgirdir,srvfdir,srvrdir,srvextf,propext,mdir,adept,timeout,ddlogin,ddpass,ddhost,prop,perlcom;
  Checkbox cgidir,cgiext,srvdir,srvext,logs,proxye,cgien,srven,remsrv,stats,cgiusr,srvusr,pinghack,ddon,perlext;
  Thread dostuff;
  String er400,er403,er404,er500,er502,er302;
  public visconfig() {
   super("Visual Configuration for Red");
   setFont(new Font("Serif",Font.PLAIN,14));
   setForeground(Color.black);
   setBackground(Color.lightGray);
   setLayout(new BorderLayout());
   stuff=new List();
   stuff.addItemListener(this);
   ok=new Button("OK");
   ok.addActionListener(this);
   cancel=new Button("Cancel");
   cancel.addActionListener(this);
   apply=new Button("Apply");
   apply.addActionListener(this);
   mainc=new CardLayout();
   main=new Panel(mainc);
   Panel dbutts=new Panel();
   Panel butts=new Panel(new GridLayout(1,3));
   butts.add(ok);
   butts.add(cancel);
   butts.add(apply);
   dbutts.add(butts);
   Panel defpan=new Panel();
   Panel dftxt1=new Panel(new GridLayout(5,1));
   dftxt1.add(new Label("This program is intended to allow you"));
   dftxt1.add(new Label("to edit the configuration settings."));
   dftxt1.add(new Label("Select the categories of interest from"));
   dftxt1.add(new Label("the left, and pages will pop up that"));
   dftxt1.add(new Label("will let you edit them."));
   defpan.add(dftxt1);
   main.add("Introduction",defpan);
   stuff.add("Introduction",0);
   Panel hostset=new Panel();
   Panel hstxt1=new Panel(new GridLayout(3,1));
   hstxt1.add(new Label("Here are the most basic settings.  Make"));
   hstxt1.add(new Label("sure that these are what you want."));
   hostset.add(hstxt1);
   Panel portp=new Panel();
   portp.add(new Label("Port:"));
   port=new TextField("80",10);
   portp.add(port);
   hostset.add(portp);
   Panel hostp=new Panel();
   hostp.add(new Label("Hostname:"));
   hostnm=new TextField("myname.my.domain.org",20);
   hostp.add(hostnm);
   hostset.add(hostp);
   main.add("Host Settings",hostset);
   stuff.add("Host Settings",1);
   Panel indop=new Panel();
   Panel iotxt1=new Panel(new GridLayout(4,1));
   iotxt1.add(new Label("This is for setting the index search"));
   iotxt1.add(new Label("order.  You should not have to change"));
   iotxt1.add(new Label("this."));
   indop.add(iotxt1);
   Panel iofls=new Panel(new GridLayout(3,1));
   index=new TextField[3];
   for (int i=0;i<3;i++) {
    index[i]=new TextField("",20);
    iofls.add(index[i]);
   }
   index[0].setText("index.html");
   index[1].setText("index.srv");
   index[2].setText("index.cgi");
   indop.add(iofls);
   main.add("Search Order",indop);
   stuff.add("Search Order",2);
   Panel cgiset=new Panel();
   Panel cstxt1=new Panel(new GridLayout(3,1));
   cstxt1.add(new Label("This allows you to setup Red's CGI"));
   cstxt1.add(new Label("support.  Enjoy..."));
   cgiset.add(cstxt1);
   Panel cgienp=new Panel();
   cgienp.add(new Label("CGI Scripts:"));
   cgien=new Checkbox("Enabled",true);
   cgien.addItemListener(this);
   cgienp.add(cgien);
   cgiset.add(cgienp);
   cgip=new Panel(new GridLayout(3,1));
   cgidir=new Checkbox("by Directory",false);
   cgidir.addItemListener(this);
   cgiext=new Checkbox("by Extension",true);
   cgip.add(new Label("CGI:"));
   Panel cdip=new Panel(new BorderLayout());
   cdip.add("West",cgidir);
   Panel ceip=new Panel(new BorderLayout());
   ceip.add("West",cgiext);
   cgip.add(cdip);
   cgip.add(ceip);
   cgiset.add(cgip);
   main.add("CGI Settings",cgiset);
   stuff.add("CGI Settings",3);
   cgidp=new Panel();
   Panel cdtxt1=new Panel(new GridLayout(3,1));
   cdtxt1.add(new Label("These settings are for the CGI-by-"));
   cdtxt1.add(new Label("directory loading feature, which"));
   cdtxt1.add(new Label("simulates old-style CGI support"));
   cgidp.add(cdtxt1);
   Panel cds=new Panel(new GridLayout(3,1));
   cds.add(new Label("CGI Directories:"));
   Panel cfdirpp=new Panel();
   cfdirpp.add(new Label("Virtual:"));
   cgifdir=new TextField("/cgi-bin/",20);
   cfdirpp.add(cgifdir);
   Panel crdirpp=new Panel();
   crdirpp.add(new Label("Real:"));
   cgirdir=new TextField("./cgi-bin/",20);
   crdirpp.add(cgirdir);
   Panel cfdirp=new Panel(new BorderLayout());
   cfdirp.add("East",cfdirpp);
   Panel crdirp=new Panel(new BorderLayout());
   crdirp.add("East",crdirpp);
   cds.add(cfdirp);
   cds.add(crdirp);
   cgidp.add(cds);
   main.add("CGI Paths",cgidp);
   Panel srvset=new Panel();
   Panel sstxt1=new Panel(new GridLayout(2,1));
   sstxt1.add(new Label("This allows you to setup Red's Servlet"));
   sstxt1.add(new Label("support.  Enjoy..."));
   srvset.add(sstxt1);
   Panel srvenp=new Panel();
   srvenp.add(new Label("Servlet Extensions:"));
   srven=new Checkbox("Enabled",true);
   srven.addItemListener(this);
   srvenp.add(srven);
   srvset.add(srvenp);
   srvp=new Panel(new GridLayout(3,1));
   srvdir=new Checkbox("by Directory",false);
   srvdir.addItemListener(this);
   srvext=new Checkbox("by Extension",true);
   srvp.add(new Label("Servlets:"));
   Panel sdip=new Panel(new BorderLayout());
   sdip.add("West",srvdir);
   Panel seip=new Panel(new BorderLayout());
   seip.add("West",srvext);
   srvp.add(sdip);
   srvp.add(seip);
   srvset.add(srvp);
   rsrvp=new Panel();
   rsrvp.add(new Label("Remeber servlets:"));
   remsrv=new Checkbox("Enabled",false);
   rsrvp.add(remsrv);
   srvset.add(rsrvp);
   main.add("Servlet Settings",srvset);
   stuff.add("Servlet Settings",5);
   srvdp=new Panel();
   Panel sdtxt1=new Panel(new GridLayout(3,1));
   sdtxt1.add(new Label("These settings are for the Servlet-by-"));
   sdtxt1.add(new Label("directory loading feature, which"));
   sdtxt1.add(new Label("simulates Sun-style Servlet support"));
   srvdp.add(sdtxt1);
   Panel sds=new Panel(new GridLayout(3,1));
   sds.add(new Label("Servlet Directories:"));
   Panel sfdirpp=new Panel();
   sfdirpp.add(new Label("Virtual:"));
   srvfdir=new TextField("/servlet/",20);
   sfdirpp.add(srvfdir);
   Panel srdirpp=new Panel();
   srdirpp.add(new Label("Real:"));
   srvrdir=new TextField("./servlet/",20);
   srdirpp.add(srvrdir);
   Panel sfdirp=new Panel(new BorderLayout());
   sfdirp.add("East",sfdirpp);
   Panel srdirp=new Panel(new BorderLayout());
   srdirp.add("East",srdirpp);
   sds.add(sfdirp);
   sds.add(srdirp);
   srvdp.add(sds);
   main.add("Servlet Paths",srvdp);
   Panel claset=new Panel();
   Panel cltxt1=new Panel(new GridLayout(3,1));
   cltxt1.add(new Label("Red has a flexible ClassLoader, which"));
   cltxt1.add(new Label("is used for things like filters and"));
   cltxt1.add(new Label("servlets.  Here are some options:"));
   claset.add(cltxt1);
   Panel ldext=new Panel(new GridLayout(3,1));
   ldext.add(new Label("Extensions:"));
   srvextf=new TextField(".class",10);
   propext=new TextField(".props",10);
   Panel sefpp=new Panel();
   sefpp.add(new Label("Default class:"));
   sefpp.add(srvextf);
   Panel prepp=new Panel();
   prepp.add(new Label("Properties:"));
   prepp.add(propext);
   Panel sefp=new Panel(new BorderLayout());
   sefp.add("East",sefpp);
   Panel prep=new Panel(new BorderLayout());
   prep.add("East",prepp);
   ldext.add(sefp);
   ldext.add(prep);
   claset.add(ldext);
   main.add("Loader Settings",claset);
   stuff.add("Loader Settings",7);
   Panel mndir=new Panel();
   Panel mdtxt1=new Panel(new GridLayout(4,1));
   mdtxt1.add(new Label("The root directory is where your"));
   mdtxt1.add(new Label("Web data is.  This is equivelant to"));
   mdtxt1.add(new Label("\"htdocs\" in Apache."));
   mndir.add(mdtxt1);
   Panel mninp=new Panel(new BorderLayout());
   mninp.add("North",new Label("Root directory:"));
   Panel mninpp=new Panel();
   mdir=new TextField("./",20);
   mninpp.add(mdir);
   mninp.add("Center",mninpp);
   mndir.add(mninp);
   main.add("Root Directory",mndir);
   stuff.add("Root Directory",8);
   Panel lgset=new Panel();
   Panel lstxt1=new Panel(new GridLayout(4,1));
   lstxt1.add(new Label("Red normally keeps a very extensive"));
   lstxt1.add(new Label("\"main.log\".  You should disable it"));
   lstxt1.add(new Label("unless you are debugging."));
   lgset.add(lstxt1);
   Panel lsenp=new Panel();
   lsenp.add(new Label("Main log:"));
   logs=new Checkbox("Enabled.",true);
   lsenp.add(logs);
   lgset.add(lsenp);
   main.add("Log Setup",lgset);
   stuff.add("Log Setup",9);
   Panel proxet=new Panel();
   Panel pxtxt1=new Panel(new GridLayout(5,1));
   pxtxt1.add(new Label("Red has some nice HTTP Proxy"));
   pxtxt1.add(new Label("capabilities.  If you need to have a"));
   pxtxt1.add(new Label("proxy, enable this.  Then be sure to"));
   pxtxt1.add(new Label("modify the Proxy Allows"));
   proxet.add(pxtxt1);
   Panel pxen=new Panel();
   pxen.add(new Label("Proxy:"));
   proxye=new Checkbox("Enabled.",false);
   pxen.add(proxye);
   proxet.add(pxen);
   proxy=new Button("Edit Proxy Allows");
   proxy.addActionListener(this);
   proxet.add(proxy);
   main.add("Proxy Setup",proxet);
   stuff.add("Proxy Setup",10);
   Panel mimet=new Panel();
   Panel mmtxt1=new Panel(new GridLayout(5,1));
   mmtxt1.add(new Label("The \"mimes\" file is used by Red to"));
   mmtxt1.add(new Label("set up extension-to-MIME definitions,"));
   mmtxt1.add(new Label("and to handle default extensions for"));
   mmtxt1.add(new Label("special files."));
   mimet.add(mmtxt1);
   mimes=new Button("Edit MIMEs");
   mimes.addActionListener(this);
   mimet.add(mimes);
   main.add("MIME Setup",mimet);
   stuff.add("MIME Setup",11);
   Panel uset=new Panel();
   Panel ustxt1=new Panel(new GridLayout(5,1));
   ustxt1.add(new Label("Red uses the \"users\" file to"));
   ustxt1.add(new Label("handle multiple Users' homepages."));
   ustxt1.add(new Label("To edit the Users database, click"));
   ustxt1.add(new Label("below."));
   uset.add(ustxt1);
   users=new Button("Edit Users");
   users.addActionListener(this);
   uset.add(users);
   main.add("Users Setup",uset);
   stuff.add("Users Setup",12);
   Panel vhset=new Panel();
   Panel vhtxt1=new Panel(new GridLayout(4,1));
   vhtxt1.add(new Label("The \"vhosts\" file is used by Red"));
   vhtxt1.add(new Label("to manage Virtual Hosts.  Click below"));
   vhtxt1.add(new Label("to edit the Virtual Hosts database."));
   vhset.add(vhtxt1);
   vhosts=new Button("Edit Virtual Hosts");
   vhosts.addActionListener(this);
   vhset.add(vhosts);
   main.add("V-Hosts Setup",vhset);
   stuff.add("V-Hosts Setup",13);
   Panel aliset=new Panel();
   Panel altxt1=new Panel(new GridLayout(3,1));
   altxt1.add(new Label("Red is capable of doing aliases.  Below"));
   altxt1.add(new Label("are some settings."));
   aliset.add(altxt1);
   Panel adp=new Panel();
   adp.add(new Label("Alias Depth:"));
   adept=new TextField("2",10);
   adp.add(adept);
   aliset.add(adp);
   alias=new Button("Edit Aliases");
   alias.addActionListener(this);
   aliset.add(alias);
   main.add("Alias Setup",aliset);
   stuff.add("Alias Setup",14);
   Panel sckset=new Panel();
   Panel sctxt1=new Panel(new GridLayout(5,1));
   sctxt1.add(new Label("Because of the way that Red's pipeline"));
   sctxt1.add(new Label("is set up, it is easy to do a DoS"));
   sctxt1.add(new Label("attack.  Setting the socket timeout"));
   sctxt1.add(new Label("is an easy yet effective precaution."));
   sckset.add(sctxt1);
   timeout=new TextField("20000",10);
   Panel topp=new Panel(new BorderLayout());
   topp.add("South",new Label("(in milliseconds)",Label.CENTER));
   Panel top=new Panel();
   top.add(new Label("Timeout:"));
   top.add(timeout);
   topp.add(top);
   sckset.add(topp);
   main.add("Timeout",sckset);
   stuff.add("Timeout",15);
   Panel secset=new Panel();
   Panel srtxt1=new Panel(new GridLayout(5,1));
   srtxt1.add(new Label("Scripts run by Red are run on the same"));
   srtxt1.add(new Label("user level as Red's Java VM.  On most"));
   srtxt1.add(new Label("systems, this means administrator. To"));
   srtxt1.add(new Label("ensure security, it is a good idea to"));
   srtxt1.add(new Label("disable scripts for users."));
   secset.add(srtxt1);
   cgiusr=new Checkbox("CGI for users",true);
   srvusr=new Checkbox("Servlets for users",true);
   Panel cusrpp=new Panel();
   Panel susrpp=new Panel();
   cusrpp.add(cgiusr);
   susrpp.add(srvusr);
   Panel cusrp=new Panel(new BorderLayout());
   Panel susrp=new Panel(new BorderLayout());
   cusrp.add("West",cusrpp);
   susrp.add("West",susrpp);
   Panel csusrp=new Panel(new GridLayout(2,1));
   csusrp.add(cusrp);
   csusrp.add(susrp);
   secset.add(csusrp);
   main.add("Script Security",secset);
   stuff.add("Script Security",16);
   Panel sttset=new Panel();
   Panel sttxt1=new Panel(new GridLayout(4,1));
   sttxt1.add(new Label("Since recently, Red has a hasty status"));
   sttxt1.add(new Label("reporting thread.  If you want to see"));
   sttxt1.add(new Label("some basic server stats, enable it here."));
   sttset.add(sttxt1);
   stats=new Checkbox("Kewl Status Enabled.");
   sttset.add(stats);
   main.add("Kewl Status",sttset);
   stuff.add("Kewl Status",17);
   Panel pnhset=new Panel();
   Panel phtxt1=new Panel(new GridLayout(6,1));
   phtxt1.add(new Label("Some ISPs disconnect their users for"));
   phtxt1.add(new Label("being idle.  The Ping Hack sends out a"));
   phtxt1.add(new Label("work-verification to the parent Red"));
   phtxt1.add(new Label("server once every 20 seconds, to make it"));
   phtxt1.add(new Label("seem like you are doing something."));
   pnhset.add(phtxt1);
   pinghack=new Checkbox("Ping Hack Enabled.",false);
   pnhset.add(pinghack);
   main.add("Ping Hack",pnhset);
   stuff.add("Ping Hack",18);
   Panel dnsset=new Panel();
   Panel ddtxt1=new Panel(new GridLayout(4,1));
   ddtxt1.add(new Label("DynDNS is a free service offered by"));
   ddtxt1.add(new Label("ML.org.  Project ReD now has the ability"));
   ddtxt1.add(new Label("to register your IP automatically."));
   dnsset.add(ddtxt1);
   ddon=new Checkbox("Activate DynDNS Client",false);
   ddon.addItemListener(this);
   dnsset.add(ddon);
   ddp=new Panel(new GridLayout(2,1));
   ddlogin=new TextField("",8);
   ddpass=new TextField("",8);
   ddhost=new TextField("",8);
   Panel dlp=new Panel();
   dlp.add(new Label("L:"));
   dlp.add(ddlogin);
   Panel dpp=new Panel();
   dpp.add(new Label("P:"));
   dpp.add(ddpass);
   Panel dhp=new Panel();
   dhp.add(new Label("Hostname:"));
   dhp.add(ddhost);
   Panel dlpp=new Panel(new GridLayout(1,2));
   dlpp.add(dlp);
   dlpp.add(dpp);
   ddp.add(dlpp);
   ddp.add(dhp);
   dnsset.add(ddp);
   main.add("ML's DynDNS",dnsset);
   stuff.add("ML's DynDNS",19);
   Panel perlp=new Panel();
   Panel petxt1=new Panel(new GridLayout(5,1));
   petxt1.add(new Label("Red now has the ability to run a program"));
   petxt1.add(new Label("that will then be resposible for running"));
   petxt1.add(new Label("the CGI.  This is good for Windows 95"));
   petxt1.add(new Label("users that want to run PERL CGI's."));
   perlp.add(petxt1);
   perlext=new Checkbox("Enable PERL-style extension.",false);
   perlext.addItemListener(this);
   perlp.add(perlext);
   ptf=new Panel();
   ptf.add(new Label("PERL Path:"));
   perlcom=new TextField("",20);
   ptf.add(perlcom);
   perlp.add(ptf);
   main.add("PERL Extension",perlp);
   // REMEMBER: adding something more will require alignment stuff
   add("Center",main);
   add("South",dbutts);
   add("West",stuff);
   resize(new Dimension(400,310));
   start();
  }
  public void actionPerformed(ActionEvent ev) {
   String arg=ev.getActionCommand();
   if (arg.equals("OK")) {
    save();
    System.exit(0);
   } else if (arg.equals("Cancel")) {
    System.exit(0);
   } else if (arg.equals("Apply")) {
    save();
   } else if (arg.equals("Edit Proxy Allows")) {
    iproxy.main(new String[0]);
   } else if (arg.equals("Edit MIMEs")) {
    imimes.main(new String[0]);
   } else if (arg.equals("Edit Users")) {
    iusers.main(new String[0]);
   } else if (arg.equals("Edit Aliases")) {
    ialias.main(new String[0]);
   } else if (arg.equals("Edit Virtual Hosts")) {
    ivhosts.main(new String[0]);
   }
  }
  public void itemStateChanged(ItemEvent ev) {
   Object item=ev.getItemSelectable();
   if (item.equals(stuff)) {
    mainc.show(main,stuff.getSelectedItem());
   } else if (item.equals(cgien)) {
    if (cgien.getState()) {
     cgip.enable();
     if (cgidir.getState()) {
      cgidp.enable();
      if (!stuff.getItem(4).equals("CGI Paths")) stuff.add("CGI Paths",4);
     }
     int pbi=5,bi=18;
     if (stuff.getItem(4).equals("CGI Paths")) {
      bi++;
      pbi++;
     }
     if (stuff.getItem(pbi).equals("Servlet Paths")) bi++;
     stuff.add("PERL Extension",bi);
    } else {
     cgip.disable();
     cgidp.disable();
     if (stuff.getItem(4).equals("CGI Paths")) stuff.remove(4);
     int pbi=5,bi=18;
     if (stuff.getItem(4).equals("CGI Paths")) {
      bi++;
      pbi++;
     }
     if (stuff.getItem(pbi).equals("Servlet Paths")) bi++;
     stuff.remove(bi);
    }
   } else if (item.equals(cgidir)) {
    if (cgidir.getState()&&cgien.getState()) {
     cgidp.enable();
     if (!stuff.getItem(4).equals("CGI Paths")) stuff.add("CGI Paths",4);
    } else {
     cgidp.disable();
     if (stuff.getItem(4).equals("CGI Paths")) stuff.remove(4);
    }
   } else if (item.equals(srven)) {
    if (srven.getState()) {
     srvp.enable();
     rsrvp.enable();
     if (srvdir.getState()) {
      srvdp.enable();
      int bi=5;
      if (stuff.getItem(4).equals("CGI Paths")) bi=6;
      if (!stuff.getItem(bi).equals("Servlet Paths")) stuff.add("Servlet Paths",bi);
     }
    } else {
     srvp.disable();
     rsrvp.disable();
     srvdp.disable();
     int bi=5;
     if (stuff.getItem(4).equals("CGI Paths")) bi=6;
     if (stuff.getItem(bi).equals("Servlet Paths")) stuff.remove(bi);
    }
   } else if (item.equals(srvdir)) {
    if (srvdir.getState()&&srven.getState()) {
     srvdp.enable();
     int bi=5;
     if (stuff.getItem(4).equals("CGI Paths")) bi=6;
     if (!stuff.getItem(bi).equals("Servlet Paths")) stuff.add("Servlet Paths",bi);
    } else {
     srvdp.disable();
     int bi=5;
     if (stuff.getItem(4).equals("CGI Paths")) bi=6;
     if (stuff.getItem(bi).equals("Servlet Paths")) stuff.remove(bi);
    }
   } else if (item.equals(ddon)) {
    if (ddon.getState()) {
     ddp.enable();
    } else {
     ddp.disable();
    }
   } else if (item.equals(perlext)) {
    if (perlext.getState()) {
     ptf.enable();
    } else {
     ptf.disable();
    }
   }
  }
  public void run() {
   cgidp.disable();
   srvdp.disable();
   ddp.disable();
   ptf.disable();
   try {
    String hostnm=InetAddress.getLocalHost().getHostAddress();
    int port=80;
    String mdir=System.getProperty("user.dir")+File.separatorChar;
    String rfl[]=new String[3];
    rfl[0]="index.html";
    rfl[1]="index.cgi";
    rfl[2]="index.txt";
    int rfln=3;
    boolean cgidr=false;
    boolean cgiex=true;
    boolean srvdr=false;
    boolean srvex=true;
    String fcgidr="/cgi-bin/";
    String rcgidr=mdir+fcgidr.replace('/',File.separatorChar);
    String fsrvdr="/servlet/";
    String rsrvdr=mdir+fsrvdr.replace('/',File.separatorChar);
    String srvdrex=".class";
    int ern=3;
    int dcn=2;
    int ppn=1;
    int cgn=1;
    int hdn=3;
    int pcn=1;
    int pdn=2;
    int rqn=3;
    int cnn=2;
    int crn=3;
    int rxn=1;
    int pxn=1;
    int psn=1;
    int srn=1;
    String prext=".props";
    int timeo=20000;
    int adept=2;
    er302="<h1>Error: 302</h1>Location moved";
    er400="<h1>Error: 400</h1>Bad Request";
    er403="<h1>Error: 403</h1>Forbidden";
    er404="<h1>Error: 404</h1>Object not found";
    er500="<h1>Error: 500</h1>Internal error";
    er502="<h1>Error: 502</h1>Connection failed";
    boolean logse=true;
    boolean remsrv=false;
    boolean proxy=false;
    boolean stats=false;
    boolean perlext=false;
    boolean cgiusr=true;
    boolean srvusr=true;
    boolean dyndnson=false;
    String ddlogin="";
    String ddpass="";
    String ddhost="";
    String perlcom="";
    File tfl=new File("config");
    boolean pinghack=false;
    BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
    String buf,prm,cmd;
    while (true) {
     buf=fin.readLine();
     if (buf==null) break;
     try {
      int fsp=buf.indexOf(' ');
      if (fsp<0) {
       cmd=buf;
       prm=null;
      } else {
       cmd=buf.substring(0,fsp);
       prm=buf.substring(fsp+1,buf.length());
      }
      if (cmd.equals("port")) {
       port=Integer.parseInt(prm);
      } else if (cmd.equals("timeout")) {
       timeo=Integer.parseInt(prm);
      } else if (cmd.equals("aldepth")) {
       adept=Integer.parseInt(prm);
      } else if (cmd.equals("er302")) {
       er302=""+prm;
      } else if (cmd.equals("er400")) {
       er400=""+prm;
      } else if (cmd.equals("er403")) {
       er403=""+prm;
      } else if (cmd.equals("perlext")) {
       perlext=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("perlcom")) {
       perlcom=""+prm;
      } else if (cmd.equals("er404")) {
       er404=""+prm;
      } else if (cmd.equals("er500")) {
       er500=""+prm;
      } else if (cmd.equals("er502")) {
       er502=""+prm;
      } else if (cmd.equals("hostnm")) {
       hostnm=""+prm;
      } else if (cmd.equals("propext")) {
       prext=""+prm;
      } else if (cmd.equals("classext")) {
       srvdrex=""+prm;
      } else if (cmd.equals("index")) {
       StringTokenizer tox2=new StringTokenizer(prm);
       rfln=0;
       while (tox2.hasMoreTokens()) {
        rfl[rfln]=""+tox2.nextToken();
        rfln++;
       }
      } else if (cmd.equals("cgiusr")) {
       cgiusr=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("srvusr")) {
       srvusr=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("pipeline")) {
       StringTokenizer tox2=new StringTokenizer(prm);
       ern=Integer.parseInt(tox2.nextToken());
       dcn=Integer.parseInt(tox2.nextToken());
       ppn=Integer.parseInt(tox2.nextToken());
       cgn=Integer.parseInt(tox2.nextToken()); 
       srn=Integer.parseInt(tox2.nextToken());
       rxn=Integer.parseInt(tox2.nextToken());
       hdn=Integer.parseInt(tox2.nextToken());
       pcn=Integer.parseInt(tox2.nextToken());
       pdn=Integer.parseInt(tox2.nextToken());
       psn=Integer.parseInt(tox2.nextToken());
       pxn=Integer.parseInt(tox2.nextToken());
       rqn=Integer.parseInt(tox2.nextToken());
       crn=Integer.parseInt(tox2.nextToken());
       cnn=Integer.parseInt(tox2.nextToken());
      } else if (cmd.equals("dyndnsset")) {
       StringTokenizer tox=new StringTokenizer(prm);
       ddlogin=tox.nextToken();
       ddpass=tox.nextToken();
       ddhost=tox.nextToken();
      } else if (cmd.equals("dyndns")) {
       dyndnson=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("remsrv")) {
       remsrv=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("pinghack")) {
       pinghack=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("cgidir")) {
       cgidr=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("cgiext")) {
       cgiex=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("srvdir")) {
       srvdr=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("srvext")) {
       srvex=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("mdir")) {
       mdir=""+prm;
       if (File.separatorChar=='\\') mdir=mdir.replace('/','\\');
       else if (File.separatorChar=='/') mdir=mdir.replace('\\','/');
      } else if (cmd.equals("setcgidir")) {
       StringTokenizer tox2=new StringTokenizer(prm);
       fcgidr=tox2.nextToken();
       rcgidr=tox2.nextToken();
      } else if (cmd.equals("setsrvdir")) {
       StringTokenizer tox2=new StringTokenizer(prm);
       fsrvdr=tox2.nextToken();
       rsrvdr=tox2.nextToken();
      } else if (cmd.equals("proxy")) {
       proxy=Boolean.valueOf(prm).booleanValue();
      } else if (cmd.equals("logs")) {
       if (!Boolean.valueOf(prm).booleanValue()) {
        logse=false;
       } else {
        logse=true;
       }
      } else if (cmd.equals("stats")) {
       if (!Boolean.valueOf(prm).booleanValue()) {
        stats=false;
       } else {
        stats=true;
       }
      } 
     } catch (Exception e) {}
    }
    fin.close();
    this.port.setText(""+port);
    this.hostnm.setText(hostnm);
    for (int i=0;i<3;i++) index[i].setText("");
    for (int i=0;i<rfln;i++) index[i].setText(rfl[i]);
    cgidir.setState(cgidr);
    cgiext.setState(cgiex);
    srvdir.setState(srvdr);
    srvext.setState(srvex);
    if (pcn==0||cgn==0) cgien.setState(false);
    if (psn==0||srn==0) srven.setState(false);
    cgifdir.setText(fcgidr);
    cgirdir.setText(rcgidr);
    srvfdir.setText(fsrvdr);
    srvrdir.setText(rsrvdr);
    srvextf.setText(srvdrex);
    propext.setText(prext);
    this.perlext.setState(perlext);
    this.perlcom.setText(perlcom);
    this.cgiusr.setState(cgiusr);
    this.srvusr.setState(srvusr);
    this.remsrv.setState(remsrv);
    this.mdir.setText(mdir);
    logs.setState(logse);
    this.adept.setText(""+adept);
    this.stats.setState(stats);
    this.pinghack.setState(pinghack);
    timeout.setText(""+timeo);
    proxye.setState(proxy);
    this.ddlogin.setText(ddlogin);
    this.ddpass.setText(ddpass);
    this.ddhost.setText(ddhost);
    ddon.setState(dyndnson);
    if (cgidir.getState()&&cgien.getState()) {
     cgidp.enable();
     if (!stuff.getItem(4).equals("CGI Paths")) stuff.add("CGI Paths",4);
    }
    if (srvdir.getState()&&srven.getState()) {
     srvdp.enable();
     int bi=5;
     if (stuff.getItem(4).equals("CGI Paths")) bi=6;
     if (!stuff.getItem(bi).equals("Servlet Paths")) stuff.add("Servlet Paths",bi);
    }
    if (!cgien.getState()) {
     cgip.disable();
    } else {
     int pbi=5,bi=18;
     if (stuff.getItem(4).equals("CGI Paths")) {
      bi++;
      pbi++;
     }
     if (stuff.getItem(pbi).equals("Servlet Paths")) bi++;
     stuff.add("PERL Extension",bi);
    }
    if (!srven.getState()) {
     srvp.disable();
     rsrvp.disable();
    }
    if (ddon.getState()) {
     ddp.enable();
    }
    if (perlext) {
     ptf.enable();
    }
   } catch (Throwable e) {}
//   ddpass.setEchoChar('*');
  }
  void save() {
   try {
    PrintStream fout=new PrintStream(new FileOutputStream("config"));
    fout.println("# Project ReD Configuration\n# Generated by visconfig.class");
    fout.println("port "+port.getText());
    fout.println("hostnm "+hostnm.getText());
    fout.println("index "+index[0].getText()+" "+index[1].getText()+" "+index[2].getText());
    fout.println("cgidir "+cgidir.getState());
    fout.println("cgiext "+cgiext.getState());
    fout.println("setcgidir "+cgifdir.getText()+" "+cgirdir.getText());
    fout.println("srvdir "+srvdir.getState());
    fout.println("srvext "+srvext.getState());
    fout.println("setsrvdir "+srvfdir.getText()+" "+srvrdir.getText());
    fout.println("srvdrex "+srvextf.getText());
    fout.println("propext "+propext.getText());
    fout.println("remsrv "+remsrv.getState());
    fout.println("mdir "+mdir.getText());
    fout.println("logs "+logs.getState());
    fout.println("stats "+stats.getState());
    fout.println("aldepth "+adept.getText());
    fout.println("timeout "+timeout.getText());
    fout.println("proxy "+proxye.getState());
    fout.println("cgiusr "+cgiusr.getState());
    fout.println("srvusr "+srvusr.getState());
    fout.println("pinghack "+pinghack.getState());
    fout.println("dyndns "+ddon.getState());
    fout.println("dyndnsset "+ddlogin.getText()+" "+ddpass.getText()+" "+ddhost.getText());
    fout.println("perlext "+perlext.getState());
    fout.println("perlcom "+perlcom.getText());
    fout.println("er302 "+er302);
    fout.println("er400 "+er400);
    fout.println("er403 "+er403);
    fout.println("er404 "+er404);
    fout.println("er500 "+er500);
    fout.println("er502 "+er502);
    fout.println("pipeline 3 2 "+((proxye.getState()?1:0)+(cgien.getState()?1:0))+" "+(cgien.getState()?1:0)+" "+(srven.getState()?1:0)+" "+(proxye.getState()?1:0)+" 3 "+(cgien.getState()?1:0)+" 2 "+(srven.getState()?1:0)+" "+(proxye.getState()?1:0)+" 3 3 2");
    fout.println("# the end!");
    fout.close();
   } catch (Throwable e) {}
  }
  public void start() {
   try {
    dostuff.stop();
   } catch (Throwable e) {}
   dostuff=new Thread(this);
   dostuff.start();
  }
  public void stop() {
   try {
    dostuff.stop();
    dostuff=null;
   } catch (Throwable e) {}
  }
}
