/*
 * Decompiled with CFR 0.152.
 */
package ch.mxco.j.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class Log {
    int maxLines = 5120;
    BufferedWriter bw;
    SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd.MM.yy, HH:mm:ss");

    public Log(String fileName, int maxLines) throws IOException {
        this(fileName);
        this.maxLines = maxLines;
    }

    public Log(String fileName) throws IOException {
        Vector<String> result = new Vector<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            while (line != null) {
                result.addElement(line);
                line = br.readLine();
                if (result.size() > this.maxLines) break;
            }
            br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {}
        this.bw = new BufferedWriter(new FileWriter(fileName));
        int i = 0;
        while (i < result.size()) {
            String l = (String)result.elementAt(i);
            this.bw.write(l);
            this.bw.newLine();
            this.bw.flush();
            ++i;
        }
    }

    public void write(String line) throws IOException {
        String date = this.sdf.format(new Date(System.currentTimeMillis()));
        this.bw.write(String.valueOf(date) + " - " + line);
        this.bw.newLine();
        this.bw.flush();
    }

    public void dispose() throws IOException {
        this.bw.close();
    }
}

