/*
 * Decompiled with CFR 0.152.
 */
import ch.mxco.j.io.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import mailFetcher.Report;

public class MailFetcher {
    static final String version = "MailFetcher 1.5.1 (29.07.1998) John Mettraux / www.mxco.ch";
    static Properties props = new Properties();
    static Log log;
    static int msgCollected;
    static int msgDistributed;
    static boolean msgSavedToDisk;
    static Report[] reports;
    static int timeToSleep;

    static void logWrite(String msg) {
        try {
            if (log != null) {
                log.write(msg);
            } else {
                System.out.println("Couldn't write this to log :\n" + msg);
            }
        }
        catch (IOException iOException) {
            System.out.println("Couldn't write this to log :\n" + msg);
        }
    }

    static void logDispose() {
        try {
            if (log != null) {
                log.dispose();
            }
        }
        catch (IOException iOException) {}
    }

    static void loadProperties(String fileName) throws IOException {
        props = new Properties();
        props.load(new BufferedInputStream(new FileInputStream(fileName)));
    }

    static void sendCmd(PrintWriter serverWriter, String cmd) {
        serverWriter.println(cmd);
        serverWriter.flush();
    }

    static String sendCmd(PrintWriter serverWriter, BufferedReader serverReader, String cmd) throws Exception {
        serverWriter.println(cmd);
        serverWriter.flush();
        return serverReader.readLine();
    }

    static void displayException(Exception e) {
        MailFetcher.logWrite(e.toString());
    }

    static String[] parseEMails(String list) {
        StringTokenizer st = new StringTokenizer(list, ";");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    static Vector fetch(String host, int port, String userName, String password, boolean delete) {
        Socket s = null;
        Vector messages = new Vector();
        try {
            s = new Socket(host, port);
            BufferedReader from_server = new BufferedReader(new InputStreamReader(s.getInputStream()));
            PrintWriter to_server = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
            String response = from_server.readLine();
            MailFetcher.sendCmd(to_server, "USER " + userName);
            response = from_server.readLine();
            if (!response.startsWith("+OK")) {
                throw new Exception(response);
            }
            MailFetcher.sendCmd(to_server, "PASS " + password);
            response = from_server.readLine();
            if (!response.startsWith("+OK")) {
                throw new Exception(response);
            }
            MailFetcher.sendCmd(to_server, "STAT");
            response = from_server.readLine();
            if (!response.startsWith("+OK")) {
                throw new Exception(response);
            }
            StringTokenizer st = new StringTokenizer(response);
            if (!st.hasMoreTokens()) {
                throw new Exception("stat corrupted");
            }
            st.nextToken();
            String msgNb = st.nextToken();
            int msgNumber = Integer.parseInt(msgNb);
            boolean j = false;
            int i = 1;
            while (i <= msgNumber) {
                MailFetcher.sendCmd(to_server, "RETR " + i);
                String line = "";
                Vector<String> message = new Vector<String>();
                while (!line.equals(".")) {
                    line = from_server.readLine();
                    message.addElement(line);
                }
                messages.addElement(message);
                ++i;
            }
            MailFetcher.sendCmd(to_server, "STAT");
            response = from_server.readLine();
            if (!response.startsWith("+OK")) {
                throw new Exception(response);
            }
            st = new StringTokenizer(response);
            if (!st.hasMoreTokens()) {
                throw new Exception("stat corrupted");
            }
            st.nextToken();
            msgNb = st.nextToken();
            msgNumber = Integer.parseInt(msgNb);
            if (delete) {
                int i2 = 1;
                while (i2 <= msgNumber) {
                    MailFetcher.sendCmd(to_server, "DELE " + i2);
                    String line = from_server.readLine();
                    if (!line.startsWith("+OK")) {
                        throw new Exception(line);
                    }
                    ++i2;
                }
            }
            MailFetcher.sendCmd(to_server, "QUIT");
            to_server.close();
            from_server.close();
        }
        catch (Exception exception) {}
        try {
            s.close();
        }
        catch (IOException iOException) {}
        return messages;
    }

    /*
     * Unable to fully structure code
     */
    static void resend(String host, int port, String[] destAccounts, Vector messages) {
        block20: {
            MailFetcher.msgCollected += messages.size();
            s = null;
            try {
                s = new Socket(host, port);
                from_server = new BufferedReader(new InputStreamReader(s.getInputStream()));
                to_server = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
                response = from_server.readLine();
                MailFetcher.sendCmd(to_server, "HELO " + host);
                response = from_server.readLine();
                if (!response.startsWith("250")) {
                    throw new Exception(response);
                }
                k = 0;
                while (k < messages.size()) {
                    MailFetcher.sendCmd(to_server, "MAIL From:<MailFetcher>");
                    response = from_server.readLine();
                    if (!response.startsWith("250")) {
                        throw new Exception(response);
                    }
                    l = 0;
                    while (l < destAccounts.length) {
                        MailFetcher.sendCmd(to_server, "RCPT to:<" + destAccounts[l] + ">");
                        response = from_server.readLine();
                        if (!response.startsWith("250")) {
                            throw new Exception(response);
                        }
                        ++l;
                    }
                    MailFetcher.sendCmd(to_server, "DATA");
                    response = from_server.readLine();
                    if (!response.startsWith("354")) {
                        throw new Exception(response);
                    }
                    to_server.println("X-fetcher:MailFetcher 1.5.1 (29.07.1998) John Mettraux / www.mxco.ch");
                    message = (Vector)messages.elementAt(k);
                    i = 0;
                    while (i < message.size()) {
                        line = (String)message.elementAt(i);
                        to_server.println(line);
                        ++i;
                    }
                    to_server.flush();
                    response = from_server.readLine();
                    if (!response.startsWith("250")) {
                        throw new Exception(response);
                    }
                    ++k;
                }
                MailFetcher.sendCmd(to_server, "QUIT");
                to_server.close();
                from_server.close();
                MailFetcher.msgDistributed += messages.size();
                break block20;
            }
            catch (Exception v0) {
                edir = MailFetcher.props.getProperty("emergency.directory");
                MailFetcher.msgSavedToDisk = true;
                MailFetcher.logWrite("Unable to connect to destination server. Writing messages in " + edir);
                if (edir == null) {
                    edir = "";
                } else if (!edir.endsWith("\\")) {
                    edir = String.valueOf(edir) + "\\";
                }
                i = 0;
                ** while (i < messages.size())
            }
lbl-1000:
            // 1 sources

            {
                message = (Vector)messages.elementAt(i);
                j = i;
                f = new File(String.valueOf(edir) + "msg" + j + ".txt");
                while (f.exists()) {
                    f = new File(String.valueOf(edir) + "msg" + ++j + ".txt");
                }
                try {
                    fw = new FileWriter(f);
                    k = 0;
                    while (k < message.size()) {
                        line = (String)message.elementAt(k);
                        fw.write(String.valueOf(line) + "\n");
                        ++k;
                    }
                    fw.close();
                }
                catch (IOException v1) {
                    MailFetcher.logWrite("Error while writing to emergency dir " + edir);
                }
                ++i;
                continue;
            }
        }
        try {
            s.close();
        }
        catch (IOException v2) {}
    }

    static void sendReport(String destHost, int destPort, String recipient) {
        Socket s = null;
        try {
            s = new Socket(destHost, destPort);
            BufferedReader fromServer = new BufferedReader(new InputStreamReader(s.getInputStream()));
            PrintWriter toServer = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
            String response = fromServer.readLine();
            response = MailFetcher.sendCmd(toServer, fromServer, "HELO " + destHost);
            if (!response.startsWith("250")) {
                throw new Exception(response);
            }
            response = MailFetcher.sendCmd(toServer, fromServer, "MAIL From:<MailFetcher>");
            if (!response.startsWith("250")) {
                throw new Exception(response);
            }
            response = MailFetcher.sendCmd(toServer, fromServer, "RCPT To:<" + recipient + ">");
            if (!response.startsWith("250")) {
                throw new Exception(response);
            }
            response = MailFetcher.sendCmd(toServer, fromServer, "DATA");
            if (!response.startsWith("354")) {
                throw new Exception(response);
            }
            MailFetcher.sendCmd(toServer, "Subject:Activity report");
            MailFetcher.sendCmd(toServer, "To:<" + recipient + ">");
            MailFetcher.sendCmd(toServer, "X-Mailer:MailFetcher 1.5.1 (29.07.1998) John Mettraux / www.mxco.ch");
            String timeZone = props.getProperty("timezone.adjustment");
            if (timeZone == null) {
                timeZone = "+0200";
            }
            SimpleDateFormat sdf = new SimpleDateFormat(" dd MMM yy, HH:mm:ss", Locale.UK);
            MailFetcher.sendCmd(toServer, "Date:" + sdf.format(new Date(System.currentTimeMillis())) + " " + timeZone);
            MailFetcher.sendCmd(toServer, "");
            int i = 0;
            while (i < reports.length) {
                Report r = reports[i];
                if (r != null) {
                    MailFetcher.sendCmd(toServer, "Fetched " + r.getMessagesFetched() + " on " + r.getHost() + " for " + r.getUser());
                }
                ++i;
            }
            MailFetcher.sendCmd(toServer, "");
            MailFetcher.sendCmd(toServer, "Total msg collected :   " + msgCollected);
            MailFetcher.sendCmd(toServer, "Total msg distributed : " + msgDistributed);
            MailFetcher.sendCmd(toServer, "");
            MailFetcher.sendCmd(toServer, "       your dear MailFetcher.");
            response = MailFetcher.sendCmd(toServer, fromServer, ".");
            if (!response.startsWith("250")) {
                throw new Exception(response);
            }
            MailFetcher.sendCmd(toServer, "QUIT");
            fromServer.close();
            toServer.close();
            s.close();
        }
        catch (Exception e) {
            MailFetcher.logWrite("Exception while sending report : " + e);
        }
        try {
            s.close();
        }
        catch (IOException iOException) {}
    }

    public static void main(String[] args) {
        boolean daemon = false;
        if (args.length > 0 && args[0].equals("daemon")) {
            daemon = true;
        }
        try {
            log = new Log("mfetcher.log");
        }
        catch (IOException ie) {
            System.out.println(ie);
            log = null;
        }
        try {
            MailFetcher.loadProperties("mfetcher.cnf");
        }
        catch (IOException iOException) {
            MailFetcher.logWrite("Couldn't load configuration file \"mfetcher.cnf\"");
            MailFetcher.logDispose();
            return;
        }
        int accountNb = Integer.parseInt(props.getProperty("account.number"));
        accountNb = 2;
        String destHost = props.getProperty("destination.host");
        int destPort = Integer.parseInt(props.getProperty("destination.port"));
        String reportTo = props.getProperty("destination.reportto");
        String sleep = props.getProperty("daemon.sleeptime");
        if (sleep != null) {
            try {
                timeToSleep = Integer.parseInt(sleep);
            }
            catch (NumberFormatException numberFormatException) {
                timeToSleep = 120;
                MailFetcher.logWrite("Error in \"mfetcher.cnf\", daemon.sleeptime must be an integer");
            }
        }
        reports = new Report[accountNb];
        int i = 1;
        while (i <= accountNb) {
            String host = props.getProperty("account." + i + ".server");
            int port = Integer.parseInt(props.getProperty("account." + i + ".port"));
            String username = props.getProperty("account." + i + ".username");
            String pass = props.getProperty("account." + i + ".pass");
            String[] destAccounts = MailFetcher.parseEMails(props.getProperty("account." + i + ".destination"));
            boolean delete = props.getProperty("account." + i + ".delete").equals("yes");
            Vector messages = MailFetcher.fetch(host, port, username, pass, delete);
            if (messages != null) {
                MailFetcher.reports[i - 1] = new Report(host, username, messages.size());
                MailFetcher.resend(destHost, destPort, destAccounts, messages);
            }
            ++i;
        }
        if (reportTo != null && !reportTo.equals("") && (daemon && msgCollected > 0 || !daemon)) {
            MailFetcher.sendReport(destHost, destPort, reportTo);
        }
        MailFetcher.logWrite("job done : " + msgCollected + " msg collected / " + msgDistributed + " msg distributed");
        msgCollected = 0;
        msgDistributed = 0;
        MailFetcher.logDispose();
        if (daemon) {
            try {
                Thread.currentThread();
                Thread.sleep(60000 * timeToSleep);
            }
            catch (InterruptedException interruptedException) {}
            MailFetcher.main(args);
        }
    }

    static {
        timeToSleep = 2;
    }
}

