************************************************************************
*PROCEDURE wwDemo
******************
***  Modified: 03/1/98
***  Function: Processes incoming wwDemo CGI requests. Called from
***            wcMain.prg using wwDemo~Task~Optional+Parms parameter.
***      Pass: loServer -   wwServer/wwOLEServer object
*************************************************************************
LPARAMETER loServer
LOCAL loProcess

#INCLUDE WCONNECT.H

*** Now create a process object - NOTE: WWC_wwHTML is a #DEFINE in WCONNECT.H
*** This value is different based on OLESERVER setting.
#IF OLESERVER
  loProcess=CREATE("WebConnectDemo",loServer.oCGI,loServer,,,[WWC_wwhtmlstring])
#ELSE
  loProcess=CREATE("WebConnectDemo",loServer.oCGI,loServer,,,[WWC_wwhtml])
#ENDIF  

IF TYPE("loProcess")#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create Process object..."
   RETURN .F.
ENDIF

*** Enable Automatic Session Object (optional)
*** Works on loProcess.oSession
*loProcess.InitSession()
*loProcess.oSession.nSessionTimeout = 3600  && 1 hour

*** Call the Process Method that handles the request

loProcess.Process()

RETURN


*** Optional HTML and graphics file path DEFINEs
*** I use these defines to avoid hardcoding paths when 
*** testing and then deploying on the server
#DEFINE MAILSERVER "your.server.net"
#DEFINE CCLIST ""
#DEFINE MAILFROMNAME "Your Name"
#DEFINE MAILFROMEMAIL "youremail@yourserver.com"

#DEFINE HOMEPATH "/wconnect/"
#DEFINE HOMEPAGE HOMEPATH+"default.htm"
#DEFINE BACKIMG HOMEPATH+"whitwav.jpg"
#DEFINE PAGEFOOT [<p><HR>]+CR+;
                 [<A HREF="http://www.west-wind.com/wwcgi.asp"><IMG SRC="/wconnect/wcpower.gif" BORDER=0 HSPACE=5 WIDTH=114 HEIGHT=42 ALIGN=LEFT ALT="Powered by Web Connection"></a>]+;
                 [<FONT SIZE=-1>Query created by <A HREF="mailto:rstrahl@west-wind.com">Rick Strahl</A><BR>]+;
                 '[<A HREF="'+HOMEPATH+ 'default.htm">Web Connection demo page</A>][<A HREF="wc.dll?wwdemo~ShowCode~'+Request.GetCGIParameter(2)+'">Show Code]'


*************************************************************
DEFINE CLASS WebConnectDemo AS wwProcess
*************************************************************
***    Author: Rick Strahl
***  Modified: 05/31/96
***  Function: This class handles the requests generated by
***            the sample HTML form and its results. The
***            class implementation makes error and output 
***            doc handling much cleaner.
***
***            Subclassed from a generic wwProcess class
***            handler which provides error handling and 
***            HTML and CGI object setup.
*************************************************************


*** Properties defined by wwProcess Parent Class
*** -----------------------------------------------
*** oCGI=.NULL.
*** oHTML=.NULL.
*** oServer=.NULL.
*** cHTMLPagePath=""
*** cDataPath="" 

*** Methods defined by wwCGIProcess Parent Class
*** --------------------------------------------
*** Init(oCGI)     && Initializes and checks HTML and CGI objects
*** Process        && Virtual Method that is always overridden
*** Error          && Handles errors that occur in the Process code 
*** ErrorMsg(cErrorHeader,cMessage)  && Quick Message Display


************************************************************************
* webConnectDemo :: Process
***************************
***  Function: This is the callback program file that handles
***            processing a CGI request
************************************************************************
FUNCTION Process
LOCAL lcParameter, lcOutFile, lcIniFile, lcOldError

*** Retrieve the HTMLPagePath and cDataPath vars
THIS.cHTMLPAGEPATH = THIS.GetAppIniVar("HTMLPAGEPATH",THIS.Class)
THIS.cDATAPATH = THIS.GetAppIniVar("DATAPATH",THIS.Class)

Response = THIS.oHTML
Request = THIS.oCGI

lcParameter=UPPER(Request.GetCGIParameter(2)) && Optional CGI parameters following EXE name

DO CASE
   *** Add any 'invalid' method calls here
   CASE INLIST(lcParameter,"PROCESS","LOAD","INIT","DESTROY")
      THIS.ErrorMsg("Invalid Method: " +lcParameter,"This method name is illegal...")

   *** Generic Page Display using ExpandTemplate()
   CASE lcParameter = "DISPLAYFILE" OR lcParameter="SHOWPAGE"
      THIS.DisplayFile(Request.GetCGIParameter(3),THIS.cHTMLPagePath)

   *** NOTE:    GENERIC ROUTING BY PARAMETER NAME
   CASE !EMPTY(lcParameter) AND PEMSTATUS(THIS,lcParameter,5)
      =EVALUATE("THIS."+lcParameter+"()")
   OTHERWISE
      *** Unhandled method - display error page
      THIS.ErrorMsg("Unable to respond to this request",;
         "Parameter Passed: <b>"+PROPER(lcParameter)+"</b><BR>"+;
         "Error: <b>Unhandled Method</b>")
      
      THIS.SendErrorEmail("Web Connection Error Message - Unhandled request")
ENDCASE

RETURN .T.
ENDFUNC 

FUNCTION NoOutput
Response.Send("Hello World")
ENDFUNC


FUNCTION TestPage
************************************************************************
* webConnectDemo :: TestPage
****************************
***  Function: This is a simple example on how to process a request
***            and output text. It uses the most basic .SendLn()
***            syntax to demonstrate line by line output.   
***
***            This routine creates a new output HTML document that
***            displays the current date and time, the request information
***            provided to your application.
***
***            Note the use of the wwHTML class, which greatly simplifies
***            creation of HTML documents. Here we're only using the
***            basic Send/SendLn methods to output text instead of the
***            higher level page generation methods.
*************************************************************************
LOCAL lcOutFile

*** HTML Content Type header and Header Line, Browser Title
*** and Background image. All but the title is optional.
*** This method is optional, but frequently used for coded pages.
Response.HTMLHeader("Hello World from Visual FoxPro!",,;
                  BACKIMG)     

Response.SendLn([<H2>Local time is: ]+TIME()+[</H2>])
Response.SendPar()  && <p>
Response.SendLn("This page was dynamically generated by a Visual FoxPro server that responds to the request you see in your "+;
              "browser's 'Location' or 'Address' line.")
Response.Sendln("Following are a few examples of the custom methods provided by the wwCGI class that "+;
              "return common settings from Web requests. <p>")


Response.SendLn("<b>Common Request and Server Info</b>")
Response.SendLn("<PRE>")
Response.SendLn([       .GetDLLVersion(): ]+Request.GetCGIVar("DLLVersion"))
Response.SendLn("          .GetBrowser(): "+Request.GetBrowser())
Response.SendLn("      .GetPreviousUrl(): "+Request.GetPreviousUrl())
Response.SendLn("       .GetCurrentUrl(): "+Request.GetCurrentUrl())
Response.SendLn("    .GetRemoteAddress(): "+Request.GetRemoteAddress())
Response.SendLn("    .GetRequestMethod(): "+Request.GetRequestMethod())
Response.SendLn("  .GetRequestProtocol(): "+Request.GetRequestProtocol())
Response.SendLn("       .GetServerName(): "+Request.GetServerName() )
Response.SendLn("     .GetPhysicalPath(): "+Request.GetPhysicalPath())
Response.SendLn("   .GetExecutablePath(): "+Request.GetExecutablePath())
Response.SendLn("            Server Port: "+Request.ServerVariables("Server Port") + [  (Hint: Try this page <A HREF="] + Request.GetCurrentURL(.T.) +[">securely</a> with https://)]) 
Response.SendLn("        .IsLinkSecure(): "+IIF(Request.IsLinkSecure(),"Yes","No") )
Response.SendLn("        Server Software: "+Request.ServerVariables("Server Software"))

Response.SendLn("</PRE><b>Query String (URL Parameter) Retrieval</b><PRE>")
Response.SendLn("         .QueryString(): "+Request.QueryString())
Response.SendLn("        .QueryString(1): "+Request.QueryString(1))
Response.SendLn("        .QueryString(2): "+Request.QueryString(2))
Response.SendLn("   .QueryString('Name'): "+Request.QueryString("Name"))
Response.SendLn(".QueryString('Company'): "+Request.QueryString("COMPANY"))

*** This code works only if Web directory Accepts Client Certs and you're running SSL 
*** and you actually have a Client Certificate installed!
lcValue = Request.ServerVariables("Server Port") 
IF !EMPTY(Request.GetClientCertificate())
    Response.SendLn()
    Response.SendLn("     Client Certificate: "+Request.GetClientCertificate())
	Response.SendLn("       Certificate Name: "+Request.GetClientCertificate("NAME") )
	Response.SendLn("      Certificate Email: "+Request.GetClientCertificate("EMAIL") )
ENDIF

Response.SendLn("</PRE>")
Response.SendPar()


Response.SendLn("<b>Retrieving Form Variables</b><br>")
Response.SendLn("Retrieving form variables is just as easy. You can simply use "+;
   "the <i>wwCGI::Form()</i> method to retrieve any form variable as "+;
   "a string. Variables are decoded including long text fields and those "+;
   "containing control characters.")
Response.SendPar()

*** Retrieve entered values if any - returns "" if not found
*** We do this to 'repopulate' fields with previous values in the form
lcFirstname = Request.Form("FirstName")
lcLastName = Request.Form("LastName")
lcCompany = Request.Form("Company")

*** Now create the actual form in code - There are better ways to do this
*** but this demonstrates how you can do it with code using some of the
*** WC high level wwHTML::Formxxx methods.
Response.SendLn([<FORM ACTION="wc.dll?wwDemo~TestPage" METHOD="POST"><PRE>])
Response.Send("Enter your first name: ")
Response.FormTextBox("FirstName",lcFirstName,17)
Response.Send("  Last: ")
Response.FormTextBox("LastName",lcLastName,22)
Response.SendLn()
Response.Send("         Your Company: ")
Response.FormTextBox("Company",lcCompany,50)
Response.SendLn()

Response.Send( "                       ") 
Response.FormButton("btnSubmit","Update this form")
Response.SendLn("</PRE></FORM>")

Response.SendLn("Here's the relevant example code from the sample form processing code in wwDemo.prg:")

Response.SendLn("<PRE>")
Response.SendLn([*** Collect form variable values into local vars])
Response.SendLn([lcFirstname=Request.Form("FirstName")] + "   <b>"+lcFirstName  + "</b>")
Response.SendLn([lcLastName=Request.Form("LastName")] + "   <b>" + lcLastName  + "</b>")
Response.SendLn([lcCompany=Request.Form("Company")] + "   <b>" + lcCompany + "</b>" )
Response.SendLn("</PRE>")


Response.HTMLFooter(PAGEFOOT)

RETURN
*EOP TestPage


FUNCTION ShowHours
************************************************************************
* wwConnectDemo :: ShowHours
*****************************
***  Function: This is a more advanced example that queries a time
***            and billing database for hours spent and displays the
***            data using the ShowCursor method.
***
***            Note that the CGI/HTML code is only a small portion
***            of this code - most of the code deals with processing
***            the form parameters and setting up the query.
************************************************************************
LOCAL lcNotes,lcOrigClient,lcDate1,lcDate2, lcDateFilter, lnGrandTotal,;
      lcClient,lcOutFile

*** Collect form variable values into local vars
lcNotes=Request.Form("FormNotes")
lcOrigClient=Request.Form("Client")
lcDate1=Request.Form("StartDate")
lcDate2=Request.Form("EndDate")

*** You can also use ScatterFormVars which scatters all form
*** variables from the HTML form to PUBLIC memory vars:
*** Format: m.ww_FormNotes
***         m.ww_Client
***         m.ww_StartDate
***         m.ww_EndDate
*** Request.ScatterFormVars()

lcClient=TRIM(UPPER(lcOrigClient))

*** This is the output file name
lcOutFile=Request.GetOutFile()

*** Process the parameter into a Filter string
lcDateFilter=""
DO CASE
   CASE !EMPTY(lcDate1) AND !EMPTY(lcDate2)
      lcDateFilter= " AND Datein >= {"+lcDate1+ "} AND Datein <= {"+lcDate2+"}"
   CASE !EMPTY(lcDate1) AND EMPTY(lcDate2)
      lcDatefilter= " AND Datein >= {"+lcDate1+"}"
   CASE EMPTY(lcDate1) AND !EMPTY(lcDate2)
      lcDatefilter= " AND Datein <= {"+lcDate2+"}"
ENDCASE

*** Run Query - Note I'm creating the Hotlink right in the query
***             to be able to use the ShowCursor method to display the
***             cursor with a single command!
SELECT ;
   [<A HREF="/wconnect/wc.dll?wwdemo~ShowClient~]+CHRTRAN(TRIM(tt_cust.company)," ","+")+[">]+;
       tt_cust.company+[</a>] AS Client,;
   [<A HREF="/wconnect/wc.dll?wwdemo~ShowSlip~]+CHRTRAN(timebill.ttId," ","+")+;
       [">]+DTOC(timebill.datein) + [</a>] AS Date,TimeIn as Time,Timeout as Timeout, ;
   timebill.totalHours as Hours ;
 FROM (THIS.cDatapath + "TIMEBILL"), (THIS.cDatapath + "TT_CUST") ;
 WHERE UPPER(tt_cust.company)=lcClient AND ;
       TIMEBILL.custno=tt_cust.custno AND ;
       !expense ;
       &lcDateFilter ;
 INTO CURSOR TQUERY ;
 ORDER BY company,Datein

IF _TALLY<1
   THIS.ErrorMsg("No Matching Records found...",;
                 [Please enter a valid name or use a shorter portion of a name.<HR>]+;
                 [<A HREF="]+Request.GetPreviousUrl()+[">Return to Test Form...</A>])
   RETURN
ENDIF

*** Create the document header
Response.HTMLHeader("Time Trakker Data Example",;
                  "Visual FoxPro Sample Query Result",;
                  BACKIMG)

*** Now do some more formatting for the text to display
IF EMPTY(lcClient)
   lcClient="All Clients"
ENDIF
IF EMPTY(lcDate1)
   lcDate1="No Starting Date"
ENDIF
IF EMPTY(lcDate2)
   lcDate2="No Ending Date"
ENDIF

Response.EnclosedText("H3","You've selected a time review for: "+lcClient)
Response.EnclosedText("B","From: "+lcDate1)
Response.sendln("<br>")
Response.EnclosedText("B","To: "+lcDate2)
Response.SendPar()


*** The easy way: Use the wwHTML :: ShowCursor() method

Response.SendLn("<CENTER>")

**** Now show the table with default headers, no title and totals for numbers
Response.ShowCursor(,,.T.)

Response.SendLn("</CENTER>")

**** Close out Page
Response.HTMLFooter(PAGEFOOT)

USE IN TIMEBILL
USE IN TQUERY

RETURN   

*** The Previous approach using ShowCursor is the quick and easy way to
*** display a table or cursor from a development Point of View, but there
*** is some overhead associated with this generic routine.
*** To use the code below comment out the last four lines of code.

*** We have to manually sum the table
lnGrandTotal=0

   Response.SendLn([<CENTER>])
   Response.SendLn([<TABLE COLSPEC="L20 L20 L20" BGCOLOR="#EEEEEE" BORDER=1 CELLPADDING=5 WIDTH="80%" STYLE="FONT:normal normal 10pt 'Arial'">])

   Response.SendLn([<TR BGCOLOR="BLACK" STYLE="COLOR:WHITE"><TH>Date</TH><TH>TIME</TH><TH>Hours</TH></TR>])

   lcClient = "xxx"
   SELE TQUERY
   SCAN
      *** Note the HREF tags for client and Date are preformatted from the SELECT query
      IF TQuery.Client # lcClient
        Response.FastSend(;
         [<TR STYLE="COLOR:WHITE;BACKGROUND:LightBLUE;FONT:BOLD 12pt 'Arial'"><TD COLSPAN=3>]+TQuery.Client + [</TD></TR>])
      ENDIF
      
      Response.FastSend([<TR><TD>]+;
         "&nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;"+Tquery.Date+;
         [</TD><TD>]+TQuery.Time+ " - " + Tquery.Timeout + [</TD><TD ALIGN="CENTER">]+;
         TRANSFORM(Tquery.hours,"999.99")+;
         [</TD></TR>]+CR)

      lnGrandTotal=lnGrandTotal+tquery.hours
      lcClient = TQUery.Client
   ENDSCAN

   Response.SendLn([<TR BGCOLOR=#FFFFCC><TD COLSPAN="2" ALIGN="CENTER"><h3>Grand Total:</h3></TD><TD ALIGN="CENTER"><h3>]+TRANSFORM(lnGrandTotal,"9,999.99")+[</h3></TD></TR>])
   Response.SendLn([</TABLE></CENTER><p>])
   
   IF !EMPTY(lcNotes)
     Response.BreakMemo(lcNotes)
   ENDIF

Response.HTMLFooter(PAGEFOOT)

* Close tables (optional)
USE IN TIMEBILL
USE IN TQUERY

RETURN


FUNCTION ShowHoursMulti
************************************************************************
* wwConnectDemo :: ShowHoursMulti
*********************************
***  Function: This is a more advanced example that queries a time
***            and billing database for hours spent and displays the
***            data using the ShowCursor method.
***
***            Note that the CGI/HTML code is only a small portion
***            of this code - most of the code deals with processing
***            the form parameters and setting up the query.
************************************************************************
LOCAL lcNotes,lcOrigClient,lcDate1,lcDate2, lcDateFilter, lnGrandTotal,;
      lcClient,lcOutFile


*** Collect form variable values into local vars
lcOrigClient=Request.Form("Client")
lcClient=TRIM(UPPER(lcOrigClient))

*** Collect Multi items into an array
DIMENSION laNames[1]
lnCount=Request.GetFormMultiple(@laNames,"Client")

lcNameFilter=""
FOR x=1 to lnCount
  lcClient=TRIM(UPPER(laNames[x]))
  IF lcClient="ALL CLIENTS"
     lcNameFilter=""
     EXIT
  ENDIF
  
  IF RIGHT(lcClient,1)="*"
     lcClient=SUBSTR(lcClient,1,len(lcClient)-1)
  ENDIF

  lcNameFilter=lcNameFilter+IIF(x=1,""," OR ")+"UPPER(tt_cust.company)='"+lcClient+"'"
ENDFOR && x=1 to Request.GetFormMultiple
IF x=2
  lcNameFilter="AND "+lcNameFilter
ENDIF  
IF x>2
  lcNameFilter="AND ("+lcNameFilter+")"
ENDIF

lcClient=TRIM(UPPER(lcOrigClient))
IF lcClient="ALL CLIENTS"
   lcClient=""
ENDIF

*** This is the output file name
lcOutFile=Request.GetOutFile()

*** Run Query - Note I'm creating the Hotlink right in the query
***             to be able to use the ShowCursor method to display the
***             cursor with a single command!
SELECT ;
   [<A HREF="/wconnect/wc.dll?wwdemo~ShowClient~]+CHRTRAN(TRIM(tt_cust.company)," ","+")+[">]+;
       tt_cust.company+[</a>] AS Client,;
   [<A HREF="/wconnect/wc.dll?wwdemo~ShowSlip~]+CHRTRAN(timebill.ttId," ","+")+;
       [">]+DTOC(timebill.datein)+" - "+timebill.timein+[</a>] AS Date,;
   timebill.totalHours as Hours ;
 FROM TIMEBILL,TT_CUST ;
 WHERE TIMEBILL.custno=tt_cust.custno AND ;
       !expense ;
       &lcNameFilter ;
 INTO CURSOR TQUERY ;
 ORDER BY company,Datein


*** Create the document header
Response.HTMLHeader("Time Trakker Data Example",;
                  "Visual FoxPro Sample Query Result",;
                  BACKIMG)


IF _TALLY<1
   THIS.ErrorMsg("No Matching Records found...",;
                 [<A HREF="]+Request.GetPreviousUrl()+[">Return to Test Form...</A>])
   RETURN
ENDIF

*** Tell Web Connection whether it's Ok to create HTML Tables
*** based on Browser capability
Response.SetAllowHTMLTables(Request.IsNetScape())

*** Now show the table
Response.ShowCursor(,,.T.)

*** Close out form
Response.HTMLFooter(PAGEFOOT)

RETURN   


FUNCTION ClientList
************************************************************************
* wwConnectDemo :: ClientList
*****************************
***  Modified: 11/11/95
***  Function: Shows List of clients and allows selection of
***            Client to back fill query form by running another
***            CGI request to redraw the original form.
*************************************************************************

*** Get all entries that have time entries (expense=.F.)
SELECT tt_cust.Company, MIN(expense) AS HasTimeEntries ;
   FROM (THIS.cDatapath + "TT_CUST"), (THIS.cDatapath + "TIMEBILL") ;
   WHERE tt_cust.custno=timebill.custno ;
   GROUP BY 1 ;
   INTO CURSOR TQuery

IF _TALLY<1
   =THIS.Error("No Clients available.")
   RETURN
ENDIF

*** Create the document header
Response.HTMLHeader("Complete Client Listing",;
                  "Web Connection Client List",;
                  BACKIMG)

Response.SendLn([Please select a client name to look up in your query. ]+;
              [To select pick a client from the listbox below and press the ]+;
              ['Fill Client Name' button to fill the value into the query form.<p>])

Response.SendLn("<i><b>*</b> --- Client has time entries to review.</i><p>")

Response.SendLn([<FORM  ACTION="/wconnect/wc.dll?wwdemo~FillQueryForm" METHOD="POST">])
Response.SendLn([<SELECT NAME="Client" SIZE=10 MULTIPLE>])
Response.SendLn([<OPTION SELECTED>None</A>])
SCAN
   Response.SendLn([<OPTION>]+TRIM(TQuery.company)+IIF(!HasTimeEntries,"*",""))
ENDSCAN

USE IN TQUery

Response.SendLn([</SELECT><p>])
Response.SendLn([<INPUT TYPE="SUBMIT" NAME="SubmitButton"  VALUE="Fill Client Name">])
Response.SendLn([</FORM>])

Response.HTMLFooter(PAGEFOOT)
RETURN



FUNCTION PagedCustomerList
************************************************************************
* wwDemo :: PagedCustomerList
*********************************
***  Function: Demonstrates use of the wwSession object, Cookies the
***            wwShowCursor's Paging mode to display a query in paged 
***            format. The code below stores the Filter of the query
***            in a Session variable which is retrieved on each page
***            hit to re-run the query and jump to the appropriate
***            page.
************************************************************************
LOCAL lcCookie, loSession, loHeader


*** Create a Session Object
THIS.InitSession()
loSession = THIS.oSession
loSession.nSessionTimeout=900   && Seconds  - 15 minutes

*** Now try retrieving the Query Parameters 
*** Values on relevant if we're running from the form on the 'first hit'
lcCompany=Request.Form("txtCompany")
lcName=Request.Form("txtName")

*** Retrieve the page number - wc.dll?wwDemo~PagedCustomerList~PageNo
lnCurrentPage=VAL(Request.QueryString(3))
IF lnCurrentPage=0 
  lnCurrentPage=1
ENDIF  

*** Check if we clicked the button of the form
IF !EMPTY(Request.Form("btnSubmit"))
   *** Build a filter
   lcFilter=""
   IF !EMPTY(lcCompany)
      lcFilter="UPPER(Company) = '" + UPPER(lcCompany) + "' AND "
   ENDIF
   IF !EMPTY(lcName)
      lcFilter=lcFilter + "UPPER(Careof) = '" + UPPER(lcName) + "'  AND "
   ENDIF
   
   IF !EMPTY(lcFilter)
      lcFilter = lcFilter + "!DELETED()"
   ENDIF
   
   *** Store the filter in the Session Object
   loSession.SetSessionVar("CustomerQueryFilter",lcFilter)
ELSE
   *** No - paging through file
   *** Retrieve the filter from the Session Variable
   lcFilter=loSession.GetSessionVar("CustomerQueryFilter")
ENDIF

IF !EMPTY(lcFilter)
  lcFilter= "WHERE " + lcFilter
ELSE
  lcFilter = "WHERE .T."   && Force to disk
ENDIF  

SELECT Company, CareOf, Phone ;
   FROM TT_CUST ;
   &lcFilter ;
   ORDER BY Company ;
   INTO CURSOR TQuery

*** Create the HTML header for the page 
***  Note the custom HTTP header object containing the Cookie (loHeader)
Response.HTMLHeader("Paged Customer List",,BACKIMG,loHeader)

*** Create a ShowCursor Object and pass our HTML object
loSC=CREATEOBJECT("wwShowCursor",Response)

*** Set the Paging parameters - 5 per page
loSC.nPage_ItemsPerPage=5
loSC.nPage_ShowPage=lnCurrentPage  && Which page?

*** The URL to use for the Next/Prev buttons - This page
loSC.cPage_PageURL="wc.dll?wwDemo~PagedCustomerList"  

*** Now dump the HTML
loSC.ShowCursor()

Response.HTMLFooter(PAGEFOOT)

ENDFUNC
* PagedCustomerList


FUNCTION FillQueryForm
************************************************************************
***  Function: Back fills the Client name from the picklist of
***            Clients in ClientList
*************************************************************************
LOCAL lcName, lnPlusSign

*** Grab CGI Form var
lcName=TRIM(Request.Form("Client"))

*** Fix up name - remove * and catch NONE entries
IF RIGHT(lcName,1)="*"
   lcName=SUBSTR(lcName,1,len(lcName)-1)
ENDIF
IF UPPER(lcName)="NONE"
   lcName=""
ENDIF   


Response.HTMLHeader([<IMG SRC="]+HOMEPATH+[wconnect.gif">],;
                  [Web Connection Sample Form],;
                  BACKIMG)
              
*** This form code was simply captured from the View Source
*** option of the wconnect.htm form and then converted to code 
*** with DO FORM WRAPPER and pasted here.
              
Response.SendLn([<p><A HREF="/wconnect/wc.dll?wwdemo~TestPage">Simple Web Connection Test</A><P>])
Response.SendLn([The following example form allows you to query a time and billing ]+;
              [database by selecting a client name and date range. To see a list ]+;
              [of clients and pick one from the list click on the Client Name ]+;
              [header button.<p>])
Response.SendLn([<FORM  ACTION="/wconnect/wc.dll?wwdemo~ShowHours" METHOD="POST">])
Response.SendLn([<A HREF="/wconnect/wc.dll?wwdemo~ClientList"><B>Client Name:</B></A><br>])

*** This is where we're setting the variable name
Response.SendLn([<INPUT NAME="Client" TYPE="TEXT" VALUE="]+lcName+[" ROWS=1 SIZE="40">])

Response.SendLn([<p>])
Response.SendLn([<PRE>])
Response.SendLn([<B>From: </B><INPUT NAME="StartDate" TYPE="TEXT" ROWS=1 SIZE="10">])
Response.SendLn([<B>  To: </B><INPUT NAME="EndDate" TYPE="TEXT" ROWS=1 SIZE="10">])
Response.SendLn([</PRE>])
Response.SendLn([<p>])
Response.SendLn([<INPUT TYPE="SUBMIT" NAME="SubmitButton"  VALUE="Show hours worked" SIZE="40">])
Response.SendLn([<INPUT TYPE="RESET"  NAME="Reset Form" VALUE="Reset" ALIGN=top>])
** Response.SendLn([<p>])
** Response.SendLn([<B>User Notes (to appear on output):</B><BR><TEXTAREA  NAME="FormNotes" ROWS=5 COLS=60 MAXLENGTH="200"></TEXTAREA>])
Response.SendLn([</FORM>])
Response.SendLn([<p>])
*Response.SendLn([<A HREF="/wconnect/wc.dll?wwdemo~Error">Throw CGI Error for unhandled parameter.</A><P>])

Response.HTMLFooter(PAGEFOOT)
RETURN


FUNCTION ShowClient
************************************************************************
* wwConnectDemo :: ShowClient
*****************************
***  Function: Shows the client information as drilled down to by
***            from the ShowHours Form
************************************************************************
LOCAL lcOutfile, lnPlusSign, lnParms

*** This is the output file name
lcOutFile=Request.GetOutFile()

*** Get the second command line parameter (wc.dll?wwdemo~ShowClient~Rick+Strahl)
*** lnParms=Request.aCGIParms()  && load parameter array - happens in Process Method
lcName=Request.QueryString(3)
IF EMPTY(lcName)
   =THIS.ErrorMsg("Can't find specified client.")
   RETURN
ENDIF

SELECT company,careof AS Contact,address,phone,email ;
   FROM TT_CUST ;
   WHERE UPPER(company)=UPPER(lcName) ;
   INTO CURSOR QUERY

IF _TALLY<1
   =THIS.ErrorMsg("Customer not found...","Bad data is not a good idea, is it now?")
   RETURN
ENDIF


*** Create the document header
Response.HTMLHeader("Client Information for "+TRIM(query.company),;
            "Visual FoxPro Nested CGI Sample",BACKIMG)

*** Use a ShowCursor Object to display the record
*** and pass it the HTML object
loShowCursor=CREATEOBJECT("wwShowCursor",Response)

*** Show the record with field name labels
loShowCursor.cExtraTableTags = [STYLE="Font:normal 10pt 'Arial'"]
loShowCursor.lCenterTable=.f.
loShowCursor.cTableWidth="450"
loShowCursor.ShowRecord()

Response.HTMLFooter(PAGEFOOT)

RETURN
*EOP ShowClient

FUNCTION ShowSlip
************************************************************************
* wwConnectDemo :: ShowSlip
***************************
***  Function: Displays the drill down time slip information
***            information based on a selecting the hotkey
*************************************************************************
LOCAL lcOutfile, lnPlusSign, lcTTID, lnparms

*** Get Customer Id passed as 3rd parameter (wc.dll?wwdemo~ShowClient~CustId)
lcTTID=Request.QueryString(3)
IF EMPTY(lcTTID)
   =THIS.ErrorMsg("No Such Time Slip.")
   RETURN
ENDIF

SELECT tt_cust.company , ;
       timebill.Datein,timebill.TimeIn,timebill.timeout,;
       timebill.totalhours,timebill.Descript ;
   FROM TIMEBILL,tt_cust ;
   WHERE TTID=lcTTID AND ;
   timebill.custno=tt_cust.custno ;
   INTO CURSOR QUERY

*** Create the document header
Response.HTMLHeader("Time Slip Lookup ","Visual FoxPro nested CGI Sample",BACKIMG)


*** Use a ShowCursor Object to display the record
*** and pass it the HTML object
loShowCursor=CREATEOBJECT("wwShowCursor",Response)

*** Show the record with field name labels
loShowCursor.cExtraTableTags = [STYLE="Font:normal 10pt 'Arial'"]
loShowCursor.lCenterTable=.f.
loShowCursor.cTableWidth="450"
loShowCursor.ShowRecord()

Response.Sendln("<hr><PRE>")   && Send Preformatted text

Response.SendLn("<b>   Company</b>: "+query.company)
Response.SendLn("    <b>  Date</b>: "+DTOC(query.datein))
Response.SendLn("   <b>Time In</b>: "+query.timein)
Response.SendLn("  <b>Time Out</b>: "+query.timeout)
Response.Sendln("             --------------")
Response.SendLn("<b>Total Time</b>: "+STR(query.totalhours,5,2)+" hours")
Response.SendPar()
Response.SendLn(" <b>Work Done</b>: "+Response.SendMemoLn(query.descript,.F.,45,12,.T.) )

Response.SendLn([</PRE>])

Response.HTMLFooter(PAGEFOOT)
RETURN


FUNCTION MailIt
************************************************************************
* wwDemo :: MailIt
*********************************
***  Function: Sends a standard form letter to the email address
***            specified by the sender.
***    Assume: wwIPStuff.dll is somewhere in VFP path
************************************************************************
LOCAL lcHeader

lcEmail=Request.Form("Email")
IF !EMPTY(lcEmail)
  *** NOTE: You have to customize the Mail server settings etc here!
  THIS.oCGIServer.SendMail(MAILSERVER, MAILFROMNAME, ;
      MAILFROMEMAIL,;
      lcEmail,CCList, ;
      "Web Connection generated E-Mail Sample",;
      "This message has been generated by West Wind Web Connection's"+CR+;
      "demo page on "+dtoc(date())+" at "+time()+" Pacific Standard Time."+CR+CR+CR+;
      "Please come back and visit the West Wind Technologies site!" + CR + CR +;
      "http://www.west-wind.com/"+CR+;
      "http://www.west-wind.com/wwthreads"+CR+CR+;
      "+++ Rick ---"+CR)

   lcHeader="Email message sent..."
   lcMessage="Please note that no error checking was performed on sending the message so the message can be processed in the background, while Web Connection continues data services."
ELSE
   lcHeader="Email message not sent..."
   lcMessage="The email address you specified was left blank. Please make sure you enter "+;
             "an email address and try again..."
ENDIF

*** Generate the page manually so we can add AutoRefresh Header
Response.ContentTypeHeader()

Response.SendLn([<HTML>])
Response.SendLn([<HEAD>])

Response.AutoRefreshPage(HOMEPAGE,10)   && Go back to defaul page after 10 secs

Response.SendLn([<TITLE>]+lcHeader+[</TITLE></HEAD>])
Response.SendLn([<BODY BACKGROUND="]+BACKIMG+[">])
Response.SendLn([<h2>]+lcHeader+[</h2></H1>])
Response.SendLn([<HR>])
Response.SendLn([<p>])
Response.SendLn(lcMessage)
Response.SendLn([<p>])
Response.HTMLFooter(PAGEFOOT)

ENDFUNC
* Mailit

FUNCTION Redirect
************************************************************************
* CGIProcess :: Redirect
*********************************
***  Function: Redirection button on the sample page. Redirects to
***            the Wconnect example home page by default
***      Pass: lcLocation  -   URL or FTP to redirect to
************************************************************************
LPARAMETER lcLocation

lcLocation=IIF(type("lcLocation")="C",lcLocation,;
               "http://www.west-wind.com/wconnect/")

Response.HTMLRedirect(lcLocation)

RETURN
* Redirect

FUNCTION CookieTest
************************************************************************
* wwDemoProcess :: CookieTest
*********************************
***  Function: Demonstrate how to set and retrieve HTML Cookies
************************************************************************

*** Try to retrieve the cookie...
lcId=Request.GetCookie("WWUSERID")

*** Create Standard Header
loHeader=CREATEOBJECT("wwHTTPHeader")
loHeader.DefaultHeader()

*** If not Found
IF EMPTY(lcId)
   *** Create the cookie
   lcId=SYS(3)
   loHeader.AddCookie("WWUSERID",lcId,"/wconnect")
   
   *** To specify a permanent cookie supply NEVER or a specific expiration date
   *** loHeader.AddCookie("WWUSERID",lcId,"/","NEVER")
ENDIF            

*** Send Header and make sure to pass the Content Type (loHeader)
Response.HTMLHeader("Cookie Test","Cookie Test",BACKIMG,loHeader)

Response.SendLn("If you hit this page repeatedly and your browser supports HTTP Cookies, you should see the "+;
   "Cookie value below stay the same. The value is stored on the client side by the browser and "+;
   "can be used to keep state for applications like stores or multiple form transactions.<p> "+;
   "Cookies can be stored permanently, but Web Connection oCGI.SetCookieString() method has a "+;
   "a life time of the Browser Session - if you shut down and restart your browser a new ID will be assigned...<p>"+;
   "Cookie Value (wwUserId):  <b>" +lcId +"</b><p> ")

Response.HTMLFooter( PAGEFOOT )

RETURN

FUNCTION SessionDemo
************************************************************************
* wwDemo :: SessionDemo
*********************************
***  Function: Demonstrates a simple use of the Session Object to
***            dynamically store user information.
***            Use it to save information about your users that is
***            required to keep state between requests, such as 
***            preferences, last page, previous query filters etc.
************************************************************************
LOCAL  lcValue, lcVariable

*** Initialize the Session object
*** Reads and writes the Cookie and finds the current session
THIS.InitSession()
THIS.oSession.nSessionTimeout=900   && Seconds  - 15 minutes

lcVariable = Request.GetFormVar("txtVariable")
lcValue = Request.Form("txtValue")


IF !EMPTY(lcVariable)
  *** Let's write a session variable
  THIS.oSession.SetSessionVar(lcVariable,lcValue)
ENDIF  

Response.HTMLHeader("Session Object Sample")

*** Display the record from the Session Object
SELE wwSession
loSC=CREATE("wwShowCursor",Response)
loSC.ShowRecord()

Response.HTMLFooter( PAGEFOOT )

ENDFUNC
* wwDemo :: SessionDemo




FUNCTION Authentication
************************************************************************
* wwDemoProcess :: Authentication
*********************************
***  Function: Demonstrate how to check authorization for users
************************************************************************
LOCAL lcUsername, lcPassword


*** Try to retrieve the cookie...
lcUserName=Request.GetCGIVar("Authenticated Username")
lcPassword=Request.GetCGIVar("Authenticated Password") && IIS doesn't pass this

IF EMPTY(lcUserName)   && Any validations against password here...
    *** Not Validated - Send Password Dialog
    THIS.oHTML.HTMLAuthenticate(Request.GetServername())
   RETURN
ENDIF   

THIS.ErrorMsg("You've been validated for this request...",;
              "You've entered a username of <b> "+lcUserName+ ;
              "</b> and password of <b> "+lcPassword + "</b><p>"+;
              "Subsequent requests for this server realm will not prompt you for "+;
              "a password again until you shut down your browser. Password validations "+;
              "persist accross the session.<p>"+;
              "Please note that password validation depends on the Web server. "+;
              "MS IIS will not pass a password back and forces all users through the NT security mechanism "+;
              "so a username is only returned to you if the user is a valid user as entered in the registry. "+;
              "Commerce Builder and Website allow more flexibility in letting set up priviliges "+;
              "on the individual files/directories, or not setting up any rights at all and letting your CGI request handle validation.")

RETURN
*EOF Authentication


FUNCTION BannerTest
************************************************************************
* wwDemoProcess :: BannerTest
*********************************
***  Function: Shows how to use the wwBanner class - two lines of code
************************************************************************
LOCAL lcImageLink, loBanner

*** Create banner class
loBanner=CREATEOBJECT("wwBanner")

*** Since we're not tracking users here, let's use
*** random images from the wwbanners table table
lcImageLink=loBanner.GetBanner(-1)   && -1 is random or use banner number

*** Note the image is embedded into the message below

THIS.ErrorMsg("Welcome to the rotating image page...",;
              lcImageLink+;
              "The picture to the left of this text will change each time you "+;
              "refresh this page (well, it's random so it's possible to "+;
              "get the same one twice). Hit the Refresh button to see the image change. " +;
              "When setting up the image you can specify additional image tags to allow " +;
              "sizing and spacing of the image among other things.<p>"+;
              "Check out the maintainence page that's included in the banner class on the "+;
              Response.HREF(Request.GetPreviousURL(),"previous link",.t.)+". You may add your "+;
              "imagelinks to this page if you like. Just enter an image that exists "+;
              "somewhere on the net and attach a URL to go to a location...<p>"           )

ENDFUNC
* BannerTest

FUNCTION Banners
************************************************************************
* wwDemoProcess :: Banners
*********************************
***  Function: Shows all available banners and an input form to add
***            new entries and delete existing.
***
***            Also handles the 'CLICK' event
************************************************************************
LOCAL loBanner

loBanner=CREATEOBJECT("wwBanner")

loBanner.cBaseURL="/wconnect/wc.dll?wwdemo~Banners"
loBanner.cPageFoot=PAGEFOOT

THIS.oHTML.Send(loBanner.HandleHTMLRequest(THIS.oCGI))

ENDFUNC
* ShowBanners



FUNCTION ShowGuest
************************************************************************
* wwDemoProcess :: ShowGuest
*********************************
***  Function: Guest Book Interactive Browser. Note that all this code
***            is not related to creating HTML at all, but rather
***            consists of setting up the logic for navigation and
***            adding editing entries.
************************************************************************
LOCAL lcCustId, lcMoveWhere, llError
PRIVATE pcErrorMsg, pcPassword

IF  Request.IsIE4() AND ;
    ATC("/wconnect/",Request.GetPreviousURL()) = 0
	   THIS.IEGuest()
	   RETURN
ENDIF   

** Retrieve the Operation option (Next, Previous etc.)
lcMoveWhere=UPPER(Request.QueryString(3))

*** Grab the commandline Customer Id
lcCustId=Request.QueryString(4)

*!* *** Handle Refresh Popup List Button via Override
*!*	IF !EMPTY(Request.Form("btnList"))
*!*	   lcMoveWhere = "GO"
*!*	   lcCustId = Request.Form("txtList")
*!*	ENDIF

pcPassword=""
pcErrorMsg=""
llError=.F.

IF !USED("Guest")
  USE (THIS.cDatapath + "GUEST") IN 0
ENDIF
SELE GUEST

  
IF EMPTY(lcCustId)
  lcMoveWhere="BOTTOM"
ELSE
  IF lcCustId#"NEW_ID"
     LOCATE FOR CustId=lcCustId
     IF !FOUND()
        pcErrorMsg="Invalid Record. Going to bottom of file..."
        lcMoveWhere="BOTTOM"
     ENDIF   
  ENDIF
ENDIF   


DO CASE 
  CASE lcMoveWhere="GO"
     *** Do nothing - just display 
  CASE lcMoveWhere="NEXT"
     IF !EOF()
        SKIP  
        IF EOF()
           pcErrorMsg="Last Record in table..."
        ENDIF
     ELSE
        GO BOTTOM
     ENDIF
     
     IF EOF()
        GO BOTTOM
        pcErrorMsg="Last Record in table..."
     ENDIF
  CASE lcMoveWhere="PREVIOUS" AND !llError
     IF !BOF()
        SKIP -1
     ENDIF
     IF BOF()
        pcErrorMsg="Beginning of File..."
     ENDIF

  CASE lcMoveWhere="TOP"
    GO TOP
    DO WHILE EMPTY(guest.name) AND !EOF()
       SKIP
    ENDDO

  CASE lcMoveWhere="BOTTOM"
     GO BOTTOM
     DO WHILE EMPTY(guest.name) AND !BOF() AND !EOF()
        SKIP -1
     ENDDO
  
  CASE lcMoveWhere="ADD"
     *** Don't add record - move to 'ghost rec' to show blank record
     GO BOTTOM
     SKIP
     
     pcErrorMsg="Please fill out the form below and click the Save button..."
  
  CASE lcMoveWhere="SAVE"
	 lcName = Request.Form("TXTNAME")
	 lcPassword = Request.Form("txtPASSWORD")

     IF EMPTY(lcName) AND EMPTY(Request.Form("txtCompany")) 
        THIS.ErrorMsg("Incomplete Input","You have to enter at least a name or company.")
        USE IN GUEST
        RETURN
     ENDIF
     IF EMPTY(Request.Form("txtPassword"))
        THIS.ErrorMsg("Incomplete Input","You have to enter a password to save this entry.")
        USE IN GUEST
        RETURN
     ENDIF       

     IF lcCustId="NEW_ID"
         LOCATE FOR UPPER(NAME)=UPPER(TRIM(Request.Form("txtName"))) AND ;
                    UPPER(COMPANY)=UPPER(TRIM(Request.Form("txtCompany")))
         IF !FOUND()
            APPEND BLANK
            REPLACE custid with sys(3), ;
                   entered with datetime(), ;
                   password with Request.Form("txtPassWord")
          ELSE
             THIS.ErrorMsg("This name has already been entered...",;
                           "Please check if you've previously entered yourself into the guestbook, "+;
                           "or change your name entry slightly...")
             USE IN GUEST                                
             RETURN
          ENDIF
     ELSE
         *** Check password
         pcPassWord=PADR(Request.Form("txtPassWord"),8)
         IF UPPER(guest.password) # UPPER(pcPassword)
            pcErrorMsg="The password you typed does not allow you to change the selected entry..."
            pcCustId=guest.custid
            pcPassword=""
            Response.ExpandTemplate(THIS.cHTMLPagePath+"Guest.wc","FORCE RELOAD")           
            RETURN
         ENDIF
     ENDIF

     REPLACE name with Request.Form("txtName"), ;
             company with Request.Form("txtCompany"),;
             location with Request.Form("txtLocation"),;
             Email with Request.Form("txtEmail"),;
             Message with Request.Form("txtMessage")
             
            
      pcErrorMsg="Record saved..."
ENDCASE

*** Prime pcCustId for all links
IF lcMoveWhere#"ADD"
   pcCustId=guest.custid
ELSE
   pcCustId="NEW_ID"   
ENDIF
pcPassword=""

pcHomePath=HOMEPATH

*** Display GUEST.WC - This HTML form contains the fields and 
*** pcErrorMsg variable...
Response.ExpandTemplate(THIS.cHTMLPagePath+"Guest.wc","FORCE RELOAD")

IF USED("Guest")
   USE IN Guest
ENDIF
   
ENDFUNC
* ShowGuest

FUNCTION BrowseGuests
************************************************************************
* wwDemoProcess :: BrowseGuests
*******************************
***  Function: Shows a list of Guests in table form for the Guest
***            Sample application.
***            This example manually creates the Browse page.
************************************************************************
LOCAL lcOrder

*** Retrieve the Order Radio Button Value - Name, Company, Location
lcOrderVal=TRIM(Request.Form("radOrder"))
IF EMPTY(lcOrderVal)
  lcOrderVal="Name"
ENDIF  

*** Build an Order By expression
lcOrder="UPPER("+lcOrderVal+")"   


SELECT [<A HREF="wc.dll?wwdemo~ShowGuest~Go~]+custid+[">]+Name+[</a>] as Guest, ;
   company, location,;
   &lcOrder ;
   FROM (THIS.cDatapath + "Guest") ;
   ORDER BY 4 ; 
   INTO CURSOR TQuery

*** Set up so we can us HTML tables
Response.SetAllowHTMLTables(Request.IsNetscape())

Response.HTMLHeader("Guest Book Browser",,BACKIMG,"Force Reload")
Response.SendLn([ <FORM ACTION="wc.dll?wwdemo~BrowseGuests" METHOD="POST">])
Response.SendLn([ Sort by: <input type="radio" value="Name" name="radOrder" ]+IIF(lcOrderVal="Name","checked=true","")+[>Name ])
Response.SendLn([ <input type="radio" value="Company" name="radOrder" ]+IIF(lcOrderVal="Company","checked=true","")+[> Company  ])
Response.SendLn([ <input type="radio" value="Location" name="radOrder"]+IIF(lcOrderVal="Location","checked=true","")+[> Location<br>])
Response.SendLn([ <input type="submit" value="Change Order">])
Response.SendLn([ </FORM> <p>])

*** Explicitly set up headers so we only display first 3 cols
DIMENSION laHeaders[3]
laHeaders[1]="Name"
laHeaders[2]="Company"
laHeaders[3]="Location"

*** Display the table
Response.ShowCursor(@laHeaders)

Response.HTMLFooter(PAGEFOOT)

IF USED("Guest")
   USE IN Guest
ENDIF

ENDFUNC
* BrowseGuests



FUNCTION IEGuest
************************************************************************
* wwDemo :: IEGuest
*********************************
***  Function: Demonstrates use of the wwHTMLForm class to render 
***            VFP forms on the fly as IE 4.0 Dynamic HTML.
***
***            This single method handles all of the guest book links
***            by reading the btnSubmit value - btnSubmit is used on
***            all buttons on the form and lcAction thus retrieves
***            the button 'Action'. Based on the action the form is
***            instantiated and moved to the appropriate record to
***            display. At this point the form is rendered as HTML
***            using the wwHTMLForm :: ShowContainer() method.
***
***    Assume: Runs only on IE 4.0
************************************************************************
LOCAL oGuest, lcCustId, lcAction

#IF wwVFPVersion = 30
   THIS.ErrorMsg("Sorry","You need Visual FoxPro 5.0 to dynamically render forms...")
   RETURN
#ENDIF

IF !Request.IsIE4()
   THIS.ErrorMsg("Internet Explorer 4.0 required",;
                 "This demo uses Internet Explorer 4.0's Dynamic HTML features to allow "+ ;
                 "rendering VFP forms to look very much like Visual FoxPro forms including "+;
                 "font, color, size, enabled and visibility settings. You can view the "+;
                 [<A HREF="/wconnect/wc.dll?wwdemo~ShowGuest">standard guestbook</a> application with any browser if you like...<p><CENTER>]+;
                 [You can download the <a HREF="http://www.microsoft.com/ie/ie40/">Platform Preview of IE 4.0</a> from the MS website<p>]+;
                 [<a HREF="http://www.microsoft.com/ie/"><IMG SRC="/images/ielogo.gif" BORDER=0></a></CENTER>])
                    RETURN
ENDIF


 
*** All buttons are *ALWAYS* tied to btnSubmit
lcAction=UPPER(Request.Form("btnSubmit"))
lcCustId=Request.Form("pgfInfo.Page1.txtCustId")

*** This is optional - the form can render as a fully self contained HTML doc
***                    Here I demonstrate how to embed the form into HTML
***                    To render the form as 'Full HTML' use the lShowAsFullHTML flag
Response.HTMLHeader(,"IE 4.0 Guest Book Browser",BACKIMG)
Response.SendLn([<CENTER>])

DO FORM Guest2.scx NAME oGuest LINKED  NOSHOW

*** Set up the Form rendering class and point it at the oGuest form
oHTMLForm=CREATEOBJECT("wwHTMLForm",oGuest,Response)
oHTMLForm.lShowAsFullHTML=.F.
oHTMLForm.lShowFormCaption=.T.    && Show VFP Title Bar
oHTMLForm.lAbsolutePosition=.F.   && Float form
oHTMLForm.lFormBackgroundTransparent=.F.
oHTMLForm.cFormAction="/wconnect/wc.dll?wwdemo~IEGuest"

DO CASE
   CASE lcAction = "REFRESH" OR  EMPTY(lcAction)
     IF !EMPTY(lcAction)
        *** We're refreshing from the listbox
       lcValue=Request.Form("lstGuests")
       
       *** Unparse the CustId which is embedded in the list
       lcCustId=SUBSTR(lcValue,AT("|",lcValue)+1)
     ENDIF

     *** Get the form ready by navigating and fixing up any fields

     *** Set the value of the Radio button
     oHTMLForm.SetValue(oGuest.optListOrder,Request.Form("optListOrder"))

     oGuest.ShowForm(lcCustId,1)     && Show in 'View' only mode
    
     *** Save and Clear password on the form so it's not readable from the HTML source
     *** Since the form is databound w/o buffering changing will update the table
     lcPassWord=oGuest.pgfInfo.Page1.txtPassword.value
     oGuest.pgfInfo.Page1.txtPassWord.value=""

     oHTMLForm.ShowContainer()
     
     *** Now reset the password
     oGuest.pgfInfo.Page1.txtPassWord.value=lcPassword

  CASE lcAction = "NEW"
     oGuest.Edit(2) && Show Edit mode with Empty fields

     *** Some HTML that gets embedded before the </FORM> tag
     *** Used here to identify a new record using hidden form field cNew
     oHTMLForm.cExitFormHTML=[<INPUT TYPE="HIDDEN" NAME="cNew" VALUE="YES">]

     oHTMLForm.ShowContainer()

   CASE lcAction = "EDIT"
     oGuest.ShowForm(lcCustId,1)     && Show Edit mode with existing fields
     oGuest.Edit()
      
     *** Save and Clear password on the form 
     *** Since the form is databound w/o buffering changing will update the table
     lcPassWord=oGuest.pgfInfo.Page1.txtPassword.value
     oGuest.pgfInfo.Page1.txtPassWord.value=""
     
     oHTMLForm.ShowContainer()
     
     *** Now reset the password
     oGuest.pgfInfo.Page1.txtPassWord.value=lcPassword
     
   CASE lcAction = "SAVE"
     *** Check for the hidden field cNew     
     llNew=IIF(!EMPTY(Request.Form("cNew")),.T.,.F.)
     
     IF EMPTY(Request.Form("pgfInfo.Page1.txtName")) OR  EMPTY(Request.Form("pgfInfo.Page1.txtCompany"))
        THIS.StandardPage("Invalid Submission","Please fill out the name and/or company fields.")
        RETURN
     ENDIF
     
     IF llNew
        INSERT INTO Guest (CustId,Entered) VALUES (SYS(3),DATETIME())
        sele guest
        lcCustId=Guest.custid
     ENDIF

     oGuest.ShowForm(lcCustId,0)     && Show Edit mode with empty fields

     *** Make sure editing has proper password
     IF !llNew AND !oGuest.CheckPassword(Request.Form("pgfInfo.Page1.txtPassword"))
        THIS.ErrorMsg("Invalid Password","Sorry you can't update this record...")
        RETURN
     ENDIF

     *** Now update the values from the request!
  
     *** First let's make sure these values are *NOT* updated by setting them to 'Null'
     Request.SetKey("lstGuests",WWC_NULLSTRING) 
     Request.SetKey("pgfInfo.Page1.txtCustId",WWC_NULLSTRING) 
     Request.SetKey("pgfInfo.Page1.txtEntered",WWC_NULLSTRING) 

     *** Now update the rest
     oHTMLForm.SetValues(Request)

     oGuest.Save()          && Update the form Buttons
     
     *** Send email notice to user and Rick
     IF llNew
     *** Note: You have to modify the mail server settings here
     THIS.oCGIServer.SendMail(MAILSERVER, ;
        MAILFROMNAME, ;
        MAILFROMEMAIL,;
        guest.email,CCList, ;
        "Your West Wind Guest Book Submission",;
        TRIM(Guest.Name) + "," + CR + CR +;
        "Thank you for your guest book entry. Be sure to come back and visit "+CR+;
        "the West Wind Technologies site at http://www.west-wind.com/."+CR+CR+;
        "At " + lower(TtOC(entered)) +" you entered the following info:"+ CR +CR +;
        "Company: " + guest.company+CR+;
        "   From: " + guest.location+CR+;
        "  Email: " + guest.email +CR + CR +;
        "Message: " + CR + ;
        STRTRAN(TRIM(guest.Message),CHR(13),CHR(13)+CHR(10)) + CR + CR + ;
        "Your password to edit this entry is: " + guest.password + CR +CR+;
        "+++ Rick ---")
     ENDIF
 
     oHTMLForm.ShowContainer()

   CASE lcAction = "DELETE"

     oGuest.ShowForm(lcCustId,1)     && Show View mode

     IF !oGuest.CheckPassword(Request.Form("pgfInfo.Page1.txtPassword"))
        THIS.ErrorMsg("Invalid Password","Sorry you can't update this record...")
        RETURN
     ENDIF

     oGuest.DeleteRecord(lcCustId)
     oGuest.ShowForm(,1)     && Show View mode

     oHTMLForm.ShowContainer()
     
   CASE INLIST(lcAction,"|<<","<<",">>",">>|")
      lcNav="TOP"
      DO CASE
         CASE lcAction="|<<"
           lcNav="TOP"
         CASE lcAction="<<"
           lcNav="PREV"
         CASE lcAction==">>"
           lcNav="NEXT"
         CASE lcAction==">>|"
           lcNav="BOTTOM"
      ENDCASE 

      *** Set the value of the Radio button
      oHTMLForm.SetValue(oGuest.optListOrder,Request.Form("optListOrder"))

      oGuest.ShowForm(lcCustId,1)     && Show View mode
      oGuest.Navigate(lcNav)
      
      *** Save and Clear password on the form 
      *** Since the form is databound w/o buffering changing will update the table
      lcPassWord=oGuest.pgfInfo.Page1.txtPassword.value
      oGuest.pgfInfo.Page1.txtPassWord.value=""
     
      oHTMLForm.ShowContainer()
     
      *** Now reset the password
      oGuest.pgfInfo.Page1.txtPassWord.value=lcPassword
   CASE lcAction = "EXIT"
     Response.HTMLRedirect("/wconnect/")     
     RETURN

   OTHERWISE
     THIS.ErrorMsg("Sorry","This feature has not been implemented yet")

ENDCASE

Response.SendLn([</CENTER>])
Response.HTMLFooter(PAGEFOOT)

ENDFUNC
* IEGuest

FUNCTION IEFormDemo
************************************************************************
* wwDemoProcess :: IEFormDemo
*********************************
***  Function: Demonstrates a simple implementation of HTML Form.
***            Shows off use of Page Frame and data bound listbox.
************************************************************************

#IF wwVFPVersion < 5
   THIS.ErrorMsg("Sorry","You need Visual FoxPro 5.0 or later to dynamically render forms...")
   RETURN
#ENDIF

*** All buttons are *ALWAYS* tied to btnSubmit
lcAction=UPPER(Request.Form("btnSubmit"))

lcListValue=Request.Form("PageFrame1.Page2.lstCustomers")

 DO FORM tt_cust.scx NAME oCust LINKED NOSHOW
 
 THIS.oHTML.HTMLHeader(,"HTML VFP Form Rendering Demo")
 THIS.oHTML.SendLn("<CENTER>")
 
 oHTMLForm=CREATEOBJECT("wwHTMLForm",oCust,THIS.oHTML)
 oHTMLForm.lShowAsFullHTML=.F.
 oHTMLForm.lShowFormCaption=.T.
 oHTMLForm.lAbsolutePosition=.F.
 oHTMLForm.cFormAction="/wconnect/wc.dll?wwdemo~IEFormDemo"
 
 *** Handle Grid Selection 
 IF !EMPTY(lcListValue)
     oCust.Navigate("SEARCH",lcListValue)
 ELSE
     oCust.Navigate()
 ENDIF

oHTMLForm.ShowContainer()

THIS.oHTML.Send([</center>])


THIS.oHTML.HTMLFooter(PAGEFOOT)
     
ENDFUNC
* IEFormDemo


FUNCTION IEFormDemo2
************************************************************************
* wwDemoProcess :: IEFormDemo2
*********************************
***  Function: Demonstrates a simple implementation of HTML Form.
***            Shows off use of Page Frame and grid display.
************************************************************************

#IF wwVFPVersion = 30
   THIS.ErrorMsg("Sorry","You need Visual FoxPro 5.0 to dynamically render forms...")
   RETURN
#ENDIF
 
 THIS.oHTML.HTMLHeader(,"HTML VFP Form Rendering Demo using PageFrame")
 THIS.oHTML.SendLn("<CENTER>")

 *** Retrieve Grid Selection if one was made
 lcId = Request.Form("grdSubmit")
  
 *** Pass ID to the form
 DO FORM IEDemoForm NAME oCust WITH lcId LINKED  NOSHOW 

 oHTMLForm=CREATEOBJECT("wwHTMLForm",oCust,THIS.oHTML)
 oHTMLForm.lShowAsFullHTML=.F.
 oHTMLForm.lShowFormCaption=.T.
 oHTMLForm.lAbsolutePosition=.F.
 oHTMLForm.cFormAction="/wconnect/wc.dll?wwdemo~IEFormDemo2"

 *** Now allow capturing the grid selection by creating a hidden
 *** form variable and storing the result to it before submitting
 *** the form
 oHTMLForm.cExitFormHTML = ;
		[<input type="HIDDEN" NAME="grdSubmit">] + CR +;
		[<script language="VBScript">] + CR +;
		[Sub masterpageframe_page3_grid1_wwItemClick(lcKey,lcText,lnIndex)] + CR +;
		[  wwForm.grdSubmit.Value = lcText] + CR + ;
		[  call wwForm.submit()] + CR + ;
		[end sub] + CR +;
		[</script>]

 oCust.Refresh
 oHTMLForm.ShowContainer()
 
 oHTMLForm = .F.
 oCust = .F.

*** Demonstrate generating external HTML - this could come from a merge file
THIS.oHTML.Send([<BR CLEAR ALL><HR><font face="Arial" size="0"><b>Note: In order to download the grid ActiveX control ]+ ;
                [your security settings must be set to medium or low.<br>]+;
                [Without the VB5 runtime a onetime total download may be over 1 meg. Actual control is 14k.<br>]+;
                [Download is required only for the grid control and only occurs once.</font>])


THIS.oHTML.SendLn("</CENTER>")
THIS.oHTML.HTMLFooter(PAGEFOOT)
     
ENDFUNC
* IEFormDemo

FUNCTION IECustInfo
************************************************************************
* wwDemoProcess :: IECustInfo
*********************************
***  Function: Demonstrates a simple implementation of HTML Form.
***            Shows off use of Page Frame and data bound listbox.
************************************************************************
LOCAL  oGuest, lcCustId, lcAction

#IF wwVFPVersion = 30
   THIS.ErrorMsg("Sorry","You need Visual FoxPro 5.0 to dynamically render forms...")
   RETURN
#ENDIF

*** Web Connection
lcFormAction = "/wconnect/wc.dll?wwDemo~IECustInfo"

*** All buttons are *ALWAYS* tied to btnSubmit
lcAction=UPPER(Request.Form("btnSubmit"))
lcName=Request.Form("combo1")

*** Back to WC Demo Page
IF lcAction = "EXIT"
   Response.HTMLRedirect("./")
   RETURN
ENDIF   

DO PATH WITH ".\wwdemo\custform"

DO FORM "customer.scx" NAME oCust LINKED WITH lcName NOSHOW

*** Create the rendering object
oHTMLForm=CREATEOBJECT("wwHTMLForm",oCust,Response)

IF lcAction="EDIT"
   oCust.EditMode(.T.)
ENDIF
IF lcAction="SAVE"
   oCust.Navigate("CUSTSEARCH",lcName)
   oCust.EditMode(.T.)

   *** Now update the form values
   oHTMLForm.SetValues(Request)
   
   *** And tell the form to save it
   oCust.SaveEntry()
ENDIF
 
Response.HTMLHeader(,"HTML VFP Form Rendering Demo")
Response.SendLn("<CENTER>")
 
oHTMLForm.lShowAsFullHTML=.F.
oHTMLForm.lShowFormCaption=.T.
oHTMLForm.lAbsolutePosition=.F.
oHTMLForm.cFormAction=lcFormAction

oHTMLForm.ShowContainer()

*HTMLForm = .F.
*Cust = .F.

Response.Send([</center>])
Response.HTMLFooter(PAGEFOOT)
 
#IF FOXISAPI
  RETURN Response.GetOutput()    
#ENDIF

ENDFUNC
* IECustInfo

FUNCTION PDFReport
************************************************************************
* wwDemoProcess :: PDFReport
*********************************
***  Function: Create a report and output it as a PDF document.
***    Assume: PDFWriter is installed and configued per wwPDF.prg
************************************************************************

lcCompany = UPPER(Request.Form("Company"))

SELECT * ;
   FROM TT_Cust ;
   WHERE UPPER(Company) = lcCompany ;
   ORDER BY Company ;
   INTO CURSOR TQuery

*lcFilename = SYS(2015) + ".pdf"
*!*	HTTP/1.0 200 OK
*!*	Content-type: application/pdf
  
oPDF=CREATE("wwPDF","WINNT")

*oPDF.SetLandscapemode()

lcPDF = oPDF.PrintReportToString("custlist") 

Response.Write("HTTP/1.0 200 Ok"+CR)
Response.Write("Content-type: application/pdf" +CR)
Response.Write("Content-length: "+LTRIM(STR(LEN(lcPDF))) +CR +CR)

*Response.ContentTypeHeader("application/pdf")
Response.Write(lcPDF)

ENDFUNC
* FIDemoServer :: PDFReport


FUNCTION ShowCursor
************************************************************************
* wwDemoProcess :: ShowCursor
*********************************
***  Function: This request demonstrates how the ShowCursor object
***            works for displaying data from a table.
************************************************************************
LOCAL loShowCursor, lcType

IF !USED("TT_CUST")
  use tt_cust IN 0
ENDIF

SELE TT_Cust  

lcCustId=""

lcType=Request.Form("Type")
IF EMPTY(lcType)
   lcType="BROWSE"
ENDIF  

Response.HTMLHeader("ShowCursor Demo",,BACKIMG)
Response.Send([This request shows the three different methods of display that the wwShowCursor ]+;
            [class provides. <p>])

*** Selection Form - pre-select current choice
Response.SendLn([<FORM METHOD="POST" ACTION="wc.dll?wwdemo~ShowCursor">])
Response.FormRadio("TYPE","BROWSE","<i>ShowCursor</i> mode",lcType="BROWSE")
Response.FormRadio("TYPE","EDIT","<i>ShowRecord</i> mode",lcType="EDIT")
Response.FormRadio("TYPE","ASCII","<i>ASCII</i> mode",lcType="ASCII")
Response.SendLn("<BR>")
Response.FormButton("btnMode","Display",30)
Response.SendLn([</FORM>])

*** Only show a few fields in BROWSE mode
IF lcType="BROWSE"
  SET FIELDS TO COMPANY, Careof, Phone
ENDIF  

loShowCursor=CREATEOBJECT("wwShowCursor",Response)
loShowCursor.lShowasTable=.t.
loShowCursor.lCenterTable=.F.
loShowCursor.lSumNumerics=.t.


DO CASE
  CASE lcType="BROWSE"
    loShowCursor.ShowCursor()
    SET FIELDS OFF
  CASE lcType="EDIT"
   loShowCursor.cTableWidth="80%"
   loShowCursor.ShowRecord()
  CASE lcType="ASCII"
   Response.SendLn("<PRE>")
   loShowCursor.nASCIILeftColumns=10  && Adjust left
   loShowCursor.ShowASCIIRecord()
   Response.SendLn("</PRE>")
ENDCASE

USE IN TT_CUST

Response.HTMLFooter(PAGEFOOT)

ENDFUNC
* ShowCursor 


FUNCTION SQLShowCursor
************************************************************************
* wcDemoProcess :: SQLShowCursor
*********************************
***  Function: Retrieves some data from SQL Server
***    Assume: Assume you have a ODBC DSN called PUBS to the SQL
***            demo database (Pubs) 
************************************************************************

#IF !ENTERPRISE
   THIS.ErrorMsg("Sorry, can't run this demo",;
                 "This demo requires the Enterprise Edition...")
   RETURN    
#ENDIF

**** CHANGE THIS DSN AND LOGIN INFO TO MATCH YOUR DATABASE!!! ****

*** In typical situations you'll want to create a permanent property
*** on teh server to hold the following reference (THIS.oCGIServer.oSQL for example)
*** and initialize it in the server startup code
loSql = CREATE("wwSQL","DSN=pubs;uid=sa;pwd=")

lcLast = Request.QueryString("Name")

IF TYPE("loSQL") # "O"
   THIS.ErrorMsg("SQL Connection to Pubs failed",;
                 "Most likely this means you need to set up an ODBC data source to the PUBS database")
   RETURN
ENDIF

* Au_fname as First,'<A HREF="SQLAuthor.wcs?Id='+Au_id+'">'+Au_lname+'</a>' as Last,City,Contract 
loSQL.cSQLCursor = "TQuery"
loSQL.Execute([SELECT  Au_fname as First,'<A HREF="SQLAuthor.wcs?Id='+Au_id+'">'+Au_lname+'</a>' as Last,City,Contract  ]+;
              [ FROM Authors ]+;
              [ WHERE au_fname like '] +lcLast +[%' order by au_lname] )
IF loSQL.lError
   THIS.ErrorMsg("SQL Error",loSQL.cErrorMsg)
   RETURN
ENDIF

Response.HTMLHeader("Pubs SQL Server Data")

*** If we're not returning a string send output directly to output source
loShowCursor=CREATE("wwShowCursor",Response)
loShowCursor.ShowCursor()
*Response.ShowCursor()

Response.HTMLFooter(PAGEFOOT)

RETURN
ENDFUNC
* wcDemoProcess :: SQLShowCursor


FUNCTION GraphDemo
************************************************************************
* wcDemoServer :: GraphDemo
*********************************
***  Function: Demonstrates the IEChart method of the wwHTML class.
************************************************************************

*** Pie Chart Demo
CREATE CURSOR TEMP (Label c(20), value I)

Response.HTMLHeader("IE Chart Demo")

*wait window Request.Form("Value 2") + CR + Request.Form("Value_1")


INSERT INTO temp (Label, Value) Values ("Value1",VAL(Request.Form("Value1")) )
INSERT INTO temp (Label, Value) Values ("Value2",VAL(Request.Form("Value2")) )
INSERT INTO temp (Label, Value) Values ("Value3",VAL(Request.Form("Value3")) )
INSERT INTO temp (Label, Value) Values ("Value4",VAL(Request.Form("Value4")) )

Response.IEChart("PIE",1)
Response.SendPar()
Response.IEChart("BAR",1)
Response.SendPar()
Response.IEChart("LINE",1)
Response.SendPar()
Response.IEChart("AREA",1)

Response.HTMLFooter(PAGEFOOT)

USE IN TEMP

ENDFUNC
* wcDemoServer :: GraphDemo


************************************************************************
* wcDemoProcess :: HTTPData
*********************************
***  Function: Run a SQL Statement on the server
***            and return result. Expects a request 
***            generated from wwHTTPData::Execute()
************************************************************************
FUNCTION HTTPData

*** Check for validation here

*** Authentication is optional
*** Supported values in the INI -  Any        -  Any Authorized user
***                                Username   -  A specific user - must match Authenticated User
***                                ""         -  None - no Authentication
*lcAuthUser = "wcuser"  
lcAuthUser = THIS.GetAppIniVar("AuthUser","wwHTTPData")

*** Create Data Object and call Server Side Execute method (wrapper for Process Method)
loData = CREATE("wwHTTPData")
loData.S_Execute(THIS,lcAuthUser)

ENDFUNC
* wwHTTPDataProcess :: Execute



FUNCTION ShowImage
************************************************************************
* wcDemoServer :: ShowImage
*********************************
***  Function: Demos how you can display an image from a file or
***            a memo field. Assumes that the image is in binary
***            format (ie. raw image) and that a content type is
***            set up on the server for this image type. GIF and JPEG
***            are defaults that should always work.
***
***        <HTML>
***           Here's your image: <IMG SRC="/wconnect/wc.dll?wwdemo~ShowImage">
***        </HTML>
************************************************************************


*** Open the image table
IF !USED("Images")
  USE (THIS.cDataPath + "IMAGES") IN 0
ENDIF
SELE IMAGES

*** And locate the Image by the ID passed on the parameter
lcImage=UPPER(Request.QueryString(3))
LOCATE FOR UPPER(ImageId)=lcImage
IF !FOUND()
   *** No error message - this will result in a broken image
   RETURN
ENDIF
 
loHeader=CREATEOBJECT("wwHTTPHeader")
loHeader.SetProtocol()
loHeader.SetContentType("image/gif")

*** Output the HTTP Header
Response.Send(loHeader.GetOutput())

*** And attach the raw image
Response.Send(Images.image)

USE IN IMAGES

ENDPROC
* EOP ShowImage

FUNCTION FileUpload
************************************************************************
* wcDemoProcess :: FileUpload
*********************************
***  Function: Demonstrates how to upload files from HTML forms
************************************************************************

lcFileName = ""
lcFileBuffer = Request.GetMultiPartFile("File",@lcFileName)
lcNotes = Request.GetMultipartFormVar("txtFileNotes")
lcFileName = SYS(2023)+"\"+lcFileName

IF LEN(lcFileBuffer) > 5000000
   THIS.StandardPage("File upload refused",;
                     "Files over 500k are not allowed for this sample...<BR>"+;
                     "File: " + lcFilename)
   RETURN
ENDIF
   
*** Now dump the file to disk
File2Var(lcFileName,lcFileBuffer)



THIS.StandardPage("Thank you for your file upload",;
                  "<b>File Uploaded:</b> " + lcFileName + ;
                  " (" + TRANSFORM(FileSize(lcFileName),"9,999,999") + " bytes)<p>"+ ;
                  "<b>Notes:</b><br>"+ CR + lcNotes )

ENDFUNC
* wcDemoProcess :: FileUpload

FUNCTION ISAPIEcb
************************************************************************
* wwDemo :: ISAPIEcb
*********************************
***  Function: Demonstrates how to use the ISAPIEcb object that
***            can optionally be passed to the WC COM object as
***            a second parameter. This object gives direct access
***            to the ISAPI ECB structure's WriteClient and 
***            GetServerVariable methods. When using the Write()
***            method on the object output is sent *immediately* to
***            the ISAPI output stream.
***    Assume: Only works with Automation/COM operation
***            Requires ServerObject=1 flag in wc.ini
***            Using Write uses cross process COM calls, so this
***            is slower than using building output and then 
***            sending the final result.
************************************************************************

IF ISNULL(THIS.oCGIServer.oISAPIEcb)
   THIS.ErrorMsg("Sorry the ISAPI ECB block is not available.",;
                 "This means either the ISAPIEcb object is not installed "+;
                 "or the ServerObject flag in wc.ini is set to 0.")
   RETURN
ENDIF

loECB = THIS.oCGIServer.oISAPIEcb

loECB.Write("HTTP/1.0 200 OK"+CR)
loECB.Write("Content-type: text/html"+CR+CR)
loECB.Write("<h3>Hang on a second!</h3>")

*loECB.Write(loEcb.ServerVariables("HTTP_USER_AGENT") + "<p>")

loECB.Write("Working<b> " +  SPACE(400) +CR)
wait window timeout 1.5
loECB.Write(". "+Space(450) + CR)
wait window timeout 2.5
loECB.Write(". . "+Space(450)+CR)
wait window timeout 1
loECB.Write(". "+Space(450) + CR)
wait window timeout 2
loECB.Write(". . . "+Space(450) +CR)
wait window timeout 1
loECB.Write(". . "+Space(450) + CR)
wait window timeout 1
loECB.Write(". "+Space(450) + CR)
wait window timeout 1
loECB.Write(". "+Space(450)+CR)
wait window timeout 1
loECB.Write(". "+Space(450))
wait window timeout 1
loECB.Write(". . . "+Space(450))
wait window timeout 1
loECB.Write(". . "+Space(450))

loECB.Write("</b><hr>")

*** Using the Response object still works, but
*** its output appends whatever you send out with
*** the ECB
SELECT Company,Phone FROM TT_CUST INTO CURSOR TQuery

Response.ShowCursor()

Response.HTMLFooter("Page Complete")

ENDFUNC


FUNCTION ShowCode
************************************************************************
* wcDemoServer :: ShowCode
*********************************
***  Function: Routine displays code for a given routine
***    Assume: Retrieves all text between the FUNCTION header and the
***            next FUNCTION statement. Last Method in the class
***            must add a dummy function header to be found.
************************************************************************

lcMethod=Request.QueryString(3)

lcProgram=File2Var(".\wwdemo\wwdemo.prg")

lcCode=Extract(lcProgram,"FUNCTION "+lcMethod,"FUNCTION ")

Response.ContentTypeHeader("text/plain")
Response.SendLn(lcCode)

ENDFUNC
* ShowCode


************************************************************************
* wwDemoProcess :: ShowFileAsText
*********************************
***  Function: Returns a file as text to the browser
***            wc.dll?wwdemo~ShowFileAsText~nocode.wc
************************************************************************
FUNCTION ShowFileAsText

lcFileName=Request.QueryString(3)
IF AT("\",lcFileName) >0
  lcFileText=File2Var(lcFileName)
ELSE
  lcFileText=File2Var(THIS.cHTMLPagePath + lcFileName)
ENDIF

THIS.oHTML.ContentTypeHeader("text/plain")

THIS.oHTML.SendLn("<i>You may have to use 'View Source' to view code as plain text...</i>")
THIS.oHTML.SendLn()

THIS.oHTML.SendLn(lcFileText)

ENDFUNC
* ShowFileAsText



FUNCTION ThrowError
************************************************************************
* wwDemo :: ThrowError
*********************************
***  Function: Demonstrates some of the error handling.
***    Assume: wc.dll?wwDemo~ThrowError
***            Note shareware version will not handle code erros since
***            DEBUGMODE is set to .T.
************************************************************************

poCGI=THIS.oCGI
poHTML=THIS.oHTML

IF UPPER(poCGI.QueryString(3)) = "SCRIPTING"
	IF !USED("TT_Cust")			
	   USE ("TT_Cust") IN 0
	ENDIF

	SELE TT_Cust
	LOCATE FOR company = "Windsurf"

	poHTML.ExpandTemplate(THIS.cHTMLPAGEPATH+"Error.wc")

	USE IN TT_Cust
ELSE
  poHTML.HTMLHeader("Dummy Output for Errors",,BACKIMG)

  *** NOTE: This code will only be handled if #DEFINE DEBUGMODE
  ***       is .F. in WCONNECT.H (won't work in shareware version)
  =EVALUATE(CrashMe)
  
ENDIF

poHTML.HTMLFooter(PAGEFOOT)

ENDFUNC
* ThrowError


************************************************************************
* wwDemoProcess :: Reindex
*********************************
***  Function: Reindexes the demo files
************************************************************************
FUNCTION Reindex

IF OPENEXCLUSIVE(THIS.cDATAPATH+"Guest")   
   wait window nowait "Reindexing Guest..."
   SELE Guest
   DELETE TAG ALL
   INDEX ON custid TAG custid
   INDEX ON upper(left(name,10)) TAG name
   INDEX ON upper(left(company,10)) TAG company
   INDEX ON dtos(entered) TAG date DESCENDING   
   USE
ELSE   
    THIS.ErrorMsg("Can't open Guest table exclusively")
	RETURN
ENDIF

IF OPENEXCLUSIVE(THIS.cDATAPATH+"TT_CUST")
   SELE TT_CUST
   wait window nowait "Reindexing TT_Cust..."
   DELETE TAG ALL
   INDEX ON upper(company) TAG names
   INDEX ON custno TAG custno
   USE
ELSE
    THIS.ErrorMsg("Can't open Customer table exclusively")
	RETURN
ENDIF

THIS.ErrorMsg("Reindexing Complete","The Guest and TT_Cust tables have been updated...")

ENDFUNC
* Reindex

FUNCTION ErrorMsg
************************************************************************
***  Function: Overridden ErrorMsg method that provides a customized
***            error message and simple HTML page display.
***
***            Use icons etc. here to allow people to go back to
***            common places in your application.
***      Pass: lcMessage  -  Error Message to display (detail)
***            THIS.oCGI      -  Current CGI object
*************************************************************************
LPARAMETER lcMessage, lcMessage2, lvHeader

lcMessage=IIF(TYPE("lcMessage")="C",lcMessage,;
   "The server was unable to respond to the CGI request.")
lcMessage2=IIF(type("lcMessage2")="C",lcMessage2,;
   "The server was unable to create the requested document.<BR>"+CHR(13)+;
   "This message was generated by Visual FoxPro...")


*** Reset the HTML output
Response.Rewind()

*** HTML Error Message
lcOutput = ;
	[<table border="0" cellpadding="5" width="100%">] + CR +;
	[  <tr><td align="center" colspan="2" bgcolor="#000000">]+ CR+;
	[  <font color="#FFFFCC" size="4" face="Verdana"><b>] + CR +;
	lcMessage + [</b></font>] + CR +;
	[  </td></tr>] + CR +;
	[  <tr><td><br><p>] + CR +;
	[  <font face="Verdana" size="2" >]+ CR +;
	lcMessage2+ [</font>] + CR +;
	[  </td></tr>] + CR +;
	[</Table>]

Response.HTMLHeader(lcOutput,lcMessage,BACKIMG,lvHeader)

*** Close down the doc and shut off further output
Response.HTMLFooter(PAGEFOOT)

Response.NoOutput(.T.)

RETURN
ENDFUNC
* EOP ErrorMsg


************************************************************************
* wwDemo :: TDCTest
*********************************
***  Function: Create a MS TDC connector data file and feed to
***            client Side ADO control
************************************************************************
FUNCTION TDCTest

SELECT Company, CareOf, INT(BillRate) as Rate ;
   FROM TT_Cust ;
   INTO CURSOR TQUery

Response.Sendln([Company:STRING,Name:STRING,Rate:INT])   
SCAN 
  Response.Send([']+CHRTRAN(Company,"'","`")+[',']+CHRTRAN(CareOf,"'","`")+[',]+STR(Rate) + CR)
ENDSCAN
RETURN

FUNCTION FixString(lcString)
CHRTRAN(lcString,"'","`")
RETURN lcString
ENDFUNC


PROCEDURE NOHEADER
*** ISAPI WC.DLL should add header
THIS.oHTML.Send("<HTML> No header here...</HTML>")
RETURN


PROCEDURE GetFormVars

DIMENSION laVars[1,2]
lnResult = Request.aFormVars(@lavars)

THIS.oHTML.SendLn("<PRE>")

FOR x=1 to lnResult
   THIS.oHTML.SendLn(laVars[x,1] + " = " + laVars[x,2])
ENDFOR

RETURN

FUNCTION Binary

Response.SendLn("THIS" +CHR(0) + " is Cool!"+ CHR(13)+CHR(10)+CHR(0)+"!")

RETURN



FUNCTION ErrorTest
THIS.SendErrorEmail("Test Email " )
THIS.ErrorMsg("Test Complete...")
ENDFUNC

FUNCTION DUMMY
ENDFUNC

ENDDEFINE
*EOC CGIProcess



