DEFINE CLASS WCS_Customer AS Custom

************************************************************************
* WebTools :: CustList
*********************************
***  Function: Test Method that retrieves a customer list based on
***            a name passed.
***      Pass: lcCompany  -  Name of the company to look up
***    Return: HTML of the list
************************************************************************
FUNCTION CustList
LPARAMETERS lcName
LOCAL loHTML

lcName=IIF(type("lcName")="C",UPPER(lcName),"")
		
lcScript = JustFName(poCGI.GetPhysicalPath())		

*** Run Query - Note I'm creating the Hotlink right in the query
***             to be able to use the ShowCursor method to display the
***             cursor with a single command!
SELECT [<A HREF="]+lcScript+[?CustNo=]+URLEncode(tt_cust.custno)+[">]+tt_cust.company+[</a>] as Company,;
       careof as Contact, Phone ;
 FROM (DATAFILEPATH + "TT_CUST") ;
 WHERE UPPER(tt_cust.company)=TRIM(lcName) ;
 INTO CURSOR TQUERY ;
 ORDER BY company

*** Uses Web Connection HTML Class to generate HTML
loHTML=CREATE("wwHTMLString")

loHTML.ShowCursor()

RETURN loHTML.Getoutput()
ENDFUNC
* CustList


************************************************************************
* WebTools :: GetCustObject
*********************************
***  Function: Retrieves a customer and returns an object ref to it
***      Pass: lcCustId   -  Customer ID (may not be Left padded)
***    Return: loCustomer -  Customer Object
************************************************************************
FUNCTION GetCustObject
LPARAMETERS lcCustId

IF !USED("TT_Cust")			
   USE (DATAFILEPATH+"TT_Cust") IN 0
ENDIF

SELE TT_Cust

LOCATE FOR CustNo=PADL(lcCustId,8)
IF FOUND()
   SCATTER NAME loCustomer MEMO
   RETURN loCustomer
ENDIF   

SCATTER NAME loCustomer MEMO BLANK
RETURN loCustomer
ENDFUNC
* WebTools :: GetCustObject
 
************************************************************************
* WebTools :: SaveCustomer
*********************************
***  Function: Saves a customer based on a CustId and returns an object
***            ref to the customer.
***      Pass: ASP Request Object
***    Return: loCustomer object
************************************************************************
FUNCTION SaveCustomer
LPARAMETERS loRequest, loResponse

lcCustno = loRequest.Form("CustNo")
lcCompany = loRequest.Form("txtCompany")
lcName = loRequest.Form("txtCareOf")
lcPhone = loRequest.Form("txtPhone")
lcEmail = loRequest.Form("txtEmail")

IF EMPTY(lcCompany) and EMPTY(lcCareof)
   RETURN .NULL.
ENDIF

If !EMPTY(lcCustNo) 
   UPDATE (DATAFILEPATH + "tt_cust") ;
      SET Company = lcCompany,CareOf = lcName, Phone = lcPhone, Email = lcEmail ;
      WHERE CustNo = PADL(lcCustno,8)
ELSE  
   INSERT INTO (DATAFILEPATH + "tt_cust") ;
      (Company, CareOf, Phone, Email,CustNo) VALUES ;
      (lcCompany, lcName, lcPhone, lcEmail, SYS(3))
ENDIF


SELE TT_Cust
LOCATE FOR Custno =  PADL(lcCustno,8)
lcOutput = "<b>" + TRIM(Company) + " has been saved...</b><br>"
loResponse.Write(lcOutput)

SCATTER NAME loCustomer MEMO

RETURN loCustomer
ENDFUNC
* WebTools :: SaveCustList

ENDDEFINE
