************************************************************************
*PROCEDURE wwDemo
******************
***  Modified: 05/31/96
***  Function: Processes incoming wwDemo CGI requests. Called from
***            CGIMAIN.PRG using wwDemo~Task~Optional+Parms parameter.
***      Pass: loCGI    -   wwCGI object
***            loServer -   wwServer/wwOLEServer object
*************************************************************************
LPARAMETER loServer
LOCAL loProcess

#INCLUDE WCONNECT.H

*** Now create a process object.
#IF OLESERVER
   loProcess=CREATEOBJECT("wwScriptMaps",loServer.oCGI,loServer,,,[WWC_wwHTMLstring])
#ELSE
   loProcess=CREATEOBJECT("wwScriptMaps",loServer.oCGI,loServer,,,[WWC_wwHTML])
#ENDIF   

IF TYPE("loProcess")#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create Process object..."
   RETURN .F.
ENDIF

*** Enable Automatic Session Object (optional)
*** Works on loProcess.oSession
loProcess.InitSession()
loProcess.oSession.nSessionTimeout = 3600  && 1 hour

*** Call the Process Method that handles the request
loProcess.Process()

RETURN

*************************************************************
DEFINE CLASS wwScriptMaps AS wwProcess
*************************************************************
***    Author: Rick Strahl
***  Modified: 05/31/96
***  Function: This class handles the requests generated by
***            the sample HTML form and its results. The
***            class implementation makes error and output 
***            doc handling much cleaner.
***
***            Subclassed from a generic wwProcess class
***            handler which provides error handling and 
***            HTML and CGI object setup.
*************************************************************

*** If you want to use compiled scripts in the runtime set
*** this flag to .T.! NOTE: You must have a development version
*** of Visual FoxPro to recompile scripts. If this flag is
*** set to .F. the runtime will use CodeBlock to execute the
*** pages at much slower speed
*** 1 - Native VFP/IDE or FXP in Runtime   2 - Codeblock

*** Not used yet
*** 0 - Auto          Runtime: Codeblock   IDE: VFP Compiles
*** 1 - Interpreted   
*** 2 - Precompiled
*** 3 - Always use CodeBlock
*nScriptMode = 3

*!*	lPreCompiled = .F.    && Use FXP in Dev Environment
*!*	lForceRuntime = .F.   && Always use compiled FXP
*!*	lUseCodeBlock = .T.   && Always use CodeBlock

lSaveCode = .F.

************************************************************************
* wwScriptMaps :: Process
***************************
***  Function: This is the callback program file that handles
***            processing a CGI request
************************************************************************
FUNCTION Process
LOCAL lcParameter, lcPhysicalPath, lcFXP, llRuntime,loCGI
PRIVATE poProcess, poSession, poServer, poHTML, poCGI, Request, Response

*** Retrieve the HTMLPagePath and cDataPath vars
* THIS.cHTMLPAGEPATH = THIS.GetAppIniVar("HTMLPAGEPATH",THIS.Class)
* THIS.cDATAPATH = THIS.GetAppIniVar("DATAPATH",THIS.Class)
Response = THIS.oHTML
Request = THIS.oCGI

lcPhysicalPath = THIS.oCGI.GetPhysicalPath()
lcExtension = UPPER(JustExt(lcPhysicalPath))

*** PRIVATE refs to Web Connection Objects
poProcess = THIS
poSession = THIS.oSession
poServer = THIS.oCGIServer
poHTML = THIS.oHTML
poCGI = THIS.oCGI

DO CASE
    CASE INLIST(lcExtension,"WCS","FXP")

         Response.ContentTypeHeader()
         lnScriptMode = THIS.oCGIServer.nScriptMode

         llRuntime = ATC("SUPPORT",Version()) >0 OR lcExtension = "FXP" OR lnScriptMode = 2
         lcFXP = ForceExt(lcPhysicalPath,"FXP")

         IF llRunTime and lnScriptMode <> 3
            lcPhysicalPath = lcFXP
         ENDIF

         loCGI = THIS.oCGI
         
         *** WCS - Script Text   WCX - Compiled   WCT - Intermediate
         oScript = CREATE([WWC_WWVFPSCRIPT],lcPhysicalPath,THIS.oHTML)
         oScript.lEditErrors = DEBUGMODE AND lcExtension # "FXP"
         oScript.nScriptMode = lnScriptMode

         oScript.lAlwaysUnloadScript = .T.

         IF oScript.nScriptMode = 3 AND lcExtension # "FXP"
            *** Using CodeBlock
            lcCode = oScript.ConvertPage(File2Var(oScript.cFileName),.T.)

            IF THIS.lSaveCode
               File2Var("TEST.PRG",lcCode)
            ENDIF
            
            oScript.RenderPageFromVar(lcCode)
            RETURN
         ENDIF

         IF !llRunTime and !THIS.lPreCompiled
            oScript.ConvertPage()
         ELSE 
            oScript.lRuntime = .T.
         ENDIF


         oScript.RenderPage()

     CASE lcExtension = "WC"
	     THIS.oHTML.ShowHTMLFile(lcPhysicalPath)
   OTHERWISE
      *** Unhandled method - display error page
      THIS.ErrorMsg("Invalid or unsupported scriptmap","")

      THIS.oCGIServer.SendMail(WWC_MAILSERVER,;
         WWC_ADMINISTRATOR_EMAIL,;
         WWC_ADMINISTRATOR_EMAIL,;
         WWC_ADMINISTRATOR_EMAIL,"", ;
         "Web Connection Error Message - Invalid Script Map",;
         THIS.oCGI.cQueryString)
ENDCASE

RETURN .T.

#IF !DEBUGMODE
FUNCTION Error
LPARAMETER lvParm1, lvParm2, lvParm3

wait windo "wwScriptMaps Error Handler..." TIMEOUT 5

*** Try to force clearing of the procedure file on an error
lcPhysicalPath = THIS.oCGI.GetPhysicalPath()
lcFXP = ForceExt(lcPhysicalPath,"FXP")
IF ATC(lcFXP,SET("PROCEDURE")) > 0
   RELEASE PROCEDURE (lcFXP)
ENDIF

DoDefault(lvParm1, lvParm2, lvParm3)

RETURN TO PROCESS
ENDFUNC
#ENDIF

ENDDEFINE
