************************************************************************
*PROCEDURE wwMaint
******************
***  Modified: 03/1/98
***  Function: Processes incoming wwDemo CGI requests. Called from
***            wcMain.prg using wwDemo~Task~Optional+Parms parameter.
***      Pass: loServer -   wwServer/wwOLEServer object
*************************************************************************
LPARAMETER loServer

#INCLUDE WCONNECT.H

*** Path where CGILOG.DBF sits
#DEFINE DATAPATH ".\"

*** Now create a process object. It's not necessary
*** to use an object here, but it makes error handling
*** document and CGI handling much easier!
#IF !OLESERVER
  loProcess=CREATE("wwMaint",loServer.oCGI,loServer,"~","+",[WWC_wwhtml])
#ELSE
  loProcess=CREATE("wwMaint",loServer.oCGI,loServer,"~","+",[WWC_wwhtmlstring])
#ENDIF  

* THIS.cScriptPath = "/wconnect/wc.dll"

IF TYPE("loProcess")#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create CGI Processing object..."
   RETURN .F.
ENDIF

*** Call the Process Method that handles the 

loProcess.Process()

RETURN

#DEFINE HTMLFOOT '<hr>[<a href="'+THIS.GetwciniSetting("AdminPage")+'">Return to Admin page</a>]'

*************************************************************
DEFINE CLASS wwMaint AS wwProcess
*************************************************************
***    Author: Rick Strahl
***  Modified: 05/31/96
***  Function: Web Connection Maintainence routines.
***            Call with "wwcgi.dll?wwMaint~SHOWLOG 
***
*************************************************************

cRestartExePath="c:\vfp\vfp.exe"
cScriptPath = "wc.dll"
cAdminAccount = ""

************************************************************************
* webConnectDemo :: Process
***************************
***  Function: This is the callback program file that handles
***            processing a CGI request
***      Pass: THIS.oCGI	-	Object containing CGI information
***    Return: .T. to erase Temp File .F. to keep it
************************************************************************
FUNCTION Process
LOCAL lcParameter, lcOutFile, lcIniFile, lcOldError
PRIVATE Request, Response

Request = THIS.oCGI
Response = THIS.oHTML
loCGI=THIS.oCGI

*** Retrieve the name of the EXE file that starts the server
THIS.cRestartExePath=THIS.GetAppIniVar("RestartExePath")   && ,THIS.class)
THIS.cHTMLPagePath=THIS.GetAppIniVar("HTMLPagePath")
THIS.cAdminAccount=THIS.GetwciniSetting("AdminAccount")

lcParameter=UPPER(THIS.oCGI.GetCGIParameter(2)) && Optional CGI parameters following EXE name

IF !INLIST(lcParameter,"SHOWLOG","SHOWSTATUS","FASTHIT","PROGLEVEL","GETTREADID","SLOWHIT") AND ;
   !EMPTY(THIS.cAdminAccount)
   *** Suggest you add Authentication here!!!
   lcUserName=Request.GetCGIVar("Authenticated Username")
   *!*	lcPassword=Request.GetCGIVar("Authenticated Password")
   
   *** Did the user Authenticate
   IF EMPTY(lcUserName)
       *** Send Password Dialog
      THIS.oHTML.HTMLAuthenticate(Request.GetServername())
      RETURN .T.
   ENDIF   
ENDIF

DO CASE
   CASE INLIST(lcParameter,"PROCESS","INIT")
      THIS.ErrorMsg("Invalid Method: " +lcParameter,"This method name is illegal...")

   CASE lcParameter = "DISPLAYFILE" OR lcParameter="SHOWPAGE"
      THIS.DisplayFile(THIS.oCGI.GetCGIParameter(3),HTMLPAGEPATH)

   *** NOTE:    GENERIC ROUTING BY PARAMETER NAME
   ***          PEMSTATUS() requires VFP 3.0b or later
   CASE !EMPTY(lcParameter) AND PEMSTATUS(THIS,lcParameter,5)
      =EVALUATE("THIS."+lcParameter+"()")

   OTHERWISE
      *** Display an error message
      *** The error method creates an error document
      *** describing the error and overwriting any existing
      *** HTML output to the output document.
      *** Uses the HTMLError Message to create error doc
      THIS.ErrorMsg("The Web Connection (wwMaint) server was unable to respond "+;
         "to the Web Server request.<br>"+;
         "Invalid Parameter: "+PROPER(lcParameter))
ENDCASE

RETURN .T.

************************************************************************
* wwMaint :: ShowLog
********************
***  Function: Displays the last 300 records in the CGILOG file.
***      Pass: Request object
*************************************************************************
PROCEDURE Showlog
LOCAL llShowErrorLog, lnStartRecno, lnReccount

IF !USED("CGILOG")
   USE ("CGILOG") in 0
ENDIF

SELE CGILOG

*** Figure out after which recnumber we can show records 
lnReccount = IIF(reccount() > 200, ;
                 200  ,;
                 reccount() ) 
lnStartRecno=reccount() - lnReccount

loHTML=THIS.oHTML
loCGI=THIS.oCGI

llShowErrorLog=IIF(ATC("ERROR",Request.GetCGIParameter(3))>0,.T.,.F.)

IF !llShowErrorLog
   loHTML.HTMLHeader("Web Connection Log")
   loHTML.SendLn("<b>Total Record Count: "+STR(reccount())+"</b><BR>")
   
   lnReccount=IIF(lnreccount>MAX_TABLE_CELLS/4-1,MAX_TABLE_CELLS/4-1,lnReccount)
   loHTML.SendLn("Displaying last "+STR(lnreccount)+" Entries <p>")
   
*** Show hourly Log graph
lnCutoff=datetime()-86000
SELECT LTRIM(STR(hour(time))) as HOUR, COUNT(time) AS Hits, DAY(TIME) AS DAY ;
   FROM cgilog ;
   WHERE time > lnCutOff AND HOUR(time) > HOUR(datetime()) - 24 ;
   GROUP BY 1 ;
   ORDER BY TIME ;
   INTO Cursor TQuery

   IF _TALLY > 1
     loHTML.SendLn([<CENTER><TABLE WIDTH="100%" BGCOLOR="#EEEEEE" BORDER=2><TR><TD>])	
     loHTML.SendLn([<CENTER><H2><FONT FACE="Arial" COLOR="800000">ISAPI Server Hits by Hour</FONT></H2>])   
     loHTML.IEChart("BAR",1,"98%",275)
     loHTML.SendLn([</CENTER></TD></TR></TABLE><p>])
   ENDIF   

   *** Actual Hit Log file selection 
#IF LOGSCRIPTNAME   
   SELECT time,PADR(MLINE(QueryStr,1),40) AS Query_String,Script,RemoteAddr, Duration ;
        FROM CGILOG ;
        WHERE recno()>=lnStartrecno ;
        INTO Cursor TQuery ;
        ORDER BY time DESC
#ELSE        
   SELECT time,PADR(MLINE(QueryStr,1),40) AS Query_String,RemoteAddr, Duration ;
        FROM CGILOG ;
        WHERE recno()>=lnStartrecno ;
        INTO Cursor TQuery ;
        ORDER BY time DESC
#ENDIF        
   
ELSE
   loHTML.HTMLHeader("Error Log Display")
   SELECT time,QueryStr as Query_String, script ;
        FROM CGILOG ;
        WHERE Error  ;
        INTO Cursor TQuery ;
        ORDER BY time DESC
   loHTML.SendLn("<b>Total Error Count: "+STR(_TALLY)+"</b><p>")

ENDIF

loHTML.ShowCursor(,,.t.,,"WIDTH=100% BORDER=3")     
loHTML.HTMLFooter(HTMLFOOT)

* oCGIServer.CleanTempFiles()

USE IN TQuery

RETURN

************************************************************************
* wwMaint :: LogStats
*********************************
***  Function: Displays a summarized view of the log file as 
***            a DHTML Form
************************************************************************
FUNCTION LogStats

loCGI = THIS.oCGI
loHTML = THIS.oHTML 

lcAction = UPPER(ALLTRIM(Request.GetFormVar("btnSubmit")))

#IF ENTERPRISE
	DO FORM ("tools\logstats") NAME oForm LINKED NOSHOW
 
	     oHTMLForm=CREATEOBJECT("wwHTMLForm",oForm,loHTML)
	     oHTMLForm.lShowAsFullHTML=.T.
	     oHTMLForm.lShowFormCaption=.T.
	     oHTMLForm.lAbsolutePosition=.F.
	     oHTMLForm.cFormAction=Request.GetCurrentURL()

	IF lcAction = "GO"
	    *** Now update the form
	     oHTMLForm.SetValues(Request)
	     oForm.FillGrid()
	ENDIF

	oHTMLForm.ShowContainer()
#ELSE
   THIS.ErrorMsg("This function is not available","This feature requires the DHTML rendering features of the Enterprise Edition")
   RETURN
#ENDIF

RETURN
ENDFUNC
* wwMaint :: LogStats


************************************************************************
PROCEDURE ClearLog
******************
***  Modified: 01/12/96
***  Function: Clears the Access Log (CGILOG.DBF) file of records
***      Pass: Request
*************************************************************************
LOCAL loHTML

loCGI=THIS.oCGI
loHTML=THIS.oHTML

CLOSE DATA 
IF !OpenExclusive("CGILOG")
   THIS.ErrorMsg("The Log File was not cleared.",;
                 "Unable to get exclusive use of the log...")
   RETURN
ENDIF

IF   UPPER(Request.GetCGIParameter(3)) # "NOBACKUP"
 USE   && Close CGILog
  
 *** Append to LOGBACK file
 IF !USED("LOGBACK")
   IF !FILE("LOGBACK.DBF")
       CREATE TABLE ("LOGBACK")  ;
            (    TIME        T ,;
               REQUEST     M ,;
               REMOTEADDR  M ,;
               DURATION    N (5,2))
    ELSE
       USE ("LOGBACK") EXCLUSIVE         
    ENDIF
    
    SELE LOGBACK
  ENDIF
  
  DELETE TAG ALL
  APPEND FROM CGILOG
  USE
    
  USE CGILOG EXCLUSIVE && Reopen
ENDIF
   
   *** Delete records for all previous days
   DELETE FOR time < Date()
   PACK
   USE
  
   THIS.ShowLog()

RETURN

************************************************************************
PROCEDURE Sessions
******************
***  Modified: 10/08/96
***  Function: Handles session management via URLs.
***
***  The following calls are available: UPPER CASE REQUIRED in 2nd parm!
***
***       wwcgi.dll?sessions~SHOW    - Show all running sessions
***       wwcgi.dll?sessions~START   - Start additional session
***       wwcgi.dll?sessions~KILL    - Kill one Session
***       wwcgi.dll?sessions~KILLUNCONDITIONAL
***       wwcgi.dll?sessions~RESTART - Kill current session and start
***                                    fresh new session
***       wwcgi.dll?sessions~CLEARSESSIONLOG 
***                                    Delete entries in the session
***                                    log file that tracks sessions.
***
***  These functions are password controlled! Set MAINTUSERNAME and
***  MAINTUSERPASSWORD to force password validation for accessing these
***  links.
*************************************************************************
LPARAMETER loCGI
LOCAL loAPI, lcType

loCGI=THIS.oCGI
loHTML=THIS.oHTML

lcParameter=loCGI.GetCGIParameter(3)
loAPI=CREATE("wwAPI")

DO CASE
   CASE lcParameter=="SHOW"
      lcFile=THIS.oCGIServer.GetSessionFileName()
      IF !EMPTY(lcFile)
         SELE 0
         USE (lcFile) ALIAS wwSess
         loHTML.HTMLHeader("Active Web Connection Sessions")
         loHTML.ShowCursor()
         loHTML.HTMLFooter(HTMLFOOT)
         USE IN wwSess
      ELSE
         loHTML.HTMLError("File does not exist...")
      ENDIF
   CASE lcParameter=="RESTART" 
        *** Load another fresh copy of VFP
        lcTemp=THIS.cRestartExePath
        loHTML.HTMLError("Web Connection Recycled",;
                          "Visual FoxPro Session has been stopped and restarted...")      
        RUN /N4 &lcTemp

        THIS.oCGIServer.KillSessionEntry()  && Force manually do it here!
        loHTML.Destroy()
        THIS.oCGIServer.SendCGIReturnFile() 
        CLOSE ALL
        QUIT
   CASE lcParameter=="KILL"
        lnSessions=THIS.oCGIServer.GetSessionCount()
        IF lnSessions > 1
            loHTML.HTMLError("Web Connection Killed",;
                             "Visual FoxPro Session has been stopped and restarted...")      
            THIS.oCGIServer.KillSessionEntry()  && Force manually do it here!
            loHTML.Destroy()
            THIS.oCGIServer.SendCGIReturnFile()
            CLOSE ALL
            QUIT
        ELSE
            loHTML.HTMLError("Web Connection Session Not Killed",;
                             "This session is the last session running...")      
        ENDIF
   CASE lcParameter=="KILLUNCONDITIONAL"
            loHTML.HTMLError("Web Connection Killed",;
                             "Visual FoxPro Session has been stopped...")      
            THIS.oCGIServer.KillSessionEntry()  && Force manually do it here!
            loHTML.Destroy()
            THIS.oCGIServer.SendCGIReturnFile()
            CLOSE ALL
            CLEAR PROG
            QUIT
   CASE lcParameter=="START"
        *** Add a new session
        * loAPI.ShellExecute("D:\VFP5\VFP.exe -t surplus.prg","\SURPLUS")
        lcTemp=THIS.cRestartExePath
        RUN /N4 &lcTemp 
        loHTML.HTMLError("Web Connection Session Added",;
                          "Visual FoxPro Sessions has been added...")      
   CASE lcParameter=="CLEARSESSIONS"
      lcFile=THIS.oCGIServer.GetSessionFileName()
      IF !EMPTY(lcFile)
         SELE 0
         IF !OPENEXCLUSIVE(lcFile)
            USE (lcFile) ALIAS wwSess
            DELETE ALL
         ELSE
            ZAP
         ENDIF
         USE IN wwSess
      ENDIF

      loHTML.HTMLError("Web Connection Session File Cleared",;
                       "The session file has been cleared and the display of "+;
                       "the sessions is now potentially inaccurate. To properly "+;
                       "set up sessions again try to run the Recycle options several times.")
ENDCASE

RETURN


************************************************************************
* wwMaint :: EditConfig
*********************************
***  Function: Allows editing the wc.ini and wcmain.ini files (or
***            the equivalent renamed versions) and update them on
***            the server
***    Assume: Only works if this code runs on the Web server box
***            that holds the wc.ini/wcmain.ini files.
************************************************************************
FUNCTION EditConfig
LOCAL lcText, loCGI, loHTML

loCGI=THIS.oCGI
loHTML=THIS.oHTML

*** For non-local servers you can hardcode these paths with 
*** UNC pathings to work from any machine. For example:
*** lcDLLIni=\\rasmain\c$\http\wconnect\wc.ini
lcDLLIni=loCGI.GetCGIVar("wcConfig")
lcWCIni=THIS.oCGIServer.cSetupIniFile

*** Web Path of the DLL
lcDLLWebPath=loCGI.GetCgiVar("Executable Path")

*** Check for save operation
IF UPPER(loCGI.GetCGIParameter(3))="SAVEDLLINI"
   lcText=loCGI.GetFormVar("txtIni")
   File2Var(lcDLLIni,lcText) 
   THIS.ErrorMsg([DLL INI File updated],;
                 [The file has been updated on the server...<p>Click here to <A HREF="]+lcDLLWebPath+[/maintain?ReadSetupIni">reload</a> the INI file.])
   RETURN
ENDIF

IF UPPER(loCGI.GetCGIParameter(3))="SAVEWCINI"
   lcText=loCGI.GetFormVar("txtIni")
   File2Var(lcWCIni,lcText) 
   THIS.oCGIServer.ReadSettingsFromIni()
   THIS.ErrorMsg([Server INI File updated],;
                 [The file and settings have been updated on the server.])
   RETURN
ENDIF


lcText=File2Var(lcDLLIni)
lcText2=File2Var(lcWCIni)

IF EMPTY(lcText)
   THIS.ErrorMsg("Can't load "+lcDLLIni,;
                 "This probably means that you're accessing data across a remote link that is not server relative. You'll have to adjust this method to properly translate the path the appropriate server.")
   RETURN
ENDIF	

loHTML.HTMLHeader("Editing Config Files",,"#FFFFFF")

loHTML.SendLn([<FORM ACTION="]+lcDLLWebPath+[?wwMaint~EditConfig~SaveDLLIni" METHOD="POST">])
loHTML.SendLn("<b>DLL File INI Settings - "+lcDLLIni+":</b><br>")
loHTML.FormTextArea("txtIni",lcText,20,75)
loHTML.SendLn("<p>")
loHTML.FormButton("btnDLLIni","Update DLL INI File")
loHTML.SendLn([</FORM>])

loHTML.SendLn([<FORM ACTION="]+lcDLLWebPath+[?wwMaint~EditConfig~SaveWCIni" METHOD="POST">])
loHTML.SendLn("<p><b>Web Connection Server INI Settings - "+lcWCIni+":</b><br>")
loHTML.FormTextArea("txtIni",lcText2,20,75)
loHTML.SendLn("<p>")
loHTML.FormButton("btnDLLIni","Update Server INI File")
loHTML.SendLn([</FORM>])

loHTML.HTMLFooter(HTMLFOOT)

ENDFUNC
* EditServerIni

************************************************************************
* wwMaint :: ServerStatus
*********************************
***  Function: Displays the Server Admin window and allows updating
***            the values directly via Form Interface.
***    Assume: Requires IE 4.0
************************************************************************
FUNCTION ServerStatus


loCGI = THIS.oCGI
loHTML = THIS.oHTML
lcAction = UPPER(loCGI.GetFormVar("btnSubmit"))

#IF ENTERPRISE
	*** SET DECIMALS TO 0 to force fields to no decimal places
	loEnv = CREATE("wwEnv","DECIMALS",0)

	loServerForm  = CREATE("wcStatusForm",THIS.oCGIServer)

	*** Disable the Show Request File button
	loServerForm.btnShowRequest.enabled = .F.

	DO CASE
	   CASE lcAction = "EXIT"
	       loHTML.HTMLRedirect("admin.asp")
	   CASE lcAction = "HTTP://"
	       loHTML.HTMLRedirect("http://www.west-wind.com/")
	   CASE lcAction = "BROWSE"
	       THIS.ShowLog()
	       RETURN
	   CASE lcAction = "CLEAR"
	       THIS.ClearLog()
	       RETURN
	   CASE lcAction = "WCMAIN" or lcAction = "WC.INI"
	       THIS.EditConfig()
	       RETURN
	ENDCASE

    loHTML.HTMLHeader(,"Web Connection Server Status")
    loHTML.Send("<CENTER>")

	oHTMLForm=CREATEOBJECT("wwHTMLForm",loServerForm,THIS.oHTML)

	IF lcAction = "SAVE SERVER"
	   oHTMLForm.SetValues(loCGI)     && Save new value to form

       lcScriptMode = Request.Form("cmbScriptMode")
       DO CASE
         CASE lcScriptMode = "Interpreted"
           loServerForm.cmbScriptMode.value =  3
         CASE lcScriptMode = "Precompiled"
           loServerForm.cmbScriptMode.value =  2
         OTHERWISE
           loServerForm.cmbScriptMode.value =  3
       ENDCASE

       loServerForm.oCGIServer.UpdateSettings()  && Write the Settings to storage	   
       
	ENDIF

	oHTMLForm.lShowAsFullHTML = .F.
	oHTMLForm.lShowFormCaption=.T.
	oHTMLForm.lAbsolutePosition=.F.
	oHTMLForm.cFormAction=THIS.cScriptPath + "?wwMaint~ServerStatus"

	oHTMLForm.ShowContainer()
#ENDIF


lcFilename=loCGI.oAPI.GetEXEFile()   

lcFDate=""
IF FILE(lcFileName)
  lcFDate=DTOC(FDATE(lcFileName)) + " - " + lower(FTIME(lcFileName))
ENDIF  

*** Create cursor for easy display
CREATE CURSOR TFile (Setting M, Value M) 

INSERT INTO TFile (Setting,Value) VALUES ("Web Connection DLL Version:",loCGI.GetCGIVar("DLLVersion") )
INSERT INTO TFile (Setting,Value) VALUES ("Web Connection Server Version:",WWVERSION + " - " + WWVERSIONDATE)
INSERT INTO TFile (Setting,Value) VALUES ("Visual FoxPro Version:",Version() + "  wwVFPVersion:" + STR(wwVFPVERSION) )
INSERT INTO TFile (Setting,Value) VALUES ("Running EXE Application:",lcFileName)
INSERT INTO TFile (Setting,Value) VALUES ("EXE File Date:",lcFDate )
INSERT INTO TFile (Setting,Value) VALUES ("Current Path:",sys(5) + CURDIR())
INSERT INTO TFile (Setting,VALUE) VALUES ("","")
INSERT INTO TFile (Setting,Value) VALUES ("Web Server Software:",loCGI.GetCGIVar("Server Software"))
INSERT INTO TFile (Setting,Value) VALUES ("Browser:",loCGI.GetBrowser())
INSERT INTO TFile (Setting,VALUE) VALUES ("","")
INSERT INTO TFile (Setting,VALUE) VALUES ("Debug Mode:",IIF(DEBUGMODE,"On","Off"))

INSERT INTO TFile (Setting,VALUE) VALUES ("OLE Automation:",IIF(OLESERVER,"On","Off"))

INSERT INTO TFile (Setting,VALUE) VALUES ("LOCALSITE Value:",STR(LOCALSITE))

LOCATE
loHTML.ShowCursor(,"Application Settings")
loHTML.HTMLFooter(HTMLFOOT)

USE IN TFile

RETURN
ENDFUNC
* wwMaint :: ServerStatus


************************************************************************
* wwMaint :: ShowStatus
*********************************
***  Function: Shows Version and status information about the Web
***            Connection Server.
************************************************************************
FUNCTION ShowStatus

loHTML=THIS.oHTML

loHTML.HTMLHeader("","Web Connection Server Settings")

lcFilename=loCGI.oAPI.GetEXEFile()   

lcFDate=""
IF FILE(lcFileName)
  lcFDate=DTOC(FDATE(lcFileName)) + " - " + lower(FTIME(lcFileName))
ENDIF  

*** Create cursor for easy display
CREATE CURSOR TFile (Setting M, Value M) 


INSERT INTO TFile (Setting,Value) VALUES ("Web Connection DLL Version:",loCGI.GetCGIVar("DLLVersion") )
INSERT INTO TFile (Setting,Value) VALUES ("Web Connection Server Version:",WWVERSION + " - " + WWVERSIONDATE)
INSERT INTO TFile (Setting,Value) VALUES ("Visual FoxPro Version:",Version())
INSERT INTO TFile (Setting,Value) VALUES ("Running EXE Application:",lcFileName)
INSERT INTO TFile (Setting,Value) VALUES ("Current Path:",sys(5) + CURDIR())
INSERT INTO TFile (Setting,Value) VALUES ("EXE File Date:",lcFDate )
INSERT INTO TFile (Setting,VALUE) VALUES ("","")
INSERT INTO TFile (Setting,Value) VALUES ("Web Server Software:",loCGI.GetCGIVar("Server Software"))
INSERT INTO TFile (Setting,Value) VALUES ("Browser:",loCGI.GetBrowser())
INSERT INTO TFile (Setting,VALUE) VALUES ("","")
INSERT INTO TFile (Setting,VALUE) VALUES ("Logging Requests:",IIF(THIS.oCGIServer.lLogStatus,"On","Off"))
INSERT INTO TFile (Setting,VALUE) VALUES ("Display Requests:",IIF(THIS.oCGIServer.lShowStatus,"On","Off"))
INSERT INTO TFile (Setting,VALUE) VALUES ("Save Request Info:",IIF(THIS.oCGIServer.lSaveRequestFiles,"On","Off"))
INSERT INTO TFile (Setting,VALUE) VALUES ("","")
INSERT INTO TFile (Setting,VALUE) VALUES ("Debug Mode:",IIF(DEBUGMODE,"On","Off"))
INSERT INTO TFile (Setting,VALUE) VALUES ("OLE Automation:",IIF(OLESERVER,"On","Off"))
INSERT INTO TFile (Setting,VALUE) VALUES ("LOCALSITE Value:",STR(LOCALSITE))

LOCATE
loHTML.ShowCursor()
loHTML.HTMLFooter(HTMLFOOT)

USE IN TFile

RETURN   
ENDFUNC
* wcServerStats

FUNCTION FileUpload
************************************************************************
* wwMaint :: FileUpload
*********************************
***  Function: Upload a file
************************************************************************

lcFileName = ""
lcFileBuffer = Request.GetMultiPartFile("File",@lcFileName)
lcPath = Request.GetMultiPartFormVar("txtFilePath")
IF EMPTY(lcPath)
   lcPath = SYS(2023) 
ENDIF   
lcFileName = ADDBS(lcPath)  + lcFileName

*** Now dump the file to disk
File2Var(lcFileName,lcFileBuffer)

THIS.StandardPage("File has been uploaded",;
                  "<b>File Uploaded:</b> " + lcFileName + ;
                  " (" + TRANSFORM(FileSize(lcFileName),"9,999,999") + " bytes)")

ENDFUNC
* wcDemoProcess :: FileUpload


************************************************************************
* wwMaint :: ScriptMode
*********************************
***  Function: Sets the script mode to either Interpreted or Precompiled
************************************************************************
FUNCTION ScriptMode

lcMode = UPPER(Request.QueryString(3))

DO CASE
  CASE lcMode = "INTERPRETED"
     THIS.oCGIServer.nScriptMode = 3
     THIS.oCGIServer.UpdateSettings()
  CASE lcMode = "PRECOMPILED"
     THIS.oCGIServer.nScriptMode = 2
     THIS.oCGIServer.UpdateSettings()
ENDCASE

lnMode = THIS.oCGIServer.nScriptMode
DO CASE
  CASE lnMode = 1
     lcmode = " 1 - Running inside of Visual FoxPro Development Environment"
  CASE lnMode = 2
     lcMode = " 2 - Using precompile FoxPro FXP files"
  CASE lnMode = 3
     lcMode = " 3 - Runtime Interpretation using Codeblock"
ENDCASE

THIS.StandardPage("Web Connection Script Mode Settings",;
                  "The current setting of the script mode flag is:<p><b>"+;
                  lcMode + "</b>")

ENDFUNC
* wwMaint :: ScriptMode

************************************************************************
* wwMaint :: CompileWCS
*********************************
***  Function: Compiles 
***    Assume: VFP 5.0 or later (uses Automation)
***            Development version of VFP is installed on server
************************************************************************
FUNCTION CompileWCS

loCGI = THIS.oCGI
lcFileSpec = loCGI.GetCGIParameter(3)

IF EMPTY(lcFileSpec)
   lcFileSpec = loCGI.GetFormVar("txtFileName")
ENDIF
IF EMPTY(lcFileSpec)
   lcPhysicalPath = loCGI.GetPhysicalPath()
   lcFileSpec = ADDBS(JustPath(lcPhysicalPath))+"*.wcs"
ENDIF   

o=CREATEOBJECT("VisualFoxPro.Application")
o.DoCmd("SET DEFAULT TO ["+SYS(5)+CURDIR()+"]")
o.DoCmd("SET PATH TO .\classes; .\eclasses; .\tools")

*** Load Web Connection Classes
o.DoCmd("DO WCONNECT")

*** Compile .WCS Active Server Script Pages
lcErrors = o.Eval("wcscompile('"+lcFileSpec+"',.t.)")

o = .F.

IF EMPTY(lcErrors)
  lcErrors = "No Errors..."
ENDIF

THIS.ErrorMsg("Scripts Compiled",;
              [  <font face="Verdana" size=3>ScriptPath: ]+lcFileSpec+CR+CR+;
                            "<HR><PRE>"+ lcErrors + "</PRE></FONT>")

ENDFUNC
* wwMaint :: CompileWCS

************************************************************************
* wwMaint :: wcDLLErrorLog
*********************************
***  Function: Displays the Error log in the wcErrorFile.
***            If a third querystring parameter of Clear is passed
***            the log file is cleared.
************************************************************************
FUNCTION wcDLLErrorLog

llDelete = !EMPTY(Request.QueryString(3))

lcFileName = THIS.oCGIServer.cTempFilePath + "wwcgierr.txt"

IF llDelete
   lnHandle = FOPEN(lcFileName,2)
   IF lnHandle > 0
	   FCHSIZE(lnHandle,0)
	   FCLOSE(lnHandle)
       THIS.StandardPage("Web Connection DLL Error File was cleared",;
                         "The file was cleared.")
   ELSE
      THIS.StandardPage("Web Connection DLL Error File not Deleted",;
                        "The file could not be deleted - most likely because it's in use. Retry this link a few times.")
   ENDIF 
   RETURN
ENDIF

IF !FILE(lcFileName)
   THIS.ErrorMsg("Error File does not exist",;
                 "This means there are no errors to report")
   RETURN
ENDIF

lcFileText = File2Var(lcFileName)
IF EMPTY(lcFileText)
   THIS.ErrorMsg("No data returned from Web Connection DLL Error File",;
                 "This means either the file is empty, or the file is in use.")
   RETURN
ENDIF

loHTML=CREATE("wwHTMLString")
loHTML.Send("<br>Filename:  " + lcFileName + "<br>")
loHTML.HREF("wc.dll?wwMaint~wcDLLErrorLog~Delete","Clear")   
loHTML.Send("</font><PRE>")
loHTML.Send(lcFileText)
loHTML.Send("</PRE><FONT>")

THIS.StandardPage("Web Connection DLL Error Log",loHTML.GetOutput())

ENDFUNC
* wwMaint :: wcErrorFile


************************************************************************
* wwMaint :: ShowTextFile
*********************************
***  Function: Allows viewing any file on the server as text. You
***            can pass a DOS filename either on the URL as the 3rd
***            parameter or load it from an HTML Form variable called
***            'txtFileName'.
************************************************************************
FUNCTION ShowTextFile
LPARAMETER lcFileName

loCGI=THIS.oCGI
loHTML=THIS.oHTML

IF EMPTY(lcFileName)
	lcFileName=loCGI.GetCGIParameter(3)
	IF EMPTY(lcFileName)
	   lcFileName=loCGI.GetFormVar("txtFileName")
	ENDIF
ENDIF

IF !FILE(lcFileName)
   THIS.ErrorMsg("Can't find file","File specified: "+lcFileName)
   RETURN
ENDIF

lcText=File2Var(lcFileName)   

loHTML.ContentTypeHeader("text/plain")
loHTML.Send(lcText)

ENDFUNC
* ShowFile

************************************************************************
* wwMaint :: ReindexSystemFiles
*********************************
***  Function: Reindexes/Packs the various Web Connection System Files
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION ReindexSystemFiles

lcMessage=""
ldPurgeDate=CTOD(loCGI.GetCGIParameter(3))

IF EMPTY(ldPurgeDate)
  ldPurgeDate = DATE()-1
ENDIF  

loTemp=CREATE("wwSession")
IF !loTemp.Reindex(ldPurgeDate)
   lcMessage="<li> wwSession file not reindexed..." + CR
ENDIF

loTemp=CREATE("wwBanner")
IF !loTemp.Reindex()
   lcMessage="<li> wwBanners file not reindexed..." + CR
ENDIF

IF FILE("wwHTML.dbf")
  loHTML=CREATE("wwHTMLString")
  loHTML.CreateHTMLDbf("REINDEX")
ENDIF

IF EMPTY(lcMessage)
  lcMessage = "wwSession and wwBanner files have been reindexed..."
ENDIF
  
THIS.ErrorMsg("System File Reindexing Complete",lcMessage)
ENDFUNC
* ReindexSystemFiles

************************************************************************
* wwMaint :: GetwcIniSetting
*********************************
***  Function: Retrieves a setting from the ISAPI DLL INI file.
***      Pass: lcKey         -  
***            lcSection     - 
***    Return: "" on error or value
************************************************************************
FUNCTION GetwcIniSetting
LPARAMETERS lcKey, lcSection
lcSection=IIF(EMPTY(lcSection),"wwCgi",lcSection)

lcValue = Request.oAPI.GetProfileString(Request.ServerVariables("wcConfig"),;
                                        lcSection,lcKey) 
IF ISNULL(lcValue)                                        
   RETURN ""
ENDIF      

RETURN lcValue
ENDFUNC
* wwMaint :: GetwcIniSetting


************************************************************************
* wwProcess :: ErrorMsg
***********************
***  Modified: 11/02/95
***  Function: A simple error handler that demonstrates how to use
***            the HTMLError method to output an error document
***            when a CGI operation fails. All errors should send
***            an error page in order to properly terminate
***            the CGI request operation.
***      Pass: lcMessage  -  Error Message to display (detail)
***            THIS.oCGI      -  Current CGI object
***            loHTML     -  Existing HTML object
***    Return:
*************************************************************************
PROCEDURE ErrorMsg
LPARAMETER lcMessage, lcMessage2, lvHeader

lcMessage=IIF(!EMPTY(lcMessage),lcMessage,;
   "")
lcMessage2=IIF(!EMPTY(lcMessage2),lcMessage2,;
   "The server was unable to create the requested document.<BR>"+CHR(13)+;
   "This message was generated by Visual FoxPro...")

*** Make sure we have a valid object since we might be in a fatal error condition
*** If not we can't spit out a message - the DLL must handle the empty output
IF TYPE("THIS.oHTML")="O" AND !ISNULL(THIS.oHTML)
   THIS.oHTML.Rewind()
    
   lcOutput = ;
	[<table border="0" cellpadding="5" width="100%">] + CR +;
	[  <tr><td align="center" colspan="2" bgcolor="#000000">]+ CR+;
	[  <font color="#FFFFFF" size="4" face="Verdana"><b>] + CR +;
	lcMessage + [</b></font>] + CR +;
	[  </td></tr>] + CR +;
	[  <tr><td><br><p>] + CR +;
	[  <font face="Verdana" size=2>]+ CR +;
	lcMessage2+ [</font>] + CR +;
	[  </td></tr>] + CR +;
	[</Table>]

   *** HTMLError handles
   THIS.oHTML.HTMLHeader(lcOutput,lcMessage,"#FFFFFF",lvHeader)
   
   *** Close down the doc and shut off further output
   THIS.oHTML.HTMLFooter(HTMLFOOT)
   
   THIS.oHTML.NoOutput(.T.)
ENDIF

ENDPROC
* EOP ErrorMsg


************************************************************************
* wwMaint :: ProgLevel
*********************************
***  Function: Displays the Program Stack. Use for Debugging problems
***            with Automation Server Exceptions where the call level
***            might stack up multiple 'Master' startups.
************************************************************************
FUNCTION ProgLevel

lcOutput = "Call Stack Levels: " + STR(ProgLevel())+CR+CR

FOR x=1 to 128
   IF EMPTY(SYS(16,x))
      exit
   ENDIF
   lcOutput = lcOutput + SYS(16,x) + CR
ENDFOR && x=1 to 128

THIS.ErrorMsg("Web Connection Call Stack - ServerID: "+THIS.oCGIServer.cServerId,;
                  "<PRE>" + lcOutput + "</PRE>")

ENDFUNC
* ProgLevel 


************************************************************************
* wwMaint :: Fasthit
*********************************
* Dummy request for testing
FUNCTION FastHit
THIS.ErrorMsg("Hello World","Testing...")
ENDFUNC
* WaitRequest

************************************************************************
* wwMaint :: Slowhit
*********************************
FUNCTION SlowHit

lnSeconds = VAL(THIS.oCGI.GetCGIParameter(3))
lnStart = SECONDS()
IF lnSeconds = 0
   lnSeconds = 5
ENDIF   

wait window "Waiting for " +LTRIM(STR(lnSeconds))+ " secs... no output" TIMEOUT (lnSeconds)
THIS.StandardPage("Slowhit","Waited for " +LTRIM(STR(lnSeconds))+ " secs...")
ENDFUNC



************************************************************************
* wwMaint :: CrashGPF
*********************************
**** CAUSE a CRASH with Dr. Watson
PROCEDURE CrashGPF

DECLARE GetSystemTime ;
   IN WIN32API ;
   STRING @
   
lcText=" "

THIS.oHTML.Send( GetSystemTime(@lcText) )

THIS.oHTML.Send("Made it through the GPF")

ENDFUNC

************************************************************************
* wwMaint :: FileDialog
*********************************
**** CAUSE a Directory Dialog to hang VFP
PROCEDURE FileDialog

SELECT * FROM asdasdsd INTO CURSOR TQuery

THIS.ErrorMsg("Exit Stage Left","")
ENDPROC

ENDDEFINE
