************************************************************************
*PROCEDURE wwHTTPData
**********************
***  Function: Responsible for serving data generically over HTTP
***      Pass: loCGI    -   wwCGI object
***            loServer -   wwServer/wwOLEServer object
*************************************************************************
LPARAMETER loServer
LOCAL loProcess

#INCLUDE WCONNECT.H

*** Now create a process object.
#IF OLESERVER
   loProcess=CREATEOBJECT("wwHTTPDataProcess",loServer.oCGI,loServer,,,[WWC_wwHTMLstring])
#ELSE
   loProcess=CREATEOBJECT("wwHTTPDataProcess",loServer.oCGI,loServer,,,[WWC_wwHTML])
#ENDIF   

IF TYPE("loProcess")#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create Process object..."
   RETURN .F.
ENDIF

*** Call the Process Method that handles the request
loProcess.Process

RETURN

*************************************************************
DEFINE CLASS wwHTTPDataProcess AS wwProcess
*************************************************************
***    Author: Rick Strahl
***  Modified: 05/31/96
***  Function: This class handles the requests generated by
***            the sample HTML form and its results. The
***            class implementation makes error and output 
***            doc handling much cleaner.
***
***            Subclassed from a generic wwProcess class
***            handler which provides error handling and 
***            HTML and CGI object setup.
*************************************************************

************************************************************************
* wwScriptMaps :: Process
***************************
***  Function: This is the callback program file that handles
***            processing a CGI request
************************************************************************
FUNCTION Process
LOCAL lcParameter

lcParameter=UPPER(THIS.oCGI.GetCGIParameter(2)) && Optional CGI parameters following EXE name

DO CASE
   *** Add any 'invalid' method calls here
   CASE INLIST(lcParameter,"PROCESS","LOAD","INIT","DESTROY")
      THIS.ErrorMsg("Invalid Method: " +lcParameter,"This method name is illegal...")

   *** NOTE:    GENERIC ROUTING BY PARAMETER NAME
   CASE !EMPTY(lcParameter) AND PEMSTATUS(THIS,lcParameter,5)
      =EVALUATE("THIS."+lcParameter+"()")

   OTHERWISE
     THIS.oHTML.Sendln("Error: Unhandled Request for wwHTTPDataProcess Object.")

ENDCASE

RETURN .T.

************************************************************************
* wwHTTPDataProcess :: Execute
*********************************
***  Function: Generic Execute request handler routine that can
***            be used to pull data from the wire.
***            Typically called from a wwHTTPData client in VFP
************************************************************************
FUNCTION Execute

*** Check for validation here

*** Authentication is optional
*** Supported values in the INI -  Any        -  Any Authorized user
***                                Username   -  A specific user - must match Authenticated User
***                                ""         -  None - no Authentication
lcAuthUser = THIS.GetAppIniVar("AuthUser","wwHTTPData")

*** Create Data Object and call Server Side Execute method (wrapper for Process Method)
loData = CREATE("wwHTTPData")
loData.S_Execute(THIS,lcAuthUser)

ENDFUNC
* wwHTTPDataProcess :: Execute

************************************************************************
* wwHTTPDataprocess :: SendFile
*********************************
***  Function: Generic File upload utility
************************************************************************
FUNCTION SendFile

lcAuthUser = THIS.GetAppIniVar("AuthUser","wwHTTPData")

loFile = CREATE("wwHTTPFile")
loFile.cForcedSavePath = SYS(5) + CURDIR() + "Uploads\"
loFile.S_SendFile(THIS,lcAuthUser)

ENDFUNC
* wwHTTPDataprocess :: SendFile

ENDDEFINE
