************************************************************************
*PROCEDURE MyCode
******************
***  Modified: 06/15/98
***  Function: Processing Template for new Web application 'projects'/
***      Pass: loServer  -   wwServer/wwOleServer object
***    Return: nothing
*************************************************************************
LPARAMETER loServer

#INCLUDE WCONNECT.H

*** Now create a process object. It's not necessary
*** to use an object here, but it makes error handling
*** document and CGI handling much easier!
#IF OLESERVER
   loProcess=CREATE("MyCodeClass",loServer.oCGI,loServer,"~","+","wwhtmlstring")
#ELSE
   loProcess=CREATE("MyCodeClass",loServer.oCGI,loServer,"~","+","wwhtml")
#ENDIF   
IF TYPE("loProcess")#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create Process object..."
   RETURN .F.
ENDIF

*** Call the Process Method that handles the request
loProcess.Process()

RETURN


*************************************************************
DEFINE CLASS MyCodeClass AS wwProcess
*************************************************************
***    Author: Rick Strahl
***  Modified: 05/31/96
***  Function: Empty Template to add custom methods to
***
***            Subclassed from a generic wwCGIProcess class
***            handler which provides error handling and 
***            HTML and CGI object setup.
*************************************************************

************************************************************************
* MyCodeClass :: Process
************************
***  Function: This is the callback program file that handles
***            processing a CGI request
************************************************************************
FUNCTION Process
LOCAL lcParameter, lcOutFile, lcIniFile, lcOldError

*** And retrieve the HTMLPagePath and cDataPath vars - [MyCodeClass] section
THIS.cHTMLPAGEPATH = THIS.GetAppIniVar("HTMLPAGEPATH")
THIS.cDATAPATH = THIS.GetAppIniVar("DATAPATH")  && This points at .\wwdemo

*** Retrieve the second parameter which specifies the Method to call
lcParameter=UPPER(THIS.oCGI.QueryString(2)) 

Response = THIS.oHTML
Request = THIS.oCGI

DO CASE
   CASE lcParameter = "DISPLAYFILE" OR lcParameter="SHOWPAGE"
      =THIS.DisplayFile(THIS.oCGI.QueryString(3),HTMLPAGEPATH)

   *** NOTE:    GENERIC ROUTING BY PARAMETER NAME
   CASE !EMPTY(lcParameter) AND PEMSTATUS(THIS,lcParameter,5)
      =EVALUATE("THIS."+lcParameter+"()")

   OTHERWISE
      *** Unhandled method - display error page
      THIS.ErrorMsg("The server was unable to respond "+;
         "to this request",;
         "Parameter Passed: <b>"+PROPER(lcParameter)+"</b><BR>"+;
         "Error: <b>Unhandled Method</b>")
ENDCASE

RETURN .T.
ENDFUNC


FUNCTION MyFirstWebRequest

*** Create a page header - HTML object is already created at this point
Response.HTMLHeader("My First Web Request")

*** Select some records from a database
SELECT company ;
   FROM (THIS.cDataPath + "TT_CUST") ;
   INTO CURSOR Tquery ;
   ORDER BY Company

*** Now display the results in an HTML table
Response.ShowCursor()

*** For fun let's put some CGI information on the page as well
Response.SendPar()
Response.SendLn("<HR>")
Response.SendLn("Browser used: "+Request.GetBrowser()+"<BR>")
Response.SendLn("Query String: "+Request.QueryString()+"<BR>")
Response.SendLn("2nd Parameter: "+Request.QueryString(2))
Response.HTMLFooter()

ENDFUNC

ENDDEFINE
