
*** IMPORTANT - Change this to match your data path!
#define DATAPATH CURDIR() + "wwdemo\"


************************************************************************
*PROCEDURE httpDemo
******************
***  Modified: 07/31/96
***  Function: Processes incoming wwDemo CGI requests. Called from
***            CGIMAIN.PRG using wwDemo~Task~Optional+Parms parameter.
***      Pass: loCGI    -   wwCGI object
***            loServer -   wwServer/wwOLEServer object
*************************************************************************
LPARAMETER loServer

#INCLUDE WCONNECT.H

*** Now create a process object.
#IF OLESERVER
   loProcess=CREATE("HTTPDemo",loServer.oCGI,loServer,,,[WWC_wwHTMLstring])
#ELSE
   loProcess=CREATE("HTTPDemo",loServer.oCGI,loServer,,,[WWC_wwHTML])
#ENDIF   

IF TYPE("loProcess")#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create CGI Processing object..."
   RETURN .F.
ENDIF

*** Call the Process Method that handles the request
loProcess.Process

RETURN


*************************************************************
DEFINE CLASS HTTPDemo AS wwProcess
*************************************************************
***    Author: Rick Strahl
***  Modified: 05/31/96
***  Function: This class handles the requests generated by
***            the sample HTML form and its results. The
***            class implementation makes error and output 
***            doc handling much cleaner.
***
***            Subclassed from a generic wwProcess class
***            handler which provides error handling and 
***            HTML and CGI object setup.
*************************************************************


********************************************************
* HTTPDemo :: CustList
*********************************
***  Function: Returns a customer list based on the URL 
***            'parameter' passed. Delimited returned.
***    Assume: wc.dll?http~CustList1~&Company=A
********************************************************
FUNCTION CustList

lcCustToFind = Request.QueryString("Company")

lcFile=SYS(2015)+".TXT"

SELECT custno,Company, Careof ; 
   FROM (DATAPATH + "TT_Cust") ;
   WHERE Company = lcCustToFind ;
   ORDER BY Company ;
   INTO CURSOR TQuery

COPY TO (lcFile) TYPE DELIMITED 

*** Send the Delimited string over the wire
Response.Write(File2Var(lcFile))

ERASE (lcFile)

USE IN TQuery
IF USED("TT_CUST")
   USE IN TT_Cust
ENDIF

ENDFUNC
* CustList

********************************************************
* HTTPDemo :: GetCust
*********************************
*  Retrieves a single customer and sends back a cursor
********************************************************
FUNCTION GetCust

lcCustno = Request.QueryString("CustNo")

lcFileName = Sys(2015)+".dbf"
SELECT * From (DATAPATH + "TT_CUST") WHERE CustNo = lcCustNo ;
         INTO DBF (lcFileName)
USE
IF _TALLY = 0
   Response.Write("Error - Invalid Customer number" + lcCustNo)
   RETURN 
ENDIF

loIP = CREATE("wwIPStuff")
lcFile = loIP.EncodeDBF(lcFileName,.T.)

Response.Write(lcFile)

ERASE lcFileName
ERASE ForceExt(lcFileName,"FPT")

RETURN

********************************************************
* HTTPDemo :: UpdateCust
*********************************
*  Updates or inserts a new customer's information
*  based on his custid.
********************************************************
FUNCTION UpdateCust

lcCustId = Request.Form("CustId")
lcCompany = Request.Form("Company")
IF EMPTY(lcCompany)
   Response.Write("Error: Company Field cannot be blank")
   RETURN
ENDIF

IF EMPTY(lcCustId)
   INSERT INTO (DATAPATH + "TT_CUST") (Company, careof, email, address, custno) ;
             values ( lcCompany,;
                      Request.Form("Name"),;
                      Request.Form("Email"),;
                      Request.Form("Address"),; 
                      SYS(3))
   Response.Write("OK - Insert")                     
ELSE                  
  IF !USED("TT_Cust")
     USE (DATAPATH + "TT_CUST") in 0
  ENDIF
  SELE TT_Cust  
  LOCATE FOR custno = lcCustID
  IF FOUND()
     REPLACE Company with lcCompany,;
             Careof with  Request.Form("Name"),;
             Email with Request.Form("Email"),;
             Address with Request.Form("Address")
     Response.Write("OK - Update")
  ELSE
      Response.Write("Error: Customer not found. Not updated")
      RETURN
  ENDIF
ENDIF

Response.Write("OK")

RETURN

************************************************************************
* wcDemoProcess :: HTTPData
*********************************
***  Function: Run a SQL Statement on the server
***            and return result. Expects a request 
***            generated from wwHTTPData::Execute()
************************************************************************
FUNCTION HTTPData

*** Check for validation here

*** Authentication is optional
*** Supported values in the INI -  Any        -  Any Authorized user
***                                Username   -  A specific user - must match Authenticated User
***                                ""         -  None - no Authentication
*lcAuthUser = "wcuser"  
lcAuthUser = THIS.GetAppIniVar("AuthUser","wwHTTPData")

*** Create Data Object and call Server Side Execute method (wrapper for Process Method)
loData = CREATE("wwHTTPData")

loData.S_Execute(THIS,lcAuthUser)

ENDFUNC
* wwHTTPDataProcess :: Execute




************************************************************************
* HTTPDemo :: SendFile
*********************************
***  Function: Receives a file and stores it on the server
************************************************************************
FUNCTION SendFile

lcFileName=THIS.oCGI.GetFormVar("FileName")
lcFileData=THIS.oCGI.GetFormVar("FileData")

File2Var(lcFileName,lcFileData)

IF FILE(lcFileName)
  THIS.ErrorMsg("File Sent")
ELSE
  THIS.ErrorMsg("File Send Failed")
ENDIF    

ENDFUNC
* SendFile





********************************************************
* HTTPDemo :: CustList2
*********************************
***  Function: Returns a customer list based on the URL 
***            'parameter' passed. This time as file!
***    Assume: wc.dll?http~CustList1~CompanySearchString
********************************************************
FUNCTION CustList2

lcCustToFind = THIS.oCGI.GetCGIParameter(3)

lcFile=SYS(3)+".DBF"

*** This query includes Memos
SELECT custno,Company, Careof, Address, phone ; 
   FROM (DATAPATH + "TT_Cust") ;
   WHERE UPPER(Company) = UPPER(lcCustToFind) ;
   ORDER BY Company ;
   INTO DBF (lcFile)
USE

o=CREATE("wwIPStuff")

*** Encode with Memo File
lcText=o.EncodeDBF(lcFile,.T.)

*** Send the Delimited string over the wire
THIS.oHTML.Send(lcText)

ERASE (lcFile)

USE IN TT_Cust

ENDFUNC
* CustList1

********************************************************
* HTTPDemo :: SendCustList3
*********************************
***  Function: Sends a customer list that's encoded 
***            in CustFile and displays result as HTML
********************************************************
FUNCTION SendCustList3

loHTML=THIS.oHTML
lcFileBuffer = THIS.oCGI.GetFormVar("CustFile")

o=CREATE("wwIPStuff")
IF !o.DecodeDBF(lcFileBuffer,"TTempFile.dbf") 
   THIS.ErrorMsg("Invalid File info")
   RETURN
ENDIF

USE TTempFile

INSERT INTO TTempFile(Company, Name, Message) ;
    VALUES (THIS.oCGI.GetServerName(),"Rick Strahl","Hey there from the server at: "+TIME())

*** Close the file and delete it!
USE In TTempFile

lcFileText=o.EncodeDBF("TTempFile.dbf",.T.)

loHTML.Send(lcFileText)

ERASE TTempFile.DBF
ERASE TTempFile.FPT

RETURN
ENDFUNC


FUNCTION SendCustList4

loHTML=THIS.oHTML

o=CREATE("wwIPStuff")
SELECT company,careof, phone From TT_Cust ;
       INTO DBF TTempFile
USE
lcFileText=o.EncodeDBF("TTempFile.dbf",.T.)

loHTML.Send(lcFileText)

ERASE TTempFile.DBF
ERASE TTempFile.FPT

RETURN
ENDFUNC

ENDDEFINE


