************************************************************************
*PROCEDURE WebHits
******************
***  Modified: 12/18/95
***  Function: Processes incoming wwDemo CGI requests. Called from
***            CGIMAIN.PRG using wwDemo~Task~Optional+Parms parameter.
***      Pass: loCGI   -   wwCGI object
***    Return: nothing
*************************************************************************
LPARAMETER loServer

#INCLUDE WCONNECT.h

*** HTML and graphics file paths
#DEFINE HOMEPATH "/webhits/"
#DEFINE HOMEPAGE HOMEPATH+"ShowHits.htm"
#DEFINE BACKIMG HOMEPATH+"whitwav.jpg"
#DEFINE PAGEFOOT [<p><HR>]+CR+;
                 [<A HREF="http://www.west-wind.com/"><IMG SRC="/webhits/wcpower.gif" BORDER=0 HSPACE=5 WIDTH=114 HEIGHT=42 ALIGN=LEFT ALT="Powered by Web Connection"></a>]+;
                 [<FONT SIZE=-1>Query created by <A HREF="mailto:rstrahl@west-wind.com">Rick Strahl</A><BR>]+;
                 '[<A HREF="'+HOMEPAGE+'">Web Hits Page</A>]'


*** Now create a process object. It's not necessary
*** to use an object here, but it makes error handling
*** document and CGI handling much easier!
#IF OLESERVER
  loProcess=CREATE("Webhits",loServer.oCGI,loServer,,,[WWC_wwhtmlstring])
#ELSE
  loProcess=CREATE("Webhits",loServer.oCGI,loServer,,,[WWC_wwhtml])
#ENDIF  

IF TYPE("loProcess")#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create CGI Processing object..."
   RETURN .F.
ENDIF

*** Call the Process Method that handles the request
loProcess.Process

RETURN


*************************************************************
DEFINE CLASS Webhits AS wwProcess
*************************************************************
***    Author: Rick Strahl
***            (c) West Wind Technologies, 1995
***   Contact: (503) 386-2087  / 76427,2363@compuserve.com
***  Modified: 11/20/95
***  Function: This is a customized subclass of the
***            CGI Process class (CPROC.PRG). This class adds 
***            individual processing methods to the existing
***            setup methods.
*************************************************************

*** Custom Properties
cLogPath = "c:\winnt\system32\logfiles\w3svc1\"
cDataPath = ".\Webhits\"
nDropDays = 90

*** Read Properties - Override Process() method
FUNCTION Process

THIS.cLogPath = THIS.GetAppIniVar("LogPath")
THIS.cDataPath = THIS.GetAppIniVar("DataPath")
THIS.cHTMLPAGEPATH = THIS.GetAppIniVar("HTMLPAGEPATH")
THIS.nDropDays = VAL(THIS.GetAppIniVar("DropDays"))
IF THIS.nDropDays = 0
   THIS.nDropDays = 90
ENDIF

*** Default Process Method to process requests   
DoDefault()

ENDFUNC


************************************************************************
* WebHits :: MainForm
*********************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION MainForm

poProcess = THIS
poCGI = THIS.oCGI
THIS.oHTML.ShowHTMLFile(THIS.cHTMLPagePath + "webhits.wc")

ENDFUNC
* WebHits :: MainForm

************************************************************************
* wwProcessDemo :: WebHits
*********************************
***  Function: Displays Webhits as generated of the MainForm query.
************************************************************************
FUNCTION Hits
LOCAL loCGI, loHTML, lcBasePath

loCGI=THIS.oCGI
loHTML=THIS.oHTML

lcCompany=lower(trim(loCGI.GetFormVar("Company")))
lcPath=STRTRAN(loCGI.GetFormVar("Path"),"\","/")
   
lcFromDate=CTOD(loCGI.GetFormVar("FromDate"))
lcToDate=CTOD(loCGI.GetFormVar("ToDate"))
lcOrderBy=loCGI.GetFormVar("OrderBy")
lcDisplay=loCGI.GetFormVar("Display")
lcDomain=loCGI.GetFormVar("Domain")

loIPStuff=CREATE("wwIPStuff")
lcIP=loIPStuff.GetIPFromDomain(lcDomain)
IF EMPTY(lcIP)
  lcIp=lcDomain
ENDIF  

lcBasePath=IIF(!EMPTY(lcPath),"/"+TRIM(lcPath),"")
lcBasePath=STRTRAN(lcBasePath,"///","/")
lcBasePath=LOWER(STRTRAN(lcBasePath,"//","/"))

lcFilter = " ServerIP = '"+lcIP+"'"

IF !EMPTY(lcFromDate)
   lcFilter = lcFilter + " .AND. date >= {"+DTOC(lcFromDate)+"}"
ENDIF
IF !EMPTY(lcToDate) 
   lcFilter = lcFilter + " .AND. date <= {"+DTOC(lcToDate)+"}"
ENDIF

lcOrder=""
IF lcOrderBy="H"
   lcOrder=" ORDER BY 1 DESC"
ENDIF

IF lcDisplay = "S"
  *** Summary by Day
  SELECT DTOC(Date) AS Date, SUM(hits) AS Hits ;
   FROM WebHits ;
   WHERE &lcFilter ;
   GROUP BY Date ;
   &lcOrder ;
   INTO CURSOR Tquery
ELSE
   *** Summary by Page
   SELECT SUM(hits) AS Hits, ;
      lower(location) as Location ;
   FROM WebHits ;
   WHERE &lcFilter ;
   GROUP BY ServerIP, 2 ;
   &lcOrder ;
   INTO CURSOR Tquery
ENDIF

***         IF lcDisplay="H"  
***           *** Allow HTML Table to display if count is Ok
***           loHTML.SetAllowHTMLTables(loCGI.IsNetScape())
***         ENDIF  

loHTML.HTMLHeader("Web Hits for "+lcDomain,,BACKIMG)
IF EMPTY(lcToDate) AND EMPTY(lcFromDate)
  loHTML.SendLn("For the last 90 days as of "+DTOC(Date()))
ELSE
  loHTML.SendLn("<b>From:</b> "+IIF(EMPTY(lcFromDate),"",DTOC(lcFromDate))+;
                "<br>   <b>To:</b> "+IIF(EMPTY(lcToDate),DTOC(Date()-1),DTOC(lcToDate)) )
ENDIF

IF lcDisplay="S" AND _TALLY > 1
     loHTML.SendPar()
     loHTML.SendLn([<CENTER><TABLE WIDTH="90%" BGCOLOR="#EEEEEE" BORDER=2><TR><TD>])	
     loHTML.SendLn([<CENTER><H2><FONT FACE="Arial" COLOR="800000">Daily Site Hits</FONT></H2>])   
     loHTML.IEChart("BAR",1,"98%",275)
     loHTML.SendLn([</CENTER></TD></TR></TABLE>])
     loHTML.SendPar()
ENDIF

loHTML.SendLn("<CENTER><p>")
loHTML.ShowCursor(,,.t.)
loHTML.SendLn("<p></CENTER>")
loHTML.SendLn(PAGEFOOT)
loHTML.HTMLFooter()

USE IN TQuery
USE IN WebHits

ENDPROC
* WebHits

************************************************************************
* wwProcessDemo :: ShowDays
*********************************
***  Function: Shows a summary of Web hits for all available dates
************************************************************************
FUNCTION ShowDays
LOCAL loHTML, lnReccount

loHTML=THIS.oHTML

SELECT Date, SUM(hits) AS Hits ;
   FROM WebHits ;
   WHERE Date > (date()-30) ;
   GROUP BY 1, ServerIP ;
   INTO CURSOR Tquery

SELE WebHits
lnReccount=reccount()
Sele TQuery

loHTML.SetAllowHTMLTables(THIS.oCGI.IsNetScape())
loHTML.HTMLHeader("Web Log Summary by Day for the last 30 days",,BACKIMG)

loHTML.SendLn("<b>Web Hit log contains: "+STR(lnReccount) +" page entries.</b><p>")

loHTML.SendLn("<CENTER><p>")
loHTML.ShowCursor(,,.t.)
loHTML.SendLn("<p></CENTER>")

loHTML.HTMLFooter(PAGEFOOT)

USE IN TQuery
USE IN WebHits

ENDFUNC
* ShowDays

************************************************************************
* wwProcessDemo :: Reindex
*********************************
***  Function: Reindexes the WebHits Datafile
************************************************************************
FUNCTION Reindex

IF !Reindex()
   THIS.ErrorMsg("Unable to reindex Web Hit log file",;
                 "Most likely this means the file is open and in use.")
ELSE
   THIS.ErrorMsg("Web Hit log reindexed","All files have been indexed and packed...")
ENDIF    

IF USED("WebHits")
  USE IN WebHits
ENDIF
  
ENDFUNC
* Reindex

************************************************************************
* wwProcessDemo :: ImportForm
*********************************
***  Function: Maintainence Page that imports HTTP log files.
***            Calls Import.
************************************************************************
FUNCTION ImportForm
LOCAL loHTML, x, laFiles

lcLogPopup = THIS.CreateLogPopup()

loHTML=THIS.oHTML

loHTML.HTMLHeader("HTTP Log Import")
                  
loHTML.SendLn([])
loHTML.SendLn([<B>Available Files:</B> ])
loHTML.SendLn([<FORM  ACTION="wc.dll?WebHits~Import" METHOD="POST">])


loHTML.SendLn(lcLogPopup)

loHTML.SendLn([<p>])
loHTML.SendLn([<INPUT TYPE="SUBMIT" NAME="SubmitButton"  VALUE="Import" SIZE="50"> <INPUT NAME="Reset Form" TYPE="RESET"  VALUE="Clear Form" ALIGN=top><p>])
loHTML.SendLn([</FORM>])
*loHTML.SendLn([</PRE>])

loHTML.HTMLFooter(PAGEFOOT)


************************************************************************
* wwCGIProcessDemo :: Import
*********************************
***  Function: Imports Web log files.
************************************************************************
FUNCTION Import
LOCAL lnFiles, laFiles

*** NOTE: Not creating HTML document since we're not likely
***       to have the import complete before timeout.
loCGI=THIS.oCGI

DIMENSION laFiles[1]
lnFiles=loCGI.GetFormMultiple(@laFiles,"Filename")

FOR x=1 TO lnFiles
   DO ImportLog WITH THIS.cLogPath+TRIM(laFiles[x]),;
                     THIS.nDropDays,THIS.cDataPath
ENDFOR && x=1 TO lnFiles

THIS.ErrorMsg("Log File Import","Importing has been completed...")

ENDPROC
* Import


Function CreateLogPopup
LOCAL lcLogPopup

DIMENSION laFiles[1]
lnFiles=ADIR(laFiles,THIS.cLogPath+"IN*.LOG")
IF lnFiles < 1
   RETURN "Sorry. No log files available..."
ENDIF                 

lcLogPopup = [<SELECT NAME="Filename" MULTIPLE SIZE=10>] +;
             [<OPTION SELECTED>]+TRIM(laFiles[1,1]) + SPACE(15) 

FOR x=2 TO lnFiles
   lcLogPopup =  lcLogPopup + [<OPTION>]+TRIM(laFiles[x,1]) + SPACE(15) 
ENDFOR && x=1 TO lnFiles

lcLogPopup = lcLogPopup + [</SELECT>]
RETURN lcLogPopup

ENDDEFINE
*EOC wwDemo




************************************************************************
PROCEDURE ImportLog
*******************
***  Modified: 01/23/96
***  Function: Imports a single HTTP Log File and appends it to
***            WebHits.dbf
***      Pass: lcImportFile  -   Name of the HTTP Log File to import
***            lcLogPath     -   Path of the log files (\\HRWEB\LOG\)
***            ldDropDate	 -   Date before which to delete entries.
***    Return: "" or an error string
*************************************************************************
LPARAMETER lcImportFile, ldDropDate, lcDataPath
LOCAL lcErrormsg, lcOldError, llError

lcImportFile=IIF(type("lcImportFile")="C",lcImportFile,"")
ldDropDate=IIF(type("ldDropDate")="D",ldDropDate,date()-90)
lcDataPath=IIF(type("lcDataPath")="C",lcDataPath,"webhits\")

IF !FILE(lcImportFile)
   lcErrorMsg="Can't find Input File..."
   wait window nowait lcErrormsg
   RETURN lcErrorMsg
ENDIF   

CREATE CURSOR IMPORT (;
   REMOTE_IP	C(15),;
   USER		C(15),;
   INDATE	C(10),;
   INTIME	C(8),;
   SERVICE	C(10),;
   MACHINE	C(10),;
   LOCAL_IP	C(16),;
   BYTESIN	C(7),;
   BYTES1	C(7),;
   BYTES2	C(7),;
   BYTES3	C(7),;
   BYTES4	C(7),;
   ACTION      	C(10),;
   LOCATION    	C(100), ;
   SPARE1	C(10) ) 

*   DOW         C (3),;
*   MONTH       C (3),;
*   DAY         C (2),;
*   TIME        C (8),;
*   YEAR        C (4),;
*   LOCAL_IP    C (15),;
*   REMOTE_IP   C (15),;
*   ACTION      C (10),;
*   LOCATION    C (100))

llError=.F.
lcOldError=ON("ERROR")
*ON ERROR llError=.T.

wait window "Appending data from HTTP Log - "+lcImportFile nowait
APPEND FROM (lcImportFile) TYPE DELIMITED 

wait window "Formatting data for import..." nowait
SELECT COUNT(*) as Hits, LTRIM(lower(location)) as Location, ;
   CTOD(ALLTRIM(import.indate)) AS DATE,;
   LTRIM(LOCAL_IP) AS ServerIP ;
   FROM IMPORT ;
   WHERE ATC(".GIF",location)=0  AND ;
         ATC(".JPG",location)=0 AND ;
         ATC(".MAP",Location)=0 ;
   GROUP BY LOCAL_IP,2,3 ;
   INTO TABLE Temp

ON ERROR &lcOldError
IF llError
   RETURN "Couldn't access the import file..."
ENDIF      

wait window "Importing data into Webhit detail table..." nowait
IF !FILE("WebHits.DBF")
  CREATE TABLE (lcDataPath + "WebHits") ;
  (  HITS        N (8,0),;
     LOCATION    C (100),;
     DATE        D ,;
     ServerIP    C (15) )
  DO REINDEX
  SET ORDER TO
ELSE     
IF USED("WebHits")
    USE IN WebHits
ENDIF

  lcOldError=ON("ERROR")
  llError=.F.
  ON ERROR llError=.T.
  USE WebHits in 0 EXCLUSIVE
  ON ERROR &lcOldError
  
  IF llError
     RETURN "Couldn't open WebHits Exclusively..."
  ENDIF

  SELE WebHits
ENDIF

llReindex=.F.

*** Now check if we got dupe dates
SELE TEMP
lddate=temp.date

SELE WebHits
LOCATE FOR date=lddate

*** Ok, delete original records and re-append
IF FOUND()
   DELETE FOR date=ldDate
   llReindex=.T.
ENDIF   

*** Now check for dropoff dates
DELETE FOR date<ldDropDate
IF _TALLY>1 AND RECCOUNT()>50000
   llReindex=.T.
ENDIF

IF llReindex
   DO REINDEX

   SELE WebHits
   SET ORDER TO
ENDIF   

APPEND FROM Temp

USE IN TEMP
ERASE TEMP.DBF

IF USED("WebHits")			
   USE IN WebHits 
ENDIF

wait clear
RETURN ""


************************************************************************
FUNCTION Reindex
******************
***    Author: Rick Strahl
***            (c) West Wind Technologies, 1996
***   Contact: (503) 386-2087  / 76427.2363@compuserve.com
***  Modified: 01/23/96
***  Function: Reindexes WebHits Table
***   Returns: .T. or .F.
************************************************************************
LOCAL lcOldError

IF USED("WebHits")
   USE IN WebHits
ENDIF

lcOldError=ON("ERROR")
llError=.F.
ON ERROR llError=.T.
SELE 0
USE WebHits EXCLUSIVE
ON ERROR &lcOldError

IF llError
   RETURN .F.
ENDIF

wait window nowait "Packing WebHits.dbf..."
DELETE TAG ALL
SET ORDER TO
PACK

wait window "Reindexing WebHits.dbf - Tag: DELETED." nowait
INDEX ON Deleted() TAG Deleted
wait window "Reindexing WebHits.dbf - Tag: LOCATION." nowait
INDEX ON lower(location) tag location
wait window "Reindexing WebHits.dbf - Tag: DATE." nowait
INDEX ON date TAG Date

SET ORDER TO

RETURN .T.