*************************************************************
DEFINE CLASS Rules AS Custom
*************************************************************
***    Author: Rick Strahl
***            (c) West Wind Technologies, 1996
***   Contact: (503) 386-2087  / 76427,2363@compuserve.com
***  Modified: 05/12/96
***
***  Function:
*************************************************************

*** Custom Properties

*** Stock Properties



************************************************************************
* Rules :: InvoiceItemTotal
*********************************
***  Function: Calculates the item total and updates the invoice
***            total for an Invoice Detail Item.
***   Assumes: Detail Item is located on the proper record
***            Invoice number is already set in item
***      Pass: 
***    Return:
************************************************************************
FUNCTION InvoiceItemTotal
LOCAL lnInvoiceTotal

lcOldAlias=ALIAS()

*** Update the Item Total
SELE GN_DETL
lnRecno=IIF(EOF(),0,recno())

lcInvNo=GN_DETL.InvNo

REPLACE GN_DETL.ITEMTOTAL WITH GN_DETL.QTY*GN_DETL.PRICE

*** Recalc Invoice Total
SUM GN_DETL.ItemTotal TO lnInvoiceTotal ;
   FOR GN_DETL.Invno=GN_INV.Invno

*** Restore Rec Pointer
IF lnRecno#0
   GOTO lnRecno
ENDIF


SELE GN_INV
lnRecno=IIF(EOF(),0,recno())

LOCATE FOR InvNo=lcInvNo
IF FOUND()
   REPLACE GN_INV.Total with lnInvoiceTotal
ENDIF   

IF lnRecno#0
   GOTO lnRecno
ENDIF

*** Update Customer Balance
SELE GN_CUST
REPLACE balance with THIS.CalcARBalance()
 
IF !EMPTY(lcOldAlias)
  SELE (lcOldAlias)
ENDIF

RETURN .T.
* InvoiceItemTotal

************************************************************************
* Rules :: CalcARBalance
*********************************
***  Function: Calculates the AR balance for a customer
***    Assume:
***      Pass: lcCustid  -  Customer Id
***            lnPaid    -  Optional Variable that can be passed by
***                         reference to allow retrieving individual
***                         value for Total Payments.
***            lnCharged -  Same for charged items.
***    Return:
************************************************************************
FUNCTION CalcARBalance
LPARAMETERS lcCustId, lnPaid, lnCharged
LOCAL lnBalance, lnCharged, lnPaid, lnRecno

lcCustid=IIF(type("lcCustid")="C",lcCustid,custno)
lnPaid=0
lnCharged=0

SELE GN_INV
lnRecNo=IIF(EOF(),0,recno())

SUM TOTAL TO lnCharged FOR custno=lcCustID

IF lnRecno#0
   GOTO lnRecNo
ENDIF

SELE GN_PYMT
lnRecno=IIF(EOF(),0,recno())

SUM AMOUNT TO lnPaid FOR custno=lcCustID

IF lnRecno # 0
   GOTO lnRecno
ENDIF

RETURN lnCharged - lnPaid
* CalcARBalance

ENDDEFINE
*EOC Custom