************************************************************************
*FUNCTION WCMAIN
******************
***    Author: Rick Strahl
***            (c) West Wind Technologies, 1995-1998
***   Contact: http://www.west-wind.com
***            rstrahl@west-wind.com
***  Function: Web Connection Mainline program. Responsible for setting
***            up the Web Connection Server and get it ready to
***            receive requests in file based operation. 
***
***            Contains a subclass of the wwServer/wwOLEServer classes
***            that customize the server to your application. Definition
***            follows mailine code (Class wcDemoServer).
***
***            NOTE: This code contains sample code for both the 
***                  file and OLE based messaging implementations.
***                  I realize this gets a little confusing to read,
***                  so pick one approach or the other (file based
***                  recommended to start) and follow it through.
***                  There are a number of #IF OLESERVERs at the top
***                  but once your code gets control there are no further
***                  differences between the approaches, so consider
***                  it worth the extra effort <s>...
************************************************************************
LPARAMETER lcIni                  && Used only for testing with OLE
 
#INCLUDE FOXPRO.H
#INCLUDE WCONNECT.H 

********************************************************************
***   INTERACTIVE (File based messaging) SERVER SETUP CODE
***
***   Steps: Set #DEFINE OLESERVER .F. in WCONNECT.H
***          Set Mechanism=File  in WC.INI (same dir as WC.DLL)
***
***   - Use this code for testing the interactive server. This 
****    Interactive Server uses file based messaging and a VFP 
***     form with a timer to receive requests from the Web server.
***     requires VFP to
***     be running with the form containing a timer polling for
***     requests.
***
***   This code is self contained within this #IF #ENDIF block.
*********************************************************************

*** FILE BASED MAINLINE
#IF NOT OLESERVER

*** PUBLIC flag allows server to never quit 
*** - unless EXIT button code is executed
PUBLIC glExitCGIServer, goWCServer

SET TALK OFF
SET NOTIFY OFF
glExitCGIServer=.F.

DO WHILE !glExitCGIServer
   #IF !DEBUGMODE
     SET DEBUG OFF
     SET STATUS BAR OFF
     SET DEVELOP OFF
     SET SYSMENU OFF
	   #IF wwVFPVersion > 5
	      *** This is purely optional 
	      SET STRICTDATE TO 0
	      SET CENTURY OFF
	   #ENDIF
   #ENDIF

   *** Allow shut down by system
   ON SHUTDOWN DO ShutIt IN WCMAIN.PRG

   *** Load the Web Connection class libraries
   DO WCONNECT

   *** Load the server - wcDemoServer defined below
   goWCServer=CREATE("wcDemoServer")

   *** If running a CGI Web server uncomment the following line
   * goWCServer.SetCgiClass("wwShellCGI")  && Overwrite for Shell CGI Script
                  
   IF TYPE("goWCServer")#"O"
      =MessageBox("Unable to load Web Connection Server",;
         MB_ICONEXCLAMATION,"Web Connection Error")
      RETURN
   ENDIF
   
   *** Make the server live - Show puts the server online and in polling mode
   goWCServer.show()
   READ EVENTS
   
   *** Done
   ON SHUTDOWN
ENDDO

ON ERROR
RELEASE glExitCGIServer
RELEASE goWCServer

SET SYSMENU ON
SET DEBUG ON
SET STATUS BAR ON
SET DEVELOP ON
SET TALK ON

RETURN

#ENDIF


*** COM SERVER TEST CODE - This code is used for testing only.
***                        when called via COM the class is directly
***                        instantiated and called.
#IF OLESERVER

lcIni=IIF(type("lcIni")="C",lcIni,"c:\temp\temp.ini")

PUBLIC o
* DO WCONNECT
* o=CREATE("wcDemoServer")             && VFP Class testing

o=CREATE("wwdemoole.wcDemoServer")  && COM Server testing
? o.GetProcessId()                  && Retrieve ProcessId and Show Server

*** Errors come back in the cErrorString property
IF o.lError
   ? o.cErrorString
ENDIF   

*** Use the following syntax to simulate a request
lcOutput = o.ProcessHit("Query+String=wwDemo~TestPage")

RETURN  lcOutput

#ENDIF


**************************************************************
****          YOUR SERVER CLASS DEFINITION                 ***
**************************************************************
#IF OLESERVER
*************************************************************
   DEFINE CLASS wcDemoServer AS wwOleServer OLEPUBLIC
*************************************************************
#ELSE
*************************************************************
   DEFINE CLASS wcDemoServer AS wwServer
*************************************************************
#ENDIF
*************************************************************
***  Function: This is a subclass of the wwServer class
***            that is application specific. Each Web Connection
***            server you create *MUST* create a subclass of the
***            class and at least implement the Process and
***            SetServerEnvironment methods to  receive requests!
*************************************************************

************************************************************************
* wcDemoServer :: SetServerEnvironment
*************************************
***  Function: This method sets the server's environment in terms
***            of VFP Environment settings. This code executes
***            just prior to the Init Code of the base class. Any
***            SET or ON statements should be made here.
***
***            THIS.cAppBasePath returns your application's startup
***            path as stored in the registry. If you need to override
***            this path in code you should do so here. This value
***            is used to SET DEFAULT TO in the Init(). You can
***            set this value on the WC Status form's Startup Path.
***
***    Assume: VIRTUAL METHOD - must ALWAYS be overridden!
************************************************************************
PROTECTED FUNCTION SetServerEnvironment

*** Location of the startup INI file 
THIS.cSetupIniFile= addbs(THIS.cAppBasePath) + "wcmain.ini"

*** This URL is executed when clicking on the Automation Server
*** Form's Exit button. It forces operation through a browser!
THIS.cOleReleaseUrl="http://localhost/wconnect/wc.dll/maintain?release"

#IF !DEBUGMODE
   *** Backup Error handler only - startup code and a few file access errors
   ***                             are the only things handled by this one
   ON ERROR DO ErrorHandler WITH ;
              ERROR(),MESSAGE(),MESSAGE(1),SYS(16),LINENO() IN WCMAIN.PRG
*   SET RESOURCE OFF
#ENDIF

ENDFUNC
* SetServerEnvironment


************************************************************************
* wcDemoServer :: SetServerProperties
*************************************
***  Function: This Method should be used to set any server properties
***            and any relative paths. At this time the server has
***            changed directories to its startup path, so it's safe
***            to set relative paths from here.
***
***            This code runs just prior to showing the server window.
************************************************************************
PROTECTED FUNCTION SetServerProperties

THIS.ReadSettingsFromIni()   && Reads from THIS.cSetupIniFile

*** Any settings you want to make to the server
THIS.Caption =This.cServerId + " - Web Connection " + WWVERSION 

*** Add any data paths - SET DEFAULT has already occurred so this is safe!
#IF ENTERPRISE AND !SHAREWARE
	DO PATH WITH ".\WWTHREADS"
	SET PROCEDURE TO wwtClasses ADDITIVE
	SET PROCEDURE TO wwtList ADDITIVE
#ENDIF

*** Add additional application paths
DO PATH WITH ".\CLASSES\"
DO PATH WITH ".\WWDEMO\"
DO PATH WITH ".\WTHREADS\"

DO PATH WITH ".\WW\"



#IF INCLUDE_VISUALWEBBUILDER
    DO WEBBUILDER
    THIS.Addobject("oWebBuilder","wbWebBuilder")
	THIS.oWebBuilder.cIniFile = "c:\wwapps\webbuilder\server\webbuilder.ini"
	THIS.oWebBuilder.cApplicationName="Web Builder"
	THIS.oWebBuilder.ReadConfiguration()   && Also connects to SQL Data Source if setting is 2

	DO PATH WITH "c:\wwapps\webbuilder\webstore"
	DO PATH WITH "c:\wwapps\webbuilder\samples"
#ENDIF	

ENDFUNC
* SetServerProperties


************************************************************************
* wcDemoServer :: Process
*************************
***  Function: This procedure's main purpose is to route incoming
***            requests to individual project PRGs/APPs.
***
***            The URL formatting used is as follows:
***            /wconnect/wc.dll?project~ClassMethod~Parm1~Parm2 etc.
***
***            The project 'parameter' is routed to the appropriate
***            program file which actually implements a Process class
***            to respond to requests. ClassMethod calls the method
***            in the wwProcess class implemented in project.prg
************************************************************************
FUNCTION Process

THIS.oCGI.aCGIParms()                            && Create Array of parameters 
lcParameter=UPPER(THIS.oCGI.GetCGIParameter(1))  && Get first Parameter (Project)

*** Set up project types and call external processing programs:
DO CASE
#IF ENTERPRISE 
   CASE lcParameter == "WWTHREADS"
     DO wwThreads with THIS
#ENDIF     
  
  CASE lcParameter == "WWDEMO"
     DO wwDemo with THIS
  
  CASE lcParameter == "WESTWIND"
     DO westwind with THIS
  
  CASE lcParameter == "WEBHITS"
     DO webhits with THIS
 

*!*  CASE lcParameter = "WWHTTPDATA"
*!*     DO wwHTTPData with THIS

*!*	  CASE lcParameter="MYCODE"
*!*	     DO MyCode with THIS

  CASE lcParameter == "WWMAINT"
      DO wwMaint with  THIS

  CASE lcParameter == "HTTP"
      DO HTTP with THIS     

  OTHERWISE
     *** Check for Script Mapped files for: .WC, .WCS, .FXP
     lcPhysicalPath=THIS.oCGI.GetPhysicalPath()
     DO CASE
     CASE ATC(".WC",lcPhysicalPath) > 0 OR ATC(".FXP",lcPhysicalPath) > 0
        DO wwScriptMaps with THIS
#IF INCLUDE_VISUALWEBBUILDER
     CASE ATC(".WB",lcPhysicalPath) > 0
        DO wbServerProcess with THIS
#ENDIF        
     OTHERWISE
         *** Error - No handler available 
	     loHTML=CREATE("wwHTMLString")
	     loHTML.HTMLError("Unhandled Request",;
	                      "The server is not setup to handle this type of Request: "+lcParameter)

	     #IF WWC_SENDEMAIL_ONERROR 
	         THIS.SendMail(WWC_MAILSERVER,WWC_ADMINISTRATOR_EMAIL, ;
	           WWC_ADMINISTRATOR_EMAIL,;
	           WWC_ADMINISTRATOR_EMAIL,"", ;
	           "Web Connection Error Message - Unhandled request",;
	           "The request Query String is: " +THIS.oCGI.cQueryString + CR+;
	           "              DLL or Script: " +THIS.oCGI.GetCGIVar("Executable Path") + CR+;
	           "                Server Name: " + THIS.oCGI.GetServerName() ) 
         #ENDIF

	     #IF OLESERVER
	         *** Simply assign to output property
	         THIS.cOutput=loHTML.GetOutput()
	     #ELSE
	         *** FileBased - must output to file
	         File2Var(THIS.oCGI.GetOutFile(),lohtml.GetOutput())
	     #ENDIF
	 ENDCASE
   
ENDCASE

RETURN

ENDDEFINE
* EOC wcDemoServer



************************************************************************
PROCEDURE ErrorHandler
**********************
***  Modified: 12/31/95
***  Function: Global Error handler. Shuts down everything then
***            restarts the server from scratch. Used to make sure the
***            server is always running. This error handler will write
***            an error to the log, but won't output an HTML document.
***
***            Note that local error handlers in the Process class
***            or other classes will override the global handler.
*************************************************************************
PARAMETER t_errorno,t_mess1,t_mess2,t_module,t_lineno
LOCAL llOldLogging, lcProcess, lcOldError

lcOldError = ON("ERROR")

*** Further errors should be ignored here
ON ERROR *

IF TYPE("goWCServer")="O"
   IF TYPE("goWCServer.oCGI")="O"  
      lcProcess= CR+goWCServer.oCGI.GetCGIParameter()+CR+CR
   ELSE
      lcProcess=""
   ENDIF

   llOldLogging=goWCServer.GetLogToFile()
   goWCServer.SetLogToFile(.T.)
   goWCServer.LogEntry("Processing Error<br>"+CR+;
                       lcProcess+CR+;
                       "<PRE>"+CR+;
                       "Error: "+STR(T_errorno)+CR+;
                       "Message: "+T_Mess1+CR+;
                       "Code: "+T_mess2+CR+;
                       "Program: "+T_Module+CR+;
                       "Line No: "+STR(T_lineno)+CR+"</PRE>",;
                       "Local",0,.t.)
  
   goWCServer.SetLogToFile(llOldLogging)
ENDIF

CLOSE DATA

RELEASE WINDOWS  && Release CGI Server Window and moves code on

ON ERROR &lcOldError

*** Restart - ie. hit the main loop
RETURN TO MASTER

************************************************************************
PROCEDURE Shutit
******************
***  Function: System Shutdown Procedure
*************************************************************************
ON ERROR *
RELEASE goWCServer
ON SHUTDOWN
QUIT
RETURN
